/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.domain.service;

import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.time.TimeSource;
import org.gotson.komga.domain.model.Book;
import org.gotson.komga.domain.model.DirectoryNotFoundException;
import org.gotson.komga.domain.model.ScanResult;
import org.gotson.komga.domain.model.Sidecar;
import org.gotson.komga.domain.service.FileSystemScannerKt;
import org.gotson.komga.infrastructure.sidecar.SidecarBookConsumer;
import org.gotson.komga.infrastructure.sidecar.SidecarSeriesConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001\u001fB!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0012J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00032\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016JT\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\r2\b\b\u0002\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u00172\b\b\u0002\u0010\u001b\u001a\u00020\u00172\b\b\u0002\u0010\u001c\u001a\u00020\u00172\u000e\b\u0002\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\u001eH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/gotson/komga/domain/service/FileSystemScanner;", "", "sidecarBookConsumers", "", "Lorg/gotson/komga/infrastructure/sidecar/SidecarBookConsumer;", "sidecarSeriesConsumers", "Lorg/gotson/komga/infrastructure/sidecar/SidecarSeriesConsumer;", "(Ljava/util/List;Ljava/util/List;)V", "sidecarBookPrefilter", "Lkotlin/text/Regex;", "pathToBook", "Lorg/gotson/komga/domain/model/Book;", "path", "Ljava/nio/file/Path;", "attrs", "Ljava/nio/file/attribute/BasicFileAttributes;", "scanBookSidecars", "Lorg/gotson/komga/domain/model/Sidecar;", "scanFile", "scanRootFolder", "Lorg/gotson/komga/domain/model/ScanResult;", "root", "forceDirectoryModifiedTime", "", "oneshotsDir", "", "scanCbx", "scanPdf", "scanEpub", "directoryExclusions", "", "TempSidecar", "komga"})
@SourceDebugExtension(value={"SMAP\nFileSystemScanner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileSystemScanner.kt\norg/gotson/komga/domain/service/FileSystemScanner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,246:1\n1360#2:247\n1446#2,5:248\n766#2:265\n857#2:266\n1747#2,3:267\n858#2:270\n1603#2,9:271\n1855#2:280\n288#2,2:281\n1856#2:284\n1612#2:285\n18#3,4:253\n50#3,7:257\n1#4:264\n1#4:283\n*S KotlinDebug\n*F\n+ 1 FileSystemScanner.kt\norg/gotson/komga/domain/service/FileSystemScanner\n*L\n46#1:247\n46#1:248,5\n223#1:265\n223#1:266\n223#1:267,3\n223#1:270\n224#1:271,9\n224#1:280\n225#1:281,2\n224#1:284\n224#1:285\n74#1:253,4\n74#1:257,7\n224#1:283\n*E\n"})
public class FileSystemScanner {
    @NotNull
    private final List<SidecarBookConsumer> sidecarBookConsumers;
    @NotNull
    private final List<SidecarSeriesConsumer> sidecarSeriesConsumers;
    @NotNull
    private final List<Regex> sidecarBookPrefilter;

    /*
     * WARNING - void declaration
     */
    public FileSystemScanner(@NotNull List<? extends SidecarBookConsumer> sidecarBookConsumers, @NotNull List<? extends SidecarSeriesConsumer> sidecarSeriesConsumers) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter(sidecarBookConsumers, (String)"sidecarBookConsumers");
        Intrinsics.checkNotNullParameter(sidecarSeriesConsumers, (String)"sidecarSeriesConsumers");
        this.sidecarBookConsumers = sidecarBookConsumers;
        this.sidecarSeriesConsumers = sidecarSeriesConsumers;
        Iterable iterable = this.sidecarBookConsumers;
        FileSystemScanner fileSystemScanner = this;
        boolean $i$f$flatMap = false;
        void var5_6 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SidecarBookConsumer it = (SidecarBookConsumer)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getSidecarBookPrefilter();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        fileSystemScanner.sidecarBookPrefilter = (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ScanResult scanRootFolder(@NotNull Path root, boolean forceDirectoryModifiedTime, @Nullable String oneshotsDir, boolean scanCbx, boolean scanPdf, boolean scanEpub, @NotNull Set<String> directoryExclusions) {
        long l;
        List list;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(directoryExclusions, (String)"directoryExclusions");
        List $this$scanRootFolder_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (scanCbx) {
            Object[] objectArray = new String[]{"cbz", "zip", "cbr", "rar"};
            $this$scanRootFolder_u24lambda_u241.addAll(CollectionsKt.listOf((Object[])objectArray));
        }
        if (scanPdf) {
            $this$scanRootFolder_u24lambda_u241.add("pdf");
        }
        if (scanEpub) {
            $this$scanRootFolder_u24lambda_u241.add("epub");
        }
        List scanForExtensions = CollectionsKt.build((List)list);
        FileSystemScannerKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        FileSystemScannerKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        FileSystemScannerKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        FileSystemScannerKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        if (!Files.isDirectory(root, new LinkOption[0]) || !Files.isReadable(root)) {
            throw new DirectoryNotFoundException("Folder is not accessible: " + root, "ERR_1016");
        }
        Map scannedSeries = new LinkedHashMap();
        List scannedSidecars = new ArrayList();
        boolean $i$f$measureTime = false;
        TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTime2 = false;
        long mark$iv$iv = $this$measureTime$iv$iv.markNow-z9LOYto();
        boolean bl2 = false;
        Map pathToSeries = new LinkedHashMap();
        Map pathToSeriesSidecars = new LinkedHashMap();
        Object pathToBooks = new LinkedHashMap();
        Map pathToBookSidecars = new LinkedHashMap();
        Files.walkFileTree(root, SetsKt.setOf((Object)((Object)FileVisitOption.FOLLOW_LINKS)), Integer.MAX_VALUE, (FileVisitor)new /* Unavailable Anonymous Inner Class!! */);
        long it = l = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv);
        boolean bl3 = false;
        Iterable iterable = scannedSeries.values();
        int n = 0;
        for (Object t : iterable) {
            void it2;
            pathToBooks = (List)t;
            int n2 = n;
            boolean bl4 = false;
            int n3 = it2.size();
            n = n2 + n3;
        }
        int countOfBooks = n;
        FileSystemScannerKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return new ScanResult(scannedSeries, scannedSidecars);
    }

    public static /* synthetic */ ScanResult scanRootFolder$default(FileSystemScanner fileSystemScanner, Path path2, boolean bl, String string, boolean bl2, boolean bl3, boolean bl4, Set set, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: scanRootFolder");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        if ((n & 0x10) != 0) {
            bl3 = true;
        }
        if ((n & 0x20) != 0) {
            bl4 = true;
        }
        if ((n & 0x40) != 0) {
            set = SetsKt.emptySet();
        }
        return fileSystemScanner.scanRootFolder(path2, bl, string, bl2, bl3, bl4, set);
    }

    @Nullable
    public Book scanFile(@NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return null;
        }
        Path path3 = path2;
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        BasicFileAttributes basicFileAttributes = Files.readAttributes(path3, BasicFileAttributes.class, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)basicFileAttributes, (String)"readAttributes(...)");
        return this.pathToBook(path2, basicFileAttributes);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Sidecar> scanBookSidecars(@NotNull Path path2) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String bookBaseName = PathsKt.getNameWithoutExtension((Path)path2);
        Path parent = path2.getParent();
        Intrinsics.checkNotNull((Object)parent);
        Iterable iterable = PathsKt.listDirectoryEntries$default((Path)parent, null, (int)1, null);
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block8: {
                Path candidate = (Path)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = this.sidecarBookPrefilter;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Regex it = (Regex)element$iv;
                        boolean bl3 = false;
                        if (!it.matches((CharSequence)PathsKt.getName((Path)candidate))) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Sidecar sidecar;
            Object v1;
            Path candidate;
            block9: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                candidate = (Path)element$iv$iv;
                boolean bl4 = false;
                Iterable $this$firstOrNull$iv = this.sidecarBookConsumers;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    SidecarBookConsumer it = (SidecarBookConsumer)element$iv;
                    boolean bl5 = false;
                    if (!it.isSidecarBookMatch(bookBaseName, PathsKt.getName((Path)candidate))) continue;
                    v1 = element$iv;
                    break block9;
                }
                v1 = null;
            }
            if ((SidecarBookConsumer)v1 != null) {
                SidecarBookConsumer it;
                boolean bl = false;
                URL uRL = candidate.toUri().toURL();
                Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
                URL uRL2 = parent.toUri().toURL();
                Intrinsics.checkNotNullExpressionValue((Object)uRL2, (String)"toURL(...)");
                Path path3 = candidate;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                BasicFileAttributes basicFileAttributes = Files.readAttributes(path3, BasicFileAttributes.class, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)basicFileAttributes, (String)"readAttributes(...)");
                sidecar = new Sidecar(uRL, uRL2, FileSystemScannerKt.getUpdatedTime((BasicFileAttributes)basicFileAttributes), it.getSidecarBookType(), Sidecar.Source.BOOK);
            } else {
                sidecar = null;
            }
            if (sidecar == null) continue;
            Sidecar it$iv$iv = sidecar;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private Book pathToBook(Path path2, BasicFileAttributes attrs) {
        String string = PathsKt.getNameWithoutExtension((Path)path2);
        URL uRL = path2.toUri().toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
        return new Book(string, uRL, FileSystemScannerKt.getUpdatedTime((BasicFileAttributes)attrs), attrs.size(), null, 0, null, null, null, null, false, null, null, 8176, null);
    }

    public static final /* synthetic */ Book access$pathToBook(FileSystemScanner $this, Path path2, BasicFileAttributes attrs) {
        return $this.pathToBook(path2, attrs);
    }

    public static final /* synthetic */ List access$getSidecarSeriesConsumers$p(FileSystemScanner $this) {
        return $this.sidecarSeriesConsumers;
    }

    public static final /* synthetic */ List access$getSidecarBookPrefilter$p(FileSystemScanner $this) {
        return $this.sidecarBookPrefilter;
    }

    public static final /* synthetic */ List access$getSidecarBookConsumers$p(FileSystemScanner $this) {
        return $this.sidecarBookConsumers;
    }
}

