/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.domain.service;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.domain.model.Book;
import org.gotson.komga.domain.model.Library;
import org.gotson.komga.domain.model.MarkSelectedPreference;
import org.gotson.komga.domain.model.Series;
import org.gotson.komga.domain.model.ThumbnailBook;
import org.gotson.komga.domain.model.ThumbnailSeries;
import org.gotson.komga.domain.persistence.LibraryRepository;
import org.gotson.komga.domain.service.BookLifecycle;
import org.gotson.komga.domain.service.LocalArtworkLifecycle;
import org.gotson.komga.domain.service.LocalArtworkLifecycleKt;
import org.gotson.komga.domain.service.SeriesLifecycle;
import org.gotson.komga.infrastructure.metadata.localartwork.LocalArtworkProvider;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/gotson/komga/domain/service/LocalArtworkLifecycle;", "", "libraryRepository", "Lorg/gotson/komga/domain/persistence/LibraryRepository;", "bookLifecycle", "Lorg/gotson/komga/domain/service/BookLifecycle;", "seriesLifecycle", "Lorg/gotson/komga/domain/service/SeriesLifecycle;", "localArtworkProvider", "Lorg/gotson/komga/infrastructure/metadata/localartwork/LocalArtworkProvider;", "(Lorg/gotson/komga/domain/persistence/LibraryRepository;Lorg/gotson/komga/domain/service/BookLifecycle;Lorg/gotson/komga/domain/service/SeriesLifecycle;Lorg/gotson/komga/infrastructure/metadata/localartwork/LocalArtworkProvider;)V", "refreshLocalArtwork", "", "book", "Lorg/gotson/komga/domain/model/Book;", "series", "Lorg/gotson/komga/domain/model/Series;", "komga"})
@SourceDebugExtension(value={"SMAP\nLocalArtworkLifecycle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalArtworkLifecycle.kt\norg/gotson/komga/domain/service/LocalArtworkLifecycle\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,44:1\n1855#2,2:45\n1855#2,2:47\n*S KotlinDebug\n*F\n+ 1 LocalArtworkLifecycle.kt\norg/gotson/komga/domain/service/LocalArtworkLifecycle\n*L\n25#1:45,2\n37#1:47,2\n*E\n"})
public class LocalArtworkLifecycle {
    @NotNull
    private final LibraryRepository libraryRepository;
    @NotNull
    private final BookLifecycle bookLifecycle;
    @NotNull
    private final SeriesLifecycle seriesLifecycle;
    @NotNull
    private final LocalArtworkProvider localArtworkProvider;

    public LocalArtworkLifecycle(@NotNull LibraryRepository libraryRepository, @NotNull BookLifecycle bookLifecycle, @NotNull SeriesLifecycle seriesLifecycle, @NotNull LocalArtworkProvider localArtworkProvider) {
        Intrinsics.checkNotNullParameter((Object)libraryRepository, (String)"libraryRepository");
        Intrinsics.checkNotNullParameter((Object)bookLifecycle, (String)"bookLifecycle");
        Intrinsics.checkNotNullParameter((Object)seriesLifecycle, (String)"seriesLifecycle");
        Intrinsics.checkNotNullParameter((Object)localArtworkProvider, (String)"localArtworkProvider");
        this.libraryRepository = libraryRepository;
        this.bookLifecycle = bookLifecycle;
        this.seriesLifecycle = seriesLifecycle;
        this.localArtworkProvider = localArtworkProvider;
    }

    public void refreshLocalArtwork(@NotNull Book book) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        LocalArtworkLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        Library library = this.libraryRepository.findById(book.getLibraryId());
        if (library.getImportLocalArtwork()) {
            Iterable $this$forEach$iv = this.localArtworkProvider.getBookThumbnails(book);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ThumbnailBook it = (ThumbnailBook)element$iv;
                boolean bl = false;
                this.bookLifecycle.addThumbnailForBook(it, it.getSelected() ? MarkSelectedPreference.IF_NONE_OR_GENERATED : MarkSelectedPreference.NO);
            }
        } else {
            LocalArtworkLifecycleKt.access$getLogger$p().info((Function0)refreshLocalArtwork.3.INSTANCE);
        }
    }

    public void refreshLocalArtwork(@NotNull Series series) {
        Intrinsics.checkNotNullParameter((Object)series, (String)"series");
        LocalArtworkLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        Library library = this.libraryRepository.findById(series.getLibraryId());
        if (library.getImportLocalArtwork()) {
            Iterable $this$forEach$iv = this.localArtworkProvider.getSeriesThumbnails(series);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ThumbnailSeries it = (ThumbnailSeries)element$iv;
                boolean bl = false;
                this.seriesLifecycle.addThumbnailForSeries(it, it.getSelected() ? MarkSelectedPreference.IF_NONE_OR_GENERATED : MarkSelectedPreference.NO);
            }
        } else {
            LocalArtworkLifecycleKt.access$getLogger$p().info((Function0)refreshLocalArtwork.6.INSTANCE);
        }
    }
}

