/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.jooq;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.domain.model.ReadStatus;
import org.gotson.komga.domain.model.SearchCondition;
import org.gotson.komga.domain.model.SearchContext;
import org.gotson.komga.domain.model.SearchOperator;
import org.gotson.komga.infrastructure.jooq.ContentRestrictionsSearchHelper;
import org.gotson.komga.infrastructure.jooq.RequiredJoin;
import org.gotson.komga.infrastructure.jooq.SearchOperatorUtilsKt;
import org.gotson.komga.infrastructure.jooq.SeriesSearchHelper;
import org.gotson.komga.infrastructure.jooq.SeriesSearchHelperKt;
import org.gotson.komga.infrastructure.jooq.UtilsKt;
import org.gotson.komga.jooq.main.Tables;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Select;
import org.jooq.TableField;
import org.jooq.impl.DSL;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bJ\"\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ*\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010H\u0002J$\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/gotson/komga/infrastructure/jooq/SeriesSearchHelper;", "Lorg/gotson/komga/infrastructure/jooq/ContentRestrictionsSearchHelper;", "context", "Lorg/gotson/komga/domain/model/SearchContext;", "(Lorg/gotson/komga/domain/model/SearchContext;)V", "getContext", "()Lorg/gotson/komga/domain/model/SearchContext;", "toCondition", "Lkotlin/Pair;", "Lorg/jooq/Condition;", "", "Lorg/gotson/komga/infrastructure/jooq/RequiredJoin;", "searchCondition", "Lorg/gotson/komga/domain/model/SearchCondition$Series;", "toConditionInternal", "libraryIds", "", "", "komga"})
@SourceDebugExtension(value={"SMAP\nSeriesSearchHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeriesSearchHelper.kt\norg/gotson/komga/infrastructure/jooq/SeriesSearchHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,252:1\n1549#2:253\n1620#2,3:254\n1789#2,3:257\n1789#2,3:260\n*S KotlinDebug\n*F\n+ 1 SeriesSearchHelper.kt\norg/gotson/komga/infrastructure/jooq/SeriesSearchHelper\n*L\n37#1:253\n37#1:254,3\n43#1:257,3\n49#1:260,3\n*E\n"})
public final class SeriesSearchHelper
extends ContentRestrictionsSearchHelper {
    @NotNull
    private final SearchContext context;

    public SeriesSearchHelper(@NotNull SearchContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final SearchContext getContext() {
        return this.context;
    }

    @NotNull
    public final Pair<Condition, Set<RequiredJoin>> toCondition(@Nullable SearchCondition.Series searchCondition) {
        Pair base = this.toCondition();
        Pair search = this.toConditionInternal(searchCondition);
        Condition condition = ((Condition)search.getFirst()).and((Condition)base.getFirst());
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"and(...)");
        return TuplesKt.to((Object)condition, (Object)SetsKt.plus((Set)((Set)search.getSecond()), (Iterable)((Iterable)base.getSecond())));
    }

    @NotNull
    public final Pair<Condition, Set<RequiredJoin>> toCondition() {
        Pair restrictions = this.toConditionInternal(this.context.getRestrictions());
        Pair authorizedLibraries = this.toConditionInternal(this.context.getLibraryIds());
        Condition condition = ((Condition)restrictions.getFirst()).and((Condition)authorizedLibraries.getFirst());
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"and(...)");
        return TuplesKt.to((Object)condition, (Object)SetsKt.plus((Set)((Set)restrictions.getSecond()), (Iterable)((Iterable)authorizedLibraries.getSecond())));
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Condition, Set<RequiredJoin>> toConditionInternal(Collection<String> libraryIds) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (libraryIds == null) {
            Condition condition = DSL.noCondition();
            Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"noCondition(...)");
            return TuplesKt.to((Object)condition, (Object)SetsKt.emptySet());
        }
        if (libraryIds.isEmpty()) {
            return TuplesKt.to((Object)DSL.falseCondition(), (Object)SetsKt.emptySet());
        }
        Iterable iterable = libraryIds;
        SeriesSearchHelper seriesSearchHelper = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new SearchCondition.LibraryId((SearchOperator.Equality)new SearchOperator.Is((Object)it)));
        }
        List list = (List)destination$iv$iv;
        return seriesSearchHelper.toConditionInternal((SearchCondition.Series)new SearchCondition.AnyOfSeries(list));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Pair<Condition, Set<RequiredJoin>> toConditionInternal(SearchCondition.Series searchCondition) {
        Pair pair;
        SearchCondition.Series series;
        block58: {
            Condition condition;
            block60: {
                SearchOperator.Equality equality3;
                TableField field;
                block59: {
                    series = searchCondition;
                    if (series instanceof SearchCondition.AllOfSeries) {
                        void $this$fold$iv;
                        Iterable iterable = ((SearchCondition.AllOfSeries)searchCondition).getConditions();
                        Condition condition2 = DSL.noCondition();
                        Intrinsics.checkNotNullExpressionValue((Object)condition2, (String)"noCondition(...)");
                        Pair initial$iv = TuplesKt.to((Object)condition2, (Object)SetsKt.emptySet());
                        boolean $i$f$fold = false;
                        Pair accumulator$iv = initial$iv;
                        for (Object element$iv : $this$fold$iv) {
                            void cond;
                            SearchCondition.Series series2 = (SearchCondition.Series)element$iv;
                            Pair acc = accumulator$iv;
                            boolean bl = false;
                            Pair seriesCondition = this.toConditionInternal((SearchCondition.Series)cond);
                            accumulator$iv = TuplesKt.to((Object)((Condition)acc.getFirst()).and((Condition)seriesCondition.getFirst()), (Object)SetsKt.plus((Set)((Set)acc.getSecond()), (Iterable)((Iterable)seriesCondition.getSecond())));
                        }
                        pair = accumulator$iv;
                        return pair;
                    }
                    if (series instanceof SearchCondition.AnyOfSeries) {
                        Iterable $this$fold$iv = ((SearchCondition.AnyOfSeries)searchCondition).getConditions();
                        Condition condition3 = DSL.noCondition();
                        Intrinsics.checkNotNullExpressionValue((Object)condition3, (String)"noCondition(...)");
                        Pair initial$iv = TuplesKt.to((Object)condition3, (Object)SetsKt.emptySet());
                        boolean $i$f$fold = false;
                        Pair accumulator$iv = initial$iv;
                        for (Object element$iv : $this$fold$iv) {
                            SearchCondition.Series cond = (SearchCondition.Series)element$iv;
                            Pair acc = accumulator$iv;
                            boolean bl = false;
                            Pair seriesCondition = this.toConditionInternal(cond);
                            accumulator$iv = TuplesKt.to((Object)((Condition)acc.getFirst()).or((Condition)seriesCondition.getFirst()), (Object)SetsKt.plus((Set)((Set)acc.getSecond()), (Iterable)((Iterable)seriesCondition.getSecond())));
                        }
                        pair = accumulator$iv;
                        return pair;
                    }
                    if (series instanceof SearchCondition.LibraryId) {
                        SearchOperator.Equality equality2 = ((SearchCondition.LibraryId)searchCondition).getOperator();
                        TableField tableField = Tables.SERIES.LIBRARY_ID;
                        Intrinsics.checkNotNullExpressionValue((Object)tableField, (String)"LIBRARY_ID");
                        pair = TuplesKt.to((Object)SearchOperatorUtilsKt.toCondition$default((SearchOperator.Equality)equality2, (Field)((Field)tableField), (boolean)false, (int)2, null), (Object)SetsKt.emptySet());
                        return pair;
                    }
                    if (series instanceof SearchCondition.Deleted) {
                        Condition condition4;
                        TableField it = Tables.SERIES.DELETED_DATE;
                        boolean equality3 = false;
                        SearchOperator.Boolean boolean_ = ((SearchCondition.Deleted)searchCondition).getOperator();
                        if (Intrinsics.areEqual((Object)boolean_, (Object)SearchOperator.IsFalse.INSTANCE)) {
                            condition4 = it.isNull();
                        } else {
                            if (!Intrinsics.areEqual((Object)boolean_, (Object)SearchOperator.IsTrue.INSTANCE)) throw new NoWhenBranchMatchedException();
                            condition4 = it.isNotNull();
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)condition4, (String)"let(...)");
                        pair = TuplesKt.to((Object)condition4, (Object)SetsKt.emptySet());
                        return pair;
                    }
                    if (series instanceof SearchCondition.ReleaseDate) {
                        SearchOperator.Date date = ((SearchCondition.ReleaseDate)searchCondition).getOperator();
                        TableField tableField = Tables.BOOK_METADATA_AGGREGATION.RELEASE_DATE;
                        Intrinsics.checkNotNullExpressionValue((Object)tableField, (String)"RELEASE_DATE");
                        pair = TuplesKt.to((Object)SearchOperatorUtilsKt.toCondition((SearchOperator.Date)date, (Field)((Field)tableField)), (Object)SetsKt.setOf((Object)RequiredJoin.BookMetadataAggregation.INSTANCE));
                        return pair;
                    }
                    if (!(series instanceof SearchCondition.ReadStatus)) break block58;
                    if (this.context.getUserId() == null) {
                        SeriesSearchHelperKt.access$getLogger$p().warn((Function0)toConditionInternal.5.INSTANCE);
                        pair = TuplesKt.to((Object)DSL.falseCondition(), (Object)SetsKt.emptySet());
                        return pair;
                    }
                    field = Tables.READ_PROGRESS_SERIES.READ_COUNT;
                    boolean bl = false;
                    equality3 = ((SearchCondition.ReadStatus)searchCondition).getOperator();
                    if (!(equality3 instanceof SearchOperator.Is)) break block59;
                    switch (WhenMappings.$EnumSwitchMapping$0[((ReadStatus)((SearchOperator.Is)((SearchCondition.ReadStatus)searchCondition).getOperator()).getValue()).ordinal()]) {
                        case 1: {
                            condition = field.isNull();
                            break block60;
                        }
                        case 2: {
                            condition = field.eq((Field)Tables.SERIES.BOOK_COUNT);
                            break block60;
                        }
                        case 3: {
                            condition = field.ne((Field)Tables.SERIES.BOOK_COUNT);
                            break block60;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                if (!(equality3 instanceof SearchOperator.IsNot)) throw new NoWhenBranchMatchedException();
                switch (WhenMappings.$EnumSwitchMapping$0[((ReadStatus)((SearchOperator.IsNot)((SearchCondition.ReadStatus)searchCondition).getOperator()).getValue()).ordinal()]) {
                    case 1: {
                        condition = field.isNotNull();
                        break;
                    }
                    case 2: {
                        condition = field.ne((Field)Tables.SERIES.BOOK_COUNT).or(field.isNull());
                        break;
                    }
                    case 3: {
                        condition = field.eq((Field)Tables.SERIES.BOOK_COUNT).or(field.isNull());
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            pair = TuplesKt.to((Object)condition, (Object)SetsKt.setOf((Object)new RequiredJoin.ReadProgress(this.context.getUserId())));
            return pair;
        }
        if (series instanceof SearchCondition.SeriesStatus) {
            SearchOperator.Equality equality = ((SearchCondition.SeriesStatus)searchCondition).getOperator();
            TableField tableField = Tables.SERIES_METADATA.STATUS;
            Intrinsics.checkNotNullExpressionValue((Object)tableField, (String)"STATUS");
            pair = TuplesKt.to((Object)SearchOperatorUtilsKt.toCondition((SearchOperator.Equality)equality, (Field)((Field)tableField), (Function1)((Function1)toConditionInternal.7.INSTANCE)), (Object)SetsKt.setOf((Object)RequiredJoin.SeriesMetadata.INSTANCE));
            return pair;
        } else if (series instanceof SearchCondition.Tag) {
            Condition condition;
            TableField field = Tables.SERIES.ID;
            boolean bl = false;
            Function1 inner2 = (Function1)toConditionInternal.8.inner.1.INSTANCE;
            SearchOperator.Equality equality = ((SearchCondition.Tag)searchCondition).getOperator();
            if (equality instanceof SearchOperator.Is) {
                condition = field.in((Select)inner2.invoke(((SearchOperator.Is)((SearchCondition.Tag)searchCondition).getOperator()).getValue()));
            } else {
                if (!(equality instanceof SearchOperator.IsNot)) throw new NoWhenBranchMatchedException();
                condition = field.notIn((Select)inner2.invoke(((SearchOperator.IsNot)((SearchCondition.Tag)searchCondition).getOperator()).getValue()));
            }
            Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"let(...)");
            pair = TuplesKt.to((Object)condition, (Object)SetsKt.emptySet());
            return pair;
        } else if (series instanceof SearchCondition.Author) {
            Condition condition;
            TableField field = Tables.SERIES.ID;
            boolean bl = false;
            Function2 inner3 = (Function2)toConditionInternal.9.inner.1.INSTANCE;
            SearchOperator.Equality inner2 = ((SearchCondition.Author)searchCondition).getOperator();
            if (inner2 instanceof SearchOperator.Is) {
                condition = ((SearchCondition.AuthorMatch)((SearchOperator.Is)((SearchCondition.Author)searchCondition).getOperator()).getValue()).getName() == null && ((SearchCondition.AuthorMatch)((SearchOperator.Is)((SearchCondition.Author)searchCondition).getOperator()).getValue()).getRole() == null ? DSL.noCondition() : field.in((Select)inner3.invoke((Object)((SearchCondition.AuthorMatch)((SearchOperator.Is)((SearchCondition.Author)searchCondition).getOperator()).getValue()).getName(), (Object)((SearchCondition.AuthorMatch)((SearchOperator.Is)((SearchCondition.Author)searchCondition).getOperator()).getValue()).getRole()));
            } else {
                if (!(inner2 instanceof SearchOperator.IsNot)) throw new NoWhenBranchMatchedException();
                condition = ((SearchCondition.AuthorMatch)((SearchOperator.IsNot)((SearchCondition.Author)searchCondition).getOperator()).getValue()).getName() == null && ((SearchCondition.AuthorMatch)((SearchOperator.IsNot)((SearchCondition.Author)searchCondition).getOperator()).getValue()).getRole() == null ? DSL.noCondition() : field.notIn((Select)inner3.invoke((Object)((SearchCondition.AuthorMatch)((SearchOperator.IsNot)((SearchCondition.Author)searchCondition).getOperator()).getValue()).getName(), (Object)((SearchCondition.AuthorMatch)((SearchOperator.IsNot)((SearchCondition.Author)searchCondition).getOperator()).getValue()).getRole()));
            }
            Condition condition5 = condition;
            Intrinsics.checkNotNull((Object)condition5);
            pair = TuplesKt.to((Object)condition5, (Object)SetsKt.emptySet());
            return pair;
        } else if (series instanceof SearchCondition.OneShot) {
            SearchOperator.Boolean boolean_ = ((SearchCondition.OneShot)searchCondition).getOperator();
            TableField tableField = Tables.SERIES.ONESHOT;
            Intrinsics.checkNotNullExpressionValue((Object)tableField, (String)"ONESHOT");
            pair = TuplesKt.to((Object)SearchOperatorUtilsKt.toCondition((SearchOperator.Boolean)boolean_, (Field)((Field)tableField)), (Object)SetsKt.emptySet());
            return pair;
        } else if (series instanceof SearchCondition.AgeRating) {
            SearchOperator.NumericNullable numericNullable = ((SearchCondition.AgeRating)searchCondition).getOperator();
            TableField tableField = Tables.SERIES_METADATA.AGE_RATING;
            Intrinsics.checkNotNullExpressionValue((Object)tableField, (String)"AGE_RATING");
            pair = TuplesKt.to((Object)SearchOperatorUtilsKt.toCondition((SearchOperator.NumericNullable)numericNullable, (Field)((Field)tableField)), (Object)SetsKt.setOf((Object)RequiredJoin.SeriesMetadata.INSTANCE));
            return pair;
        } else if (series instanceof SearchCondition.CollectionId) {
            SearchOperator.Equality equality = ((SearchCondition.CollectionId)searchCondition).getOperator();
            if (equality instanceof SearchOperator.Is) {
                pair = TuplesKt.to((Object)UtilsKt.csAlias((String)((String)((SearchOperator.Is)((SearchCondition.CollectionId)searchCondition).getOperator()).getValue())).COLLECTION_ID.eq(((SearchOperator.Is)((SearchCondition.CollectionId)searchCondition).getOperator()).getValue()), (Object)SetsKt.setOf((Object)new RequiredJoin.Collection((String)((SearchOperator.Is)((SearchCondition.CollectionId)searchCondition).getOperator()).getValue())));
                return pair;
            } else {
                if (!(equality instanceof SearchOperator.IsNot)) throw new NoWhenBranchMatchedException();
                Function1 inner4 = (Function1)toConditionInternal.inner.1.INSTANCE;
                Condition condition = Tables.SERIES.ID.notIn((Select)inner4.invoke(((SearchOperator.IsNot)((SearchCondition.CollectionId)searchCondition).getOperator()).getValue()));
                Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"notIn(...)");
                pair = TuplesKt.to((Object)condition, (Object)SetsKt.emptySet());
            }
            return pair;
        } else if (series instanceof SearchCondition.Complete) {
            Condition condition;
            TableField field = Tables.SERIES_METADATA.TOTAL_BOOK_COUNT;
            boolean bl = false;
            SearchOperator.Boolean inner3 = ((SearchCondition.Complete)searchCondition).getOperator();
            if (Intrinsics.areEqual((Object)inner3, (Object)SearchOperator.IsTrue.INSTANCE)) {
                condition = field.isNotNull().and(field.eq((Field)Tables.SERIES.BOOK_COUNT));
            } else {
                if (!Intrinsics.areEqual((Object)inner3, (Object)SearchOperator.IsFalse.INSTANCE)) throw new NoWhenBranchMatchedException();
                condition = field.isNotNull().and(field.ne((Field)Tables.SERIES.BOOK_COUNT));
            }
            pair = TuplesKt.to((Object)condition, (Object)SetsKt.setOf((Object)RequiredJoin.SeriesMetadata.INSTANCE));
            return pair;
        } else if (series instanceof SearchCondition.Genre) {
            Condition condition;
            TableField field = Tables.SERIES.ID;
            boolean bl = false;
            Function1 inner5 = (Function1)toConditionInternal.11.inner.1.INSTANCE;
            SearchOperator.Equality equality = ((SearchCondition.Genre)searchCondition).getOperator();
            if (equality instanceof SearchOperator.Is) {
                condition = field.in((Select)inner5.invoke(((SearchOperator.Is)((SearchCondition.Genre)searchCondition).getOperator()).getValue()));
            } else {
                if (!(equality instanceof SearchOperator.IsNot)) throw new NoWhenBranchMatchedException();
                condition = field.notIn((Select)inner5.invoke(((SearchOperator.IsNot)((SearchCondition.Genre)searchCondition).getOperator()).getValue()));
            }
            Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"let(...)");
            pair = TuplesKt.to((Object)condition, (Object)SetsKt.emptySet());
            return pair;
        } else if (series instanceof SearchCondition.Language) {
            SearchOperator.Equality equality = ((SearchCondition.Language)searchCondition).getOperator();
            TableField tableField = Tables.SERIES_METADATA.LANGUAGE;
            Intrinsics.checkNotNullExpressionValue((Object)tableField, (String)"LANGUAGE");
            pair = TuplesKt.to((Object)SearchOperatorUtilsKt.toCondition((SearchOperator.Equality)equality, (Field)((Field)tableField), (boolean)true), (Object)SetsKt.setOf((Object)RequiredJoin.SeriesMetadata.INSTANCE));
            return pair;
        } else if (series instanceof SearchCondition.Publisher) {
            SearchOperator.Equality equality = ((SearchCondition.Publisher)searchCondition).getOperator();
            TableField tableField = Tables.SERIES_METADATA.PUBLISHER;
            Intrinsics.checkNotNullExpressionValue((Object)tableField, (String)"PUBLISHER");
            pair = TuplesKt.to((Object)SearchOperatorUtilsKt.toCondition((SearchOperator.Equality)equality, (Field)((Field)tableField), (boolean)true), (Object)SetsKt.setOf((Object)RequiredJoin.SeriesMetadata.INSTANCE));
            return pair;
        } else if (series instanceof SearchCondition.SharingLabel) {
            Condition condition;
            TableField field = Tables.SERIES.ID;
            boolean bl = false;
            Function1 inner6 = (Function1)toConditionInternal.12.inner.1.INSTANCE;
            SearchOperator.Equality equality = ((SearchCondition.SharingLabel)searchCondition).getOperator();
            if (equality instanceof SearchOperator.Is) {
                condition = field.in((Select)inner6.invoke(((SearchOperator.Is)((SearchCondition.SharingLabel)searchCondition).getOperator()).getValue()));
            } else {
                if (!(equality instanceof SearchOperator.IsNot)) throw new NoWhenBranchMatchedException();
                condition = field.notIn((Select)inner6.invoke(((SearchOperator.IsNot)((SearchCondition.SharingLabel)searchCondition).getOperator()).getValue()));
            }
            Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"let(...)");
            pair = TuplesKt.to((Object)condition, (Object)SetsKt.emptySet());
            return pair;
        } else if (series instanceof SearchCondition.Title) {
            SearchOperator.StringOp stringOp = ((SearchCondition.Title)searchCondition).getOperator();
            TableField tableField = Tables.SERIES_METADATA.TITLE;
            Intrinsics.checkNotNullExpressionValue((Object)tableField, (String)"TITLE");
            pair = TuplesKt.to((Object)SearchOperatorUtilsKt.toCondition((SearchOperator.StringOp)stringOp, (Field)((Field)tableField)), (Object)SetsKt.setOf((Object)RequiredJoin.SeriesMetadata.INSTANCE));
            return pair;
        } else if (series instanceof SearchCondition.TitleSort) {
            SearchOperator.StringOp stringOp = ((SearchCondition.TitleSort)searchCondition).getOperator();
            TableField tableField = Tables.SERIES_METADATA.TITLE_SORT;
            Intrinsics.checkNotNullExpressionValue((Object)tableField, (String)"TITLE_SORT");
            pair = TuplesKt.to((Object)SearchOperatorUtilsKt.toCondition((SearchOperator.StringOp)stringOp, (Field)((Field)tableField)), (Object)SetsKt.setOf((Object)RequiredJoin.SeriesMetadata.INSTANCE));
            return pair;
        } else {
            if (series != null) throw new NoWhenBranchMatchedException();
            Condition condition = DSL.noCondition();
            Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"noCondition(...)");
            pair = TuplesKt.to((Object)condition, (Object)SetsKt.emptySet());
        }
        return pair;
    }
}

