/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.jooq.main;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.gotson.komga.domain.model.BookPage;
import org.gotson.komga.domain.model.Dimension;
import org.gotson.komga.domain.model.Media;
import org.gotson.komga.domain.model.MediaExtension;
import org.gotson.komga.domain.model.MediaFile;
import org.gotson.komga.domain.model.ProxyExtension;
import org.gotson.komga.domain.persistence.MediaRepository;
import org.gotson.komga.infrastructure.jooq.UtilsKt;
import org.gotson.komga.infrastructure.jooq.main.MediaDao;
import org.gotson.komga.jooq.main.Tables;
import org.gotson.komga.jooq.main.tables.Book;
import org.gotson.komga.jooq.main.tables.MediaPage;
import org.gotson.komga.jooq.main.tables.records.MediaFileRecord;
import org.gotson.komga.jooq.main.tables.records.MediaPageRecord;
import org.gotson.komga.jooq.main.tables.records.MediaRecord;
import org.gotson.komga.language.LanguageUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.AggregateFunction;
import org.jooq.BatchBindStep;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.Record2;
import org.jooq.RecordMapper;
import org.jooq.Result;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.UpdateSetMoreStep;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0017J\u0016\u0010\u0018\u001a\u00020\u00192\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001dH\u0017J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001bH\u0012J,\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001b0\u001d2\u0006\u0010!\u001a\u00020\u001b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001d2\u0006\u0010#\u001a\u00020\u0005H\u0016J\u0010\u0010$\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J(\u0010(\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00050)0\u001d2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001dH\u0016J\u0016\u0010*\u001a\u00020\u00192\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001dH\u0017J\u0010\u0010*\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\u001fH\u0017J\u0016\u0010-\u001a\u00020\u00192\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001dH\u0012J\u0016\u0010.\u001a\u00020\u00192\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001dH\u0012J\u0010\u0010/\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\u001fH\u0017J\f\u00100\u001a\u000201*\u000202H\u0012J\f\u00100\u001a\u000203*\u000204H\u0012J(\u00100\u001a\u00020\u001f*\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u000203072\f\u00108\u001a\b\u0012\u0004\u0012\u00020107H\u0012R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000b*\u0004\u0018\u00010\r0\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000e\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u000b*\b\u0012\u0002\b\u0003\u0018\u00010\u00100\u00100\u000fX\u0092\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0016\u0010\u0012\u001a\n \u000b*\u0004\u0018\u00010\u00130\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u000b*\u0004\u0018\u00010\u00150\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/gotson/komga/infrastructure/jooq/main/MediaDao;", "Lorg/gotson/komga/domain/persistence/MediaRepository;", "dsl", "Lorg/jooq/DSLContext;", "batchSize", "", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lorg/jooq/DSLContext;ILcom/fasterxml/jackson/databind/ObjectMapper;)V", "b", "Lorg/gotson/komga/jooq/main/tables/Book;", "kotlin.jvm.PlatformType", "f", "Lorg/gotson/komga/jooq/main/tables/MediaFile;", "groupFields", "", "Lorg/jooq/Field;", "[Lorg/jooq/Field;", "m", "Lorg/gotson/komga/jooq/main/tables/Media;", "p", "Lorg/gotson/komga/jooq/main/tables/MediaPage;", "count", "", "delete", "", "bookId", "", "bookIds", "", "find", "Lorg/gotson/komga/domain/model/Media;", "findAllBookIdsByLibraryIdAndMediaTypeAndWithMissingPageHash", "libraryId", "mediaTypes", "pageHashing", "findById", "findByIdOrNull", "findExtensionByIdOrNull", "Lorg/gotson/komga/domain/model/MediaExtension;", "getPagesSizes", "Lkotlin/Pair;", "insert", "medias", "media", "insertFiles", "insertPages", "update", "toDomain", "Lorg/gotson/komga/domain/model/MediaFile;", "Lorg/gotson/komga/jooq/main/tables/records/MediaFileRecord;", "Lorg/gotson/komga/domain/model/BookPage;", "Lorg/gotson/komga/jooq/main/tables/records/MediaPageRecord;", "Lorg/gotson/komga/jooq/main/tables/records/MediaRecord;", "pages", "", "files", "komga"})
@SourceDebugExtension(value={"SMAP\nMediaDao.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediaDao.kt\norg/gotson/komga/infrastructure/jooq/main/MediaDao\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,328:1\n125#2:329\n152#2,2:330\n154#2:339\n819#3:332\n847#3,2:333\n1549#3:335\n1620#3,3:336\n1855#3:340\n1855#3:341\n1856#3:343\n1856#3:344\n1747#3,3:345\n1855#3:348\n1855#3:349\n1864#3,3:350\n1856#3:353\n1856#3:354\n1747#3,3:355\n1855#3:358\n1855#3:359\n1855#3,2:360\n1856#3:362\n1856#3:363\n1#4:342\n*S KotlinDebug\n*F\n+ 1 MediaDao.kt\norg/gotson/komga/infrastructure/jooq/main/MediaDao\n*L\n118#1:329\n118#1:330,2\n118#1:339\n125#1:332\n125#1:333,2\n125#1:335\n125#1:336,3\n136#1:340\n153#1:341\n153#1:343\n136#1:344\n175#1:345,3\n176#1:348\n192#1:349\n193#1:350,3\n192#1:353\n176#1:354\n212#1:355,3\n213#1:358\n226#1:359\n227#1:360,2\n226#1:362\n213#1:363\n*E\n"})
public class MediaDao
implements MediaRepository {
    @NotNull
    private final DSLContext dsl;
    private final int batchSize;
    @NotNull
    private final ObjectMapper mapper;
    private final org.gotson.komga.jooq.main.tables.Media m;
    private final MediaPage p;
    private final org.gotson.komga.jooq.main.tables.MediaFile f;
    private final Book b;
    @NotNull
    private final Field<?>[] groupFields;

    public MediaDao(@NotNull DSLContext dsl, @Value(value="#{@komgaProperties.database.batchChunkSize}") int batchSize, @NotNull ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)dsl, (String)"dsl");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this.dsl = dsl;
        this.batchSize = batchSize;
        this.mapper = mapper;
        this.m = Tables.MEDIA;
        this.p = Tables.MEDIA_PAGE;
        this.f = Tables.MEDIA_FILE;
        this.b = Tables.BOOK;
        SpreadBuilder spreadBuilder = new SpreadBuilder(11);
        spreadBuilder.add((Object)this.m.BOOK_ID);
        spreadBuilder.add((Object)this.m.MEDIA_TYPE);
        spreadBuilder.add((Object)this.m.STATUS);
        spreadBuilder.add((Object)this.m.CREATED_DATE);
        spreadBuilder.add((Object)this.m.LAST_MODIFIED_DATE);
        spreadBuilder.add((Object)this.m.COMMENT);
        spreadBuilder.add((Object)this.m.PAGE_COUNT);
        spreadBuilder.add((Object)this.m.EXTENSION_CLASS);
        spreadBuilder.add((Object)this.m.EPUB_DIVINA_COMPATIBLE);
        spreadBuilder.add((Object)this.m.EPUB_IS_KEPUB);
        Field[] fieldArray = this.p.fields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"fields(...)");
        spreadBuilder.addSpread((Object)fieldArray);
        this.groupFields = (Field[])spreadBuilder.toArray((Object[])new Field[spreadBuilder.size()]);
    }

    @NotNull
    public Media findById(@NotNull String bookId) {
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        Media media = this.find(this.dsl, bookId);
        Intrinsics.checkNotNull((Object)media);
        return media;
    }

    @Nullable
    public Media findByIdOrNull(@NotNull String bookId) {
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        return this.find(this.dsl, bookId);
    }

    @Nullable
    public MediaExtension findExtensionByIdOrNull(@NotNull String bookId) {
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        Record2 record2 = (Record2)this.dsl.select((SelectField)this.m.EXTENSION_CLASS, (SelectField)this.m.EXTENSION_VALUE_BLOB).from((TableLike)this.m).where(this.m.BOOK_ID.eq((Object)bookId)).fetchOne();
        return record2 != null ? (MediaExtension)record2.map(arg_0 -> MediaDao.findExtensionByIdOrNull$lambda$0(this, arg_0)) : null;
    }

    @NotNull
    public Collection<String> findAllBookIdsByLibraryIdAndMediaTypeAndWithMissingPageHash(@NotNull String libraryId, @NotNull Collection<String> mediaTypes, int pageHashing) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        Intrinsics.checkNotNullParameter(mediaTypes, (String)"mediaTypes");
        AggregateFunction aggregateFunction = DSL.count((Field)((Field)this.p.BOOK_ID));
        Intrinsics.checkNotNullExpressionValue((Object)aggregateFunction, (String)"count(...)");
        AggregateFunction pagesCount = aggregateFunction;
        Field field = DSL.sum((Field)DSL.when((Condition)this.p.FILE_HASH.eq((Object)""), (Object)0).otherwise((Object)1)).cast(Integer.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)field, (String)"cast(...)");
        Field hashedCount = field;
        int neededHash = pageHashing * 2;
        Field field2 = DSL.when((Condition)pagesCount.lt((Object)neededHash), (Field)((Field)pagesCount)).otherwise((Object)neededHash);
        Intrinsics.checkNotNullExpressionValue((Object)field2, (String)"otherwise(...)");
        Field neededHashForBook = field2;
        GroupField[] groupFieldArray = new GroupField[]{this.b.ID};
        List list = this.dsl.select((SelectField)this.b.ID).from((TableLike)this.b).leftJoin((TableLike)this.p).on(this.b.ID.eq((Field)this.p.BOOK_ID)).leftJoin((TableLike)this.m).on(this.b.ID.eq((Field)this.m.BOOK_ID)).where(this.b.LIBRARY_ID.eq((Object)libraryId)).and(this.m.STATUS.eq((Object)"READY")).and(this.m.MEDIA_TYPE.in(mediaTypes)).groupBy(groupFieldArray).having(hashedCount.lt(neededHashForBook)).fetch().map((RecordMapper)findAllBookIdsByLibraryIdAndMediaTypeAndWithMissingPageHash.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    @NotNull
    public Collection<Pair<String, Integer>> getPagesSizes(@NotNull Collection<String> bookIds) {
        Intrinsics.checkNotNullParameter(bookIds, (String)"bookIds");
        List list = this.dsl.select((SelectField)this.m.BOOK_ID, (SelectField)this.m.PAGE_COUNT).from((TableLike)this.m).where(this.m.BOOK_ID.in(bookIds)).fetch().map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private Media find(DSLContext dsl, String bookId) {
        void $this$mapTo$iv$iv;
        Field[] fieldArray = this.groupFields;
        SelectConditionStep selectConditionStep = dsl.select((SelectFieldOrAsterisk[])Arrays.copyOf(fieldArray, fieldArray.length)).from((TableLike)this.m).leftJoin((TableLike)this.p).on(this.m.BOOK_ID.eq((Field)this.p.BOOK_ID)).where(this.m.BOOK_ID.eq((Object)bookId));
        fieldArray = this.groupFields;
        Map map = selectConditionStep.groupBy((GroupField[])Arrays.copyOf(fieldArray, fieldArray.length)).orderBy((OrderField)this.p.NUMBER.asc()).fetchGroups((RecordMapper)new /* Unavailable Anonymous Inner Class!! */, (RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"fetchGroups(...)");
        Map $this$map$iv = map;
        boolean $i$f$map = false;
        Map map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Result files;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            MediaPageRecord it;
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            MediaRecord mr = (MediaRecord)entry.getKey();
            List pr = (List)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)dsl.selectFrom((TableLike)this.f).where(this.f.BOOK_ID.eq((Object)bookId)).fetchInto((Table)this.f), (String)"fetchInto(...)");
            Intrinsics.checkNotNull((Object)mr);
            Intrinsics.checkNotNull((Object)pr);
            Iterable iterable = pr;
            MediaRecord mediaRecord = mr;
            MediaDao mediaDao = this;
            boolean $i$f$filterNot = false;
            void var19_20 = $this$filterNot$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                it = (MediaPageRecord)element$iv$iv;
                boolean bl2 = false;
                if (it.getBookId() == null) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            Collection<BookPage> collection2 = (List)destination$iv$iv2;
            $this$filterNot$iv = collection2;
            boolean $i$f$map2 = false;
            $this$filterNotTo$iv$iv = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                it = (MediaPageRecord)item$iv$iv2;
                collection2 = destination$iv$iv2;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)it);
                collection2.add(this.toDomain(it));
            }
            collection2 = (List)destination$iv$iv2;
            List list = files.map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
            collection.add(mediaDao.toDomain(mediaRecord, (List)collection2, list));
        }
        return (Media)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    @Transactional
    public void insert(@NotNull Media media) {
        Intrinsics.checkNotNullParameter((Object)media, (String)"media");
        this.insert((Collection)CollectionsKt.listOf((Object)media));
    }

    @Transactional
    public void insert(@NotNull Collection<Media> medias) {
        Intrinsics.checkNotNullParameter(medias, (String)"medias");
        if (!medias.isEmpty()) {
            Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)medias, (int)this.batchSize);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BatchBindStep batchBindStep;
                List chunk = (List)element$iv;
                boolean bl = false;
                BatchBindStep step = batchBindStep = this.dsl.batch((Query)this.dsl.insertInto((Table)this.m, (Field)this.m.BOOK_ID, (Field)this.m.STATUS, (Field)this.m.MEDIA_TYPE, (Field)this.m.COMMENT, (Field)this.m.PAGE_COUNT, (Field)this.m.EPUB_DIVINA_COMPATIBLE, (Field)this.m.EPUB_IS_KEPUB, (Field)this.m.EXTENSION_CLASS, (Field)this.m.EXTENSION_VALUE_BLOB).values(null, null, null, null, null, null, null, null, null));
                boolean bl2 = false;
                Iterable $this$forEach$iv2 = chunk;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String string;
                    String string2;
                    String string3;
                    MediaExtension it;
                    BatchBindStep batchBindStep2;
                    Object[] objectArray;
                    int n;
                    Media media = (Media)element$iv2;
                    boolean bl3 = false;
                    BatchBindStep batchBindStep3 = step;
                    Object[] objectArray2 = new Object[9];
                    objectArray2[0] = media.getBookId();
                    objectArray2[1] = media.getStatus();
                    objectArray2[2] = media.getMediaType();
                    objectArray2[3] = media.getComment();
                    objectArray2[4] = media.getPageCount();
                    objectArray2[5] = media.getEpubDivinaCompatible();
                    objectArray2[6] = media.getEpubIsKepub();
                    Object[] objectArray3 = objectArray2;
                    int n2 = 7;
                    if (media.getExtension() != null) {
                        n = n2;
                        objectArray = objectArray3;
                        batchBindStep2 = batchBindStep3;
                        boolean bl4 = false;
                        string3 = it instanceof ProxyExtension ? null : Reflection.getOrCreateKotlinClass(it.getClass()).getQualifiedName();
                        batchBindStep3 = batchBindStep2;
                        objectArray3 = objectArray;
                        n2 = n;
                        string2 = string3;
                    } else {
                        string2 = null;
                    }
                    objectArray3[n2] = string2;
                    Object[] objectArray4 = objectArray2;
                    int n3 = 8;
                    if (media.getExtension() != null) {
                        n = n3;
                        objectArray = objectArray4;
                        batchBindStep2 = batchBindStep3;
                        boolean bl5 = false;
                        string3 = it instanceof ProxyExtension ? null : UtilsKt.serializeJsonGz((ObjectMapper)this.mapper, (Object)it);
                        batchBindStep3 = batchBindStep2;
                        objectArray4 = objectArray;
                        n3 = n;
                        string = string3;
                    } else {
                        string = null;
                    }
                    objectArray4[n3] = string;
                    batchBindStep3.bind(objectArray2);
                }
                batchBindStep.execute();
            }
            this.insertPages(medias);
            this.insertFiles(medias);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void insertPages(Collection<Media> medias) {
        boolean bl;
        block8: {
            Iterable $this$any$iv = medias;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Media it = (Media)element$iv;
                    boolean bl2 = false;
                    boolean bl3 = !((Collection)it.getPages()).isEmpty();
                    if (!bl3) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)medias, (int)this.batchSize);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BatchBindStep batchBindStep;
                List chunk = (List)element$iv;
                boolean bl4 = false;
                BatchBindStep step = batchBindStep = this.dsl.batch((Query)this.dsl.insertInto((Table)this.p, (Field)this.p.BOOK_ID, (Field)this.p.FILE_NAME, (Field)this.p.MEDIA_TYPE, (Field)this.p.NUMBER, (Field)this.p.WIDTH, (Field)this.p.HEIGHT, (Field)this.p.FILE_HASH, (Field)this.p.FILE_SIZE).values(null, null, null, null, null, null, null, null));
                boolean bl5 = false;
                Iterable $this$forEach$iv2 = chunk;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Media media = (Media)element$iv2;
                    boolean bl6 = false;
                    Iterable $this$forEachIndexed$iv = media.getPages();
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (Object item$iv : $this$forEachIndexed$iv) {
                        void page;
                        int n;
                        if ((n = index$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        BookPage bookPage = (BookPage)item$iv;
                        int index = n;
                        boolean bl7 = false;
                        Object[] objectArray = new Object[8];
                        objectArray[0] = media.getBookId();
                        objectArray[1] = page.getFileName();
                        objectArray[2] = page.getMediaType();
                        objectArray[3] = index;
                        Dimension dimension = page.getDimension();
                        objectArray[4] = dimension != null ? Integer.valueOf(dimension.getWidth()) : null;
                        Dimension dimension2 = page.getDimension();
                        objectArray[5] = dimension2 != null ? Integer.valueOf(dimension2.getHeight()) : null;
                        objectArray[6] = page.getFileHash();
                        objectArray[7] = page.getFileSize();
                        step.bind(objectArray);
                    }
                }
                batchBindStep.execute();
            }
        }
    }

    private void insertFiles(Collection<Media> medias) {
        boolean bl;
        block7: {
            Iterable $this$any$iv = medias;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Media it = (Media)element$iv;
                    boolean bl2 = false;
                    boolean bl3 = !((Collection)it.getFiles()).isEmpty();
                    if (!bl3) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)medias, (int)this.batchSize);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BatchBindStep batchBindStep;
                List chunk = (List)element$iv;
                boolean bl4 = false;
                BatchBindStep step = batchBindStep = this.dsl.batch((Query)this.dsl.insertInto((Table)this.f, (Field)this.f.BOOK_ID, (Field)this.f.FILE_NAME, (Field)this.f.MEDIA_TYPE, (Field)this.f.SUB_TYPE, (Field)this.f.FILE_SIZE).values(null, null, null, null, null));
                boolean bl5 = false;
                Iterable $this$forEach$iv2 = chunk;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Media media = (Media)element$iv2;
                    boolean bl6 = false;
                    Iterable $this$forEach$iv3 = media.getFiles();
                    boolean $i$f$forEach3 = false;
                    for (Object element$iv3 : $this$forEach$iv3) {
                        MediaFile it = (MediaFile)element$iv3;
                        boolean bl7 = false;
                        Object[] objectArray = new Object[]{media.getBookId(), it.getFileName(), it.getMediaType(), it.getSubType(), it.getFileSize()};
                        step.bind(objectArray);
                    }
                }
                batchBindStep.execute();
            }
        }
    }

    @Transactional
    public void update(@NotNull Media media) {
        UpdateSetMoreStep updateSetMoreStep;
        Intrinsics.checkNotNullParameter((Object)media, (String)"media");
        UpdateSetMoreStep $this$update_u24lambda_u2419 = updateSetMoreStep = this.dsl.update((Table)this.m).set((Field)this.m.STATUS, (Object)media.getStatus().toString()).set((Field)this.m.MEDIA_TYPE, (Object)media.getMediaType()).set((Field)this.m.COMMENT, (Object)media.getComment()).set((Field)this.m.PAGE_COUNT, (Object)media.getPageCount()).set((Field)this.m.EPUB_DIVINA_COMPATIBLE, (Object)media.getEpubDivinaCompatible()).set((Field)this.m.EPUB_IS_KEPUB, (Object)media.getEpubIsKepub());
        boolean bl = false;
        if (media.getExtension() != null && !(media.getExtension() instanceof ProxyExtension)) {
            $this$update_u24lambda_u2419.set((Field)this.m.EXTENSION_CLASS, (Object)Reflection.getOrCreateKotlinClass(media.getExtension().getClass()).getQualifiedName());
            $this$update_u24lambda_u2419.set((Field)this.m.EXTENSION_VALUE_BLOB, (Object)UtilsKt.serializeJsonGz((ObjectMapper)this.mapper, (Object)media.getExtension()));
        }
        updateSetMoreStep.set((Field)this.m.LAST_MODIFIED_DATE, (Object)LocalDateTime.now(ZoneId.of("Z"))).where(this.m.BOOK_ID.eq((Object)media.getBookId())).execute();
        this.dsl.deleteFrom((Table)this.p).where(this.p.BOOK_ID.eq((Object)media.getBookId())).execute();
        this.dsl.deleteFrom((Table)this.f).where(this.f.BOOK_ID.eq((Object)media.getBookId())).execute();
        this.insertPages((Collection)CollectionsKt.listOf((Object)media));
        this.insertFiles((Collection)CollectionsKt.listOf((Object)media));
    }

    @Transactional
    public void delete(@NotNull String bookId) {
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        this.dsl.deleteFrom((Table)this.p).where(this.p.BOOK_ID.eq((Object)bookId)).execute();
        this.dsl.deleteFrom((Table)this.f).where(this.f.BOOK_ID.eq((Object)bookId)).execute();
        this.dsl.deleteFrom((Table)this.m).where(this.m.BOOK_ID.eq((Object)bookId)).execute();
    }

    @Transactional
    public void delete(@NotNull Collection<String> bookIds) {
        Intrinsics.checkNotNullParameter(bookIds, (String)"bookIds");
        UtilsKt.insertTempStrings((DSLContext)this.dsl, (int)this.batchSize, bookIds);
        this.dsl.deleteFrom((Table)this.p).where(this.p.BOOK_ID.in((Select)UtilsKt.selectTempStrings((DSLContext)this.dsl))).execute();
        this.dsl.deleteFrom((Table)this.f).where(this.f.BOOK_ID.in((Select)UtilsKt.selectTempStrings((DSLContext)this.dsl))).execute();
        this.dsl.deleteFrom((Table)this.m).where(this.m.BOOK_ID.in((Select)UtilsKt.selectTempStrings((DSLContext)this.dsl))).execute();
    }

    public long count() {
        return this.dsl.fetchCount((Table)this.m);
    }

    private Media toDomain(MediaRecord $this$toDomain, List<? extends BookPage> pages, List<MediaFile> files) {
        String string = $this$toDomain.getStatus();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStatus(...)");
        Media.Status status = Media.Status.valueOf((String)string);
        String string2 = $this$toDomain.getMediaType();
        Integer n = $this$toDomain.getPageCount();
        ProxyExtension proxyExtension = ProxyExtension.Companion.of($this$toDomain.getExtensionClass());
        String string3 = $this$toDomain.getComment();
        String string4 = $this$toDomain.getBookId();
        Boolean bl = $this$toDomain.getEpubDivinaCompatible();
        Boolean bl2 = $this$toDomain.getEpubIsKepub();
        LocalDateTime localDateTime = $this$toDomain.getCreatedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"getCreatedDate(...)");
        LocalDateTime localDateTime2 = LanguageUtilsKt.toCurrentTimeZone((LocalDateTime)localDateTime);
        LocalDateTime localDateTime3 = $this$toDomain.getLastModifiedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime3, (String)"getLastModifiedDate(...)");
        LocalDateTime localDateTime4 = LanguageUtilsKt.toCurrentTimeZone((LocalDateTime)localDateTime3);
        Intrinsics.checkNotNull((Object)n);
        int n2 = n;
        MediaExtension mediaExtension = (MediaExtension)proxyExtension;
        Intrinsics.checkNotNull((Object)string4);
        Intrinsics.checkNotNull((Object)bl);
        boolean bl3 = bl;
        Intrinsics.checkNotNull((Object)bl2);
        return new Media(status, string2, pages, n2, files, string3, mediaExtension, string4, bl3, bl2.booleanValue(), localDateTime2, localDateTime4);
    }

    private BookPage toDomain(MediaPageRecord $this$toDomain) {
        Dimension dimension;
        String string = $this$toDomain.getFileName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
        String string2 = $this$toDomain.getMediaType();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMediaType(...)");
        if ($this$toDomain.getWidth() != null && $this$toDomain.getHeight() != null) {
            Integer n = $this$toDomain.getWidth();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getWidth(...)");
            int n2 = ((Number)n).intValue();
            Integer n3 = $this$toDomain.getHeight();
            Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"getHeight(...)");
            dimension = new Dimension(n2, ((Number)n3).intValue());
        } else {
            dimension = null;
        }
        String string3 = $this$toDomain.getFileHash();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getFileHash(...)");
        return new BookPage(string, string2, dimension, string3, $this$toDomain.getFileSize());
    }

    /*
     * WARNING - void declaration
     */
    private MediaFile toDomain(MediaFileRecord $this$toDomain) {
        MediaFile.SubType subType;
        String string = $this$toDomain.getFileName();
        String string2 = string;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
        String string3 = $this$toDomain.getMediaType();
        String string4 = $this$toDomain.getSubType();
        if (string4 != null) {
            void it;
            String string5 = string4;
            String string6 = string3;
            String string7 = string2;
            boolean bl = false;
            MediaFile.SubType subType2 = MediaFile.SubType.valueOf((String)it);
            string2 = string7;
            string3 = string6;
            subType = subType2;
        } else {
            subType = null;
        }
        Long l = $this$toDomain.getFileSize();
        MediaFile.SubType subType3 = subType;
        String string8 = string3;
        String string9 = string2;
        return new MediaFile(string9, string8, subType3, l);
    }

    private static final MediaExtension findExtensionByIdOrNull$lambda$0(MediaDao this$0, Record it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return UtilsKt.deserializeMediaExtension((ObjectMapper)this$0.mapper, (String)((String)it.get((Field)this$0.m.EXTENSION_CLASS)), (byte[])((byte[])it.get((Field)this$0.m.EXTENSION_VALUE_BLOB)));
    }

    public static final /* synthetic */ org.gotson.komga.jooq.main.tables.Media access$getM$p(MediaDao $this) {
        return $this.m;
    }

    public static final /* synthetic */ MediaPage access$getP$p(MediaDao $this) {
        return $this.p;
    }

    public static final /* synthetic */ MediaFile access$toDomain(MediaDao $this, MediaFileRecord $receiver) {
        return $this.toDomain($receiver);
    }
}

