/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.jooq.main;

import java.net.URL;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.domain.model.Dimension;
import org.gotson.komga.domain.model.ThumbnailSeries;
import org.gotson.komga.domain.persistence.ThumbnailSeriesRepository;
import org.gotson.komga.infrastructure.jooq.UtilsKt;
import org.gotson.komga.jooq.main.Tables;
import org.gotson.komga.jooq.main.tables.records.ThumbnailSeriesRecord;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.RecordMapper;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\rH\u0016J\u0016\u0010\u0010\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u0012H\u0017J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u000f\u001a\u00020\rH\u0016J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001d\u001a\u00020\rH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000f\u001a\u00020\rH\u0016J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u0014H\u0016J\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u0014H\u0017J\u0010\u0010\"\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u0014H\u0016J\u0016\u0010#\u001a\u00020\u000b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00140\u0012H\u0016J\f\u0010%\u001a\u00020\u0014*\u00020&H\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/gotson/komga/infrastructure/jooq/main/ThumbnailSeriesDao;", "Lorg/gotson/komga/domain/persistence/ThumbnailSeriesRepository;", "dsl", "Lorg/jooq/DSLContext;", "batchSize", "", "(Lorg/jooq/DSLContext;I)V", "ts", "Lorg/gotson/komga/jooq/main/tables/ThumbnailSeries;", "kotlin.jvm.PlatformType", "delete", "", "thumbnailSeriesId", "", "deleteBySeriesId", "seriesId", "deleteBySeriesIds", "seriesIds", "", "findAllBySeriesId", "Lorg/gotson/komga/domain/model/ThumbnailSeries;", "findAllBySeriesIdIdAndType", "type", "Lorg/gotson/komga/domain/model/ThumbnailSeries$Type;", "findAllWithoutMetadata", "Lorg/springframework/data/domain/Page;", "pageable", "Lorg/springframework/data/domain/Pageable;", "findByIdOrNull", "thumbnailId", "findSelectedBySeriesIdOrNull", "insert", "thumbnail", "markSelected", "update", "updateMetadata", "thumbnails", "toDomain", "Lorg/gotson/komga/jooq/main/tables/records/ThumbnailSeriesRecord;", "komga"})
@SourceDebugExtension(value={"SMAP\nThumbnailSeriesDao.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThumbnailSeriesDao.kt\norg/gotson/komga/infrastructure/jooq/main/ThumbnailSeriesDao\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,175:1\n1#2:176\n1855#3,2:177\n*S KotlinDebug\n*F\n+ 1 ThumbnailSeriesDao.kt\norg/gotson/komga/infrastructure/jooq/main/ThumbnailSeriesDao\n*L\n114#1:177,2\n*E\n"})
public class ThumbnailSeriesDao
implements ThumbnailSeriesRepository {
    @NotNull
    private final DSLContext dsl;
    private final int batchSize;
    private final org.gotson.komga.jooq.main.tables.ThumbnailSeries ts;

    public ThumbnailSeriesDao(@NotNull DSLContext dsl, @Value(value="#{@komgaProperties.database.batchChunkSize}") int batchSize) {
        Intrinsics.checkNotNullParameter((Object)dsl, (String)"dsl");
        this.dsl = dsl;
        this.batchSize = batchSize;
        this.ts = Tables.THUMBNAIL_SERIES;
    }

    @Nullable
    public ThumbnailSeries findByIdOrNull(@NotNull String thumbnailId) {
        Intrinsics.checkNotNullParameter((Object)thumbnailId, (String)"thumbnailId");
        ThumbnailSeriesRecord thumbnailSeriesRecord = (ThumbnailSeriesRecord)this.dsl.selectFrom((TableLike)this.ts).where(this.ts.ID.eq((Object)thumbnailId)).fetchOneInto((Table)this.ts);
        return thumbnailSeriesRecord != null ? this.toDomain(thumbnailSeriesRecord) : null;
    }

    @NotNull
    public Collection<ThumbnailSeries> findAllBySeriesId(@NotNull String seriesId) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        List list = this.dsl.selectFrom((TableLike)this.ts).where(this.ts.SERIES_ID.eq((Object)seriesId)).fetchInto((Table)this.ts).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    @NotNull
    public Collection<ThumbnailSeries> findAllBySeriesIdIdAndType(@NotNull String seriesId, @NotNull ThumbnailSeries.Type type) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        List list = this.dsl.selectFrom((TableLike)this.ts).where(this.ts.SERIES_ID.eq((Object)seriesId)).and(this.ts.TYPE.eq((Object)type.toString())).fetchInto((Table)this.ts).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    @Nullable
    public ThumbnailSeries findSelectedBySeriesIdOrNull(@NotNull String seriesId) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        List list = this.dsl.selectFrom((TableLike)this.ts).where(this.ts.SERIES_ID.eq((Object)seriesId)).and(this.ts.SELECTED.isTrue()).limit((Number)1).fetchInto((Table)this.ts).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return (ThumbnailSeries)CollectionsKt.firstOrNull((List)list);
    }

    @NotNull
    public Page<ThumbnailSeries> findAllWithoutMetadata(@NotNull Pageable pageable) {
        SelectConditionStep selectConditionStep;
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        SelectConditionStep selectConditionStep2 = this.dsl.selectFrom((TableLike)this.ts).where(this.ts.FILE_SIZE.eq((Object)0L)).or(this.ts.MEDIA_TYPE.eq((Object)"")).or(this.ts.WIDTH.eq((Object)0)).or(this.ts.HEIGHT.eq((Object)0));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep2, (String)"or(...)");
        SelectConditionStep query = selectConditionStep2;
        int count = CollectionsKt.count((Iterable)((Iterable)query));
        SelectConditionStep $this$findAllWithoutMetadata_u24lambda_u240 = selectConditionStep = query;
        boolean bl = false;
        if (pageable.isPaged()) {
            $this$findAllWithoutMetadata_u24lambda_u240.limit((Number)pageable.getPageSize()).offset((Number)pageable.getOffset());
        }
        List list = selectConditionStep.fetchInto((Table)this.ts).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        List items2 = list;
        return (Page)new PageImpl(items2, pageable, (long)count);
    }

    public void insert(@NotNull ThumbnailSeries thumbnail) {
        Intrinsics.checkNotNullParameter((Object)thumbnail, (String)"thumbnail");
        URL uRL = thumbnail.getUrl();
        this.dsl.insertInto((Table)this.ts).set((Field)this.ts.ID, (Object)thumbnail.getId()).set((Field)this.ts.SERIES_ID, (Object)thumbnail.getSeriesId()).set((Field)this.ts.URL, (Object)(uRL != null ? uRL.toString() : null)).set((Field)this.ts.THUMBNAIL, (Object)thumbnail.getThumbnail()).set((Field)this.ts.TYPE, (Object)thumbnail.getType().toString()).set((Field)this.ts.MEDIA_TYPE, (Object)thumbnail.getMediaType()).set((Field)this.ts.WIDTH, (Object)thumbnail.getDimension().getWidth()).set((Field)this.ts.HEIGHT, (Object)thumbnail.getDimension().getHeight()).set((Field)this.ts.FILE_SIZE, (Object)thumbnail.getFileSize()).set((Field)this.ts.SELECTED, (Object)thumbnail.getSelected()).execute();
    }

    public void update(@NotNull ThumbnailSeries thumbnail) {
        Intrinsics.checkNotNullParameter((Object)thumbnail, (String)"thumbnail");
        URL uRL = thumbnail.getUrl();
        this.dsl.update((Table)this.ts).set((Field)this.ts.SERIES_ID, (Object)thumbnail.getSeriesId()).set((Field)this.ts.THUMBNAIL, (Object)thumbnail.getThumbnail()).set((Field)this.ts.URL, (Object)(uRL != null ? uRL.toString() : null)).set((Field)this.ts.SELECTED, (Object)thumbnail.getSelected()).set((Field)this.ts.TYPE, (Object)thumbnail.getType().toString()).set((Field)this.ts.MEDIA_TYPE, (Object)thumbnail.getMediaType()).set((Field)this.ts.WIDTH, (Object)thumbnail.getDimension().getWidth()).set((Field)this.ts.HEIGHT, (Object)thumbnail.getDimension().getHeight()).set((Field)this.ts.FILE_SIZE, (Object)thumbnail.getFileSize()).where(this.ts.ID.eq((Object)thumbnail.getId())).execute();
    }

    public void updateMetadata(@NotNull Collection<ThumbnailSeries> thumbnails) {
        Intrinsics.checkNotNullParameter(thumbnails, (String)"thumbnails");
        this.dsl.batched(arg_0 -> ThumbnailSeriesDao.updateMetadata$lambda$2(thumbnails, this, arg_0));
    }

    @Transactional
    public void markSelected(@NotNull ThumbnailSeries thumbnail) {
        Intrinsics.checkNotNullParameter((Object)thumbnail, (String)"thumbnail");
        this.dsl.update((Table)this.ts).set((Field)this.ts.SELECTED, (Object)false).where(this.ts.SERIES_ID.eq((Object)thumbnail.getSeriesId())).and(this.ts.ID.ne((Object)thumbnail.getId())).execute();
        this.dsl.update((Table)this.ts).set((Field)this.ts.SELECTED, (Object)true).where(this.ts.SERIES_ID.eq((Object)thumbnail.getSeriesId())).and(this.ts.ID.eq((Object)thumbnail.getId())).execute();
    }

    public void delete(@NotNull String thumbnailSeriesId) {
        Intrinsics.checkNotNullParameter((Object)thumbnailSeriesId, (String)"thumbnailSeriesId");
        this.dsl.deleteFrom((Table)this.ts).where(this.ts.ID.eq((Object)thumbnailSeriesId)).execute();
    }

    public void deleteBySeriesId(@NotNull String seriesId) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        this.dsl.deleteFrom((Table)this.ts).where(this.ts.SERIES_ID.eq((Object)seriesId)).execute();
    }

    @Transactional
    public void deleteBySeriesIds(@NotNull Collection<String> seriesIds) {
        Intrinsics.checkNotNullParameter(seriesIds, (String)"seriesIds");
        UtilsKt.insertTempStrings((DSLContext)this.dsl, (int)this.batchSize, seriesIds);
        this.dsl.deleteFrom((Table)this.ts).where(this.ts.SERIES_ID.in((Select)UtilsKt.selectTempStrings((DSLContext)this.dsl))).execute();
    }

    /*
     * WARNING - void declaration
     */
    private ThumbnailSeries toDomain(ThumbnailSeriesRecord $this$toDomain) {
        URL uRL;
        byte[] byArray = $this$toDomain.getThumbnail();
        String string = $this$toDomain.getUrl();
        if (string != null) {
            void it;
            String string2 = string;
            byte[] byArray2 = byArray;
            boolean bl = false;
            uRL = new URL((String)it);
            byArray = byArray2;
        } else {
            uRL = null;
        }
        Boolean bl = $this$toDomain.getSelected();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getSelected(...)");
        boolean bl2 = bl;
        String string3 = $this$toDomain.getType();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getType(...)");
        ThumbnailSeries.Type type = ThumbnailSeries.Type.valueOf((String)string3);
        String string4 = $this$toDomain.getMediaType();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getMediaType(...)");
        Long l = $this$toDomain.getFileSize();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getFileSize(...)");
        long l2 = ((Number)l).longValue();
        Integer n = $this$toDomain.getWidth();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getWidth(...)");
        int n2 = ((Number)n).intValue();
        Integer n3 = $this$toDomain.getHeight();
        Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"getHeight(...)");
        Dimension dimension = new Dimension(n2, ((Number)n3).intValue());
        String string5 = $this$toDomain.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getId(...)");
        String string6 = $this$toDomain.getSeriesId();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getSeriesId(...)");
        LocalDateTime localDateTime = $this$toDomain.getCreatedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"getCreatedDate(...)");
        LocalDateTime localDateTime2 = $this$toDomain.getLastModifiedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"getLastModifiedDate(...)");
        LocalDateTime localDateTime3 = localDateTime2;
        LocalDateTime localDateTime4 = localDateTime;
        String string7 = string6;
        String string8 = string5;
        Dimension dimension2 = dimension;
        long l3 = l2;
        String string9 = string4;
        ThumbnailSeries.Type type2 = type;
        boolean bl3 = bl2;
        URL uRL2 = uRL;
        byte[] byArray3 = byArray;
        return new ThumbnailSeries(byArray3, uRL2, bl3, type2, string9, l3, dimension2, string8, string7, localDateTime4, localDateTime3);
    }

    private static final void updateMetadata$lambda$2(Collection $thumbnails, ThumbnailSeriesDao this$0, Configuration c) {
        Intrinsics.checkNotNullParameter((Object)$thumbnails, (String)"$thumbnails");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$forEach$iv = $thumbnails;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ThumbnailSeries it = (ThumbnailSeries)element$iv;
            boolean bl = false;
            c.dsl().update((Table)this$0.ts).set((Field)this$0.ts.MEDIA_TYPE, (Object)it.getMediaType()).set((Field)this$0.ts.WIDTH, (Object)it.getDimension().getWidth()).set((Field)this$0.ts.HEIGHT, (Object)it.getDimension().getHeight()).set((Field)this$0.ts.FILE_SIZE, (Object)it.getFileSize()).where(this$0.ts.ID.eq((Object)it.getId())).execute();
        }
    }

    public static final /* synthetic */ ThumbnailSeries access$toDomain(ThumbnailSeriesDao $this, ThumbnailSeriesRecord $receiver) {
        return $this.toDomain($receiver);
    }
}

