/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.kobo;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.gotson.komga.domain.model.KomgaSyncToken;
import org.gotson.komga.infrastructure.configuration.KomgaSettingsProvider;
import org.gotson.komga.infrastructure.kobo.KoboProxyKt;
import org.gotson.komga.infrastructure.kobo.KomgaSyncTokenGenerator;
import org.gotson.komga.infrastructure.web.UtilsKt;
import org.gotson.komga.language.LanguageUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.http.client.ClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.http.client.ReactorClientHttpRequestFactoryBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClient;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.util.UriBuilder;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u000bH\u0012J$\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00130\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010!\u001a\u00020\u001bH\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00138VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/gotson/komga/infrastructure/kobo/KoboProxy;", "", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "komgaSyncTokenGenerator", "Lorg/gotson/komga/infrastructure/kobo/KomgaSyncTokenGenerator;", "komgaSettingsProvider", "Lorg/gotson/komga/infrastructure/configuration/KomgaSettingsProvider;", "(Lcom/fasterxml/jackson/databind/ObjectMapper;Lorg/gotson/komga/infrastructure/kobo/KomgaSyncTokenGenerator;Lorg/gotson/komga/infrastructure/configuration/KomgaSettingsProvider;)V", "headersOutExclude", "", "", "headersOutInclude", "imageHostUrl", "getImageHostUrl", "()Ljava/lang/String;", "koboApiClient", "Lorg/springframework/web/client/RestClient;", "nativeKoboResources", "Lcom/fasterxml/jackson/databind/JsonNode;", "getNativeKoboResources", "()Lcom/fasterxml/jackson/databind/JsonNode;", "nativeKoboResources$delegate", "Lkotlin/Lazy;", "pathRegex", "Lkotlin/text/Regex;", "isEnabled", "", "isKoboHeader", "headerName", "proxyCurrentRequest", "Lorg/springframework/http/ResponseEntity;", "body", "includeSyncToken", "komga"})
@SourceDebugExtension(value={"SMAP\nKoboProxy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KoboProxy.kt\norg/gotson/komga/infrastructure/kobo/KoboProxy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 RestClientExtensions.kt\norg/springframework/web/client/RestClientExtensionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,312:1\n1#2:313\n63#3:314\n478#4,7:315\n453#4:322\n403#4:323\n1238#5,4:324\n819#5:328\n847#5,2:329\n766#5:331\n857#5,2:332\n1855#5,2:334\n*S KotlinDebug\n*F\n+ 1 KoboProxy.kt\norg/gotson/komga/infrastructure/kobo/KoboProxy\n*L\n114#1:314\n120#1:315,7\n91#1:322\n91#1:323\n91#1:324,4\n97#1:328\n97#1:329,2\n98#1:331\n98#1:332,2\n99#1:334,2\n*E\n"})
public class KoboProxy {
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final KomgaSyncTokenGenerator komgaSyncTokenGenerator;
    @NotNull
    private final KomgaSettingsProvider komgaSettingsProvider;
    @NotNull
    private final RestClient koboApiClient;
    @NotNull
    private final Regex pathRegex;
    @NotNull
    private final Set<String> headersOutInclude;
    @NotNull
    private final Set<String> headersOutExclude;
    @NotNull
    private final String imageHostUrl;
    @NotNull
    private final Lazy nativeKoboResources$delegate;

    public KoboProxy(@NotNull ObjectMapper objectMapper, @NotNull KomgaSyncTokenGenerator komgaSyncTokenGenerator, @NotNull KomgaSettingsProvider komgaSettingsProvider) {
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)komgaSyncTokenGenerator, (String)"komgaSyncTokenGenerator");
        Intrinsics.checkNotNullParameter((Object)komgaSettingsProvider, (String)"komgaSettingsProvider");
        this.objectMapper = objectMapper;
        this.komgaSyncTokenGenerator = komgaSyncTokenGenerator;
        this.komgaSettingsProvider = komgaSettingsProvider;
        RestClient.Builder builder = RestClient.builder().baseUrl("https://storeapi.kobo.com");
        ReactorClientHttpRequestFactoryBuilder reactorClientHttpRequestFactoryBuilder = ClientHttpRequestFactoryBuilder.reactor();
        ClientHttpRequestFactorySettings clientHttpRequestFactorySettings = ClientHttpRequestFactorySettings.defaults();
        long l = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES);
        int n = Duration.getNanosecondsComponent-impl((long)l);
        long l2 = Duration.getInWholeSeconds-impl((long)l);
        java.time.Duration duration = java.time.Duration.ofSeconds(l2, n);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"toComponents-impl(...)");
        ClientHttpRequestFactorySettings clientHttpRequestFactorySettings2 = clientHttpRequestFactorySettings.withReadTimeout(duration);
        l = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES);
        n = Duration.getNanosecondsComponent-impl((long)l);
        l2 = Duration.getInWholeSeconds-impl((long)l);
        java.time.Duration duration2 = java.time.Duration.ofSeconds(l2, n);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"toComponents-impl(...)");
        RestClient restClient = builder.requestFactory(reactorClientHttpRequestFactoryBuilder.build(clientHttpRequestFactorySettings2.withConnectTimeout(duration2))).build();
        Intrinsics.checkNotNullExpressionValue((Object)restClient, (String)"build(...)");
        this.koboApiClient = restClient;
        this.pathRegex = new Regex("\\/kobo\\/[-\\w]*(.*)");
        Object[] objectArray = new String[]{"Authorization", "User-Agent", "Accept", "Accept-Language"};
        this.headersOutInclude = SetsKt.setOf((Object[])objectArray);
        this.headersOutExclude = SetsKt.setOf((Object)"x-kobo-synctoken");
        this.imageHostUrl = "https://cdn.kobo.com/book-images/{ImageId}/{Width}/{Height}/false/image.jpg";
        this.nativeKoboResources$delegate = LazyKt.lazy((Function0)((Function0)new /* Unavailable Anonymous Inner Class!! */));
    }

    private boolean isKoboHeader(String headerName) {
        return StringsKt.startsWith((String)headerName, (String)"x-kobo-", (boolean)true);
    }

    public boolean isEnabled() {
        return this.komgaSettingsProvider.getKoboProxy();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ResponseEntity<JsonNode> proxyCurrentRequest(@Nullable Object body, boolean includeSyncToken) {
        Map map;
        void $this$filterKeys$iv;
        void $this$toEntity$iv;
        if (!this.komgaSettingsProvider.getKoboProxy()) {
            throw new IllegalStateException("kobo proxying is disabled");
        }
        HttpServletRequest request = UtilsKt.getCurrentRequest();
        String string = request.getRequestURI();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRequestURI(...)");
        MatchResult matchResult = Regex.find$default((Regex)this.pathRegex, (CharSequence)string, (int)0, (int)2, null);
        if (matchResult == null || (matchResult = matchResult.getDestructured()) == null) {
            throw new IllegalStateException("Could not get path from current request");
        }
        String path2 = (String)matchResult.getMatch().getGroupValues().get(1);
        KomgaSyncToken syncToken = includeSyncToken ? this.komgaSyncTokenGenerator.fromRequestHeaders(request) : null;
        RestClient.RequestHeadersSpec requestHeadersSpec = ((RestClient.RequestBodySpec)this.koboApiClient.method(HttpMethod.valueOf((String)request.getMethod())).uri(arg_0 -> KoboProxy.proxyCurrentRequest$lambda$2(path2, request, arg_0))).headers(arg_0 -> KoboProxy.proxyCurrentRequest$lambda$6(request, includeSyncToken, syncToken, this, arg_0));
        RestClient.RequestBodySpec $this$proxyCurrentRequest_u24lambda_u247 = (RestClient.RequestBodySpec)requestHeadersSpec;
        boolean bl = false;
        if (body != null) {
            $this$proxyCurrentRequest_u24lambda_u247.body(body);
        }
        RestClient.ResponseSpec responseSpec = ((RestClient.RequestBodySpec)requestHeadersSpec).retrieve().onStatus(HttpStatusCode::isError, KoboProxy::proxyCurrentRequest$lambda$8);
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"onStatus(...)");
        RestClient.ResponseSpec responseSpec2 = responseSpec;
        boolean $i$f$toEntity22 = false;
        ResponseEntity responseEntity = $this$toEntity$iv.toEntity((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"toEntity");
        ResponseEntity response2 = responseEntity;
        KoboProxyKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
        HttpHeaders httpHeaders = response2.getHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"getHeaders(...)");
        Map $i$f$toEntity22 = (Map)httpHeaders;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            String it = (String)entry$iv.getKey();
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            if (!this.isKoboHeader(it)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map $this$proxyCurrentRequest_u24lambda_u2410 = map = MapsKt.toMutableMap((Map)result$iv);
        boolean bl3 = false;
        if (LanguageUtilsKt.contains((Iterable)$this$proxyCurrentRequest_u24lambda_u2410.keySet(), (String)"x-kobo-synctoken", (boolean)true)) {
            String koboSyncToken;
            List list = (List)$this$proxyCurrentRequest_u24lambda_u2410.get("x-kobo-synctoken");
            String string2 = koboSyncToken = list != null ? (String)CollectionsKt.firstOrNull((List)list) : null;
            if (koboSyncToken != null && includeSyncToken && syncToken != null) {
                KomgaSyncToken komgaSyncToken = KomgaSyncToken.copy$default((KomgaSyncToken)syncToken, (int)0, (String)koboSyncToken, null, null, (int)13, null);
                $this$proxyCurrentRequest_u24lambda_u2410.put("x-kobo-synctoken", CollectionsKt.listOf((Object)this.komgaSyncTokenGenerator.toBase64(komgaSyncToken)));
            }
        }
        Map headersToReturn = map;
        return new ResponseEntity(response2.getBody(), (MultiValueMap)new LinkedMultiValueMap(headersToReturn), response2.getStatusCode());
    }

    public static /* synthetic */ ResponseEntity proxyCurrentRequest$default(KoboProxy koboProxy, Object object, boolean bl, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: proxyCurrentRequest");
        }
        if ((n & 1) != 0) {
            object = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return koboProxy.proxyCurrentRequest(object, bl);
    }

    @NotNull
    public String getImageHostUrl() {
        return this.imageHostUrl;
    }

    @NotNull
    public JsonNode getNativeKoboResources() {
        Lazy lazy = this.nativeKoboResources$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (JsonNode)object;
    }

    /*
     * WARNING - void declaration
     */
    private static final URI proxyCurrentRequest$lambda$2(String $path, HttpServletRequest $request, UriBuilder uriBuilder) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        UriBuilder uriBuilder2 = uriBuilder.path($path);
        Map map = $request.getParameterMap();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getParameterMap(...)");
        Object object = map;
        UriBuilder uriBuilder3 = uriBuilder2;
        boolean $i$f$mapValues = false;
        void var5_7 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Object v = it.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
            List list = ArraysKt.toList((Object[])((Object[])v));
            map3.put(k, list);
        }
        Map map4 = destination$iv$iv;
        Object it = object = uriBuilder3.queryParams((MultiValueMap)new LinkedMultiValueMap(map4)).build(new Object[0]);
        boolean bl = false;
        KoboProxyKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static final void proxyCurrentRequest$lambda$6(HttpServletRequest $request, boolean $includeSyncToken, KomgaSyncToken $syncToken, KoboProxy this$0, HttpHeaders headersOut) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        String it;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Enumeration enumeration = $request.getHeaderNames();
        Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"getHeaderNames(...)");
        ArrayList arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
        Iterable iterable = arrayList;
        boolean $i$f$filterNot = false;
        Iterator iterator = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            Iterable iterable2 = this$0.headersOutExclude;
            Intrinsics.checkNotNull((Object)it);
            if (LanguageUtilsKt.contains((Iterable)iterable2, (String)it, (boolean)true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterNotTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            Iterable iterable3 = this$0.headersOutInclude;
            Intrinsics.checkNotNull((Object)it);
            if (!(LanguageUtilsKt.contains((Iterable)iterable3, (String)it, (boolean)true) || this$0.isKoboHeader(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            String it2;
            block10: {
                block9: {
                    it2 = (String)element$iv;
                    boolean bl = false;
                    Enumeration enumeration2 = $request.getHeaders(it2);
                    object = enumeration2;
                    if (object == null) break block9;
                    Intrinsics.checkNotNull((Object)object);
                    ArrayList arrayList2 = Collections.list(enumeration2);
                    Intrinsics.checkNotNullExpressionValue(arrayList2, (String)"list(...)");
                    object = arrayList2;
                    if (object != null) break block10;
                }
                object = CollectionsKt.emptyList();
            }
            headersOut.addAll(it2, (List)object);
        }
        if ($includeSyncToken) {
            if ($syncToken != null && !StringsKt.isBlank((CharSequence)$syncToken.getRawKoboSyncToken())) {
                headersOut.add("x-kobo-synctoken", $syncToken.getRawKoboSyncToken());
            } else {
                throw new IllegalStateException("request must include sync token, but no raw Kobo sync token found");
            }
        }
        KoboProxyKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    private static final void proxyCurrentRequest$lambda$8(HttpRequest httpRequest, ClientHttpResponse response2) {
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        throw new ResponseStatusException(response2.getStatusCode(), response2.getStatusText());
    }

    public static final /* synthetic */ ObjectMapper access$getObjectMapper$p(KoboProxy $this) {
        return $this.objectMapper;
    }
}

