/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.metadata.comicrack;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gotson.komga.domain.model.ComicRackListException;
import org.gotson.komga.domain.model.ReadListRequest;
import org.gotson.komga.domain.model.ReadListRequestBook;
import org.gotson.komga.infrastructure.metadata.comicrack.ComicInfoProviderKt;
import org.gotson.komga.infrastructure.metadata.comicrack.ReadListProvider;
import org.gotson.komga.infrastructure.metadata.comicrack.ReadListProviderKt;
import org.gotson.komga.infrastructure.metadata.comicrack.dto.Book;
import org.gotson.komga.infrastructure.metadata.comicrack.dto.ReadingList;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0003\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/gotson/komga/infrastructure/metadata/comicrack/ReadListProvider;", "", "mapper", "Lcom/fasterxml/jackson/dataformat/xml/XmlMapper;", "(Lcom/fasterxml/jackson/dataformat/xml/XmlMapper;)V", "importFromCbl", "Lorg/gotson/komga/domain/model/ReadListRequest;", "cbl", "", "komga"})
@SourceDebugExtension(value={"SMAP\nReadListProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReadListProvider.kt\norg/gotson/komga/infrastructure/metadata/comicrack/ReadListProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1549#2:44\n1620#2,2:45\n1622#2:48\n1#3:47\n*S KotlinDebug\n*F\n+ 1 ReadListProvider.kt\norg/gotson/komga/infrastructure/metadata/comicrack/ReadListProvider\n*L\n33#1:44\n33#1:45,2\n33#1:48\n*E\n"})
public class ReadListProvider {
    @NotNull
    private final XmlMapper mapper;

    public ReadListProvider(@Autowired(required=false) @NotNull XmlMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this.mapper = mapper;
    }

    public /* synthetic */ ReadListProvider(XmlMapper xmlMapper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            xmlMapper = new XmlMapper();
        }
        this(xmlMapper);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ReadListRequest importFromCbl(@NotNull byte[] cbl) throws ComicRackListException {
        ReadListRequest readListRequest;
        void $this$mapTo$iv$iv;
        Object object;
        Intrinsics.checkNotNullParameter((Object)cbl, (String)"cbl");
        try {
            object = (ReadingList)this.mapper.readValue(cbl, ReadingList.class);
        }
        catch (Exception e) {
            ReadListProviderKt.access$getLogger$p().error((Throwable)e, (Function0)importFromCbl.readingList.1.INSTANCE);
            throw new ComicRackListException("Error while trying to parse ComicRack ReadingList", "ERR_1015");
        }
        ReadingList readingList2 = object;
        ReadListProviderKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
        object = readingList2.getName();
        if (object == null || StringsKt.isBlank((CharSequence)object)) {
            throw new ComicRackListException("ReadingList has no Name element", "ERR_1030");
        }
        if (readingList2.getBooks().isEmpty()) {
            throw new ComicRackListException("ReadingList does not contain any Book element", "ERR_1029");
        }
        Iterable $this$map$iv = readingList2.getBooks();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            void it;
            Book book = (Book)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CharSequence charSequence = it.getSeries();
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || it.getNumber() == null) {
                throw new ComicRackListException("Book is missing series or number: " + (Book)it, "ERR_1031");
            }
            Object[] objectArray = new String[2];
            objectArray[0] = ComicInfoProviderKt.computeSeriesFromSeriesAndVolume((String)it.getSeries(), (Integer)it.getVolume());
            Object[] objectArray2 = objectArray;
            int n = 1;
            String string2 = it.getSeries();
            if (string2 != null) {
                CharSequence charSequence2;
                CharSequence charSequence3 = string2;
                if (StringsKt.isBlank((CharSequence)charSequence3)) {
                    int n2 = n;
                    Object[] objectArray3 = objectArray2;
                    boolean bl2 = false;
                    Object var19_22 = null;
                    objectArray2 = objectArray3;
                    n = n2;
                    charSequence2 = var19_22;
                } else {
                    charSequence2 = charSequence3;
                }
                string = (String)charSequence2;
            } else {
                string = null;
            }
            objectArray2[n] = string;
            Set series = SetsKt.setOfNotNull((Object[])objectArray);
            String string3 = it.getNumber();
            Intrinsics.checkNotNull((Object)string3);
            collection.add(new ReadListRequestBook(series, ((Object)StringsKt.trim((CharSequence)string3)).toString()));
        }
        List books = (List)destination$iv$iv;
        String string = readingList2.getName();
        Intrinsics.checkNotNull((Object)string);
        ReadListRequest it = readListRequest = new ReadListRequest(string, books);
        boolean bl = false;
        ReadListProviderKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return readListRequest;
    }

    public ReadListProvider() {
        this(null, 1, null);
    }
}

