/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.metadata.localartwork;

import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.apache.commons.io.FilenameUtils;
import org.gotson.komga.domain.model.Book;
import org.gotson.komga.domain.model.Series;
import org.gotson.komga.domain.model.Sidecar;
import org.gotson.komga.domain.model.ThumbnailBook;
import org.gotson.komga.domain.model.ThumbnailSeries;
import org.gotson.komga.infrastructure.image.ImageAnalyzer;
import org.gotson.komga.infrastructure.mediacontainer.ContentDetector;
import org.gotson.komga.infrastructure.metadata.localartwork.LocalArtworkProvider;
import org.gotson.komga.infrastructure.metadata.localartwork.LocalArtworkProviderKt;
import org.gotson.komga.infrastructure.sidecar.SidecarBookConsumer;
import org.gotson.komga.infrastructure.sidecar.SidecarSeriesConsumer;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\tH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\b\u0010\u001c\u001a\u00020\u001aH\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006!"}, d2={"Lorg/gotson/komga/infrastructure/metadata/localartwork/LocalArtworkProvider;", "Lorg/gotson/komga/infrastructure/sidecar/SidecarSeriesConsumer;", "Lorg/gotson/komga/infrastructure/sidecar/SidecarBookConsumer;", "contentDetector", "Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;", "imageAnalyzer", "Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;", "(Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;)V", "supportedExtensions", "", "", "getSupportedExtensions", "()Ljava/util/List;", "supportedSeriesFiles", "getSupportedSeriesFiles", "getBookThumbnails", "Lorg/gotson/komga/domain/model/ThumbnailBook;", "book", "Lorg/gotson/komga/domain/model/Book;", "getSeriesThumbnails", "Lorg/gotson/komga/domain/model/ThumbnailSeries;", "series", "Lorg/gotson/komga/domain/model/Series;", "getSidecarBookPrefilter", "Lkotlin/text/Regex;", "getSidecarBookType", "Lorg/gotson/komga/domain/model/Sidecar$Type;", "getSidecarSeriesFilenames", "getSidecarSeriesType", "isSidecarBookMatch", "", "basename", "sidecar", "komga"})
@SourceDebugExtension(value={"SMAP\nLocalArtworkProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalArtworkProvider.kt\norg/gotson/komga/infrastructure/metadata/localartwork/LocalArtworkProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n1549#2:110\n1620#2,3:111\n1360#2:114\n1446#2,2:115\n1549#2:117\n1620#2,3:118\n1448#2,3:121\n*S KotlinDebug\n*F\n+ 1 LocalArtworkProvider.kt\norg/gotson/komga/infrastructure/metadata/localartwork/LocalArtworkProvider\n*L\n95#1:110\n95#1:111,3\n105#1:114\n105#1:115,2\n106#1:117\n106#1:118,3\n105#1:121,3\n*E\n"})
public class LocalArtworkProvider
implements SidecarSeriesConsumer,
SidecarBookConsumer {
    @NotNull
    private final ContentDetector contentDetector;
    @NotNull
    private final ImageAnalyzer imageAnalyzer;
    @NotNull
    private final List<String> supportedExtensions;
    @NotNull
    private final List<String> supportedSeriesFiles;

    public LocalArtworkProvider(@NotNull ContentDetector contentDetector, @NotNull ImageAnalyzer imageAnalyzer) {
        Intrinsics.checkNotNullParameter((Object)contentDetector, (String)"contentDetector");
        Intrinsics.checkNotNullParameter((Object)imageAnalyzer, (String)"imageAnalyzer");
        this.contentDetector = contentDetector;
        this.imageAnalyzer = imageAnalyzer;
        Object[] objectArray = new String[]{"png", "jpeg", "jpg", "tbn", "webp"};
        this.supportedExtensions = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"cover", "default", "folder", "poster", "series"};
        this.supportedSeriesFiles = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<String> getSupportedExtensions() {
        return this.supportedExtensions;
    }

    @NotNull
    public List<String> getSupportedSeriesFiles() {
        return this.supportedSeriesFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<ThumbnailBook> getBookThumbnails(@NotNull Book book) {
        List list;
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        LocalArtworkProviderKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        Path bookPath = book.getPath();
        String baseName = PathsKt.getNameWithoutExtension((Path)bookPath);
        Regex regex = new Regex(Regex.Companion.escape(baseName) + "(-\\d+)?", RegexOption.IGNORE_CASE);
        AutoCloseable autoCloseable = Files.list(bookPath.getParent());
        Throwable throwable = null;
        try {
            Stream dirStream = (Stream)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)dirStream);
            list = SequencesKt.toList((Sequence)SequencesKt.mapIndexed((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)StreamsKt.asSequence((Stream)dirStream), (Function1)((Function1)getBookThumbnails.2.1.INSTANCE)), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */)), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */)), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */)), (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */)));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<ThumbnailSeries> getSeriesThumbnails(@NotNull Series series) {
        List list;
        Intrinsics.checkNotNullParameter((Object)series, (String)"series");
        if (series.getOneshot()) {
            LocalArtworkProviderKt.access$getLogger$p().debug((Function0)getSeriesThumbnails.1.INSTANCE);
            return CollectionsKt.emptyList();
        }
        LocalArtworkProviderKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        AutoCloseable autoCloseable = Files.list(series.getPath());
        Throwable throwable = null;
        try {
            Stream dirStream = (Stream)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)dirStream);
            list = SequencesKt.toList((Sequence)SequencesKt.mapIndexed((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)StreamsKt.asSequence((Stream)dirStream), (Function1)((Function1)getSeriesThumbnails.3.1.INSTANCE)), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */)), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */)), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */)), (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */)));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return list;
    }

    @NotNull
    public Sidecar.Type getSidecarBookType() {
        return Sidecar.Type.ARTWORK;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Regex> getSidecarBookPrefilter() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getSupportedExtensions();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void ext;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Regex(".*(-\\d+)?\\." + (String)ext, RegexOption.IGNORE_CASE));
        }
        return (List)destination$iv$iv;
    }

    public boolean isSidecarBookMatch(@NotNull String basename, @NotNull String sidecar) {
        Intrinsics.checkNotNullParameter((Object)basename, (String)"basename");
        Intrinsics.checkNotNullParameter((Object)sidecar, (String)"sidecar");
        Regex regex = new Regex(Regex.Companion.escape(basename) + "(-\\d+)?", RegexOption.IGNORE_CASE);
        String string = FilenameUtils.getBaseName((String)sidecar);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBaseName(...)");
        return regex.matches((CharSequence)string);
    }

    @NotNull
    public Sidecar.Type getSidecarSeriesType() {
        return Sidecar.Type.ARTWORK;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> getSidecarSeriesFilenames() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.getSupportedSeriesFiles();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            String filename = (String)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = this.getSupportedExtensions();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void ext;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(filename + "." + (String)ext);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ ContentDetector access$getContentDetector$p(LocalArtworkProvider $this) {
        return $this.contentDetector;
    }

    public static final /* synthetic */ ImageAnalyzer access$getImageAnalyzer$p(LocalArtworkProvider $this) {
        return $this.imageAnalyzer;
    }
}

