/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.time.TimeSource;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.gotson.komga.domain.model.DomainEvent;
import org.gotson.komga.domain.model.ReadList;
import org.gotson.komga.domain.model.SeriesCollection;
import org.gotson.komga.domain.persistence.ReadListRepository;
import org.gotson.komga.domain.persistence.SeriesCollectionRepository;
import org.gotson.komga.infrastructure.search.LuceneEntity;
import org.gotson.komga.infrastructure.search.LuceneEntityKt;
import org.gotson.komga.infrastructure.search.LuceneHelper;
import org.gotson.komga.infrastructure.search.SearchIndexLifecycle;
import org.gotson.komga.infrastructure.search.SearchIndexLifecycleKt;
import org.gotson.komga.interfaces.api.persistence.BookDtoRepository;
import org.gotson.komga.interfaces.api.persistence.SeriesDtoRepository;
import org.gotson.komga.interfaces.api.rest.dto.BookDto;
import org.gotson.komga.interfaces.api.rest.dto.SeriesDto;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.event.EventListener;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0012J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\u0018\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0012J\u001a\u0010\u0019\u001a\u00020\u000e2\u0010\b\u0002\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u001bH\u0016JH\u0010\u0019\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\u001a\u0010\u001d\u001a\u0016\u0012\u0004\u0012\u00020\u001f\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u001c0 0\u001e2\u0014\u0010!\u001a\u0010\u0012\u0004\u0012\u0002H\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u001eH\u0012J \u0010\"\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u0010H\u0012J\b\u0010$\u001a\u00020\u000eH\u0016J\f\u0010%\u001a\u00020\u0010*\u00020&H\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/gotson/komga/infrastructure/search/SearchIndexLifecycle;", "", "collectionRepository", "Lorg/gotson/komga/domain/persistence/SeriesCollectionRepository;", "readListRepository", "Lorg/gotson/komga/domain/persistence/ReadListRepository;", "bookDtoRepository", "Lorg/gotson/komga/interfaces/api/persistence/BookDtoRepository;", "seriesDtoRepository", "Lorg/gotson/komga/interfaces/api/persistence/SeriesDtoRepository;", "luceneHelper", "Lorg/gotson/komga/infrastructure/search/LuceneHelper;", "(Lorg/gotson/komga/domain/persistence/SeriesCollectionRepository;Lorg/gotson/komga/domain/persistence/ReadListRepository;Lorg/gotson/komga/interfaces/api/persistence/BookDtoRepository;Lorg/gotson/komga/interfaces/api/persistence/SeriesDtoRepository;Lorg/gotson/komga/infrastructure/search/LuceneHelper;)V", "addEntity", "", "doc", "Lorg/apache/lucene/document/Document;", "consumeEvents", "event", "Lorg/gotson/komga/domain/model/DomainEvent;", "deleteEntity", "entity", "Lorg/gotson/komga/infrastructure/search/LuceneEntity;", "entityId", "", "rebuildIndex", "entities", "", "T", "provider", "Lkotlin/Function1;", "Lorg/springframework/data/domain/Pageable;", "Lorg/springframework/data/domain/Page;", "toDoc", "updateEntity", "newDoc", "upgradeIndex", "bookToDocument", "Lorg/gotson/komga/interfaces/api/rest/dto/BookDto;", "komga"})
@SourceDebugExtension(value={"SMAP\nSearchIndexLifecycle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchIndexLifecycle.kt\norg/gotson/komga/infrastructure/search/SearchIndexLifecycle\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n1855#2,2:134\n1855#2:146\n1603#2,9:147\n1855#2:156\n1856#2:158\n1612#2:159\n1856#2:160\n18#3,4:136\n50#3,6:140\n56#3:161\n1#4:157\n1#4:162\n*S KotlinDebug\n*F\n+ 1 SearchIndexLifecycle.kt\norg/gotson/komga/infrastructure/search/SearchIndexLifecycle\n*L\n44#1:134,2\n71#1:146\n76#1:147,9\n76#1:156\n76#1:158\n76#1:159\n71#1:160\n68#1:136,4\n68#1:140,6\n68#1:161\n76#1:157\n*E\n"})
public class SearchIndexLifecycle {
    @NotNull
    private final SeriesCollectionRepository collectionRepository;
    @NotNull
    private final ReadListRepository readListRepository;
    @NotNull
    private final BookDtoRepository bookDtoRepository;
    @NotNull
    private final SeriesDtoRepository seriesDtoRepository;
    @NotNull
    private final LuceneHelper luceneHelper;

    public SearchIndexLifecycle(@NotNull SeriesCollectionRepository collectionRepository, @NotNull ReadListRepository readListRepository, @NotNull BookDtoRepository bookDtoRepository, @NotNull SeriesDtoRepository seriesDtoRepository, @NotNull LuceneHelper luceneHelper) {
        Intrinsics.checkNotNullParameter((Object)collectionRepository, (String)"collectionRepository");
        Intrinsics.checkNotNullParameter((Object)readListRepository, (String)"readListRepository");
        Intrinsics.checkNotNullParameter((Object)bookDtoRepository, (String)"bookDtoRepository");
        Intrinsics.checkNotNullParameter((Object)seriesDtoRepository, (String)"seriesDtoRepository");
        Intrinsics.checkNotNullParameter((Object)luceneHelper, (String)"luceneHelper");
        this.collectionRepository = collectionRepository;
        this.readListRepository = readListRepository;
        this.bookDtoRepository = bookDtoRepository;
        this.seriesDtoRepository = seriesDtoRepository;
        this.luceneHelper = luceneHelper;
    }

    public void upgradeIndex() {
        this.luceneHelper.upgradeIndex();
        this.luceneHelper.setIndexVersion(8);
    }

    public void rebuildIndex(@Nullable Set<? extends LuceneEntity> entities) {
        Set set = entities;
        if (set == null) {
            set = ArraysKt.toSet((Object[])LuceneEntity.values());
        }
        Set targetEntities = set;
        SearchIndexLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        Iterable $this$forEach$iv = targetEntities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LuceneEntity it = (LuceneEntity)element$iv;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[it.ordinal()]) {
                case 1: {
                    this.rebuildIndex(it, (Function1)new /* Unavailable Anonymous Inner Class!! */, (Function1)new /* Unavailable Anonymous Inner Class!! */);
                    break;
                }
                case 2: {
                    this.rebuildIndex(it, (Function1)new /* Unavailable Anonymous Inner Class!! */, (Function1)rebuildIndex.2.4.INSTANCE);
                    break;
                }
                case 3: {
                    this.rebuildIndex(it, (Function1)new /* Unavailable Anonymous Inner Class!! */, (Function1)rebuildIndex.2.6.INSTANCE);
                    break;
                }
                case 4: {
                    this.rebuildIndex(it, (Function1)new /* Unavailable Anonymous Inner Class!! */, (Function1)rebuildIndex.2.8.INSTANCE);
                }
            }
        }
        this.luceneHelper.setIndexVersion(8);
    }

    public static /* synthetic */ void rebuildIndex$default(SearchIndexLifecycle searchIndexLifecycle, Set set, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: rebuildIndex");
        }
        if ((n & 1) != 0) {
            set = null;
        }
        searchIndexLifecycle.rebuildIndex(set);
    }

    /*
     * WARNING - void declaration
     */
    private <T> void rebuildIndex(LuceneEntity entity, Function1<? super Pageable, ? extends Page<? extends T>> provider, Function1<? super T, Document> toDoc) {
        long l;
        SearchIndexLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        Pageable pageable = Pageable.ofSize((int)1);
        Intrinsics.checkNotNullExpressionValue((Object)pageable, (String)"ofSize(...)");
        long count = ((Page)provider.invoke((Object)pageable)).getTotalElements();
        int batchSize = 5000;
        int pages = (int)Math.ceil((double)count / (double)batchSize);
        SearchIndexLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        boolean $i$f$measureTime = false;
        TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTime2 = false;
        long mark$iv$iv = $this$measureTime$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        this.luceneHelper.deleteDocuments(new Term("type", entity.getType()));
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)pages);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            int element$iv;
            int page = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl2 = false;
            SearchIndexLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
            PageRequest pageRequest = PageRequest.of((int)page, (int)batchSize);
            Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
            Iterable iterable = ((Page)provider.invoke((Object)pageRequest)).getContent();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getContent(...)");
            iterable = iterable;
            boolean $i$f$mapNotNull = false;
            void var23_23 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Document it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl3 = false;
                Object it = element$iv$iv;
                boolean bl4 = false;
                if ((Document)toDoc.invoke(it) == null) continue;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List entityDocs = (List)destination$iv$iv;
            this.luceneHelper.addDocuments((Iterable)entityDocs);
        }
        long duration = l = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv);
        boolean bl6 = false;
        SearchIndexLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    @EventListener
    public void consumeEvents(@NotNull DomainEvent event) {
        block1: {
            DomainEvent domainEvent;
            block11: {
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                block6: {
                                    block5: {
                                        block4: {
                                            block3: {
                                                block2: {
                                                    block0: {
                                                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                                                        domainEvent = event;
                                                        if (!(domainEvent instanceof DomainEvent.SeriesAdded)) break block0;
                                                        SeriesDto seriesDto = this.seriesDtoRepository.findByIdOrNull(((DomainEvent.SeriesAdded)event).getSeries().getId(), "unused");
                                                        if (seriesDto == null || (seriesDto = LuceneEntityKt.toDocument((SeriesDto)seriesDto)) == null) break block1;
                                                        SeriesDto it = seriesDto;
                                                        boolean bl = false;
                                                        this.addEntity((Document)it);
                                                        break block1;
                                                    }
                                                    if (!(domainEvent instanceof DomainEvent.SeriesUpdated)) break block2;
                                                    SeriesDto seriesDto = this.seriesDtoRepository.findByIdOrNull(((DomainEvent.SeriesUpdated)event).getSeries().getId(), "unused");
                                                    if (seriesDto == null || (seriesDto = LuceneEntityKt.toDocument((SeriesDto)seriesDto)) == null) break block1;
                                                    SeriesDto it = seriesDto;
                                                    boolean bl = false;
                                                    this.updateEntity(LuceneEntity.Series, ((DomainEvent.SeriesUpdated)event).getSeries().getId(), (Document)it);
                                                    break block1;
                                                }
                                                if (!(domainEvent instanceof DomainEvent.SeriesDeleted)) break block3;
                                                this.deleteEntity(LuceneEntity.Series, ((DomainEvent.SeriesDeleted)event).getSeries().getId());
                                                break block1;
                                            }
                                            if (!(domainEvent instanceof DomainEvent.BookAdded)) break block4;
                                            BookDto bookDto = this.bookDtoRepository.findByIdOrNull(((DomainEvent.BookAdded)event).getBook().getId(), "unused");
                                            if (bookDto == null || (bookDto = this.bookToDocument(bookDto)) == null) break block1;
                                            BookDto it = bookDto;
                                            boolean bl = false;
                                            this.addEntity((Document)it);
                                            break block1;
                                        }
                                        if (!(domainEvent instanceof DomainEvent.BookUpdated)) break block5;
                                        BookDto bookDto = this.bookDtoRepository.findByIdOrNull(((DomainEvent.BookUpdated)event).getBook().getId(), "unused");
                                        if (bookDto == null || (bookDto = this.bookToDocument(bookDto)) == null) break block1;
                                        BookDto it = bookDto;
                                        boolean bl = false;
                                        this.updateEntity(LuceneEntity.Book, ((DomainEvent.BookUpdated)event).getBook().getId(), (Document)it);
                                        break block1;
                                    }
                                    if (!(domainEvent instanceof DomainEvent.BookDeleted)) break block6;
                                    this.deleteEntity(LuceneEntity.Book, ((DomainEvent.BookDeleted)event).getBook().getId());
                                    break block1;
                                }
                                if (!(domainEvent instanceof DomainEvent.ReadListAdded)) break block7;
                                ReadList readList = ReadListRepository.DefaultImpls.findByIdOrNull$default((ReadListRepository)this.readListRepository, (String)((DomainEvent.ReadListAdded)event).getReadList().getId(), null, null, (int)6, null);
                                if (readList == null || (readList = LuceneEntityKt.toDocument((ReadList)readList)) == null) break block1;
                                ReadList it = readList;
                                boolean bl = false;
                                this.addEntity((Document)it);
                                break block1;
                            }
                            if (!(domainEvent instanceof DomainEvent.ReadListUpdated)) break block8;
                            ReadList readList = ReadListRepository.DefaultImpls.findByIdOrNull$default((ReadListRepository)this.readListRepository, (String)((DomainEvent.ReadListUpdated)event).getReadList().getId(), null, null, (int)6, null);
                            if (readList == null || (readList = LuceneEntityKt.toDocument((ReadList)readList)) == null) break block1;
                            ReadList it = readList;
                            boolean bl = false;
                            this.updateEntity(LuceneEntity.ReadList, ((DomainEvent.ReadListUpdated)event).getReadList().getId(), (Document)it);
                            break block1;
                        }
                        if (!(domainEvent instanceof DomainEvent.ReadListDeleted)) break block9;
                        this.deleteEntity(LuceneEntity.ReadList, ((DomainEvent.ReadListDeleted)event).getReadList().getId());
                        break block1;
                    }
                    if (!(domainEvent instanceof DomainEvent.CollectionAdded)) break block10;
                    SeriesCollection seriesCollection = SeriesCollectionRepository.DefaultImpls.findByIdOrNull$default((SeriesCollectionRepository)this.collectionRepository, (String)((DomainEvent.CollectionAdded)event).getCollection().getId(), null, null, (int)6, null);
                    if (seriesCollection == null || (seriesCollection = LuceneEntityKt.toDocument((SeriesCollection)seriesCollection)) == null) break block1;
                    SeriesCollection it = seriesCollection;
                    boolean bl = false;
                    this.addEntity((Document)it);
                    break block1;
                }
                if (!(domainEvent instanceof DomainEvent.CollectionUpdated)) break block11;
                SeriesCollection seriesCollection = SeriesCollectionRepository.DefaultImpls.findByIdOrNull$default((SeriesCollectionRepository)this.collectionRepository, (String)((DomainEvent.CollectionUpdated)event).getCollection().getId(), null, null, (int)6, null);
                if (seriesCollection == null || (seriesCollection = LuceneEntityKt.toDocument((SeriesCollection)seriesCollection)) == null) break block1;
                SeriesCollection it = seriesCollection;
                boolean bl = false;
                this.updateEntity(LuceneEntity.Collection, ((DomainEvent.CollectionUpdated)event).getCollection().getId(), (Document)it);
                break block1;
            }
            if (!(domainEvent instanceof DomainEvent.CollectionDeleted)) break block1;
            this.deleteEntity(LuceneEntity.Collection, ((DomainEvent.CollectionDeleted)event).getCollection().getId());
        }
    }

    private Document bookToDocument(BookDto $this$bookToDocument) {
        Document document;
        if ($this$bookToDocument.getOneshot()) {
            SeriesDto seriesDto = this.seriesDtoRepository.findByIdOrNull($this$bookToDocument.getSeriesId(), "unused");
            Intrinsics.checkNotNull((Object)seriesDto);
            document = LuceneEntityKt.oneshotDocument((SeriesDto)seriesDto, (Document)LuceneEntityKt.toDocument((BookDto)$this$bookToDocument));
        } else {
            document = LuceneEntityKt.toDocument((BookDto)$this$bookToDocument);
        }
        return document;
    }

    private void addEntity(Document doc) {
        this.luceneHelper.addDocument(doc);
    }

    private void updateEntity(LuceneEntity entity, String entityId, Document newDoc) {
        this.luceneHelper.updateDocument(new Term(entity.getId(), entityId), newDoc);
    }

    private void deleteEntity(LuceneEntity entity, String entityId) {
        this.luceneHelper.deleteDocuments(new Term(entity.getId(), entityId));
    }

    public static final /* synthetic */ BookDtoRepository access$getBookDtoRepository$p(SearchIndexLifecycle $this) {
        return $this.bookDtoRepository;
    }

    public static final /* synthetic */ Document access$bookToDocument(SearchIndexLifecycle $this, BookDto $receiver) {
        return $this.bookToDocument($receiver);
    }

    public static final /* synthetic */ SeriesDtoRepository access$getSeriesDtoRepository$p(SearchIndexLifecycle $this) {
        return $this.seriesDtoRepository;
    }

    public static final /* synthetic */ SeriesCollectionRepository access$getCollectionRepository$p(SearchIndexLifecycle $this) {
        return $this.collectionRepository;
    }

    public static final /* synthetic */ ReadListRepository access$getReadListRepository$p(SearchIndexLifecycle $this) {
        return $this.readListRepository;
    }
}

