/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.security.oauth2;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.RandomStringUtils;
import org.gotson.komga.domain.model.KomgaUser;
import org.gotson.komga.domain.persistence.KomgaUserRepository;
import org.gotson.komga.domain.service.KomgaUserLifecycle;
import org.gotson.komga.infrastructure.configuration.KomgaProperties;
import org.gotson.komga.infrastructure.security.KomgaPrincipal;
import org.gotson.komga.infrastructure.security.oauth2.GithubOAuth2UserService;
import org.gotson.komga.infrastructure.security.oauth2.KomgaOAuth2UserServiceConfigurationKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.client.userinfo.DefaultOAuth2UserService;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequest;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;

@Configuration
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0017J\u0014\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\nH\u0017J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/gotson/komga/infrastructure/security/oauth2/KomgaOAuth2UserServiceConfiguration;", "", "userRepository", "Lorg/gotson/komga/domain/persistence/KomgaUserRepository;", "userLifecycle", "Lorg/gotson/komga/domain/service/KomgaUserLifecycle;", "komgaProperties", "Lorg/gotson/komga/infrastructure/configuration/KomgaProperties;", "(Lorg/gotson/komga/domain/persistence/KomgaUserRepository;Lorg/gotson/komga/domain/service/KomgaUserLifecycle;Lorg/gotson/komga/infrastructure/configuration/KomgaProperties;)V", "oauth2UserService", "Lorg/springframework/security/oauth2/client/userinfo/OAuth2UserService;", "Lorg/springframework/security/oauth2/client/userinfo/OAuth2UserRequest;", "Lorg/springframework/security/oauth2/core/user/OAuth2User;", "oidcUserService", "Lorg/springframework/security/oauth2/client/oidc/userinfo/OidcUserRequest;", "Lorg/springframework/security/oauth2/core/oidc/user/OidcUser;", "tryCreateNewUser", "Lorg/gotson/komga/domain/model/KomgaUser;", "email", "", "komga"})
public class KomgaOAuth2UserServiceConfiguration {
    @NotNull
    private final KomgaUserRepository userRepository;
    @NotNull
    private final KomgaUserLifecycle userLifecycle;
    @NotNull
    private final KomgaProperties komgaProperties;

    public KomgaOAuth2UserServiceConfiguration(@NotNull KomgaUserRepository userRepository, @NotNull KomgaUserLifecycle userLifecycle, @NotNull KomgaProperties komgaProperties) {
        Intrinsics.checkNotNullParameter((Object)userRepository, (String)"userRepository");
        Intrinsics.checkNotNullParameter((Object)userLifecycle, (String)"userLifecycle");
        Intrinsics.checkNotNullParameter((Object)komgaProperties, (String)"komgaProperties");
        this.userRepository = userRepository;
        this.userLifecycle = userLifecycle;
        this.komgaProperties = komgaProperties;
    }

    @Bean
    @NotNull
    public OAuth2UserService<OAuth2UserRequest, OAuth2User> oauth2UserService() {
        DefaultOAuth2UserService defaultDelegate = new DefaultOAuth2UserService();
        GithubOAuth2UserService githubDelegate = new GithubOAuth2UserService();
        return arg_0 -> KomgaOAuth2UserServiceConfiguration.oauth2UserService$lambda$0(githubDelegate, defaultDelegate, this, arg_0);
    }

    @Bean
    @NotNull
    public OAuth2UserService<OidcUserRequest, OidcUser> oidcUserService() {
        OidcUserService delegate = new OidcUserService();
        return arg_0 -> KomgaOAuth2UserServiceConfiguration.oidcUserService$lambda$1(delegate, this, arg_0);
    }

    private KomgaUser tryCreateNewUser(String email) {
        if (!this.komgaProperties.getOauth2AccountCreation()) {
            throw new OAuth2AuthenticationException("ERR_1025");
        }
        KomgaOAuth2UserServiceConfigurationKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        String string = RandomStringUtils.secure().nextAlphanumeric(12);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nextAlphanumeric(...)");
        return this.userLifecycle.createUser(new KomgaUser(email, string, false, false, false, false, null, false, null, null, null, null, 4088, null));
    }

    private static final OAuth2User oauth2UserService$lambda$0(GithubOAuth2UserService $githubDelegate, DefaultOAuth2UserService $defaultDelegate, KomgaOAuth2UserServiceConfiguration this$0, OAuth2UserRequest userRequest) {
        Intrinsics.checkNotNullParameter((Object)$githubDelegate, (String)"$githubDelegate");
        Intrinsics.checkNotNullParameter((Object)$defaultDelegate, (String)"$defaultDelegate");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)userRequest, (String)"userRequest");
        String string = userRequest.getClientRegistration().getRegistrationId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRegistrationId(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        DefaultOAuth2UserService delegate = Intrinsics.areEqual((Object)string2, (Object)"github") ? (DefaultOAuth2UserService)$githubDelegate : $defaultDelegate;
        OAuth2User oAuth2User = delegate.loadUser(userRequest);
        String string3 = (String)oAuth2User.getAttribute("email");
        if (string3 == null) {
            throw new OAuth2AuthenticationException("ERR_1024");
        }
        String email = string3;
        KomgaUser komgaUser = this$0.userRepository.findByEmailIgnoreCaseOrNull(email);
        if (komgaUser == null) {
            komgaUser = this$0.tryCreateNewUser(email);
        }
        KomgaUser existingUser = komgaUser;
        return (OAuth2User)new KomgaPrincipal(existingUser, oAuth2User, null, null, null, 28, null);
    }

    private static final OidcUser oidcUserService$lambda$1(OidcUserService $delegate, KomgaOAuth2UserServiceConfiguration this$0, OidcUserRequest userRequest) {
        Intrinsics.checkNotNullParameter((Object)$delegate, (String)"$delegate");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)userRequest, (String)"userRequest");
        OidcUser oidcUser = $delegate.loadUser(userRequest);
        if (oidcUser.getEmail() == null) {
            throw new OAuth2AuthenticationException("ERR_1028");
        }
        if (this$0.komgaProperties.getOidcEmailVerification() && oidcUser.getEmailVerified() == null) {
            throw new OAuth2AuthenticationException("ERR_1027");
        }
        if (this$0.komgaProperties.getOidcEmailVerification() && Intrinsics.areEqual((Object)oidcUser.getEmailVerified(), (Object)false)) {
            throw new OAuth2AuthenticationException("ERR_1026");
        }
        KomgaUserRepository komgaUserRepository = this$0.userRepository;
        String string = oidcUser.getEmail();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEmail(...)");
        KomgaUser komgaUser = komgaUserRepository.findByEmailIgnoreCaseOrNull(string);
        if (komgaUser == null) {
            String string2 = oidcUser.getEmail();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getEmail(...)");
            komgaUser = this$0.tryCreateNewUser(string2);
        }
        KomgaUser existingUser = komgaUser;
        return (OidcUser)new KomgaPrincipal(existingUser, (OAuth2User)oidcUser, null, null, null, 28, null);
    }
}

