/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.api.opds;

import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gotson.komga.domain.model.TypedBytes;
import org.gotson.komga.domain.service.BookLifecycle;
import org.gotson.komga.infrastructure.image.ImageConverter;
import org.gotson.komga.infrastructure.image.ImageType;
import org.gotson.komga.infrastructure.security.KomgaPrincipal;
import org.gotson.komga.interfaces.api.ContentRestrictionChecker;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/gotson/komga/interfaces/api/opds/OpdsCommonController;", "", "contentRestrictionChecker", "Lorg/gotson/komga/interfaces/api/ContentRestrictionChecker;", "bookLifecycle", "Lorg/gotson/komga/domain/service/BookLifecycle;", "imageConverter", "Lorg/gotson/komga/infrastructure/image/ImageConverter;", "(Lorg/gotson/komga/interfaces/api/ContentRestrictionChecker;Lorg/gotson/komga/domain/service/BookLifecycle;Lorg/gotson/komga/infrastructure/image/ImageConverter;)V", "getBookThumbnail", "", "principal", "Lorg/gotson/komga/infrastructure/security/KomgaPrincipal;", "bookId", "", "komga"})
public class OpdsCommonController {
    @NotNull
    private final ContentRestrictionChecker contentRestrictionChecker;
    @NotNull
    private final BookLifecycle bookLifecycle;
    @NotNull
    private final ImageConverter imageConverter;

    public OpdsCommonController(@NotNull ContentRestrictionChecker contentRestrictionChecker, @NotNull BookLifecycle bookLifecycle, @NotNull ImageConverter imageConverter) {
        Intrinsics.checkNotNullParameter((Object)contentRestrictionChecker, (String)"contentRestrictionChecker");
        Intrinsics.checkNotNullParameter((Object)bookLifecycle, (String)"bookLifecycle");
        Intrinsics.checkNotNullParameter((Object)imageConverter, (String)"imageConverter");
        this.contentRestrictionChecker = contentRestrictionChecker;
        this.bookLifecycle = bookLifecycle;
        this.imageConverter = imageConverter;
    }

    @ApiResponse(content={@Content(schema=@Schema(format="binary", type="string"))})
    @GetMapping(value={"/opds/v1.2/books/{bookId}/thumbnail", "/opds/v2/books/{bookId}/thumbnail"}, produces={"image/jpeg"})
    @NotNull
    public byte[] getBookThumbnail(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String bookId) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        this.contentRestrictionChecker.checkContentRestriction(principal.getUser(), bookId);
        TypedBytes typedBytes = this.bookLifecycle.getThumbnailBytesOriginal(bookId);
        if (typedBytes == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        TypedBytes poster = typedBytes;
        return !Intrinsics.areEqual((Object)poster.getMediaType(), (Object)ImageType.JPEG.getMediaType()) ? this.imageConverter.convertImage(poster.getBytes(), ImageType.JPEG.getImageIOFormat()) : poster.getBytes();
    }
}

