/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.api.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gotson.komga.application.tasks.TaskEmitter;
import org.gotson.komga.domain.model.Book;
import org.gotson.komga.domain.model.BookMetadata;
import org.gotson.komga.domain.model.BookPage;
import org.gotson.komga.domain.model.BookSearch;
import org.gotson.komga.domain.model.Dimension;
import org.gotson.komga.domain.model.DomainEvent;
import org.gotson.komga.domain.model.ImageConversionException;
import org.gotson.komga.domain.model.KomgaUser;
import org.gotson.komga.domain.model.MarkSelectedPreference;
import org.gotson.komga.domain.model.Media;
import org.gotson.komga.domain.model.MediaExtension;
import org.gotson.komga.domain.model.MediaExtensionEpub;
import org.gotson.komga.domain.model.MediaNotReadyException;
import org.gotson.komga.domain.model.MediaProfile;
import org.gotson.komga.domain.model.ReadList;
import org.gotson.komga.domain.model.ReadStatus;
import org.gotson.komga.domain.model.SearchCondition;
import org.gotson.komga.domain.model.SearchContext;
import org.gotson.komga.domain.model.SearchOperator;
import org.gotson.komga.domain.model.ThumbnailBook;
import org.gotson.komga.domain.model.TypedBytes;
import org.gotson.komga.domain.persistence.BookMetadataRepository;
import org.gotson.komga.domain.persistence.BookRepository;
import org.gotson.komga.domain.persistence.MediaRepository;
import org.gotson.komga.domain.persistence.ReadListRepository;
import org.gotson.komga.domain.persistence.ReadProgressRepository;
import org.gotson.komga.domain.persistence.ThumbnailBookRepository;
import org.gotson.komga.domain.service.BookAnalyzer;
import org.gotson.komga.domain.service.BookLifecycle;
import org.gotson.komga.infrastructure.image.ImageAnalyzer;
import org.gotson.komga.infrastructure.jooq.UnpagedSorted;
import org.gotson.komga.infrastructure.mediacontainer.ContentDetector;
import org.gotson.komga.infrastructure.security.KomgaPrincipal;
import org.gotson.komga.infrastructure.swagger.PageableAsQueryParam;
import org.gotson.komga.infrastructure.swagger.PageableWithoutSortAsQueryParam;
import org.gotson.komga.interfaces.api.CommonBookController;
import org.gotson.komga.interfaces.api.ContentRestrictionChecker;
import org.gotson.komga.interfaces.api.UtilsKt;
import org.gotson.komga.interfaces.api.WebPubGenerator;
import org.gotson.komga.interfaces.api.dto.ConstantsKt;
import org.gotson.komga.interfaces.api.dto.WPPublicationDto;
import org.gotson.komga.interfaces.api.persistence.BookDtoRepository;
import org.gotson.komga.interfaces.api.rest.BookController;
import org.gotson.komga.interfaces.api.rest.BookControllerKt;
import org.gotson.komga.interfaces.api.rest.dto.BookDto;
import org.gotson.komga.interfaces.api.rest.dto.BookDtoKt;
import org.gotson.komga.interfaces.api.rest.dto.BookImportBatchDto;
import org.gotson.komga.interfaces.api.rest.dto.BookImportDto;
import org.gotson.komga.interfaces.api.rest.dto.BookMetadataUpdateDto;
import org.gotson.komga.interfaces.api.rest.dto.BookMetadataUpdateDtoKt;
import org.gotson.komga.interfaces.api.rest.dto.PageDto;
import org.gotson.komga.interfaces.api.rest.dto.R2Positions;
import org.gotson.komga.interfaces.api.rest.dto.ReadListDto;
import org.gotson.komga.interfaces.api.rest.dto.ReadListDtoKt;
import org.gotson.komga.interfaces.api.rest.dto.ReadProgressUpdateDto;
import org.gotson.komga.interfaces.api.rest.dto.ThumbnailBookDto;
import org.gotson.komga.interfaces.api.rest.dto.ThumbnailBookDtoKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(produces={"application/json"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0085\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u0012\u0006\u0010 \u001a\u00020!\u00a2\u0006\u0002\u0010\"J0\u0010#\u001a\u00020$2\b\b\u0001\u0010%\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020(2\b\b\u0001\u0010)\u001a\u00020*2\b\b\u0003\u0010+\u001a\u00020,H\u0017J\u0012\u0010-\u001a\u00020.2\b\b\u0001\u0010'\u001a\u00020(H\u0017J\u0012\u0010/\u001a\u00020.2\b\b\u0001\u0010'\u001a\u00020(H\u0017J\u001c\u00100\u001a\u00020.2\b\b\u0001\u0010'\u001a\u00020(2\b\b\u0001\u0010%\u001a\u00020&H\u0017J&\u00101\u001a\u00020.2\b\b\u0001\u0010%\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020(2\b\b\u0001\u00102\u001a\u00020(H\u0017J\u008c\u0001\u00103\u001a\b\u0012\u0004\u0012\u000205042\b\b\u0001\u0010%\u001a\u00020&2\n\b\u0003\u00106\u001a\u0004\u0018\u00010(2\u0010\b\u0003\u00107\u001a\n\u0012\u0004\u0012\u00020(\u0018\u0001082\u0010\b\u0003\u00109\u001a\n\u0012\u0004\u0012\u00020:\u0018\u0001082\u0010\b\u0003\u0010;\u001a\n\u0012\u0004\u0012\u00020<\u0018\u0001082\n\b\u0003\u0010=\u001a\u0004\u0018\u00010>2\u0010\b\u0003\u0010?\u001a\n\u0012\u0004\u0012\u00020(\u0018\u0001082\b\b\u0003\u0010@\u001a\u00020,2\b\b\u0001\u0010A\u001a\u00020BH\u0017J\"\u0010C\u001a\b\u0012\u0004\u0012\u00020D082\b\b\u0001\u0010%\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020(H\u0017Jf\u0010E\u001a\b\u0012\u0004\u0012\u00020G0F2\b\b\u0001\u0010%\u001a\u00020&2\u0006\u0010H\u001a\u00020I2\b\b\u0001\u0010'\u001a\u00020(2\b\b\u0001\u0010J\u001a\u00020K2\n\b\u0001\u0010L\u001a\u0004\u0018\u00010(2\b\b\u0001\u0010M\u001a\u00020,2\u0010\b\u0001\u0010N\u001a\n\u0012\u0004\u0012\u00020P\u0018\u00010O2\b\b\u0001\u0010Q\u001a\u00020,H\u0017J4\u0010R\u001a\b\u0012\u0004\u0012\u00020G0F2\b\b\u0001\u0010%\u001a\u00020&2\u0006\u0010H\u001a\u00020S2\b\b\u0001\u0010'\u001a\u00020(2\b\b\u0001\u0010J\u001a\u00020KH\u0017J\"\u0010T\u001a\b\u0012\u0004\u0012\u00020U082\b\b\u0001\u0010%\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020(H\u0017J\u001c\u0010V\u001a\u0002052\b\b\u0001\u0010%\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020(H\u0017J\u001c\u0010W\u001a\u0002052\b\b\u0001\u0010%\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020(H\u0017J\u001c\u0010X\u001a\u00020G2\b\b\u0001\u0010%\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020(H\u0017J&\u0010Y\u001a\u00020G2\b\b\u0001\u0010%\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020(2\b\b\u0001\u00102\u001a\u00020(H\u0017J\"\u0010Z\u001a\b\u0012\u0004\u0012\u00020$0[2\b\b\u0001\u0010%\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020(H\u0017J4\u0010\\\u001a\b\u0012\u0004\u0012\u000205042\b\b\u0001\u0010%\u001a\u00020&2\u0010\b\u0003\u00107\u001a\n\u0012\u0004\u0012\u00020(\u0018\u0001082\b\b\u0001\u0010A\u001a\u00020BH\u0017J,\u0010]\u001a\b\u0012\u0004\u0012\u000205042\b\b\u0001\u0010%\u001a\u00020&2\b\b\u0003\u0010@\u001a\u00020,2\b\b\u0001\u0010A\u001a\u00020BH\u0017J,\u0010^\u001a\b\u0012\u0004\u0012\u000205042\b\b\u0001\u0010%\u001a\u00020&2\b\b\u0003\u0010@\u001a\u00020,2\b\b\u0001\u0010A\u001a\u00020BH\u0017J\u001c\u0010_\u001a\u0002052\b\b\u0001\u0010%\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020(H\u0017J*\u0010`\u001a\b\u0012\u0004\u0012\u00020a0F2\u0006\u0010H\u001a\u00020b2\b\b\u0001\u0010%\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020(H\u0017J\"\u0010c\u001a\b\u0012\u0004\u0012\u00020d0F2\b\b\u0001\u0010%\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020(H\u0017J\u001c\u0010e\u001a\u00020d2\b\b\u0001\u0010%\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020(H\u0017J\u001c\u0010f\u001a\u00020d2\b\b\u0001\u0010%\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020(H\u0017J\u001c\u0010g\u001a\u00020d2\b\b\u0001\u0010%\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020(H\u0017J\u0012\u0010h\u001a\u00020.2\b\b\u0001\u0010i\u001a\u00020jH\u0017J&\u0010k\u001a\u00020.2\b\b\u0001\u0010'\u001a\u00020(2\b\b\u0001\u0010l\u001a\u00020m2\b\b\u0001\u0010%\u001a\u00020&H\u0017J&\u0010n\u001a\u00020.2\b\b\u0001\u0010%\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020(2\b\b\u0001\u00102\u001a\u00020(H\u0017J\u0012\u0010o\u001a\u00020.2\b\b\u0001\u0010'\u001a\u00020(H\u0017J\u0012\u0010p\u001a\u00020.2\b\b\u0003\u0010q\u001a\u00020,H\u0017J\u001e\u0010r\u001a\u00020.2\u0014\b\u0001\u0010s\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020u0tH\u0017J\u001c\u0010v\u001a\u00020.2\b\b\u0001\u0010'\u001a\u00020(2\b\b\u0001\u0010w\u001a\u00020uH\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006x"}, d2={"Lorg/gotson/komga/interfaces/api/rest/BookController;", "", "taskEmitter", "Lorg/gotson/komga/application/tasks/TaskEmitter;", "bookAnalyzer", "Lorg/gotson/komga/domain/service/BookAnalyzer;", "bookLifecycle", "Lorg/gotson/komga/domain/service/BookLifecycle;", "bookRepository", "Lorg/gotson/komga/domain/persistence/BookRepository;", "readProgressRepository", "Lorg/gotson/komga/domain/persistence/ReadProgressRepository;", "bookMetadataRepository", "Lorg/gotson/komga/domain/persistence/BookMetadataRepository;", "mediaRepository", "Lorg/gotson/komga/domain/persistence/MediaRepository;", "bookDtoRepository", "Lorg/gotson/komga/interfaces/api/persistence/BookDtoRepository;", "readListRepository", "Lorg/gotson/komga/domain/persistence/ReadListRepository;", "contentDetector", "Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;", "imageAnalyzer", "Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "thumbnailBookRepository", "Lorg/gotson/komga/domain/persistence/ThumbnailBookRepository;", "webPubGenerator", "Lorg/gotson/komga/interfaces/api/WebPubGenerator;", "contentRestrictionChecker", "Lorg/gotson/komga/interfaces/api/ContentRestrictionChecker;", "commonBookController", "Lorg/gotson/komga/interfaces/api/CommonBookController;", "(Lorg/gotson/komga/application/tasks/TaskEmitter;Lorg/gotson/komga/domain/service/BookAnalyzer;Lorg/gotson/komga/domain/service/BookLifecycle;Lorg/gotson/komga/domain/persistence/BookRepository;Lorg/gotson/komga/domain/persistence/ReadProgressRepository;Lorg/gotson/komga/domain/persistence/BookMetadataRepository;Lorg/gotson/komga/domain/persistence/MediaRepository;Lorg/gotson/komga/interfaces/api/persistence/BookDtoRepository;Lorg/gotson/komga/domain/persistence/ReadListRepository;Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;Lorg/springframework/context/ApplicationEventPublisher;Lorg/gotson/komga/domain/persistence/ThumbnailBookRepository;Lorg/gotson/komga/interfaces/api/WebPubGenerator;Lorg/gotson/komga/interfaces/api/ContentRestrictionChecker;Lorg/gotson/komga/interfaces/api/CommonBookController;)V", "addUserUploadedBookThumbnail", "Lorg/gotson/komga/interfaces/api/rest/dto/ThumbnailBookDto;", "principal", "Lorg/gotson/komga/infrastructure/security/KomgaPrincipal;", "bookId", "", "file", "Lorg/springframework/web/multipart/MultipartFile;", "selected", "", "analyze", "", "deleteBook", "deleteReadProgress", "deleteUserUploadedBookThumbnail", "thumbnailId", "getAllBooks", "Lorg/springframework/data/domain/Page;", "Lorg/gotson/komga/interfaces/api/rest/dto/BookDto;", "searchTerm", "libraryIds", "", "mediaStatus", "Lorg/gotson/komga/domain/model/Media$Status;", "readStatus", "Lorg/gotson/komga/domain/model/ReadStatus;", "releasedAfter", "Ljava/time/LocalDate;", "tags", "unpaged", "page", "Lorg/springframework/data/domain/Pageable;", "getAllReadListsByBook", "Lorg/gotson/komga/interfaces/api/rest/dto/ReadListDto;", "getBookPage", "Lorg/springframework/http/ResponseEntity;", "", "request", "Lorg/springframework/web/context/request/ServletWebRequest;", "pageNumber", "", "convertTo", "zeroBasedIndex", "acceptHeaders", "", "Lorg/springframework/http/MediaType;", "contentNegotiation", "getBookPageThumbnail", "Lorg/springframework/web/context/request/WebRequest;", "getBookPages", "Lorg/gotson/komga/interfaces/api/rest/dto/PageDto;", "getBookSiblingNext", "getBookSiblingPrevious", "getBookThumbnail", "getBookThumbnailById", "getBookThumbnails", "", "getBooksOnDeck", "getDuplicateBooks", "getLatestBooks", "getOneBook", "getPositions", "Lorg/gotson/komga/interfaces/api/rest/dto/R2Positions;", "Ljakarta/servlet/http/HttpServletRequest;", "getWebPubManifest", "Lorg/gotson/komga/interfaces/api/dto/WPPublicationDto;", "getWebPubManifestDivina", "getWebPubManifestEpub", "getWebPubManifestPdf", "importBooks", "bookImportBatch", "Lorg/gotson/komga/interfaces/api/rest/dto/BookImportBatchDto;", "markReadProgress", "readProgress", "Lorg/gotson/komga/interfaces/api/rest/dto/ReadProgressUpdateDto;", "markSelectedBookThumbnail", "refreshMetadata", "regenerateThumbnails", "forBiggerResultOnly", "updateBatchMetadata", "newMetadatas", "", "Lorg/gotson/komga/interfaces/api/rest/dto/BookMetadataUpdateDto;", "updateMetadata", "newMetadata", "komga"})
@SourceDebugExtension(value={"SMAP\nBookController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookController.kt\norg/gotson/komga/interfaces/api/rest/BookController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,715:1\n1549#2:716\n1620#2,3:717\n1549#2:720\n1620#2,3:721\n1549#2:724\n1620#2,3:725\n1549#2:728\n1620#2,3:729\n1549#2:733\n1620#2,3:734\n1549#2:737\n1620#2,3:738\n1559#2:741\n1590#2,4:742\n1855#2,2:759\n1549#2:761\n1620#2,3:762\n1855#2,2:765\n1855#2,2:767\n1#3:732\n1#3:756\n135#4,9:746\n215#4:755\n216#4:757\n144#4:758\n*S KotlinDebug\n*F\n+ 1 BookController.kt\norg/gotson/komga/interfaces/api/rest/BookController\n*L\n158#1:716\n158#1:717,3\n159#1:720\n159#1:721,3\n160#1:724\n160#1:725,3\n161#1:728\n161#1:729,3\n289#1:733\n289#1:734,3\n328#1:737\n328#1:738,3\n411#1:741\n411#1:742,4\n629#1:759,2\n630#1:761\n630#1:762,3\n630#1:765,2\n678#1:767,2\n620#1:756\n620#1:746,9\n620#1:755\n620#1:757\n620#1:758\n*E\n"})
public class BookController {
    @NotNull
    private final TaskEmitter taskEmitter;
    @NotNull
    private final BookAnalyzer bookAnalyzer;
    @NotNull
    private final BookLifecycle bookLifecycle;
    @NotNull
    private final BookRepository bookRepository;
    @NotNull
    private final ReadProgressRepository readProgressRepository;
    @NotNull
    private final BookMetadataRepository bookMetadataRepository;
    @NotNull
    private final MediaRepository mediaRepository;
    @NotNull
    private final BookDtoRepository bookDtoRepository;
    @NotNull
    private final ReadListRepository readListRepository;
    @NotNull
    private final ContentDetector contentDetector;
    @NotNull
    private final ImageAnalyzer imageAnalyzer;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;
    @NotNull
    private final ThumbnailBookRepository thumbnailBookRepository;
    @NotNull
    private final WebPubGenerator webPubGenerator;
    @NotNull
    private final ContentRestrictionChecker contentRestrictionChecker;
    @NotNull
    private final CommonBookController commonBookController;

    public BookController(@NotNull TaskEmitter taskEmitter, @NotNull BookAnalyzer bookAnalyzer, @NotNull BookLifecycle bookLifecycle, @NotNull BookRepository bookRepository, @NotNull ReadProgressRepository readProgressRepository, @NotNull BookMetadataRepository bookMetadataRepository, @NotNull MediaRepository mediaRepository, @NotNull BookDtoRepository bookDtoRepository, @NotNull ReadListRepository readListRepository, @NotNull ContentDetector contentDetector, @NotNull ImageAnalyzer imageAnalyzer, @NotNull ApplicationEventPublisher eventPublisher, @NotNull ThumbnailBookRepository thumbnailBookRepository, @NotNull WebPubGenerator webPubGenerator, @NotNull ContentRestrictionChecker contentRestrictionChecker, @NotNull CommonBookController commonBookController) {
        Intrinsics.checkNotNullParameter((Object)taskEmitter, (String)"taskEmitter");
        Intrinsics.checkNotNullParameter((Object)bookAnalyzer, (String)"bookAnalyzer");
        Intrinsics.checkNotNullParameter((Object)bookLifecycle, (String)"bookLifecycle");
        Intrinsics.checkNotNullParameter((Object)bookRepository, (String)"bookRepository");
        Intrinsics.checkNotNullParameter((Object)readProgressRepository, (String)"readProgressRepository");
        Intrinsics.checkNotNullParameter((Object)bookMetadataRepository, (String)"bookMetadataRepository");
        Intrinsics.checkNotNullParameter((Object)mediaRepository, (String)"mediaRepository");
        Intrinsics.checkNotNullParameter((Object)bookDtoRepository, (String)"bookDtoRepository");
        Intrinsics.checkNotNullParameter((Object)readListRepository, (String)"readListRepository");
        Intrinsics.checkNotNullParameter((Object)contentDetector, (String)"contentDetector");
        Intrinsics.checkNotNullParameter((Object)imageAnalyzer, (String)"imageAnalyzer");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)thumbnailBookRepository, (String)"thumbnailBookRepository");
        Intrinsics.checkNotNullParameter((Object)webPubGenerator, (String)"webPubGenerator");
        Intrinsics.checkNotNullParameter((Object)contentRestrictionChecker, (String)"contentRestrictionChecker");
        Intrinsics.checkNotNullParameter((Object)commonBookController, (String)"commonBookController");
        this.taskEmitter = taskEmitter;
        this.bookAnalyzer = bookAnalyzer;
        this.bookLifecycle = bookLifecycle;
        this.bookRepository = bookRepository;
        this.readProgressRepository = readProgressRepository;
        this.bookMetadataRepository = bookMetadataRepository;
        this.mediaRepository = mediaRepository;
        this.bookDtoRepository = bookDtoRepository;
        this.readListRepository = readListRepository;
        this.contentDetector = contentDetector;
        this.imageAnalyzer = imageAnalyzer;
        this.eventPublisher = eventPublisher;
        this.thumbnailBookRepository = thumbnailBookRepository;
        this.webPubGenerator = webPubGenerator;
        this.contentRestrictionChecker = contentRestrictionChecker;
        this.commonBookController = commonBookController;
    }

    @PageableAsQueryParam
    @GetMapping(value={"api/v1/books"})
    @NotNull
    public Page<BookDto> getAllBooks(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="search", required=false) @Nullable String searchTerm, @RequestParam(name="library_id", required=false) @Nullable List<String> libraryIds, @RequestParam(name="media_status", required=false) @Nullable List<? extends Media.Status> mediaStatus, @RequestParam(name="read_status", required=false) @Nullable List<? extends ReadStatus> readStatus, @RequestParam(name="released_after", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) @Nullable LocalDate releasedAfter, @RequestParam(name="tag", required=false) @Nullable List<String> tags, @RequestParam(name="unpaged", required=false) boolean unpaged, @Parameter(hidden=true) @NotNull Pageable page) {
        Object it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        Iterable $this$map$iv;
        boolean $i$f$map;
        List list;
        List list2;
        Pageable pageable;
        Sort sort;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        if (page.getSort().isSorted()) {
            sort = page.getSort();
        } else {
            String[] stringArray = (String[])searchTerm;
            if (!(stringArray == null || StringsKt.isBlank((CharSequence)stringArray))) {
                stringArray = new String[]{"relevance"};
                sort = Sort.by((String[])stringArray);
            } else {
                sort = Sort.unsorted();
            }
        }
        Sort sort2 = sort;
        Intrinsics.checkNotNull((Object)sort2);
        Sort sort3 = sort2;
        if (unpaged) {
            pageable = (Pageable)new UnpagedSorted(sort3);
        } else {
            PageRequest pageRequest = PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)sort3);
            Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
            pageable = (Pageable)pageRequest;
        }
        Pageable pageRequest = pageable;
        List $this$getAllBooks_u24lambda_u245 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable iterable = libraryIds;
        if (!(iterable == null || iterable.isEmpty())) {
            iterable = libraryIds;
            list = $this$getAllBooks_u24lambda_u245;
            $i$f$map = false;
            Collection collection2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new SearchCondition.LibraryId((SearchOperator.Equality)new SearchOperator.Is(it)));
            }
            List list3 = (List)destination$iv$iv;
            list.add(new SearchCondition.AnyOfBook(list3));
        }
        if (!(($this$map$iv = (Collection)mediaStatus) == null || $this$map$iv.isEmpty())) {
            $this$map$iv = mediaStatus;
            list = $this$getAllBooks_u24lambda_u245;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Media.Status)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(new SearchCondition.MediaStatus((SearchOperator.Equality)new SearchOperator.Is(it)));
            }
            List list4 = (List)destination$iv$iv;
            list.add(new SearchCondition.AnyOfBook(list4));
        }
        if (!(($this$map$iv = (Collection)readStatus) == null || $this$map$iv.isEmpty())) {
            $this$map$iv = readStatus;
            list = $this$getAllBooks_u24lambda_u245;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (ReadStatus)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(new SearchCondition.ReadStatus((SearchOperator.Equality)new SearchOperator.Is(it)));
            }
            List list5 = (List)destination$iv$iv;
            list.add(new SearchCondition.AnyOfBook(list5));
        }
        if (!(($this$map$iv = (Collection)tags) == null || $this$map$iv.isEmpty())) {
            $this$map$iv = tags;
            list = $this$getAllBooks_u24lambda_u245;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl5 = false;
                collection.add(new SearchCondition.Tag((SearchOperator.Equality)new SearchOperator.Is(it)));
            }
            List list6 = (List)destination$iv$iv;
            list.add(new SearchCondition.AnyOfBook(list6));
        }
        LocalDate localDate = releasedAfter;
        if (localDate != null) {
            LocalDate it2 = localDate;
            boolean bl6 = false;
            ZonedDateTime zonedDateTime = it2.atStartOfDay(ZoneOffset.UTC);
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"atStartOfDay(...)");
            $this$getAllBooks_u24lambda_u245.add(new SearchCondition.ReleaseDate((SearchOperator.Date)new SearchOperator.After(zonedDateTime)));
        }
        List list7 = CollectionsKt.build((List)list2);
        String string = searchTerm;
        SearchCondition.Book book = (SearchCondition.Book)new SearchCondition.AllOfBook(list7);
        BookSearch bookSearch = new BookSearch(book, string);
        Page page2 = this.bookDtoRepository.findAll(bookSearch, new SearchContext(principal.getUser()), pageRequest).map(arg_0 -> BookController.getAllBooks$lambda$6((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
        return page2;
    }

    public static /* synthetic */ Page getAllBooks$default(BookController bookController, KomgaPrincipal komgaPrincipal, String string, List list, List list2, List list3, LocalDate localDate, List list4, boolean bl, Pageable pageable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getAllBooks");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            list = null;
        }
        if ((n & 8) != 0) {
            list2 = null;
        }
        if ((n & 0x10) != 0) {
            list3 = null;
        }
        if ((n & 0x20) != 0) {
            localDate = null;
        }
        if ((n & 0x40) != 0) {
            list4 = null;
        }
        if ((n & 0x80) != 0) {
            bl = false;
        }
        return bookController.getAllBooks(komgaPrincipal, string, list, list2, list3, localDate, list4, bl, pageable);
    }

    @Operation(description="Return newly added or updated books.")
    @PageableWithoutSortAsQueryParam
    @GetMapping(value={"api/v1/books/latest"})
    @NotNull
    public Page<BookDto> getLatestBooks(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="unpaged", required=false) boolean unpaged, @Parameter(hidden=true) @NotNull Pageable page) {
        Pageable pageable;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Sort.Order[] orderArray = new Sort.Order[]{Sort.Order.desc((String)"lastModifiedDate")};
        Sort sort = Sort.by((Sort.Order[])orderArray);
        Intrinsics.checkNotNullExpressionValue((Object)sort, (String)"by(...)");
        Sort sort2 = sort;
        if (unpaged) {
            pageable = (Pageable)new UnpagedSorted(sort2);
        } else {
            PageRequest pageRequest = PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)sort2);
            Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
            pageable = (Pageable)pageRequest;
        }
        Pageable pageRequest = pageable;
        Page page2 = this.bookDtoRepository.findAll(new SearchContext(principal.getUser()), pageRequest).map(arg_0 -> BookController.getLatestBooks$lambda$7((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
        return page2;
    }

    public static /* synthetic */ Page getLatestBooks$default(BookController bookController, KomgaPrincipal komgaPrincipal, boolean bl, Pageable pageable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getLatestBooks");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return bookController.getLatestBooks(komgaPrincipal, bl, pageable);
    }

    @Operation(description="Return first unread book of series with at least one book read and no books in progress.")
    @PageableWithoutSortAsQueryParam
    @GetMapping(value={"api/v1/books/ondeck"})
    @NotNull
    public Page<BookDto> getBooksOnDeck(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="library_id", required=false) @Nullable List<String> libraryIds, @Parameter(hidden=true) @NotNull Pageable page) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Page page2 = this.bookDtoRepository.findAllOnDeck(principal.getUser().getId(), principal.getUser().getAuthorizedLibraryIds((Collection)libraryIds), page, principal.getUser().getRestrictions()).map(arg_0 -> BookController.getBooksOnDeck$lambda$8((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
        return page2;
    }

    public static /* synthetic */ Page getBooksOnDeck$default(BookController bookController, KomgaPrincipal komgaPrincipal, List list, Pageable pageable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getBooksOnDeck");
        }
        if ((n & 2) != 0) {
            list = null;
        }
        return bookController.getBooksOnDeck(komgaPrincipal, list, pageable);
    }

    @PageableAsQueryParam
    @GetMapping(value={"api/v1/books/duplicates"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @NotNull
    public Page<BookDto> getDuplicateBooks(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="unpaged", required=false) boolean unpaged, @Parameter(hidden=true) @NotNull Pageable page) {
        Pageable pageable;
        Sort sort;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        if (page.getSort().isSorted()) {
            sort = page.getSort();
        } else {
            pageable = new Pageable[]{Sort.Order.asc((String)"fileHash")};
            sort = Sort.by((Sort.Order[])pageable);
        }
        Sort sort2 = sort;
        Intrinsics.checkNotNull((Object)sort2);
        Sort sort3 = sort2;
        pageable = unpaged ? Pageable.unpaged() : (Pageable)PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)sort3);
        Intrinsics.checkNotNull((Object)pageable);
        Pageable pageRequest = pageable;
        return this.bookDtoRepository.findAllDuplicates(principal.getUser().getId(), pageRequest);
    }

    public static /* synthetic */ Page getDuplicateBooks$default(BookController bookController, KomgaPrincipal komgaPrincipal, boolean bl, Pageable pageable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getDuplicateBooks");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return bookController.getDuplicateBooks(komgaPrincipal, bl, pageable);
    }

    @GetMapping(value={"api/v1/books/{bookId}"})
    @NotNull
    public BookDto getOneBook(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String bookId) {
        BookDto bookDto;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
                Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
                bookDto = this.bookDtoRepository.findByIdOrNull(bookId, principal.getUser().getId());
                if (bookDto == null) break block2;
                BookDto it = bookDto;
                boolean bl = false;
                this.contentRestrictionChecker.checkContentRestriction(principal.getUser(), it);
                BookDto bookDto2 = BookDtoKt.restrictUrl((BookDto)it, (!principal.getUser().getRoleAdmin() ? 1 : 0) != 0);
                bookDto = bookDto2;
                if (bookDto2 != null) break block3;
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return bookDto;
    }

    @GetMapping(value={"api/v1/books/{bookId}/previous"})
    @NotNull
    public BookDto getBookSiblingPrevious(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String bookId) {
        BookDto bookDto;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        this.contentRestrictionChecker.checkContentRestriction(principal.getUser(), bookId);
        BookDto bookDto2 = this.bookDtoRepository.findPreviousInSeriesOrNull(bookId, principal.getUser().getId());
        if (bookDto2 == null || (bookDto = BookDtoKt.restrictUrl((BookDto)bookDto2, (!principal.getUser().getRoleAdmin() ? 1 : 0) != 0)) == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return bookDto;
    }

    @GetMapping(value={"api/v1/books/{bookId}/next"})
    @NotNull
    public BookDto getBookSiblingNext(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String bookId) {
        BookDto bookDto;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        this.contentRestrictionChecker.checkContentRestriction(principal.getUser(), bookId);
        BookDto bookDto2 = this.bookDtoRepository.findNextInSeriesOrNull(bookId, principal.getUser().getId());
        if (bookDto2 == null || (bookDto = BookDtoKt.restrictUrl((BookDto)bookDto2, (!principal.getUser().getRoleAdmin() ? 1 : 0) != 0)) == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return bookDto;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"api/v1/books/{bookId}/readlists"})
    @NotNull
    public List<ReadListDto> getAllReadListsByBook(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable(name="bookId") @NotNull String bookId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        this.contentRestrictionChecker.checkContentRestriction(principal.getUser(), bookId);
        Iterable $this$map$iv = this.readListRepository.findAllContainingBookId(bookId, principal.getUser().getAuthorizedLibraryIds(null), principal.getUser().getRestrictions());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ReadList readList = (ReadList)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ReadListDtoKt.toDto((ReadList)it));
        }
        return (List)destination$iv$iv;
    }

    @ApiResponse(content={@Content(schema=@Schema(format="binary", type="string"))})
    @GetMapping(value={"api/v1/books/{bookId}/thumbnail"}, produces={"image/jpeg"})
    @NotNull
    public byte[] getBookThumbnail(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String bookId) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
                Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
                this.contentRestrictionChecker.checkContentRestriction(principal.getUser(), bookId);
                object = BookLifecycle.getThumbnailBytes$default((BookLifecycle)this.bookLifecycle, (String)bookId, null, (int)2, null);
                if (object == null) break block2;
                byte[] byArray = object.getBytes();
                object = byArray;
                if (byArray != null) break block3;
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return object;
    }

    @ApiResponse(content={@Content(schema=@Schema(format="binary", type="string"))})
    @GetMapping(value={"api/v1/books/{bookId}/thumbnails/{thumbnailId}"}, produces={"image/jpeg"})
    @NotNull
    public byte[] getBookThumbnailById(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable(name="bookId") @NotNull String bookId, @PathVariable(name="thumbnailId") @NotNull String thumbnailId) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
                Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
                Intrinsics.checkNotNullParameter((Object)thumbnailId, (String)"thumbnailId");
                this.contentRestrictionChecker.checkContentRestriction(principal.getUser(), bookId);
                object = this.bookLifecycle.getThumbnailBytesByThumbnailId(thumbnailId);
                if (object == null) break block2;
                byte[] byArray = object.getBytes();
                object = byArray;
                if (byArray != null) break block3;
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"api/v1/books/{bookId}/thumbnails"}, produces={"application/json"})
    @NotNull
    public Collection<ThumbnailBookDto> getBookThumbnails(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable(name="bookId") @NotNull String bookId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        this.contentRestrictionChecker.checkContentRestriction(principal.getUser(), bookId);
        Iterable $this$map$iv = this.thumbnailBookRepository.findAllByBookId(bookId);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ThumbnailBook thumbnailBook = (ThumbnailBook)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ThumbnailBookDtoKt.toDto((ThumbnailBook)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"api/v1/books/{bookId}/thumbnails"}, consumes={"multipart/form-data"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @NotNull
    public ThumbnailBookDto addUserUploadedBookThumbnail(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable(name="bookId") @NotNull String bookId, @RequestParam(value="file") @NotNull MultipartFile file, @RequestParam(value="selected") boolean selected) {
        String string;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Book book = this.bookRepository.findByIdOrNull(bookId);
        if (book == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        Book book2 = book;
        InputStream inputStream = file.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        Object object = inputStream;
        int n = 8192;
        object = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
        Object object2 = null;
        try {
            BufferedInputStream it = (BufferedInputStream)object;
            boolean bl = false;
            string = this.contentDetector.detectMediaType((InputStream)it);
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        String mediaType2 = string;
        if (!this.contentDetector.isImage(mediaType2)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNSUPPORTED_MEDIA_TYPE);
        }
        object = book2.getId();
        object2 = file.getBytes();
        string = ThumbnailBook.Type.USER_UPLOADED;
        long l = file.getBytes().length;
        InputStream inputStream2 = file.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getInputStream(...)");
        InputStream inputStream3 = inputStream2;
        int n2 = 8192;
        Dimension dimension = this.imageAnalyzer.getDimension((InputStream)(inputStream3 instanceof BufferedInputStream ? (BufferedInputStream)inputStream3 : new BufferedInputStream(inputStream3, n2)));
        if (dimension == null) {
            dimension = new Dimension(0, 0);
        }
        Dimension dimension2 = dimension;
        return ThumbnailBookDtoKt.toDto((ThumbnailBook)this.bookLifecycle.addThumbnailForBook(new ThumbnailBook((byte[])object2, null, selected, (ThumbnailBook.Type)string, mediaType2, l, dimension2, null, (String)object, null, null, 1666, null), selected ? MarkSelectedPreference.YES : MarkSelectedPreference.NO));
    }

    public static /* synthetic */ ThumbnailBookDto addUserUploadedBookThumbnail$default(BookController bookController, KomgaPrincipal komgaPrincipal, String string, MultipartFile multipartFile, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addUserUploadedBookThumbnail");
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        return bookController.addUserUploadedBookThumbnail(komgaPrincipal, string, multipartFile, bl);
    }

    @PutMapping(value={"api/v1/books/{bookId}/thumbnails/{thumbnailId}/selected"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void markSelectedBookThumbnail(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable(name="bookId") @NotNull String bookId, @PathVariable(name="thumbnailId") @NotNull String thumbnailId) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        Intrinsics.checkNotNullParameter((Object)thumbnailId, (String)"thumbnailId");
        ThumbnailBook thumbnailBook = this.thumbnailBookRepository.findByIdOrNull(thumbnailId);
        if (thumbnailBook != null) {
            ThumbnailBook it = thumbnailBook;
            boolean bl = false;
            this.thumbnailBookRepository.markSelected(it);
            this.eventPublisher.publishEvent((Object)new DomainEvent.ThumbnailBookAdded(ThumbnailBook.copy$default((ThumbnailBook)it, null, null, (boolean)true, null, null, (long)0L, null, null, null, null, null, (int)2043, null)));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @DeleteMapping(value={"api/v1/books/{bookId}/thumbnails/{thumbnailId}"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void deleteUserUploadedBookThumbnail(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable(name="bookId") @NotNull String bookId, @PathVariable(name="thumbnailId") @NotNull String thumbnailId) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        Intrinsics.checkNotNullParameter((Object)thumbnailId, (String)"thumbnailId");
        ThumbnailBook thumbnailBook = this.thumbnailBookRepository.findByIdOrNull(thumbnailId);
        if (thumbnailBook != null) {
            ThumbnailBook it = thumbnailBook;
            boolean bl = false;
            try {
                this.bookLifecycle.deleteThumbnailForBook(it);
            }
            catch (IllegalArgumentException e) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getMessage());
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"api/v1/books/{bookId}/pages"})
    @NotNull
    public List<PageDto> getBookPages(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String bookId) {
        Collection destination$iv$iv;
        block10: {
            block9: {
                Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
                Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
                Book book = this.bookRepository.findByIdOrNull(bookId);
                if (book == null) break block9;
                Book book2 = book;
                boolean bl = false;
                this.contentRestrictionChecker.checkContentRestriction(principal.getUser(), book2);
                Media media = this.mediaRepository.findById(book2.getId());
                switch (WhenMappings.$EnumSwitchMapping$0[media.getStatus().ordinal()]) {
                    case 1: {
                        throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Book has not been analyzed yet");
                    }
                    case 2: {
                        throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Book is outdated and must be re-analyzed");
                    }
                    case 3: {
                        throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Book analysis failed");
                    }
                    case 4: {
                        throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Book format is not supported");
                    }
                    case 5: {
                        void $this$mapIndexedTo$iv$iv;
                        List pages = media.getProfile() == MediaProfile.PDF ? this.bookAnalyzer.getPdfPagesDynamic(media) : media.getPages();
                        Iterable $this$mapIndexed$iv = pages;
                        boolean $i$f$mapIndexed = false;
                        Iterable iterable = $this$mapIndexed$iv;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                        boolean $i$f$mapIndexedTo = false;
                        int index$iv$iv = 0;
                        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                            void index;
                            void bookPage;
                            int n;
                            if ((n = index$iv$iv++) < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            BookPage bookPage2 = (BookPage)item$iv$iv;
                            int n2 = n;
                            Collection collection = destination$iv$iv;
                            boolean bl2 = false;
                            Dimension dimension = bookPage.getDimension();
                            Dimension dimension2 = bookPage.getDimension();
                            collection.add(new PageDto((int)(index + true), bookPage.getFileName(), bookPage.getMediaType(), dimension != null ? Integer.valueOf(dimension.getWidth()) : null, dimension2 != null ? Integer.valueOf(dimension2.getHeight()) : null, bookPage.getFileSize(), null, 64, null));
                        }
                        break block10;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return (List)destination$iv$iv;
    }

    @ApiResponse(content={@Content(mediaType="image/*", schema=@Schema(format="binary", type="string"))})
    @GetMapping(value={"api/v1/books/{bookId}/pages/{pageNumber}"}, produces={"*/*"})
    @PreAuthorize(value="hasRole('PAGE_STREAMING')")
    @NotNull
    public ResponseEntity<byte[]> getBookPage(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @NotNull ServletWebRequest request, @PathVariable @NotNull String bookId, @PathVariable int pageNumber, @Parameter(description="Convert the image to the provided format.", schema=@Schema(allowableValues={"jpeg", "png"})) @RequestParam(value="convert", required=false) @Nullable String convertTo, @Parameter(description="If set to true, pages will start at index 0. If set to false, pages will start at index 1.") @RequestParam(value="zero_based", defaultValue="false") boolean zeroBasedIndex, @Parameter(description="Some very limited server driven content negotiation is handled. If a book is a PDF book, and the Accept header contains 'application/pdf' as a more specific type than other 'image/' types, a raw PDF page will be returned.") @RequestHeader(value="Accept", required=false) @Nullable List<MediaType> acceptHeaders, @RequestParam(value="contentNegotiation", defaultValue="true") boolean contentNegotiation) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        return this.commonBookController.getBookPageInternal(bookId, zeroBasedIndex ? pageNumber + 1 : pageNumber, convertTo, request, principal, contentNegotiation ? acceptHeaders : null);
    }

    @ApiResponse(content={@Content(schema=@Schema(format="binary", type="string"))})
    @GetMapping(value={"api/v1/books/{bookId}/pages/{pageNumber}/thumbnail"}, produces={"image/jpeg"})
    @NotNull
    public ResponseEntity<byte[]> getBookPageThumbnail(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @NotNull WebRequest request, @PathVariable @NotNull String bookId, @PathVariable int pageNumber) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        Book book = this.bookRepository.findByIdOrNull(bookId);
        if (book != null) {
            Book book2 = book;
            boolean bl = false;
            Media media = this.mediaRepository.findById(bookId);
            if (request.checkNotModified(UtilsKt.getBookLastModified((Media)media))) {
                ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.NOT_MODIFIED));
                Intrinsics.checkNotNullExpressionValue((Object)bodyBuilder, (String)"status(...)");
                v2 = UtilsKt.setNotModified((ResponseEntity.BodyBuilder)bodyBuilder, (Media)media).body((Object)new byte[0]);
            } else {
                ResponseEntity responseEntity2;
                this.contentRestrictionChecker.checkContentRestriction(principal.getUser(), book2);
                try {
                    TypedBytes pageContent = BookLifecycle.getBookPage$default((BookLifecycle)this.bookLifecycle, (Book)book2, (int)pageNumber, null, (Integer)300, (int)4, null);
                    ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.ok().contentType(org.gotson.komga.infrastructure.web.UtilsKt.getMediaTypeOrDefault((String)pageContent.getMediaType()));
                    Intrinsics.checkNotNullExpressionValue((Object)bodyBuilder, (String)"contentType(...)");
                    responseEntity2 = UtilsKt.setNotModified((ResponseEntity.BodyBuilder)bodyBuilder, (Media)media).body((Object)pageContent.getBytes());
                }
                catch (IndexOutOfBoundsException ex) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Page number does not exist");
                }
                catch (ImageConversionException ex) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, ex.getMessage());
                }
                catch (MediaNotReadyException ex) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Book analysis failed");
                }
                catch (NoSuchFileException ex) {
                    BookControllerKt.access$getLogger$p().warn((Throwable)ex, (Function0)new /* Unavailable Anonymous Inner Class!! */);
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "File not found, it may have moved");
                }
                v2 = responseEntity2;
            }
        } else {
            v2 = responseEntity = null;
        }
        if (responseEntity == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return responseEntity;
    }

    @GetMapping(value={"api/v1/books/{bookId}/manifest"}, produces={"application/webpub+json", "application/divina+json"})
    @NotNull
    public ResponseEntity<WPPublicationDto> getWebPubManifest(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String bookId) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        WPPublicationDto manifest = this.commonBookController.getWebPubManifestInternal(principal, bookId, this.webPubGenerator);
        ResponseEntity responseEntity = ResponseEntity.ok().contentType(manifest.getMediaType()).body((Object)manifest);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
        return responseEntity;
    }

    @GetMapping(value={"api/v1/books/{bookId}/positions"}, produces={"application/vnd.readium.position-list+json"})
    @NotNull
    public ResponseEntity<R2Positions> getPositions(@NotNull HttpServletRequest request, @AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String bookId) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        Book book = this.bookRepository.findByIdOrNull(bookId);
        if (book != null) {
            Book book2 = book;
            boolean bl = false;
            Media media = this.mediaRepository.findById(book2.getId());
            if (new ServletWebRequest(request).checkNotModified(UtilsKt.getBookLastModified((Media)media))) {
                ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.NOT_MODIFIED));
                Intrinsics.checkNotNullExpressionValue((Object)bodyBuilder, (String)"status(...)");
                ResponseEntity responseEntity2 = UtilsKt.setNotModified((ResponseEntity.BodyBuilder)bodyBuilder, (Media)media).body(null);
                Intrinsics.checkNotNullExpressionValue((Object)responseEntity2, (String)"body(...)");
                return responseEntity2;
            }
            this.contentRestrictionChecker.checkContentRestriction(principal.getUser(), book2);
            MediaExtension mediaExtension = this.mediaRepository.findExtensionByIdOrNull(book2.getId());
            MediaExtensionEpub mediaExtensionEpub = mediaExtension instanceof MediaExtensionEpub ? (MediaExtensionEpub)mediaExtension : null;
            if (mediaExtensionEpub == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            MediaExtensionEpub extension = mediaExtensionEpub;
            ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.ok().contentType(ConstantsKt.getMEDIATYPE_POSITION_LIST_JSON());
            Intrinsics.checkNotNullExpressionValue((Object)bodyBuilder, (String)"contentType(...)");
            v4 = UtilsKt.setNotModified((ResponseEntity.BodyBuilder)bodyBuilder, (Media)media).body((Object)new R2Positions(extension.getPositions().size(), extension.getPositions()));
        } else {
            v4 = responseEntity = null;
        }
        if (responseEntity == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return responseEntity;
    }

    @GetMapping(value={"api/v1/books/{bookId}/manifest/epub"}, produces={"application/webpub+json"})
    @NotNull
    public WPPublicationDto getWebPubManifestEpub(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String bookId) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        return this.commonBookController.getWebPubManifestEpubInternal(principal, bookId, this.webPubGenerator);
    }

    @GetMapping(value={"api/v1/books/{bookId}/manifest/pdf"}, produces={"application/webpub+json"})
    @NotNull
    public WPPublicationDto getWebPubManifestPdf(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String bookId) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        return this.commonBookController.getWebPubManifestPdfInternal(principal, bookId, this.webPubGenerator);
    }

    @GetMapping(value={"api/v1/books/{bookId}/manifest/divina"}, produces={"application/divina+json"})
    @NotNull
    public WPPublicationDto getWebPubManifestDivina(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String bookId) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        return this.commonBookController.getWebPubManifestDivinaInternal(principal, bookId, this.webPubGenerator);
    }

    @PostMapping(value={"api/v1/books/{bookId}/analyze"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void analyze(@PathVariable @NotNull String bookId) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        Book book = this.bookRepository.findByIdOrNull(bookId);
        if (book != null) {
            Book book2 = book;
            boolean bl = false;
            this.taskEmitter.analyzeBook(book2, 6);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @PostMapping(value={"api/v1/books/{bookId}/metadata/refresh"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void refreshMetadata(@PathVariable @NotNull String bookId) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        Book book = this.bookRepository.findByIdOrNull(bookId);
        if (book != null) {
            Book book2 = book;
            boolean bl = false;
            TaskEmitter.refreshBookMetadata$default((TaskEmitter)this.taskEmitter, (Book)book2, null, (int)6, (int)2, null);
            this.taskEmitter.refreshBookLocalArtwork(book2, 6);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @PatchMapping(value={"api/v1/books/{bookId}/metadata"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateMetadata(@PathVariable @NotNull String bookId, @Parameter(description="Metadata fields to update. Set a field to null to unset the metadata. You can omit fields you don't want to update.") @Valid @RequestBody @NotNull BookMetadataUpdateDto newMetadata) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        Intrinsics.checkNotNullParameter((Object)newMetadata, (String)"newMetadata");
        BookMetadata bookMetadata = this.bookMetadataRepository.findByIdOrNull(bookId);
        if (bookMetadata != null) {
            BookMetadata existing = bookMetadata;
            boolean bl = false;
            BookMetadata updated = BookMetadataUpdateDtoKt.patch((BookMetadata)existing, (BookMetadataUpdateDto)newMetadata);
            this.bookMetadataRepository.update(updated);
            Book book = this.bookRepository.findByIdOrNull(bookId);
            if (book != null) {
                Book updatedBook = book;
                boolean bl2 = false;
                TaskEmitter.aggregateSeriesMetadata$default((TaskEmitter)this.taskEmitter, (String)updatedBook.getSeriesId(), (int)0, (int)2, null);
                Book it = updatedBook;
                boolean bl3 = false;
                this.eventPublisher.publishEvent((Object)new DomainEvent.BookUpdated(it));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PatchMapping(value={"api/v1/books/metadata"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateBatchMetadata(@Parameter(description="A map of book IDs which values are the metadata fields to update. Set a field to null to unset the metadata. You can omit fields you don't want to update.") @Valid @RequestBody @NotNull Map<String, BookMetadataUpdateDto> newMetadatas) {
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(newMetadatas, (String)"newMetadatas");
        Map<String, BookMetadataUpdateDto> $this$mapNotNull$iv = newMetadatas;
        boolean $i$f$mapNotNull = false;
        Map<String, BookMetadataUpdateDto> map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Book book = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (book.hasNext()) {
            Book book2;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = book.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            String bookId = (String)entry.getKey();
            BookMetadataUpdateDto newMetadata = (BookMetadataUpdateDto)entry.getValue();
            if (this.bookMetadataRepository.findByIdOrNull(bookId) != null) {
                BookMetadata existing;
                boolean bl3 = false;
                BookMetadata updated = BookMetadataUpdateDtoKt.patch((BookMetadata)existing, (BookMetadataUpdateDto)newMetadata);
                this.bookMetadataRepository.update(updated);
                book2 = this.bookRepository.findByIdOrNull(bookId);
            } else {
                book2 = null;
            }
            if (book2 == null) continue;
            Book it$iv$iv = book2;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List updatedBooks = (List)destination$iv$iv;
        Iterable $this$forEach$iv = updatedBooks;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Book it = (Book)element$iv;
            boolean bl = false;
            this.eventPublisher.publishEvent((Object)new DomainEvent.BookUpdated(it));
        }
        Iterable $this$map$iv = updatedBooks;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            book = (Book)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSeriesId());
        }
        $this$forEach$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            TaskEmitter.aggregateSeriesMetadata$default((TaskEmitter)this.taskEmitter, (String)it, (int)0, (int)2, null);
        }
    }

    @Operation(description="Mark book as read and/or change page progress")
    @PatchMapping(value={"api/v1/books/{bookId}/read-progress"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void markReadProgress(@PathVariable @NotNull String bookId, @Parameter(description="page can be omitted if completed is set to true. completed can be omitted, and will be set accordingly depending on the page passed and the total number of pages in the book.") @Valid @RequestBody @NotNull ReadProgressUpdateDto readProgress, @AuthenticationPrincipal @NotNull KomgaPrincipal principal) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        Intrinsics.checkNotNullParameter((Object)readProgress, (String)"readProgress");
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Book book = this.bookRepository.findByIdOrNull(bookId);
        if (book != null) {
            Book book2 = book;
            boolean bl = false;
            this.contentRestrictionChecker.checkContentRestriction(principal.getUser(), book2);
            try {
                if (readProgress.getCompleted() != null && readProgress.getCompleted().booleanValue()) {
                    this.bookLifecycle.markReadProgressCompleted(book2.getId(), principal.getUser());
                } else {
                    KomgaUser komgaUser = principal.getUser();
                    Integer n = readProgress.getPage();
                    Intrinsics.checkNotNull((Object)n);
                    this.bookLifecycle.markReadProgress(book2, komgaUser, n.intValue());
                }
            }
            catch (IllegalArgumentException e) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getMessage());
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @Operation(description="Mark book as unread")
    @DeleteMapping(value={"api/v1/books/{bookId}/read-progress"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReadProgress(@PathVariable @NotNull String bookId, @AuthenticationPrincipal @NotNull KomgaPrincipal principal) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Book book = this.bookRepository.findByIdOrNull(bookId);
        if (book != null) {
            Book book2 = book;
            boolean bl = false;
            this.contentRestrictionChecker.checkContentRestriction(principal.getUser(), book2);
            this.bookLifecycle.deleteReadProgress(book2, principal.getUser());
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @PostMapping(value={"api/v1/books/import"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void importBooks(@RequestBody @NotNull BookImportBatchDto bookImportBatch) {
        Intrinsics.checkNotNullParameter((Object)bookImportBatch, (String)"bookImportBatch");
        Iterable $this$forEach$iv = bookImportBatch.getBooks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BookImportDto it = (BookImportDto)element$iv;
            boolean bl = false;
            try {
                this.taskEmitter.importBook(it.getSourceFile(), it.getSeriesId(), bookImportBatch.getCopyMode(), it.getDestinationName(), it.getUpgradeBookId(), 8);
            }
            catch (Exception e) {
                BookControllerKt.access$getLogger$p().error((Throwable)e, (Function0)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
    }

    @DeleteMapping(value={"api/v1/books/{bookId}/file"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void deleteBook(@PathVariable @NotNull String bookId) {
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        this.taskEmitter.deleteBook(bookId, 8);
    }

    @PutMapping(value={"api/v1/books/thumbnails"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void regenerateThumbnails(@RequestParam(name="for_bigger_result_only", required=false) boolean forBiggerResultOnly) {
        this.taskEmitter.findBookThumbnailsToRegenerate(forBiggerResultOnly, 0);
    }

    public static /* synthetic */ void regenerateThumbnails$default(BookController bookController, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: regenerateThumbnails");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        bookController.regenerateThumbnails(bl);
    }

    private static final BookDto getAllBooks$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (BookDto)$tmp0.invoke(p0);
    }

    private static final BookDto getLatestBooks$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (BookDto)$tmp0.invoke(p0);
    }

    private static final BookDto getBooksOnDeck$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (BookDto)$tmp0.invoke(p0);
    }
}

