/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.api.rest;

import io.swagger.v3.oas.annotations.Parameter;
import jakarta.validation.Valid;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gotson.komga.application.tasks.TaskEmitter;
import org.gotson.komga.domain.model.DirectoryNotFoundException;
import org.gotson.komga.domain.model.DuplicateNameException;
import org.gotson.komga.domain.model.Library;
import org.gotson.komga.domain.model.PathContainedInPath;
import org.gotson.komga.domain.model.SearchCondition;
import org.gotson.komga.domain.model.SearchContext;
import org.gotson.komga.domain.model.SearchOperator;
import org.gotson.komga.domain.persistence.BookRepository;
import org.gotson.komga.domain.persistence.LibraryRepository;
import org.gotson.komga.domain.persistence.SeriesRepository;
import org.gotson.komga.domain.service.LibraryLifecycle;
import org.gotson.komga.infrastructure.security.KomgaPrincipal;
import org.gotson.komga.infrastructure.web.UtilsKt;
import org.gotson.komga.interfaces.api.rest.LibraryController$getAll$;
import org.gotson.komga.interfaces.api.rest.dto.LibraryCreationDto;
import org.gotson.komga.interfaces.api.rest.dto.LibraryDto;
import org.gotson.komga.interfaces.api.rest.dto.LibraryDtoKt;
import org.gotson.komga.interfaces.api.rest.dto.LibraryUpdateDto;
import org.gotson.komga.interfaces.api.rest.dto.ScanIntervalDto;
import org.gotson.komga.interfaces.api.rest.dto.ScanIntervalDtoKt;
import org.gotson.komga.interfaces.api.rest.dto.SeriesCoverDto;
import org.gotson.komga.interfaces.api.rest.dto.SeriesCoverDtoKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"api/v1/libraries"}, produces={"application/json"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001c\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0017J\u0012\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0017J\u0012\u0010\u0017\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0017J\u0012\u0010\u0018\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0017J\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001a2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0017J\u001c\u0010\u001b\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0017J\u001c\u0010\u001c\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\u0011\u001a\u00020\u001dH\u0017J\u0012\u0010\u001e\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0017J\u001c\u0010\u001f\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u00162\b\b\u0003\u0010 \u001a\u00020!H\u0017J\u001c\u0010\"\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\u0011\u001a\u00020\u001dH\u0017R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/gotson/komga/interfaces/api/rest/LibraryController;", "", "taskEmitter", "Lorg/gotson/komga/application/tasks/TaskEmitter;", "libraryLifecycle", "Lorg/gotson/komga/domain/service/LibraryLifecycle;", "libraryRepository", "Lorg/gotson/komga/domain/persistence/LibraryRepository;", "bookRepository", "Lorg/gotson/komga/domain/persistence/BookRepository;", "seriesRepository", "Lorg/gotson/komga/domain/persistence/SeriesRepository;", "(Lorg/gotson/komga/application/tasks/TaskEmitter;Lorg/gotson/komga/domain/service/LibraryLifecycle;Lorg/gotson/komga/domain/persistence/LibraryRepository;Lorg/gotson/komga/domain/persistence/BookRepository;Lorg/gotson/komga/domain/persistence/SeriesRepository;)V", "addOne", "Lorg/gotson/komga/interfaces/api/rest/dto/LibraryDto;", "principal", "Lorg/gotson/komga/infrastructure/security/KomgaPrincipal;", "library", "Lorg/gotson/komga/interfaces/api/rest/dto/LibraryCreationDto;", "analyze", "", "libraryId", "", "deleteOne", "emptyTrash", "getAll", "", "getOne", "patchOne", "Lorg/gotson/komga/interfaces/api/rest/dto/LibraryUpdateDto;", "refreshMetadata", "scan", "deep", "", "updateOne", "komga"})
@SourceDebugExtension(value={"SMAP\nLibraryController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryController.kt\norg/gotson/komga/interfaces/api/rest/LibraryController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,269:1\n1045#2:270\n1549#2:271\n1620#2,3:272\n1#3:275\n*S KotlinDebug\n*F\n+ 1 LibraryController.kt\norg/gotson/komga/interfaces/api/rest/LibraryController\n*L\n63#1:270\n63#1:271\n63#1:272,3\n*E\n"})
public class LibraryController {
    @NotNull
    private final TaskEmitter taskEmitter;
    @NotNull
    private final LibraryLifecycle libraryLifecycle;
    @NotNull
    private final LibraryRepository libraryRepository;
    @NotNull
    private final BookRepository bookRepository;
    @NotNull
    private final SeriesRepository seriesRepository;

    public LibraryController(@NotNull TaskEmitter taskEmitter, @NotNull LibraryLifecycle libraryLifecycle, @NotNull LibraryRepository libraryRepository, @NotNull BookRepository bookRepository, @NotNull SeriesRepository seriesRepository) {
        Intrinsics.checkNotNullParameter((Object)taskEmitter, (String)"taskEmitter");
        Intrinsics.checkNotNullParameter((Object)libraryLifecycle, (String)"libraryLifecycle");
        Intrinsics.checkNotNullParameter((Object)libraryRepository, (String)"libraryRepository");
        Intrinsics.checkNotNullParameter((Object)bookRepository, (String)"bookRepository");
        Intrinsics.checkNotNullParameter((Object)seriesRepository, (String)"seriesRepository");
        this.taskEmitter = taskEmitter;
        this.libraryLifecycle = libraryLifecycle;
        this.libraryRepository = libraryRepository;
        this.bookRepository = bookRepository;
        this.seriesRepository = seriesRepository;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping
    @NotNull
    public List<LibraryDto> getAll(@AuthenticationPrincipal @NotNull KomgaPrincipal principal) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Iterable $this$sortedBy$iv = principal.getUser().canAccessAllLibraries() ? this.libraryRepository.findAll() : this.libraryRepository.findAllByIds((Collection)principal.getUser().getSharedLibrariesIds());
        boolean $i$f$sortedBy = false;
        Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new getAll$$inlined$sortedBy$1()));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Library library = (Library)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(LibraryDtoKt.toDto((Library)it, (boolean)principal.getUser().getRoleAdmin()));
        }
        return (List)destination$iv$iv;
    }

    @GetMapping(value={"{libraryId}"})
    @NotNull
    public LibraryDto getOne(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String libraryId) {
        Library library;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
                Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
                library = this.libraryRepository.findByIdOrNull(libraryId);
                if (library == null) break block4;
                Library it = library;
                boolean bl = false;
                if (!principal.getUser().canAccessLibrary(it)) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
                }
                LibraryDto libraryDto = LibraryDtoKt.toDto((Library)it, (boolean)principal.getUser().getRoleAdmin());
                library = libraryDto;
                if (libraryDto != null) break block5;
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return library;
    }

    @PostMapping
    @PreAuthorize(value="hasRole('ADMIN')")
    @NotNull
    public LibraryDto addOne(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @Valid @RequestBody @NotNull LibraryCreationDto library) {
        String string;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        try {
            String string2;
            LibraryLifecycle libraryLifecycle = this.libraryLifecycle;
            string = library.getName();
            URL uRL = UtilsKt.filePathToUrl((String)library.getRoot());
            boolean bl = library.getImportComicInfoBook();
            boolean bl2 = library.getImportComicInfoSeries();
            boolean bl3 = library.getImportComicInfoCollection();
            boolean bl4 = library.getImportComicInfoReadList();
            boolean bl5 = library.getImportComicInfoSeriesAppendVolume();
            boolean bl6 = library.getImportEpubBook();
            boolean bl7 = library.getImportEpubSeries();
            boolean bl8 = library.getImportMylarSeries();
            boolean bl9 = library.getImportLocalArtwork();
            boolean bl10 = library.getImportBarcodeIsbn();
            boolean bl11 = library.getScanForceModifiedTime();
            Library.ScanInterval scanInterval = ScanIntervalDtoKt.toDomain((ScanIntervalDto)library.getScanInterval());
            boolean bl12 = library.getScanOnStartup();
            boolean bl13 = library.getScanCbx();
            boolean bl14 = library.getScanPdf();
            boolean bl15 = library.getScanEpub();
            Set set = library.getScanDirectoryExclusions();
            boolean bl16 = library.getRepairExtensions();
            boolean bl17 = library.getConvertToCbz();
            boolean bl18 = library.getEmptyTrashAfterScan();
            Library.SeriesCover seriesCover = SeriesCoverDtoKt.toDomain((SeriesCoverDto)library.getSeriesCover());
            boolean bl19 = library.getHashFiles();
            boolean bl20 = library.getHashPages();
            boolean bl21 = library.getAnalyzeDimensions();
            String string3 = library.getOneshotsDirectory();
            if (string3 != null) {
                CharSequence charSequence;
                CharSequence charSequence2 = string3;
                if (StringsKt.isBlank((CharSequence)charSequence2)) {
                    LibraryLifecycle libraryLifecycle2 = libraryLifecycle;
                    boolean bl22 = false;
                    charSequence = null;
                    libraryLifecycle = libraryLifecycle2;
                } else {
                    charSequence = charSequence2;
                }
                string2 = (String)charSequence;
            } else {
                string2 = null;
            }
            String string4 = string2;
            string = LibraryDtoKt.toDto((Library)libraryLifecycle.addLibrary(new Library(string, uRL, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9, bl10, bl11, bl12, scanInterval, bl13, bl14, bl15, set, bl16, bl17, bl18, seriesCover, bl19, bl20, bl21, string4, null, null, null, null, 0x78000000, null)), (boolean)principal.getUser().getRoleAdmin());
        }
        catch (Exception e) {
            Exception exception = e;
            if (((exception instanceof FileNotFoundException ? true : exception instanceof DirectoryNotFoundException) ? true : exception instanceof DuplicateNameException) ? true : exception instanceof PathContainedInPath) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getMessage());
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return string;
    }

    @PutMapping(value={"/{libraryId}"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Deprecated(message="Use PATCH /v1/library instead", replaceWith=@ReplaceWith(expression="patchOne", imports={}))
    public void updateOne(@PathVariable @NotNull String libraryId, @Valid @RequestBody @NotNull LibraryUpdateDto library) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        this.patchOne(libraryId, library);
    }

    @PatchMapping(value={"/{libraryId}"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void patchOne(@PathVariable @NotNull String libraryId, @Parameter(description="Fields to update. You can omit fields you don't want to update.") @Valid @RequestBody @NotNull LibraryUpdateDto library) {
        Unit unit;
        block23: {
            block20: {
                String string;
                boolean bl;
                Set set;
                boolean bl2;
                Object object;
                String string2;
                LibraryUpdateDto $this$patchOne_u24lambda_u247_u24lambda_u246;
                Library existing;
                block22: {
                    block21: {
                        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
                        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
                        Library library2 = this.libraryRepository.findByIdOrNull(libraryId);
                        if (library2 == null) break block20;
                        existing = library2;
                        boolean bl3 = false;
                        $this$patchOne_u24lambda_u247_u24lambda_u246 = library;
                        boolean bl4 = false;
                        String string3 = $this$patchOne_u24lambda_u247_u24lambda_u246.getName();
                        if (string3 == null) {
                            string3 = string2 = existing.getName();
                        }
                        if ((object = $this$patchOne_u24lambda_u247_u24lambda_u246.getRoot()) == null) break block21;
                        String it = object;
                        boolean bl5 = false;
                        String string4 = $this$patchOne_u24lambda_u247_u24lambda_u246.getRoot();
                        Intrinsics.checkNotNull((Object)string4);
                        URL uRL = UtilsKt.filePathToUrl((String)string4);
                        object = uRL;
                        if (uRL != null) break block22;
                    }
                    object = existing.getRoot();
                }
                Object object2 = object;
                Boolean bl6 = $this$patchOne_u24lambda_u247_u24lambda_u246.getImportComicInfoBook();
                boolean bl7 = bl6 != null ? bl6.booleanValue() : existing.getImportComicInfoBook();
                Boolean bl8 = $this$patchOne_u24lambda_u247_u24lambda_u246.getImportComicInfoSeries();
                boolean bl9 = bl8 != null ? bl8.booleanValue() : existing.getImportComicInfoSeries();
                Boolean bl10 = $this$patchOne_u24lambda_u247_u24lambda_u246.getImportComicInfoCollection();
                boolean bl11 = bl10 != null ? bl10.booleanValue() : existing.getImportComicInfoCollection();
                Boolean bl12 = $this$patchOne_u24lambda_u247_u24lambda_u246.getImportComicInfoReadList();
                boolean bl13 = bl12 != null ? bl12.booleanValue() : existing.getImportComicInfoReadList();
                Boolean bl14 = $this$patchOne_u24lambda_u247_u24lambda_u246.getImportComicInfoSeriesAppendVolume();
                boolean bl15 = bl14 != null ? bl14.booleanValue() : existing.getImportComicInfoSeriesAppendVolume();
                Boolean bl16 = $this$patchOne_u24lambda_u247_u24lambda_u246.getImportEpubBook();
                boolean bl17 = bl16 != null ? bl16.booleanValue() : existing.getImportEpubBook();
                Boolean bl18 = $this$patchOne_u24lambda_u247_u24lambda_u246.getImportEpubSeries();
                boolean bl19 = bl18 != null ? bl18.booleanValue() : existing.getImportEpubSeries();
                Boolean bl20 = $this$patchOne_u24lambda_u247_u24lambda_u246.getImportMylarSeries();
                boolean bl21 = bl20 != null ? bl20.booleanValue() : existing.getImportMylarSeries();
                Boolean bl22 = $this$patchOne_u24lambda_u247_u24lambda_u246.getImportLocalArtwork();
                boolean bl23 = bl22 != null ? bl22.booleanValue() : existing.getImportLocalArtwork();
                Boolean bl24 = $this$patchOne_u24lambda_u247_u24lambda_u246.getImportBarcodeIsbn();
                boolean bl25 = bl24 != null ? bl24.booleanValue() : existing.getImportBarcodeIsbn();
                Boolean bl26 = $this$patchOne_u24lambda_u247_u24lambda_u246.getScanForceModifiedTime();
                boolean bl27 = bl26 != null ? bl26.booleanValue() : existing.getScanForceModifiedTime();
                ScanIntervalDto scanIntervalDto = $this$patchOne_u24lambda_u247_u24lambda_u246.getScanInterval();
                if (scanIntervalDto == null || (scanIntervalDto = ScanIntervalDtoKt.toDomain((ScanIntervalDto)scanIntervalDto)) == null) {
                    scanIntervalDto = existing.getScanInterval();
                }
                ScanIntervalDto scanIntervalDto2 = scanIntervalDto;
                Boolean bl28 = $this$patchOne_u24lambda_u247_u24lambda_u246.getScanOnStartup();
                boolean bl29 = bl28 != null ? bl28.booleanValue() : existing.getScanOnStartup();
                Boolean bl30 = $this$patchOne_u24lambda_u247_u24lambda_u246.getScanCbx();
                boolean bl31 = bl30 != null ? bl30.booleanValue() : existing.getScanCbx();
                Boolean bl32 = $this$patchOne_u24lambda_u247_u24lambda_u246.getScanPdf();
                boolean bl33 = bl32 != null ? bl32.booleanValue() : existing.getScanPdf();
                Boolean bl34 = $this$patchOne_u24lambda_u247_u24lambda_u246.getScanEpub();
                boolean bl35 = bl2 = bl34 != null ? bl34.booleanValue() : existing.getScanEpub();
                if ($this$patchOne_u24lambda_u247_u24lambda_u246.isSet("scanDirectoryExclusions")) {
                    set = $this$patchOne_u24lambda_u247_u24lambda_u246.getScanDirectoryExclusions();
                    if (set == null) {
                        set = SetsKt.emptySet();
                    }
                } else {
                    set = existing.getScanDirectoryExclusions();
                }
                Set set2 = set;
                Boolean bl36 = $this$patchOne_u24lambda_u247_u24lambda_u246.getRepairExtensions();
                boolean bl37 = bl36 != null ? bl36.booleanValue() : existing.getRepairExtensions();
                Boolean bl38 = $this$patchOne_u24lambda_u247_u24lambda_u246.getConvertToCbz();
                boolean bl39 = bl38 != null ? bl38.booleanValue() : existing.getConvertToCbz();
                Boolean bl40 = $this$patchOne_u24lambda_u247_u24lambda_u246.getEmptyTrashAfterScan();
                boolean bl41 = bl40 != null ? bl40.booleanValue() : existing.getEmptyTrashAfterScan();
                SeriesCoverDto seriesCoverDto = $this$patchOne_u24lambda_u247_u24lambda_u246.getSeriesCover();
                if (seriesCoverDto == null || (seriesCoverDto = SeriesCoverDtoKt.toDomain((SeriesCoverDto)seriesCoverDto)) == null) {
                    seriesCoverDto = existing.getSeriesCover();
                }
                SeriesCoverDto seriesCoverDto2 = seriesCoverDto;
                Boolean bl42 = $this$patchOne_u24lambda_u247_u24lambda_u246.getHashFiles();
                boolean bl43 = bl42 != null ? bl42.booleanValue() : existing.getHashFiles();
                Boolean bl44 = $this$patchOne_u24lambda_u247_u24lambda_u246.getHashPages();
                boolean bl45 = bl44 != null ? bl44.booleanValue() : existing.getHashPages();
                Boolean bl46 = $this$patchOne_u24lambda_u247_u24lambda_u246.getAnalyzeDimensions();
                boolean bl47 = bl = bl46 != null ? bl46.booleanValue() : existing.getAnalyzeDimensions();
                if ($this$patchOne_u24lambda_u247_u24lambda_u246.isSet("oneshotsDirectory")) {
                    String string5 = $this$patchOne_u24lambda_u247_u24lambda_u246.getOneshotsDirectory();
                    if (string5 != null) {
                        CharSequence charSequence;
                        CharSequence charSequence2 = string5;
                        if (StringsKt.isBlank((CharSequence)charSequence2)) {
                            boolean bl48 = false;
                            charSequence = null;
                        } else {
                            charSequence = charSequence2;
                        }
                        string = (String)charSequence;
                    } else {
                        string = null;
                    }
                } else {
                    string = existing.getOneshotsDirectory();
                }
                String string6 = string;
                Library toUpdate = Library.copy$default((Library)existing, (String)string2, (URL)object2, (boolean)bl7, (boolean)bl9, (boolean)bl11, (boolean)bl13, (boolean)bl15, (boolean)bl17, (boolean)bl19, (boolean)bl21, (boolean)bl23, (boolean)bl25, (boolean)bl27, (boolean)bl29, (Library.ScanInterval)scanIntervalDto2, (boolean)bl31, (boolean)bl33, (boolean)bl2, (Set)set2, (boolean)bl37, (boolean)bl39, (boolean)bl41, (Library.SeriesCover)seriesCoverDto2, (boolean)bl43, (boolean)bl45, (boolean)bl, (String)string6, null, (String)libraryId, null, null, (int)0x68000000, null);
                try {
                    this.libraryLifecycle.updateLibrary(toUpdate);
                }
                catch (Exception e) {
                    Exception exception = e;
                    if (((exception instanceof FileNotFoundException ? true : exception instanceof DirectoryNotFoundException) ? true : exception instanceof DuplicateNameException) ? true : exception instanceof PathContainedInPath) {
                        throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getMessage());
                    }
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
                unit = Unit.INSTANCE;
                break block23;
            }
            unit = null;
        }
        if (unit == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @DeleteMapping(value={"/{libraryId}"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteOne(@PathVariable @NotNull String libraryId) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        Library library = this.libraryRepository.findByIdOrNull(libraryId);
        if (library != null) {
            Library it = library;
            boolean bl = false;
            this.libraryLifecycle.deleteLibrary(it);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @PostMapping(value={"{libraryId}/scan"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void scan(@PathVariable @NotNull String libraryId, @RequestParam(required=false) boolean deep) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        Library library = this.libraryRepository.findByIdOrNull(libraryId);
        if (library != null) {
            Library library2 = library;
            boolean bl = false;
            this.taskEmitter.scanLibrary(library2.getId(), deep, 8);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    public static /* synthetic */ void scan$default(LibraryController libraryController, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: scan");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        libraryController.scan(string, bl);
    }

    @PostMapping(value={"{libraryId}/analyze"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void analyze(@PathVariable @NotNull String libraryId) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        SearchCondition.Book book = (SearchCondition.Book)new SearchCondition.LibraryId((SearchOperator.Equality)new SearchOperator.Is((Object)libraryId));
        SearchContext searchContext = SearchContext.Companion.empty();
        Pageable pageable = Pageable.unpaged();
        Intrinsics.checkNotNullExpressionValue((Object)pageable, (String)"unpaged(...)");
        List list = this.bookRepository.findAll(book, searchContext, pageable).getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
        List books = list;
        this.taskEmitter.analyzeBook((Collection)books, 6);
    }

    @PostMapping(value={"{libraryId}/metadata/refresh"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void refreshMetadata(@PathVariable @NotNull String libraryId) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        SearchCondition.Book book = (SearchCondition.Book)new SearchCondition.LibraryId((SearchOperator.Equality)new SearchOperator.Is((Object)libraryId));
        SearchContext searchContext = SearchContext.Companion.empty();
        Pageable pageable = Pageable.unpaged();
        Intrinsics.checkNotNullExpressionValue((Object)pageable, (String)"unpaged(...)");
        List list = this.bookRepository.findAll(book, searchContext, pageable).getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
        List books = list;
        TaskEmitter.refreshBookMetadata$default((TaskEmitter)this.taskEmitter, (Collection)books, null, (int)6, (int)2, null);
        this.taskEmitter.refreshBookLocalArtwork((Collection)books, 6);
        this.taskEmitter.refreshSeriesLocalArtwork(this.seriesRepository.findAllIdsByLibraryId(libraryId), 6);
    }

    @PostMapping(value={"{libraryId}/empty-trash"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void emptyTrash(@PathVariable @NotNull String libraryId) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        Library library = this.libraryRepository.findByIdOrNull(libraryId);
        if (library != null) {
            Library library2 = library;
            boolean bl = false;
            this.taskEmitter.emptyTrash(library2.getId(), 6);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }
}

