/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.api.rest;

import java.net.URL;
import java.nio.file.NoSuchFileException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.domain.model.BookPage;
import org.gotson.komga.domain.model.CodedException;
import org.gotson.komga.domain.model.Dimension;
import org.gotson.komga.domain.model.MediaFile;
import org.gotson.komga.domain.model.MediaNotReadyException;
import org.gotson.komga.domain.model.MediaProfile;
import org.gotson.komga.domain.model.TransientBook;
import org.gotson.komga.domain.model.TypedBytes;
import org.gotson.komga.domain.persistence.TransientBookRepository;
import org.gotson.komga.domain.service.BookAnalyzer;
import org.gotson.komga.domain.service.TransientBookLifecycle;
import org.gotson.komga.infrastructure.web.UtilsKt;
import org.gotson.komga.interfaces.api.rest.ScanRequestDto;
import org.gotson.komga.interfaces.api.rest.TransientBookDto;
import org.gotson.komga.interfaces.api.rest.TransientBooksController;
import org.gotson.komga.interfaces.api.rest.TransientBooksControllerKt;
import org.gotson.komga.interfaces.api.rest.dto.PageDto;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"api/v1/transient-books"}, produces={"application/json"})
@PreAuthorize(value="hasRole('ADMIN')")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0017J\"\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\b\u0001\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017J\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0017J\f\u0010\u0016\u001a\u00020\n*\u00020\u0017H\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/gotson/komga/interfaces/api/rest/TransientBooksController;", "", "transientBookLifecycle", "Lorg/gotson/komga/domain/service/TransientBookLifecycle;", "transientBookRepository", "Lorg/gotson/komga/domain/persistence/TransientBookRepository;", "bookAnalyzer", "Lorg/gotson/komga/domain/service/BookAnalyzer;", "(Lorg/gotson/komga/domain/service/TransientBookLifecycle;Lorg/gotson/komga/domain/persistence/TransientBookRepository;Lorg/gotson/komga/domain/service/BookAnalyzer;)V", "analyze", "Lorg/gotson/komga/interfaces/api/rest/TransientBookDto;", "id", "", "getSourcePage", "Lorg/springframework/http/ResponseEntity;", "", "pageNumber", "", "scanForTransientBooks", "", "request", "Lorg/gotson/komga/interfaces/api/rest/ScanRequestDto;", "toDto", "Lorg/gotson/komga/domain/model/TransientBook;", "komga"})
@SourceDebugExtension(value={"SMAP\nTransientBooksController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransientBooksController.kt\norg/gotson/komga/interfaces/api/rest/TransientBooksController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n1045#2:136\n1549#2:137\n1620#2,3:138\n1559#2:141\n1590#2,4:142\n1549#2:146\n1620#2,3:147\n*S KotlinDebug\n*F\n+ 1 TransientBooksController.kt\norg/gotson/komga/interfaces/api/rest/TransientBooksController\n*L\n47#1:136\n48#1:137\n48#1:138,3\n98#1:141\n98#1:142,4\n108#1:146\n108#1:147,3\n*E\n"})
public class TransientBooksController {
    @NotNull
    private final TransientBookLifecycle transientBookLifecycle;
    @NotNull
    private final TransientBookRepository transientBookRepository;
    @NotNull
    private final BookAnalyzer bookAnalyzer;

    public TransientBooksController(@NotNull TransientBookLifecycle transientBookLifecycle, @NotNull TransientBookRepository transientBookRepository, @NotNull BookAnalyzer bookAnalyzer) {
        Intrinsics.checkNotNullParameter((Object)transientBookLifecycle, (String)"transientBookLifecycle");
        Intrinsics.checkNotNullParameter((Object)transientBookRepository, (String)"transientBookRepository");
        Intrinsics.checkNotNullParameter((Object)bookAnalyzer, (String)"bookAnalyzer");
        this.transientBookLifecycle = transientBookLifecycle;
        this.transientBookRepository = transientBookRepository;
        this.bookAnalyzer = bookAnalyzer;
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping
    @NotNull
    public List<TransientBookDto> scanForTransientBooks(@RequestBody @NotNull ScanRequestDto request) {
        List list;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            void $this$mapTo$iv$iv;
            Iterable $this$sortedBy$iv = this.transientBookLifecycle.scanAndPersist(request.getPath());
            boolean $i$f$sortedBy = false;
            Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new /* Unavailable Anonymous Inner Class!! */));
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TransientBook transientBook = (TransientBook)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.toDto((TransientBook)it));
            }
            list = (List)destination$iv$iv;
        }
        catch (CodedException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getCode());
        }
        return list;
    }

    @PostMapping(value={"{id}/analyze"})
    @NotNull
    public TransientBookDto analyze(@PathVariable @NotNull String id) {
        TransientBook transientBook;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                transientBook = this.transientBookRepository.findByIdOrNull(id);
                if (transientBook == null) break block2;
                TransientBook it = transientBook;
                boolean bl = false;
                TransientBookDto transientBookDto = this.toDto(this.transientBookLifecycle.analyzeAndPersist(it));
                transientBook = transientBookDto;
                if (transientBookDto != null) break block3;
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return transientBook;
    }

    @GetMapping(value={"{id}/pages/{pageNumber}"}, produces={"*/*"})
    @NotNull
    public ResponseEntity<byte[]> getSourcePage(@PathVariable @NotNull String id, @PathVariable int pageNumber) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        TransientBook transientBook = this.transientBookRepository.findByIdOrNull(id);
        if (transientBook != null) {
            ResponseEntity responseEntity2;
            TransientBook it = transientBook;
            boolean bl = false;
            try {
                TypedBytes pageContent = this.transientBookLifecycle.getBookPage(it, pageNumber);
                responseEntity2 = ResponseEntity.ok().contentType(UtilsKt.getMediaTypeOrDefault((String)pageContent.getMediaType())).body((Object)pageContent.getBytes());
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Page number does not exist");
            }
            catch (MediaNotReadyException ex) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Book analysis failed");
            }
            catch (NoSuchFileException ex) {
                TransientBooksControllerKt.access$getLogger$p().warn((Throwable)ex, (Function0)getSourcePage.1.1.INSTANCE);
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "File not found, it may have moved");
            }
            v1 = responseEntity2;
        } else {
            v1 = responseEntity = null;
        }
        if (responseEntity == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return responseEntity;
    }

    /*
     * WARNING - void declaration
     */
    private TransientBookDto toDto(TransientBook $this$toDto) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection<PageDto> collection2;
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv;
        List pages = $this$toDto.getMedia().getProfile() == MediaProfile.PDF ? this.bookAnalyzer.getPdfPagesDynamic($this$toDto.getMedia()) : $this$toDto.getMedia().getPages();
        String string = $this$toDto.getBook().getId();
        String string2 = $this$toDto.getBook().getName();
        String string3 = UtilsKt.toFilePath((URL)$this$toDto.getBook().getUrl());
        LocalDateTime localDateTime = $this$toDto.getBook().getFileLastModified();
        long l = $this$toDto.getBook().getFileSize();
        String string4 = $this$toDto.getMedia().getStatus().toString();
        String string5 = $this$toDto.getMedia().getMediaType();
        if (string5 == null) {
            string5 = "";
        }
        Iterable iterable = pages;
        String string6 = string5;
        String string7 = string4;
        String string8 = null;
        long l2 = l;
        LocalDateTime localDateTime2 = localDateTime;
        String string9 = string3;
        String string10 = string2;
        String string11 = string;
        boolean $i$f$mapIndexed = false;
        void var5_13 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
            void index;
            void bookPage;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            BookPage bookPage2 = (BookPage)item$iv$iv2;
            int n2 = n;
            collection2 = destination$iv$iv;
            boolean bl = false;
            Dimension dimension = bookPage.getDimension();
            Dimension dimension2 = bookPage.getDimension();
            collection2.add(new PageDto((int)(index + true), bookPage.getFileName(), bookPage.getMediaType(), dimension != null ? Integer.valueOf(dimension.getWidth()) : null, dimension2 != null ? Integer.valueOf(dimension2.getHeight()) : null, bookPage.getFileSize(), null, 64, null));
        }
        collection2 = (List)destination$iv$iv;
        $this$mapIndexed$iv = $this$toDto.getMedia().getFiles();
        boolean $i$f$map = false;
        $this$mapIndexedTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object item$iv$iv2;
            item$iv$iv2 = (MediaFile)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFileName());
        }
        collection = (List)destination$iv$iv;
        String string12 = $this$toDto.getMedia().getComment();
        if (string12 == null) {
            string12 = "";
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 32;
        String string13 = $this$toDto.getMetadata().getSeriesId();
        Float f = $this$toDto.getMetadata().getNumber();
        String string14 = string12;
        Collection<String> collection3 = collection;
        Collection<PageDto> collection4 = collection2;
        String string15 = string6;
        String string16 = string7;
        String string17 = string8;
        long l3 = l2;
        LocalDateTime localDateTime3 = localDateTime2;
        String string18 = string9;
        String string19 = string10;
        String string20 = string11;
        return new TransientBookDto(string20, string19, string18, localDateTime3, l3, string17, string16, string15, collection4, collection3, string14, f, string13, n, defaultConstructorMarker);
    }
}

