/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.application.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.application.tasks.Task;
import org.gotson.komga.application.tasks.TaskAddedEvent;
import org.gotson.komga.application.tasks.TaskEmitterKt;
import org.gotson.komga.application.tasks.TasksRepository;
import org.gotson.komga.domain.model.Book;
import org.gotson.komga.domain.model.BookMetadataPatchCapability;
import org.gotson.komga.domain.model.BookPageNumbered;
import org.gotson.komga.domain.model.CopyMode;
import org.gotson.komga.domain.model.Library;
import org.gotson.komga.domain.model.Media;
import org.gotson.komga.domain.model.SearchCondition;
import org.gotson.komga.domain.model.SearchContext;
import org.gotson.komga.domain.model.SearchOperator;
import org.gotson.komga.domain.persistence.BookRepository;
import org.gotson.komga.domain.service.BookConverter;
import org.gotson.komga.infrastructure.jooq.UnpagedSorted;
import org.gotson.komga.infrastructure.search.LuceneEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00142\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\u0019\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u001c\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020!2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\"\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010#\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010$\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010%\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010%\u001a\u00020\f2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010'\u001a\u00020\f2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010)\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010*\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J>\u0010+\u001a\u00020\f2\u0006\u0010,\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u00010\u000e2\b\u00100\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0016J$\u00101\u001a\u00020\f2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\u0010\b\u0002\u00102\u001a\n\u0012\u0004\u0012\u000204\u0018\u000103H\u0016J \u00105\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u00105\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00142\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0016J0\u00106\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u000e\b\u0002\u00107\u001a\b\u0012\u0004\u0012\u000208032\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0016J*\u00106\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00142\u000e\b\u0002\u00107\u001a\b\u0012\u0004\u0012\u000208032\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u00109\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0016J \u00109\u001a\u00020\f2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010;\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010<\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u000e2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020>0\u00132\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0016J,\u0010<\u001a\u00020\f2\u0018\u0010?\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020>0\u00130@2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010A\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0016J$\u0010B\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u000e2\b\b\u0002\u0010C\u001a\u00020!2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010D\u001a\u00020\f2\u0006\u0010E\u001a\u00020FH\u0012J\u0016\u0010G\u001a\u00020\f2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020F0\u0013H\u0012J\u0012\u0010I\u001a\u00020\f2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lorg/gotson/komga/application/tasks/TaskEmitter;", "", "bookRepository", "Lorg/gotson/komga/domain/persistence/BookRepository;", "bookConverter", "Lorg/gotson/komga/domain/service/BookConverter;", "tasksRepository", "Lorg/gotson/komga/application/tasks/TasksRepository;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "(Lorg/gotson/komga/domain/persistence/BookRepository;Lorg/gotson/komga/domain/service/BookConverter;Lorg/gotson/komga/application/tasks/TasksRepository;Lorg/springframework/context/ApplicationEventPublisher;)V", "aggregateSeriesMetadata", "", "seriesId", "", "priority", "", "analyzeBook", "books", "", "Lorg/gotson/komga/domain/model/Book;", "book", "analyzeUnknownAndOutdatedBooks", "library", "Lorg/gotson/komga/domain/model/Library;", "convertBookToCbz", "deleteBook", "bookId", "deleteSeries", "emptyTrash", "libraryId", "findBookThumbnailsToRegenerate", "forBiggerResultOnly", "", "findBooksToConvert", "findBooksWithMissingPageHash", "findDuplicatePagesToDelete", "generateBookThumbnail", "bookIds", "hashBookPages", "bookIdToSeriesId", "hashBooksWithoutHash", "hashBooksWithoutHashKoreader", "importBook", "sourceFile", "copyMode", "Lorg/gotson/komga/domain/model/CopyMode;", "destinationName", "upgradeBookId", "rebuildIndex", "entities", "", "Lorg/gotson/komga/infrastructure/search/LuceneEntity;", "refreshBookLocalArtwork", "refreshBookMetadata", "capabilities", "Lorg/gotson/komga/domain/model/BookMetadataPatchCapability;", "refreshSeriesLocalArtwork", "seriesIds", "refreshSeriesMetadata", "removeDuplicatePages", "pages", "Lorg/gotson/komga/domain/model/BookPageNumbered;", "bookIdToPages", "", "repairExtensions", "scanLibrary", "scanDeep", "submitTask", "task", "Lorg/gotson/komga/application/tasks/Task;", "submitTasks", "tasks", "upgradeIndex", "komga"})
@SourceDebugExtension(value={"SMAP\nTaskEmitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskEmitter.kt\norg/gotson/komga/application/tasks/TaskEmitter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,296:1\n1549#2:297\n1620#2,3:298\n1549#2:302\n1620#2,3:303\n1549#2:306\n1620#2,3:307\n1549#2:310\n1620#2,3:311\n1549#2:314\n1620#2,3:315\n1549#2:318\n1620#2,3:319\n1549#2:326\n1620#2,3:327\n1549#2:330\n1620#2,3:331\n1549#2:334\n1620#2,3:335\n1549#2:338\n1620#2,3:339\n1549#2:342\n1620#2,3:343\n1#3:301\n125#4:322\n152#4,3:323\n*S KotlinDebug\n*F\n+ 1 TaskEmitter.kt\norg/gotson/komga/application/tasks/TaskEmitter\n*L\n58#1:297\n58#1:298,3\n66#1:302\n66#1:303,3\n74#1:306\n74#1:307,3\n90#1:310\n90#1:311,3\n106#1:314\n106#1:315,3\n117#1:318\n117#1:319,3\n157#1:326\n157#1:327,3\n173#1:330\n173#1:331,3\n191#1:334\n191#1:335,3\n221#1:338\n221#1:339,3\n237#1:342\n237#1:343,3\n141#1:322\n141#1:323,3\n*E\n"})
public class TaskEmitter {
    @NotNull
    private final BookRepository bookRepository;
    @NotNull
    private final BookConverter bookConverter;
    @NotNull
    private final TasksRepository tasksRepository;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;

    public TaskEmitter(@NotNull BookRepository bookRepository, @NotNull BookConverter bookConverter, @NotNull TasksRepository tasksRepository, @NotNull ApplicationEventPublisher eventPublisher) {
        Intrinsics.checkNotNullParameter((Object)bookRepository, (String)"bookRepository");
        Intrinsics.checkNotNullParameter((Object)bookConverter, (String)"bookConverter");
        Intrinsics.checkNotNullParameter((Object)tasksRepository, (String)"tasksRepository");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        this.bookRepository = bookRepository;
        this.bookConverter = bookConverter;
        this.tasksRepository = tasksRepository;
        this.eventPublisher = eventPublisher;
    }

    public void scanLibrary(@NotNull String libraryId, boolean scanDeep, int priority) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        this.submitTask((Task)new Task.ScanLibrary(libraryId, scanDeep, priority));
    }

    public static /* synthetic */ void scanLibrary$default(TaskEmitter taskEmitter, String string, boolean bl, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: scanLibrary");
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            n = 4;
        }
        taskEmitter.scanLibrary(string, bl, n);
    }

    public void emptyTrash(@NotNull String libraryId, int priority) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        this.submitTask((Task)new Task.EmptyTrash(libraryId, priority));
    }

    public static /* synthetic */ void emptyTrash$default(TaskEmitter taskEmitter, String string, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: emptyTrash");
        }
        if ((n2 & 2) != 0) {
            n = 4;
        }
        taskEmitter.emptyTrash(string, n);
    }

    /*
     * WARNING - void declaration
     */
    public void analyzeUnknownAndOutdatedBooks(@NotNull Library library) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        SearchCondition.Book[] bookArray = new SearchCondition.Book[2];
        bookArray[0] = new SearchCondition.LibraryId((SearchOperator.Equality)new SearchOperator.Is((Object)library.getId()));
        Object object = new SearchCondition.Book[]{new SearchCondition.MediaStatus((SearchOperator.Equality)new SearchOperator.Is((Object)Media.Status.UNKNOWN)), new SearchCondition.MediaStatus((SearchOperator.Equality)new SearchOperator.Is((Object)Media.Status.OUTDATED))};
        bookArray[1] = new SearchCondition.AnyOfBook(object);
        SearchCondition.Book book = (SearchCondition.Book)new SearchCondition.AllOfBook(bookArray);
        SearchContext searchContext = SearchContext.Companion.empty();
        object = new Sort.Order[]{Sort.Order.asc((String)"seriesId"), Sort.Order.asc((String)"number")};
        Sort sort = Sort.by((Sort.Order[])object);
        Intrinsics.checkNotNullExpressionValue((Object)sort, (String)"by(...)");
        List list = this.bookRepository.findAll(book, searchContext, (Pageable)new UnpagedSorted(sort)).getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Book book2 = (Book)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Task.AnalyzeBook(it.getId(), 0, it.getSeriesId(), 2, null));
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        this.submitTasks((Collection)it);
    }

    /*
     * WARNING - void declaration
     */
    public void hashBooksWithoutHash(@NotNull Library library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        if (library.getHashFiles()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.bookRepository.findAllByLibraryIdAndWithEmptyHash(library.getId());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Book book = (Book)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Task.HashBook(it.getId(), 0));
            }
            List it = (List)destination$iv$iv;
            boolean bl = false;
            this.submitTasks((Collection)it);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void hashBooksWithoutHashKoreader(@NotNull Library library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        if (library.getHashKoreader()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.bookRepository.findAllByLibraryIdAndWithEmptyHashKoreader(library.getId());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Book book = (Book)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Task.HashBookKoreader(it.getId(), 0));
            }
            List it = (List)destination$iv$iv;
            boolean bl = false;
            this.submitTasks((Collection)it);
        }
    }

    public void findBooksWithMissingPageHash(@NotNull Library library, int priority) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        this.submitTask((Task)new Task.FindBooksWithMissingPageHash(library.getId(), priority));
    }

    public static /* synthetic */ void findBooksWithMissingPageHash$default(TaskEmitter taskEmitter, Library library, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findBooksWithMissingPageHash");
        }
        if ((n2 & 2) != 0) {
            n = 4;
        }
        taskEmitter.findBooksWithMissingPageHash(library, n);
    }

    /*
     * WARNING - void declaration
     */
    public void hashBookPages(@NotNull Collection<String> bookIdToSeriesId, int priority) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(bookIdToSeriesId, (String)"bookIdToSeriesId");
        Iterable $this$map$iv = bookIdToSeriesId;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Task.HashBookPages((String)it, priority));
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        this.submitTasks((Collection)it);
    }

    public static /* synthetic */ void hashBookPages$default(TaskEmitter taskEmitter, Collection collection, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: hashBookPages");
        }
        if ((n2 & 2) != 0) {
            n = 4;
        }
        taskEmitter.hashBookPages(collection, n);
    }

    public void findBooksToConvert(@NotNull Library library, int priority) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        this.submitTask((Task)new Task.FindBooksToConvert(library.getId(), priority));
    }

    public static /* synthetic */ void findBooksToConvert$default(TaskEmitter taskEmitter, Library library, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findBooksToConvert");
        }
        if ((n2 & 2) != 0) {
            n = 4;
        }
        taskEmitter.findBooksToConvert(library, n);
    }

    /*
     * WARNING - void declaration
     */
    public void convertBookToCbz(@NotNull Collection<Book> books, int priority) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(books, (String)"books");
        Iterable $this$map$iv = books;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Book book = (Book)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Task.ConvertBook(it.getId(), priority, it.getSeriesId()));
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        this.submitTasks((Collection)it);
    }

    public static /* synthetic */ void convertBookToCbz$default(TaskEmitter taskEmitter, Collection collection, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: convertBookToCbz");
        }
        if ((n2 & 2) != 0) {
            n = 4;
        }
        taskEmitter.convertBookToCbz(collection, n);
    }

    /*
     * WARNING - void declaration
     */
    public void repairExtensions(@NotNull Library library, int priority) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        if (library.getRepairExtensions()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.bookConverter.getMismatchedExtensionBooks(library);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Book book = (Book)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Task.RepairExtension(it.getId(), priority, it.getSeriesId()));
            }
            List it = (List)destination$iv$iv;
            boolean bl = false;
            this.submitTasks((Collection)it);
        }
    }

    public static /* synthetic */ void repairExtensions$default(TaskEmitter taskEmitter, Library library, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: repairExtensions");
        }
        if ((n2 & 2) != 0) {
            n = 4;
        }
        taskEmitter.repairExtensions(library, n);
    }

    public void findDuplicatePagesToDelete(@NotNull Library library, int priority) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        this.submitTask((Task)new Task.FindDuplicatePagesToDelete(library.getId(), priority));
    }

    public static /* synthetic */ void findDuplicatePagesToDelete$default(TaskEmitter taskEmitter, Library library, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findDuplicatePagesToDelete");
        }
        if ((n2 & 2) != 0) {
            n = 4;
        }
        taskEmitter.findDuplicatePagesToDelete(library, n);
    }

    public void removeDuplicatePages(@NotNull String bookId, @NotNull Collection<BookPageNumbered> pages, int priority) {
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        Intrinsics.checkNotNullParameter(pages, (String)"pages");
        this.submitTask((Task)new Task.RemoveHashedPages(bookId, pages, priority));
    }

    public static /* synthetic */ void removeDuplicatePages$default(TaskEmitter taskEmitter, String string, Collection collection, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: removeDuplicatePages");
        }
        if ((n2 & 4) != 0) {
            n = 4;
        }
        taskEmitter.removeDuplicatePages(string, collection, n);
    }

    /*
     * WARNING - void declaration
     */
    public void removeDuplicatePages(@NotNull Map<String, ? extends Collection<BookPageNumbered>> bookIdToPages, int priority) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(bookIdToPages, (String)"bookIdToPages");
        Map<String, ? extends Collection<BookPageNumbered>> $this$map$iv = bookIdToPages;
        boolean $i$f$map = false;
        Map<String, ? extends Collection<BookPageNumbered>> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Task.RemoveHashedPages((String)it.getKey(), (Collection)it.getValue(), priority));
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        this.submitTasks((Collection)it);
    }

    public static /* synthetic */ void removeDuplicatePages$default(TaskEmitter taskEmitter, Map map, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: removeDuplicatePages");
        }
        if ((n2 & 2) != 0) {
            n = 4;
        }
        taskEmitter.removeDuplicatePages(map, n);
    }

    public void analyzeBook(@NotNull Book book, int priority) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        this.submitTask((Task)new Task.AnalyzeBook(book.getId(), priority, book.getSeriesId()));
    }

    public static /* synthetic */ void analyzeBook$default(TaskEmitter taskEmitter, Book book, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: analyzeBook");
        }
        if ((n2 & 2) != 0) {
            n = 4;
        }
        taskEmitter.analyzeBook(book, n);
    }

    /*
     * WARNING - void declaration
     */
    public void analyzeBook(@NotNull Collection<Book> books, int priority) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(books, (String)"books");
        Iterable $this$map$iv = books;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Book book = (Book)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Task.AnalyzeBook(it.getId(), priority, it.getSeriesId()));
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        this.submitTasks((Collection)it);
    }

    public static /* synthetic */ void analyzeBook$default(TaskEmitter taskEmitter, Collection collection, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: analyzeBook");
        }
        if ((n2 & 2) != 0) {
            n = 4;
        }
        taskEmitter.analyzeBook(collection, n);
    }

    public void generateBookThumbnail(@NotNull String bookId, int priority) {
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        this.submitTask((Task)new Task.GenerateBookThumbnail(bookId, priority));
    }

    public static /* synthetic */ void generateBookThumbnail$default(TaskEmitter taskEmitter, String string, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: generateBookThumbnail");
        }
        if ((n2 & 2) != 0) {
            n = 4;
        }
        taskEmitter.generateBookThumbnail(string, n);
    }

    /*
     * WARNING - void declaration
     */
    public void generateBookThumbnail(@NotNull Collection<String> bookIds, int priority) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(bookIds, (String)"bookIds");
        Iterable $this$map$iv = bookIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Task.GenerateBookThumbnail((String)it, priority));
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        this.submitTasks((Collection)it);
    }

    public static /* synthetic */ void generateBookThumbnail$default(TaskEmitter taskEmitter, Collection collection, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: generateBookThumbnail");
        }
        if ((n2 & 2) != 0) {
            n = 4;
        }
        taskEmitter.generateBookThumbnail(collection, n);
    }

    public void refreshBookMetadata(@NotNull Book book, @NotNull Set<? extends BookMetadataPatchCapability> capabilities, int priority) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        Intrinsics.checkNotNullParameter(capabilities, (String)"capabilities");
        this.submitTask((Task)new Task.RefreshBookMetadata(book.getId(), capabilities, priority, book.getSeriesId()));
    }

    public static /* synthetic */ void refreshBookMetadata$default(TaskEmitter taskEmitter, Book book, Set set, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: refreshBookMetadata");
        }
        if ((n2 & 2) != 0) {
            set = ArraysKt.toSet((Object[])BookMetadataPatchCapability.values());
        }
        if ((n2 & 4) != 0) {
            n = 4;
        }
        taskEmitter.refreshBookMetadata(book, set, n);
    }

    /*
     * WARNING - void declaration
     */
    public void refreshBookMetadata(@NotNull Collection<Book> books, @NotNull Set<? extends BookMetadataPatchCapability> capabilities, int priority) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(books, (String)"books");
        Intrinsics.checkNotNullParameter(capabilities, (String)"capabilities");
        Iterable iterable = books;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Book book = (Book)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Task.RefreshBookMetadata(it.getId(), capabilities, priority, it.getSeriesId()));
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        this.submitTasks((Collection)it);
    }

    public static /* synthetic */ void refreshBookMetadata$default(TaskEmitter taskEmitter, Collection collection, Set set, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: refreshBookMetadata");
        }
        if ((n2 & 2) != 0) {
            set = ArraysKt.toSet((Object[])BookMetadataPatchCapability.values());
        }
        if ((n2 & 4) != 0) {
            n = 4;
        }
        taskEmitter.refreshBookMetadata(collection, set, n);
    }

    public void refreshSeriesMetadata(@NotNull String seriesId, int priority) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        this.submitTask((Task)new Task.RefreshSeriesMetadata(seriesId, priority));
    }

    public static /* synthetic */ void refreshSeriesMetadata$default(TaskEmitter taskEmitter, String string, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: refreshSeriesMetadata");
        }
        if ((n2 & 2) != 0) {
            n = 4;
        }
        taskEmitter.refreshSeriesMetadata(string, n);
    }

    public void aggregateSeriesMetadata(@NotNull String seriesId, int priority) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        this.submitTask((Task)new Task.AggregateSeriesMetadata(seriesId, priority));
    }

    public static /* synthetic */ void aggregateSeriesMetadata$default(TaskEmitter taskEmitter, String string, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: aggregateSeriesMetadata");
        }
        if ((n2 & 2) != 0) {
            n = 4;
        }
        taskEmitter.aggregateSeriesMetadata(string, n);
    }

    public void refreshBookLocalArtwork(@NotNull Book book, int priority) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        this.submitTask((Task)new Task.RefreshBookLocalArtwork(book.getId(), priority));
    }

    public static /* synthetic */ void refreshBookLocalArtwork$default(TaskEmitter taskEmitter, Book book, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: refreshBookLocalArtwork");
        }
        if ((n2 & 2) != 0) {
            n = 4;
        }
        taskEmitter.refreshBookLocalArtwork(book, n);
    }

    /*
     * WARNING - void declaration
     */
    public void refreshBookLocalArtwork(@NotNull Collection<Book> books, int priority) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(books, (String)"books");
        Iterable $this$map$iv = books;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Book book = (Book)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Task.RefreshBookLocalArtwork(it.getId(), priority));
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        this.submitTasks((Collection)it);
    }

    public static /* synthetic */ void refreshBookLocalArtwork$default(TaskEmitter taskEmitter, Collection collection, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: refreshBookLocalArtwork");
        }
        if ((n2 & 2) != 0) {
            n = 4;
        }
        taskEmitter.refreshBookLocalArtwork(collection, n);
    }

    public void refreshSeriesLocalArtwork(@NotNull String seriesId, int priority) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        this.submitTask((Task)new Task.RefreshSeriesLocalArtwork(seriesId, priority));
    }

    public static /* synthetic */ void refreshSeriesLocalArtwork$default(TaskEmitter taskEmitter, String string, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: refreshSeriesLocalArtwork");
        }
        if ((n2 & 2) != 0) {
            n = 4;
        }
        taskEmitter.refreshSeriesLocalArtwork(string, n);
    }

    /*
     * WARNING - void declaration
     */
    public void refreshSeriesLocalArtwork(@NotNull Collection<String> seriesIds, int priority) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(seriesIds, (String)"seriesIds");
        Iterable $this$map$iv = seriesIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Task.RefreshSeriesLocalArtwork((String)it, priority));
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        this.submitTasks((Collection)it);
    }

    public static /* synthetic */ void refreshSeriesLocalArtwork$default(TaskEmitter taskEmitter, Collection collection, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: refreshSeriesLocalArtwork");
        }
        if ((n2 & 2) != 0) {
            n = 4;
        }
        taskEmitter.refreshSeriesLocalArtwork(collection, n);
    }

    public void importBook(@NotNull String sourceFile, @NotNull String seriesId, @NotNull CopyMode copyMode, @Nullable String destinationName, @Nullable String upgradeBookId, int priority) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        Intrinsics.checkNotNullParameter((Object)copyMode, (String)"copyMode");
        this.submitTask((Task)new Task.ImportBook(sourceFile, seriesId, copyMode, destinationName, upgradeBookId, priority));
    }

    public static /* synthetic */ void importBook$default(TaskEmitter taskEmitter, String string, String string2, CopyMode copyMode, String string3, String string4, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: importBook");
        }
        if ((n2 & 0x20) != 0) {
            n = 4;
        }
        taskEmitter.importBook(string, string2, copyMode, string3, string4, n);
    }

    public void rebuildIndex(int priority, @Nullable Set<? extends LuceneEntity> entities) {
        this.submitTask((Task)new Task.RebuildIndex(entities, priority));
    }

    public static /* synthetic */ void rebuildIndex$default(TaskEmitter taskEmitter, int n, Set set, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: rebuildIndex");
        }
        if ((n2 & 1) != 0) {
            n = 4;
        }
        if ((n2 & 2) != 0) {
            set = null;
        }
        taskEmitter.rebuildIndex(n, set);
    }

    public void upgradeIndex(int priority) {
        this.submitTask((Task)new Task.UpgradeIndex(priority));
    }

    public static /* synthetic */ void upgradeIndex$default(TaskEmitter taskEmitter, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: upgradeIndex");
        }
        if ((n2 & 1) != 0) {
            n = 4;
        }
        taskEmitter.upgradeIndex(n);
    }

    public void deleteBook(@NotNull String bookId, int priority) {
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        this.submitTask((Task)new Task.DeleteBook(bookId, priority));
    }

    public static /* synthetic */ void deleteBook$default(TaskEmitter taskEmitter, String string, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: deleteBook");
        }
        if ((n2 & 2) != 0) {
            n = 4;
        }
        taskEmitter.deleteBook(string, n);
    }

    public void deleteSeries(@NotNull String seriesId, int priority) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        this.submitTask((Task)new Task.DeleteSeries(seriesId, priority));
    }

    public static /* synthetic */ void deleteSeries$default(TaskEmitter taskEmitter, String string, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: deleteSeries");
        }
        if ((n2 & 2) != 0) {
            n = 4;
        }
        taskEmitter.deleteSeries(string, n);
    }

    public void findBookThumbnailsToRegenerate(boolean forBiggerResultOnly, int priority) {
        this.submitTask((Task)new Task.FindBookThumbnailsToRegenerate(forBiggerResultOnly, priority));
    }

    public static /* synthetic */ void findBookThumbnailsToRegenerate$default(TaskEmitter taskEmitter, boolean bl, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findBookThumbnailsToRegenerate");
        }
        if ((n2 & 2) != 0) {
            n = 4;
        }
        taskEmitter.findBookThumbnailsToRegenerate(bl, n);
    }

    private void submitTask(Task task2) {
        TaskEmitterKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        this.tasksRepository.save(task2);
        this.eventPublisher.publishEvent((Object)TaskAddedEvent.INSTANCE);
    }

    private void submitTasks(Collection<? extends Task> tasks) {
        TaskEmitterKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        this.tasksRepository.save(tasks);
        this.eventPublisher.publishEvent((Object)TaskAddedEvent.INSTANCE);
    }
}

