/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.application.tasks;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import org.gotson.komga.application.tasks.Task;
import org.gotson.komga.application.tasks.TaskEmitter;
import org.gotson.komga.application.tasks.TaskHandlerKt;
import org.gotson.komga.domain.model.Book;
import org.gotson.komga.domain.model.BookAction;
import org.gotson.komga.domain.model.Library;
import org.gotson.komga.domain.model.Series;
import org.gotson.komga.domain.persistence.BookRepository;
import org.gotson.komga.domain.persistence.LibraryRepository;
import org.gotson.komga.domain.persistence.SeriesRepository;
import org.gotson.komga.domain.service.BookConverter;
import org.gotson.komga.domain.service.BookImporter;
import org.gotson.komga.domain.service.BookLifecycle;
import org.gotson.komga.domain.service.BookMetadataLifecycle;
import org.gotson.komga.domain.service.BookPageEditor;
import org.gotson.komga.domain.service.LibraryContentLifecycle;
import org.gotson.komga.domain.service.LocalArtworkLifecycle;
import org.gotson.komga.domain.service.PageHashLifecycle;
import org.gotson.komga.domain.service.SeriesLifecycle;
import org.gotson.komga.domain.service.SeriesMetadataLifecycle;
import org.gotson.komga.infrastructure.search.SearchIndexLifecycle;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0085\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u0012\u0006\u0010 \u001a\u00020!\u00a2\u0006\u0002\u0010\"J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016R\u000e\u0010\u0018\u001a\u00020\u0019X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/gotson/komga/application/tasks/TaskHandler;", "", "taskEmitter", "Lorg/gotson/komga/application/tasks/TaskEmitter;", "libraryRepository", "Lorg/gotson/komga/domain/persistence/LibraryRepository;", "bookRepository", "Lorg/gotson/komga/domain/persistence/BookRepository;", "seriesRepository", "Lorg/gotson/komga/domain/persistence/SeriesRepository;", "libraryContentLifecycle", "Lorg/gotson/komga/domain/service/LibraryContentLifecycle;", "bookLifecycle", "Lorg/gotson/komga/domain/service/BookLifecycle;", "bookMetadataLifecycle", "Lorg/gotson/komga/domain/service/BookMetadataLifecycle;", "seriesLifecycle", "Lorg/gotson/komga/domain/service/SeriesLifecycle;", "seriesMetadataLifecycle", "Lorg/gotson/komga/domain/service/SeriesMetadataLifecycle;", "localArtworkLifecycle", "Lorg/gotson/komga/domain/service/LocalArtworkLifecycle;", "bookImporter", "Lorg/gotson/komga/domain/service/BookImporter;", "bookConverter", "Lorg/gotson/komga/domain/service/BookConverter;", "bookPageEditor", "Lorg/gotson/komga/domain/service/BookPageEditor;", "searchIndexLifecycle", "Lorg/gotson/komga/infrastructure/search/SearchIndexLifecycle;", "pageHashLifecycle", "Lorg/gotson/komga/domain/service/PageHashLifecycle;", "meterRegistry", "Lio/micrometer/core/instrument/MeterRegistry;", "(Lorg/gotson/komga/application/tasks/TaskEmitter;Lorg/gotson/komga/domain/persistence/LibraryRepository;Lorg/gotson/komga/domain/persistence/BookRepository;Lorg/gotson/komga/domain/persistence/SeriesRepository;Lorg/gotson/komga/domain/service/LibraryContentLifecycle;Lorg/gotson/komga/domain/service/BookLifecycle;Lorg/gotson/komga/domain/service/BookMetadataLifecycle;Lorg/gotson/komga/domain/service/SeriesLifecycle;Lorg/gotson/komga/domain/service/SeriesMetadataLifecycle;Lorg/gotson/komga/domain/service/LocalArtworkLifecycle;Lorg/gotson/komga/domain/service/BookImporter;Lorg/gotson/komga/domain/service/BookConverter;Lorg/gotson/komga/domain/service/BookPageEditor;Lorg/gotson/komga/infrastructure/search/SearchIndexLifecycle;Lorg/gotson/komga/domain/service/PageHashLifecycle;Lio/micrometer/core/instrument/MeterRegistry;)V", "handleTask", "", "task", "Lorg/gotson/komga/application/tasks/Task;", "komga"})
@SourceDebugExtension(value={"SMAP\nTaskHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskHandler.kt\norg/gotson/komga/application/tasks/TaskHandler\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n*L\n1#1,195:1\n18#2,4:196\n50#2,7:200\n*S KotlinDebug\n*F\n+ 1 TaskHandler.kt\norg/gotson/komga/application/tasks/TaskHandler\n*L\n51#1:196,4\n51#1:200,7\n*E\n"})
public class TaskHandler {
    @NotNull
    private final TaskEmitter taskEmitter;
    @NotNull
    private final LibraryRepository libraryRepository;
    @NotNull
    private final BookRepository bookRepository;
    @NotNull
    private final SeriesRepository seriesRepository;
    @NotNull
    private final LibraryContentLifecycle libraryContentLifecycle;
    @NotNull
    private final BookLifecycle bookLifecycle;
    @NotNull
    private final BookMetadataLifecycle bookMetadataLifecycle;
    @NotNull
    private final SeriesLifecycle seriesLifecycle;
    @NotNull
    private final SeriesMetadataLifecycle seriesMetadataLifecycle;
    @NotNull
    private final LocalArtworkLifecycle localArtworkLifecycle;
    @NotNull
    private final BookImporter bookImporter;
    @NotNull
    private final BookConverter bookConverter;
    @NotNull
    private final BookPageEditor bookPageEditor;
    @NotNull
    private final SearchIndexLifecycle searchIndexLifecycle;
    @NotNull
    private final PageHashLifecycle pageHashLifecycle;
    @NotNull
    private final MeterRegistry meterRegistry;

    public TaskHandler(@NotNull TaskEmitter taskEmitter, @NotNull LibraryRepository libraryRepository, @NotNull BookRepository bookRepository, @NotNull SeriesRepository seriesRepository, @NotNull LibraryContentLifecycle libraryContentLifecycle, @NotNull BookLifecycle bookLifecycle, @NotNull BookMetadataLifecycle bookMetadataLifecycle, @NotNull SeriesLifecycle seriesLifecycle, @NotNull SeriesMetadataLifecycle seriesMetadataLifecycle, @NotNull LocalArtworkLifecycle localArtworkLifecycle, @NotNull BookImporter bookImporter, @NotNull BookConverter bookConverter, @NotNull BookPageEditor bookPageEditor, @NotNull SearchIndexLifecycle searchIndexLifecycle, @NotNull PageHashLifecycle pageHashLifecycle, @NotNull MeterRegistry meterRegistry) {
        Intrinsics.checkNotNullParameter((Object)taskEmitter, (String)"taskEmitter");
        Intrinsics.checkNotNullParameter((Object)libraryRepository, (String)"libraryRepository");
        Intrinsics.checkNotNullParameter((Object)bookRepository, (String)"bookRepository");
        Intrinsics.checkNotNullParameter((Object)seriesRepository, (String)"seriesRepository");
        Intrinsics.checkNotNullParameter((Object)libraryContentLifecycle, (String)"libraryContentLifecycle");
        Intrinsics.checkNotNullParameter((Object)bookLifecycle, (String)"bookLifecycle");
        Intrinsics.checkNotNullParameter((Object)bookMetadataLifecycle, (String)"bookMetadataLifecycle");
        Intrinsics.checkNotNullParameter((Object)seriesLifecycle, (String)"seriesLifecycle");
        Intrinsics.checkNotNullParameter((Object)seriesMetadataLifecycle, (String)"seriesMetadataLifecycle");
        Intrinsics.checkNotNullParameter((Object)localArtworkLifecycle, (String)"localArtworkLifecycle");
        Intrinsics.checkNotNullParameter((Object)bookImporter, (String)"bookImporter");
        Intrinsics.checkNotNullParameter((Object)bookConverter, (String)"bookConverter");
        Intrinsics.checkNotNullParameter((Object)bookPageEditor, (String)"bookPageEditor");
        Intrinsics.checkNotNullParameter((Object)searchIndexLifecycle, (String)"searchIndexLifecycle");
        Intrinsics.checkNotNullParameter((Object)pageHashLifecycle, (String)"pageHashLifecycle");
        Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"meterRegistry");
        this.taskEmitter = taskEmitter;
        this.libraryRepository = libraryRepository;
        this.bookRepository = bookRepository;
        this.seriesRepository = seriesRepository;
        this.libraryContentLifecycle = libraryContentLifecycle;
        this.bookLifecycle = bookLifecycle;
        this.bookMetadataLifecycle = bookMetadataLifecycle;
        this.seriesLifecycle = seriesLifecycle;
        this.seriesMetadataLifecycle = seriesMetadataLifecycle;
        this.localArtworkLifecycle = localArtworkLifecycle;
        this.bookImporter = bookImporter;
        this.bookConverter = bookConverter;
        this.bookPageEditor = bookPageEditor;
        this.searchIndexLifecycle = searchIndexLifecycle;
        this.pageHashLifecycle = pageHashLifecycle;
        this.meterRegistry = meterRegistry;
    }

    public void handleTask(@NotNull Task task2) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        TaskHandlerKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        try {
            boolean $i$f$measureTime = false;
            TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTime2 = false;
            long mark$iv$iv = $this$measureTime$iv$iv.markNow-z9LOYto();
            boolean bl = false;
            Task task3 = task2;
            if (task3 instanceof Task.ScanLibrary) {
                Unit unit;
                Library library = this.libraryRepository.findByIdOrNull(((Task.ScanLibrary)task2).getLibraryId());
                if (library != null) {
                    Library library2 = library;
                    boolean bl2 = false;
                    this.libraryContentLifecycle.scanRootFolder(library2, ((Task.ScanLibrary)task2).getScanDeep());
                    this.taskEmitter.analyzeUnknownAndOutdatedBooks(library2);
                    this.taskEmitter.repairExtensions(library2, 2);
                    this.taskEmitter.findBooksToConvert(library2, 0);
                    this.taskEmitter.findBooksWithMissingPageHash(library2, 0);
                    this.taskEmitter.findDuplicatePagesToDelete(library2, 0);
                    this.taskEmitter.hashBooksWithoutHash(library2);
                    this.taskEmitter.hashBooksWithoutHashKoreader(library2);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit == null) {
                    TaskHandlerKt.access$getLogger$p().warn((Function0)new /* Unavailable Anonymous Inner Class!! */);
                }
            } else if (task3 instanceof Task.FindBooksToConvert) {
                Unit unit;
                Library library = this.libraryRepository.findByIdOrNull(((Task.FindBooksToConvert)task2).getLibraryId());
                if (library != null) {
                    Library library3 = library;
                    boolean bl3 = false;
                    this.taskEmitter.convertBookToCbz(this.bookConverter.getConvertibleBooks(library3), task2.getPriority() + 1);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit == null) {
                    TaskHandlerKt.access$getLogger$p().warn((Function0)new /* Unavailable Anonymous Inner Class!! */);
                }
            } else if (task3 instanceof Task.FindBooksWithMissingPageHash) {
                Unit unit;
                Library library = this.libraryRepository.findByIdOrNull(((Task.FindBooksWithMissingPageHash)task2).getLibraryId());
                if (library != null) {
                    Library library4 = library;
                    boolean bl4 = false;
                    this.taskEmitter.hashBookPages(this.pageHashLifecycle.getBookIdsWithMissingPageHash(library4), task2.getPriority() + 1);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit == null) {
                    TaskHandlerKt.access$getLogger$p().warn((Function0)new /* Unavailable Anonymous Inner Class!! */);
                }
            } else if (task3 instanceof Task.FindDuplicatePagesToDelete) {
                Unit unit;
                Library library = this.libraryRepository.findByIdOrNull(((Task.FindDuplicatePagesToDelete)task2).getLibraryId());
                if (library != null) {
                    Library library5 = library;
                    boolean bl5 = false;
                    this.taskEmitter.removeDuplicatePages(this.pageHashLifecycle.getBookPagesToDeleteAutomatically(library5), task2.getPriority() + 1);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit == null) {
                    TaskHandlerKt.access$getLogger$p().warn((Function0)new /* Unavailable Anonymous Inner Class!! */);
                }
            } else if (task3 instanceof Task.EmptyTrash) {
                Unit unit;
                Library library = this.libraryRepository.findByIdOrNull(((Task.EmptyTrash)task2).getLibraryId());
                if (library != null) {
                    Library library6 = library;
                    boolean bl6 = false;
                    this.libraryContentLifecycle.emptyTrash(library6);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit == null) {
                    TaskHandlerKt.access$getLogger$p().warn((Function0)new /* Unavailable Anonymous Inner Class!! */);
                }
            } else if (task3 instanceof Task.AnalyzeBook) {
                Unit unit;
                Book book = this.bookRepository.findByIdOrNull(((Task.AnalyzeBook)task2).getBookId());
                if (book != null) {
                    Book book2 = book;
                    boolean bl7 = false;
                    Set actions = this.bookLifecycle.analyzeAndPersist(book2);
                    if (actions.contains(BookAction.GENERATE_THUMBNAIL)) {
                        this.taskEmitter.generateBookThumbnail(book2.getId(), task2.getPriority() + 1);
                    }
                    if (actions.contains(BookAction.REFRESH_METADATA)) {
                        TaskEmitter.refreshBookMetadata$default((TaskEmitter)this.taskEmitter, (Book)book2, null, (int)(task2.getPriority() + 1), (int)2, null);
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit == null) {
                    TaskHandlerKt.access$getLogger$p().warn((Function0)new /* Unavailable Anonymous Inner Class!! */);
                }
            } else if (task3 instanceof Task.GenerateBookThumbnail) {
                Unit unit;
                Book book = this.bookRepository.findByIdOrNull(((Task.GenerateBookThumbnail)task2).getBookId());
                if (book != null) {
                    Book book3 = book;
                    boolean bl8 = false;
                    this.bookLifecycle.generateThumbnailAndPersist(book3);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit == null) {
                    TaskHandlerKt.access$getLogger$p().warn((Function0)new /* Unavailable Anonymous Inner Class!! */);
                }
            } else if (task3 instanceof Task.RefreshBookMetadata) {
                Unit unit;
                Book book = this.bookRepository.findByIdOrNull(((Task.RefreshBookMetadata)task2).getBookId());
                if (book != null) {
                    Book book4 = book;
                    boolean bl9 = false;
                    this.bookMetadataLifecycle.refreshMetadata(book4, ((Task.RefreshBookMetadata)task2).getCapabilities());
                    this.taskEmitter.refreshSeriesMetadata(book4.getSeriesId(), task2.getPriority() - 1);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit == null) {
                    TaskHandlerKt.access$getLogger$p().warn((Function0)new /* Unavailable Anonymous Inner Class!! */);
                }
            } else if (task3 instanceof Task.RefreshSeriesMetadata) {
                Unit unit;
                Series series = this.seriesRepository.findByIdOrNull(((Task.RefreshSeriesMetadata)task2).getSeriesId());
                if (series != null) {
                    Series series2 = series;
                    boolean bl10 = false;
                    this.seriesMetadataLifecycle.refreshMetadata(series2);
                    this.taskEmitter.aggregateSeriesMetadata(series2.getId(), task2.getPriority());
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit == null) {
                    TaskHandlerKt.access$getLogger$p().warn((Function0)new /* Unavailable Anonymous Inner Class!! */);
                }
            } else if (task3 instanceof Task.AggregateSeriesMetadata) {
                Unit unit;
                Series series = this.seriesRepository.findByIdOrNull(((Task.AggregateSeriesMetadata)task2).getSeriesId());
                if (series != null) {
                    Series series3 = series;
                    boolean bl11 = false;
                    this.seriesMetadataLifecycle.aggregateMetadata(series3);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit == null) {
                    TaskHandlerKt.access$getLogger$p().warn((Function0)new /* Unavailable Anonymous Inner Class!! */);
                }
            } else if (task3 instanceof Task.RefreshBookLocalArtwork) {
                Unit unit;
                Book book = this.bookRepository.findByIdOrNull(((Task.RefreshBookLocalArtwork)task2).getBookId());
                if (book != null) {
                    Book book5 = book;
                    boolean bl12 = false;
                    this.localArtworkLifecycle.refreshLocalArtwork(book5);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit == null) {
                    TaskHandlerKt.access$getLogger$p().warn((Function0)new /* Unavailable Anonymous Inner Class!! */);
                }
            } else if (task3 instanceof Task.RefreshSeriesLocalArtwork) {
                Unit unit;
                Series series = this.seriesRepository.findByIdOrNull(((Task.RefreshSeriesLocalArtwork)task2).getSeriesId());
                if (series != null) {
                    Series series4 = series;
                    boolean bl13 = false;
                    this.localArtworkLifecycle.refreshLocalArtwork(series4);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit == null) {
                    TaskHandlerKt.access$getLogger$p().warn((Function0)new /* Unavailable Anonymous Inner Class!! */);
                }
            } else if (task3 instanceof Task.ImportBook) {
                Unit unit;
                Series series = this.seriesRepository.findByIdOrNull(((Task.ImportBook)task2).getSeriesId());
                if (series != null) {
                    Series series5 = series;
                    boolean bl14 = false;
                    Path path2 = Paths.get(((Task.ImportBook)task2).getSourceFile(), new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                    Book importedBook = this.bookImporter.importBook(path2, series5, ((Task.ImportBook)task2).getCopyMode(), ((Task.ImportBook)task2).getDestinationName(), ((Task.ImportBook)task2).getUpgradeBookId());
                    this.taskEmitter.analyzeBook(importedBook, task2.getPriority() + 1);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit == null) {
                    TaskHandlerKt.access$getLogger$p().warn((Function0)new /* Unavailable Anonymous Inner Class!! */);
                }
            } else if (task3 instanceof Task.ConvertBook) {
                Unit unit;
                Book book = this.bookRepository.findByIdOrNull(((Task.ConvertBook)task2).getBookId());
                if (book != null) {
                    Book book6 = book;
                    boolean bl15 = false;
                    this.bookConverter.convertToCbz(book6);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit == null) {
                    TaskHandlerKt.access$getLogger$p().warn((Function0)new /* Unavailable Anonymous Inner Class!! */);
                }
            } else if (task3 instanceof Task.RepairExtension) {
                Unit unit;
                Book book = this.bookRepository.findByIdOrNull(((Task.RepairExtension)task2).getBookId());
                if (book != null) {
                    Book book7 = book;
                    boolean bl16 = false;
                    this.bookConverter.repairExtension(book7);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit == null) {
                    TaskHandlerKt.access$getLogger$p().warn((Function0)new /* Unavailable Anonymous Inner Class!! */);
                }
            } else if (task3 instanceof Task.RemoveHashedPages) {
                Unit unit;
                Book book = this.bookRepository.findByIdOrNull(((Task.RemoveHashedPages)task2).getBookId());
                if (book != null) {
                    Book book8 = book;
                    boolean bl17 = false;
                    if (this.bookPageEditor.removeHashedPages(book8, ((Task.RemoveHashedPages)task2).getPages()) == BookAction.GENERATE_THUMBNAIL) {
                        this.taskEmitter.generateBookThumbnail(book8.getId(), task2.getPriority() + 1);
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit == null) {
                    TaskHandlerKt.access$getLogger$p().warn((Function0)new /* Unavailable Anonymous Inner Class!! */);
                }
            } else if (task3 instanceof Task.HashBook) {
                Unit unit;
                Book book = this.bookRepository.findByIdOrNull(((Task.HashBook)task2).getBookId());
                if (book != null) {
                    Book book9 = book;
                    boolean bl18 = false;
                    this.bookLifecycle.hashAndPersist(book9);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit == null) {
                    TaskHandlerKt.access$getLogger$p().warn((Function0)new /* Unavailable Anonymous Inner Class!! */);
                }
            } else if (task3 instanceof Task.HashBookKoreader) {
                Unit unit;
                Book book = this.bookRepository.findByIdOrNull(((Task.HashBookKoreader)task2).getBookId());
                if (book != null) {
                    Book book10 = book;
                    boolean bl19 = false;
                    this.bookLifecycle.hashKoreaderAndPersist(book10);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit == null) {
                    TaskHandlerKt.access$getLogger$p().warn((Function0)new /* Unavailable Anonymous Inner Class!! */);
                }
            } else if (task3 instanceof Task.HashBookPages) {
                Unit unit;
                Book book = this.bookRepository.findByIdOrNull(((Task.HashBookPages)task2).getBookId());
                if (book != null) {
                    Book book11 = book;
                    boolean bl20 = false;
                    this.bookLifecycle.hashPagesAndPersist(book11);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit == null) {
                    TaskHandlerKt.access$getLogger$p().warn((Function0)new /* Unavailable Anonymous Inner Class!! */);
                }
            } else if (task3 instanceof Task.RebuildIndex) {
                this.searchIndexLifecycle.rebuildIndex(((Task.RebuildIndex)task2).getEntities());
            } else if (task3 instanceof Task.UpgradeIndex) {
                this.searchIndexLifecycle.upgradeIndex();
            } else if (task3 instanceof Task.DeleteBook) {
                Book book = this.bookRepository.findByIdOrNull(((Task.DeleteBook)task2).getBookId());
                if (book != null) {
                    Book book12 = book;
                    boolean bl21 = false;
                    if (book12.getOneshot()) {
                        Series series = this.seriesRepository.findByIdOrNull(book12.getSeriesId());
                        Intrinsics.checkNotNull((Object)series);
                        this.seriesLifecycle.deleteSeriesFiles(series);
                    } else {
                        this.bookLifecycle.deleteBookFiles(book12);
                    }
                }
            } else if (task3 instanceof Task.DeleteSeries) {
                Series series = this.seriesRepository.findByIdOrNull(((Task.DeleteSeries)task2).getSeriesId());
                if (series != null) {
                    Series series6 = series;
                    boolean bl22 = false;
                    this.seriesLifecycle.deleteSeriesFiles(series6);
                }
            } else if (task3 instanceof Task.FindBookThumbnailsToRegenerate) {
                this.taskEmitter.generateBookThumbnail(this.bookLifecycle.findBookThumbnailsToRegenerate(((Task.FindBookThumbnailsToRegenerate)task2).getForBiggerResultOnly()), task2.getPriority());
            }
            long it = $i$f$measureTime = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv);
            boolean bl23 = false;
            TaskHandlerKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
            String[] stringArray = new String[]{"type", task2.getClass().getSimpleName()};
            Timer timer = this.meterRegistry.timer("komga.tasks.execution", stringArray);
            long l = it;
            int n = Duration.getNanosecondsComponent-impl((long)l);
            long l2 = Duration.getInWholeSeconds-impl((long)l);
            java.time.Duration duration = java.time.Duration.ofSeconds(l2, n);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"toComponents-impl(...)");
            timer.record(duration);
        }
        catch (Exception e) {
            TaskHandlerKt.access$getLogger$p().error((Throwable)e, (Function0)new /* Unavailable Anonymous Inner Class!! */);
            String[] stringArray = new String[]{"type", task2.getClass().getSimpleName()};
            this.meterRegistry.counter("komga.tasks.failure", stringArray).increment();
        }
    }
}

