/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.application.tasks;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.application.tasks.Task;
import org.gotson.komga.application.tasks.TaskAddedEvent;
import org.gotson.komga.application.tasks.TaskHandler;
import org.gotson.komga.application.tasks.TaskProcessor;
import org.gotson.komga.application.tasks.TaskProcessorKt;
import org.gotson.komga.application.tasks.TasksRepository;
import org.gotson.komga.infrastructure.configuration.KomgaSettingsProvider;
import org.gotson.komga.infrastructure.configuration.SettingChangedEvent;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.task.ThreadPoolTaskExecutorBuilder;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0017J\b\u0010\u0018\u001a\u00020\u0016H\u0012J\b\u0010\u0019\u001a\u00020\u0016H\u0017R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/gotson/komga/application/tasks/TaskProcessor;", "Lorg/springframework/beans/factory/InitializingBean;", "tasksRepository", "Lorg/gotson/komga/application/tasks/TasksRepository;", "taskHandler", "Lorg/gotson/komga/application/tasks/TaskHandler;", "settingsProvider", "Lorg/gotson/komga/infrastructure/configuration/KomgaSettingsProvider;", "taskExecutorBuilder", "Lorg/springframework/boot/task/ThreadPoolTaskExecutorBuilder;", "(Lorg/gotson/komga/application/tasks/TasksRepository;Lorg/gotson/komga/application/tasks/TaskHandler;Lorg/gotson/komga/infrastructure/configuration/KomgaSettingsProvider;Lorg/springframework/boot/task/ThreadPoolTaskExecutorBuilder;)V", "executor", "Lorg/springframework/scheduling/concurrent/ThreadPoolTaskExecutor;", "getExecutor", "()Lorg/springframework/scheduling/concurrent/ThreadPoolTaskExecutor;", "processTasks", "", "getProcessTasks", "()Z", "setProcessTasks", "(Z)V", "afterPropertiesSet", "", "processAvailableTask", "takeAndProcess", "taskPoolSizeChanged", "komga"})
@SourceDebugExtension(value={"SMAP\nTaskProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskProcessor.kt\norg/gotson/komga/application/tasks/TaskProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1#2:75\n*E\n"})
public class TaskProcessor
implements InitializingBean {
    @NotNull
    private final TasksRepository tasksRepository;
    @NotNull
    private final TaskHandler taskHandler;
    @NotNull
    private final KomgaSettingsProvider settingsProvider;
    @NotNull
    private final ThreadPoolTaskExecutor executor;
    private boolean processTasks;

    /*
     * WARNING - void declaration
     */
    public TaskProcessor(@NotNull TasksRepository tasksRepository, @NotNull TaskHandler taskHandler, @NotNull KomgaSettingsProvider settingsProvider, @NotNull ThreadPoolTaskExecutorBuilder taskExecutorBuilder) {
        void $this$executor_u24lambda_u240;
        ThreadPoolTaskExecutor threadPoolTaskExecutor;
        Intrinsics.checkNotNullParameter((Object)tasksRepository, (String)"tasksRepository");
        Intrinsics.checkNotNullParameter((Object)taskHandler, (String)"taskHandler");
        Intrinsics.checkNotNullParameter((Object)settingsProvider, (String)"settingsProvider");
        Intrinsics.checkNotNullParameter((Object)taskExecutorBuilder, (String)"taskExecutorBuilder");
        this.tasksRepository = tasksRepository;
        this.taskHandler = taskHandler;
        this.settingsProvider = settingsProvider;
        ThreadPoolTaskExecutor threadPoolTaskExecutor2 = threadPoolTaskExecutor = taskExecutorBuilder.threadNamePrefix("taskProcessor-").corePoolSize(this.settingsProvider.getTaskPoolSize()).build();
        TaskProcessor taskProcessor = this;
        boolean bl = false;
        $this$executor_u24lambda_u240.initialize();
        ThreadPoolTaskExecutor threadPoolTaskExecutor3 = threadPoolTaskExecutor;
        Intrinsics.checkNotNullExpressionValue((Object)threadPoolTaskExecutor3, (String)"apply(...)");
        taskProcessor.executor = threadPoolTaskExecutor3;
    }

    @NotNull
    public ThreadPoolTaskExecutor getExecutor() {
        return this.executor;
    }

    public boolean getProcessTasks() {
        return this.processTasks;
    }

    public void setProcessTasks(boolean bl) {
        this.processTasks = bl;
    }

    public void afterPropertiesSet() {
        int disowned = this.tasksRepository.disown();
        if (disowned > 0) {
            TaskProcessorKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.setProcessTasks(true);
    }

    @EventListener(value={SettingChangedEvent.TaskPoolSize.class})
    public void taskPoolSizeChanged() {
        this.getExecutor().setCorePoolSize(this.settingsProvider.getTaskPoolSize());
    }

    @EventListener(value={TaskAddedEvent.class, ApplicationReadyEvent.class})
    public void processAvailableTask() {
        if (this.getProcessTasks()) {
            TaskProcessorKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
            if (this.getExecutor().getCorePoolSize() == 1) {
                this.getExecutor().execute(() -> TaskProcessor.processAvailableTask$lambda$1(this));
            } else {
                while (this.tasksRepository.hasAvailable() && this.getExecutor().getActiveCount() < this.getExecutor().getCorePoolSize()) {
                    this.getExecutor().execute(() -> TaskProcessor.processAvailableTask$lambda$2(this));
                }
            }
        } else {
            TaskProcessorKt.access$getLogger$p().debug((Function0)processAvailableTask.4.INSTANCE);
        }
    }

    private void takeAndProcess() {
        TaskProcessorKt.access$getLogger$p().debug((Function0)takeAndProcess.1.INSTANCE);
        Task task2 = TasksRepository.DefaultImpls.takeFirst$default((TasksRepository)this.tasksRepository, null, (int)1, null);
        if (task2 != null) {
            TaskProcessorKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
            this.taskHandler.handleTask(task2);
            TaskProcessorKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
            this.tasksRepository.delete(task2.getUniqueId());
            this.processAvailableTask();
        } else {
            TaskProcessorKt.access$getLogger$p().debug((Function0)takeAndProcess.4.INSTANCE);
        }
    }

    private static final void processAvailableTask$lambda$1(TaskProcessor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.takeAndProcess();
    }

    private static final void processAvailableTask$lambda$2(TaskProcessor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.takeAndProcess();
    }
}

