/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.domain.model;

import com.github.f4b6a3.tsid.TsidCreator;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.NotBlank;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.domain.model.AgeRestriction;
import org.gotson.komga.domain.model.AllowExclude;
import org.gotson.komga.domain.model.Auditable;
import org.gotson.komga.domain.model.ContentRestrictions;
import org.gotson.komga.domain.model.Library;
import org.gotson.komga.domain.model.UserRoles;
import org.gotson.komga.language.LanguageUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001Bk\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010#\u001a\u00020\nJ\u000e\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u0003J\u000e\u0010$\u001a\u00020\n2\u0006\u0010&\u001a\u00020'J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J\u000f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J\t\u0010,\u001a\u00020\nH\u00c6\u0003J\t\u0010-\u001a\u00020\fH\u00c6\u0003J\t\u0010.\u001a\u00020\u0003H\u00c6\u0003J\t\u0010/\u001a\u00020\u000fH\u00c6\u0003J\t\u00100\u001a\u00020\u000fH\u00c6\u0003Jo\u00101\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00062\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u00032\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000fH\u00c6\u0001J\u0013\u00102\u001a\u00020\n2\b\u00103\u001a\u0004\u0018\u000104H\u00d6\u0003J\u001e\u00105\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u0001062\u000e\u00107\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u000106J\t\u00108\u001a\u000209H\u00d6\u0001J'\u0010:\u001a\u00020\n2\n\b\u0002\u0010;\u001a\u0004\u0018\u0001092\u000e\b\u0002\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010=J\b\u0010>\u001a\u00020\u0003H\u0016R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u001b\u0010\u0017\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0010\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0018R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010 \u00a8\u0006?"}, d2={"Lorg/gotson/komga/domain/model/KomgaUser;", "Lorg/gotson/komga/domain/model/Auditable;", "email", "", "password", "roles", "", "Lorg/gotson/komga/domain/model/UserRoles;", "sharedLibrariesIds", "sharedAllLibraries", "", "restrictions", "Lorg/gotson/komga/domain/model/ContentRestrictions;", "id", "createdDate", "Ljava/time/LocalDateTime;", "lastModifiedDate", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;Ljava/util/Set;ZLorg/gotson/komga/domain/model/ContentRestrictions;Ljava/lang/String;Ljava/time/LocalDateTime;Ljava/time/LocalDateTime;)V", "getCreatedDate", "()Ljava/time/LocalDateTime;", "getEmail", "()Ljava/lang/String;", "getId", "isAdmin", "()Z", "isAdmin$delegate", "Lkotlin/Lazy;", "getLastModifiedDate", "getPassword", "getRestrictions", "()Lorg/gotson/komga/domain/model/ContentRestrictions;", "getRoles", "()Ljava/util/Set;", "getSharedAllLibraries", "getSharedLibrariesIds", "canAccessAllLibraries", "canAccessLibrary", "libraryId", "library", "Lorg/gotson/komga/domain/model/Library;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "", "getAuthorizedLibraryIds", "", "libraryIds", "hashCode", "", "isContentAllowed", "ageRating", "sharingLabels", "(Ljava/lang/Integer;Ljava/util/Set;)Z", "toString", "komga"})
@SourceDebugExtension(value={"SMAP\nKomgaUser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KomgaUser.kt\norg/gotson/komga/domain/model/KomgaUser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n1747#2,3:98\n1747#2,3:101\n*S KotlinDebug\n*F\n+ 1 KomgaUser.kt\norg/gotson/komga/domain/model/KomgaUser\n*L\n50#1:98,3\n52#1:101,3\n*E\n"})
public final class KomgaUser
implements Auditable {
    @NotNull
    private final String email;
    @NotNull
    private final String password;
    @NotNull
    private final Set<UserRoles> roles;
    @NotNull
    private final Set<String> sharedLibrariesIds;
    private final boolean sharedAllLibraries;
    @NotNull
    private final ContentRestrictions restrictions;
    @NotNull
    private final String id;
    @NotNull
    private final LocalDateTime createdDate;
    @NotNull
    private final LocalDateTime lastModifiedDate;
    @NotNull
    private final transient Lazy isAdmin$delegate;

    public KomgaUser(@Email(regexp=".+@.+\\..+") @NotBlank @NotNull String email, @NotBlank @NotNull String password, @NotNull Set<? extends UserRoles> roles2, @NotNull Set<String> sharedLibrariesIds, boolean sharedAllLibraries, @NotNull ContentRestrictions restrictions, @NotNull String id, @NotNull LocalDateTime createdDate, @NotNull LocalDateTime lastModifiedDate) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter(roles2, (String)"roles");
        Intrinsics.checkNotNullParameter(sharedLibrariesIds, (String)"sharedLibrariesIds");
        Intrinsics.checkNotNullParameter((Object)restrictions, (String)"restrictions");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)createdDate, (String)"createdDate");
        Intrinsics.checkNotNullParameter((Object)lastModifiedDate, (String)"lastModifiedDate");
        this.email = email;
        this.password = password;
        this.roles = roles2;
        this.sharedLibrariesIds = sharedLibrariesIds;
        this.sharedAllLibraries = sharedAllLibraries;
        this.restrictions = restrictions;
        this.id = id;
        this.createdDate = createdDate;
        this.lastModifiedDate = lastModifiedDate;
        this.isAdmin$delegate = LazyKt.lazy((Function0)((Function0)new /* Unavailable Anonymous Inner Class!! */));
    }

    public /* synthetic */ KomgaUser(String string, String string2, Set set, Set set2, boolean bl, ContentRestrictions contentRestrictions, String string3, LocalDateTime localDateTime, LocalDateTime localDateTime2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            Object[] objectArray = new UserRoles[]{UserRoles.FILE_DOWNLOAD, UserRoles.PAGE_STREAMING};
            set = SetsKt.setOf((Object[])objectArray);
        }
        if ((n & 8) != 0) {
            set2 = SetsKt.emptySet();
        }
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            contentRestrictions = new ContentRestrictions(null, null, null, 7, null);
        }
        if ((n & 0x40) != 0) {
            String string4 = TsidCreator.getTsid256().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
            string3 = string4;
        }
        if ((n & 0x80) != 0) {
            LocalDateTime localDateTime3 = LocalDateTime.now();
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime3, (String)"now(...)");
            localDateTime = localDateTime3;
        }
        if ((n & 0x100) != 0) {
            localDateTime2 = localDateTime;
        }
        this(string, string2, set, set2, bl, contentRestrictions, string3, localDateTime, localDateTime2);
    }

    @NotNull
    public final String getEmail() {
        return this.email;
    }

    @NotNull
    public final String getPassword() {
        return this.password;
    }

    @NotNull
    public final Set<UserRoles> getRoles() {
        return this.roles;
    }

    @NotNull
    public final Set<String> getSharedLibrariesIds() {
        return this.sharedLibrariesIds;
    }

    public final boolean getSharedAllLibraries() {
        return this.sharedAllLibraries;
    }

    @NotNull
    public final ContentRestrictions getRestrictions() {
        return this.restrictions;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public LocalDateTime getCreatedDate() {
        return this.createdDate;
    }

    @NotNull
    public LocalDateTime getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final boolean isAdmin() {
        Lazy lazy = this.isAdmin$delegate;
        return (Boolean)lazy.getValue();
    }

    @Nullable
    public final Collection<String> getAuthorizedLibraryIds(@Nullable Collection<String> libraryIds) {
        Collection collection;
        if (!this.canAccessAllLibraries() && libraryIds != null) {
            collection = CollectionsKt.intersect((Iterable)libraryIds, (Iterable)this.sharedLibrariesIds);
        } else if (!this.canAccessAllLibraries() && libraryIds == null) {
            collection = this.sharedLibrariesIds;
        } else {
            collection = libraryIds;
            if (collection == null) {
                collection = null;
            }
        }
        return collection;
    }

    public final boolean canAccessAllLibraries() {
        return this.sharedAllLibraries || this.isAdmin();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canAccessLibrary(@NotNull String libraryId) {
        String it;
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        if (this.canAccessAllLibraries()) return true;
        Iterable $this$any$iv = this.sharedLibrariesIds;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!Intrinsics.areEqual((Object)it, (Object)libraryId));
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canAccessLibrary(@NotNull Library library) {
        String it;
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        if (this.canAccessAllLibraries()) return true;
        Iterable $this$any$iv = this.sharedLibrariesIds;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!Intrinsics.areEqual((Object)it, (Object)library.getId()));
        return true;
    }

    public final boolean isContentAllowed(@Nullable Integer ageRating, @NotNull Set<String> sharingLabels) {
        boolean ageDenied;
        boolean allowed;
        Intrinsics.checkNotNullParameter(sharingLabels, (String)"sharingLabels");
        Set labels = CollectionsKt.toSet((Iterable)LanguageUtilsKt.lowerNotBlank((Iterable)sharingLabels));
        AgeRestriction ageRestriction = this.restrictions.getAgeRestriction();
        Boolean ageAllowed = (ageRestriction != null ? ageRestriction.getRestriction() : null) == AllowExclude.ALLOW_ONLY ? Boolean.valueOf(ageRating != null && ageRating <= this.restrictions.getAgeRestriction().getAge()) : null;
        Boolean labelAllowed = !((Collection)this.restrictions.getLabelsAllow()).isEmpty() ? Boolean.valueOf(!((Collection)CollectionsKt.intersect((Iterable)this.restrictions.getLabelsAllow(), (Iterable)labels)).isEmpty()) : null;
        boolean bl = ageAllowed == null ? !Intrinsics.areEqual(labelAllowed, (Object)false) : (labelAllowed == null ? !Intrinsics.areEqual((Object)ageAllowed, (Object)false) : (allowed = !Intrinsics.areEqual((Object)ageAllowed, (Object)false) || !Intrinsics.areEqual((Object)labelAllowed, (Object)false)));
        if (!allowed) {
            return false;
        }
        AgeRestriction ageRestriction2 = this.restrictions.getAgeRestriction();
        boolean bl2 = (ageRestriction2 != null ? ageRestriction2.getRestriction() : null) == AllowExclude.EXCLUDE ? ageRating != null && ageRating >= this.restrictions.getAgeRestriction().getAge() : (ageDenied = false);
        boolean labelDenied = !((Collection)this.restrictions.getLabelsExclude()).isEmpty() ? !((Collection)CollectionsKt.intersect((Iterable)this.restrictions.getLabelsExclude(), (Iterable)labels)).isEmpty() : false;
        return !ageDenied && !labelDenied;
    }

    public static /* synthetic */ boolean isContentAllowed$default(KomgaUser komgaUser, Integer n, Set set, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        if ((n2 & 2) != 0) {
            set = SetsKt.emptySet();
        }
        return komgaUser.isContentAllowed(n, set);
    }

    @NotNull
    public String toString() {
        return "KomgaUser(createdDate=" + this.getCreatedDate() + ", email='" + this.email + "', roles=" + this.roles + ", sharedLibrariesIds=" + this.sharedLibrariesIds + ", sharedAllLibraries=" + this.sharedAllLibraries + ", restrictions=" + this.restrictions + ", id='" + this.id + "', lastModifiedDate=" + this.getLastModifiedDate() + ")";
    }

    @NotNull
    public final String component1() {
        return this.email;
    }

    @NotNull
    public final String component2() {
        return this.password;
    }

    @NotNull
    public final Set<UserRoles> component3() {
        return this.roles;
    }

    @NotNull
    public final Set<String> component4() {
        return this.sharedLibrariesIds;
    }

    public final boolean component5() {
        return this.sharedAllLibraries;
    }

    @NotNull
    public final ContentRestrictions component6() {
        return this.restrictions;
    }

    @NotNull
    public final String component7() {
        return this.id;
    }

    @NotNull
    public final LocalDateTime component8() {
        return this.createdDate;
    }

    @NotNull
    public final LocalDateTime component9() {
        return this.lastModifiedDate;
    }

    @NotNull
    public final KomgaUser copy(@Email(regexp=".+@.+\\..+") @NotBlank @NotNull String email, @NotBlank @NotNull String password, @NotNull Set<? extends UserRoles> roles2, @NotNull Set<String> sharedLibrariesIds, boolean sharedAllLibraries, @NotNull ContentRestrictions restrictions, @NotNull String id, @NotNull LocalDateTime createdDate, @NotNull LocalDateTime lastModifiedDate) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter(roles2, (String)"roles");
        Intrinsics.checkNotNullParameter(sharedLibrariesIds, (String)"sharedLibrariesIds");
        Intrinsics.checkNotNullParameter((Object)restrictions, (String)"restrictions");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)createdDate, (String)"createdDate");
        Intrinsics.checkNotNullParameter((Object)lastModifiedDate, (String)"lastModifiedDate");
        return new KomgaUser(email, password, roles2, sharedLibrariesIds, sharedAllLibraries, restrictions, id, createdDate, lastModifiedDate);
    }

    public static /* synthetic */ KomgaUser copy$default(KomgaUser komgaUser, String string, String string2, Set set, Set set2, boolean bl, ContentRestrictions contentRestrictions, String string3, LocalDateTime localDateTime, LocalDateTime localDateTime2, int n, Object object) {
        if ((n & 1) != 0) {
            string = komgaUser.email;
        }
        if ((n & 2) != 0) {
            string2 = komgaUser.password;
        }
        if ((n & 4) != 0) {
            set = komgaUser.roles;
        }
        if ((n & 8) != 0) {
            set2 = komgaUser.sharedLibrariesIds;
        }
        if ((n & 0x10) != 0) {
            bl = komgaUser.sharedAllLibraries;
        }
        if ((n & 0x20) != 0) {
            contentRestrictions = komgaUser.restrictions;
        }
        if ((n & 0x40) != 0) {
            string3 = komgaUser.id;
        }
        if ((n & 0x80) != 0) {
            localDateTime = komgaUser.createdDate;
        }
        if ((n & 0x100) != 0) {
            localDateTime2 = komgaUser.lastModifiedDate;
        }
        return komgaUser.copy(string, string2, set, set2, bl, contentRestrictions, string3, localDateTime, localDateTime2);
    }

    public int hashCode() {
        int result2 = this.email.hashCode();
        result2 = result2 * 31 + this.password.hashCode();
        result2 = result2 * 31 + ((Object)this.roles).hashCode();
        result2 = result2 * 31 + ((Object)this.sharedLibrariesIds).hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.sharedAllLibraries);
        result2 = result2 * 31 + this.restrictions.hashCode();
        result2 = result2 * 31 + this.id.hashCode();
        result2 = result2 * 31 + this.createdDate.hashCode();
        result2 = result2 * 31 + this.lastModifiedDate.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KomgaUser)) {
            return false;
        }
        KomgaUser komgaUser = (KomgaUser)other;
        if (!Intrinsics.areEqual((Object)this.email, (Object)komgaUser.email)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.password, (Object)komgaUser.password)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.roles, (Object)komgaUser.roles)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sharedLibrariesIds, (Object)komgaUser.sharedLibrariesIds)) {
            return false;
        }
        if (this.sharedAllLibraries != komgaUser.sharedAllLibraries) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.restrictions, (Object)komgaUser.restrictions)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.id, (Object)komgaUser.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.createdDate, (Object)komgaUser.createdDate)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.lastModifiedDate, (Object)komgaUser.lastModifiedDate);
    }
}

