/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.domain.service;

import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.AccessDeniedException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.build.AbstractOriginSupplier;
import org.gotson.komga.domain.model.Book;
import org.gotson.komga.domain.model.BookPage;
import org.gotson.komga.domain.model.BookWithMedia;
import org.gotson.komga.domain.model.Dimension;
import org.gotson.komga.domain.model.Media;
import org.gotson.komga.domain.model.MediaContainerEntry;
import org.gotson.komga.domain.model.MediaExtension;
import org.gotson.komga.domain.model.MediaExtensionEpub;
import org.gotson.komga.domain.model.MediaFile;
import org.gotson.komga.domain.model.MediaNotReadyException;
import org.gotson.komga.domain.model.MediaProfile;
import org.gotson.komga.domain.model.MediaType;
import org.gotson.komga.domain.model.MediaUnsupportedException;
import org.gotson.komga.domain.model.NoThumbnailFoundException;
import org.gotson.komga.domain.model.ThumbnailBook;
import org.gotson.komga.domain.model.TypedBytes;
import org.gotson.komga.domain.service.BookAnalyzer;
import org.gotson.komga.domain.service.BookAnalyzerKt;
import org.gotson.komga.infrastructure.configuration.KomgaSettingsProvider;
import org.gotson.komga.infrastructure.hash.Hasher;
import org.gotson.komga.infrastructure.image.ImageAnalyzer;
import org.gotson.komga.infrastructure.image.ImageConverter;
import org.gotson.komga.infrastructure.image.ImageType;
import org.gotson.komga.infrastructure.mediacontainer.ContentDetector;
import org.gotson.komga.infrastructure.mediacontainer.divina.DivinaExtractor;
import org.gotson.komga.infrastructure.mediacontainer.epub.EpubExtractor;
import org.gotson.komga.infrastructure.mediacontainer.epub.EpubKt;
import org.gotson.komga.infrastructure.mediacontainer.epub.EpubPackage;
import org.gotson.komga.infrastructure.mediacontainer.epub.OpfKt;
import org.gotson.komga.infrastructure.mediacontainer.pdf.PdfExtractor;
import org.gotson.komga.infrastructure.util.ZipFileUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.parser.Parser;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u00002\u00020\u0001Bi\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0001\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\b\b\u0001\u0010\u0015\u001a\u00020\u0016\u0012\b\b\u0001\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0018J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J \u0010$\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010%\u001a\u00020&2\u0006\u0010\"\u001a\u00020#H\u0012J\u0018\u0010'\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0012J\u0018\u0010(\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0012J\u0010\u0010)\u001a\u00020*2\u0006\u0010 \u001a\u00020+H\u0016J\u0018\u0010,\u001a\u00020-2\u0006\u0010 \u001a\u00020+2\u0006\u0010.\u001a\u00020\u001bH\u0016J\u0018\u0010/\u001a\u00020-2\u0006\u0010 \u001a\u00020+2\u0006\u00100\u001a\u00020\u0012H\u0016J\u0018\u00101\u001a\u0002022\u0006\u0010 \u001a\u00020+2\u0006\u00100\u001a\u00020\u0012H\u0016J\u0016\u00103\u001a\b\u0012\u0004\u0012\u0002040\u00052\u0006\u00105\u001a\u00020\u001fH\u0016J\u0012\u00106\u001a\u0004\u0018\u0001022\u0006\u0010 \u001a\u00020+H\u0016J\u0018\u00107\u001a\u00020\u001b2\u0006\u00108\u001a\u0002042\u0006\u00109\u001a\u00020-H\u0016J\u0010\u0010:\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020+H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00060\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\t\u001a\u00020\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/gotson/komga/domain/service/BookAnalyzer;", "", "contentDetector", "Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;", "extractors", "", "Lorg/gotson/komga/infrastructure/mediacontainer/divina/DivinaExtractor;", "pdfExtractor", "Lorg/gotson/komga/infrastructure/mediacontainer/pdf/PdfExtractor;", "epubExtractor", "Lorg/gotson/komga/infrastructure/mediacontainer/epub/EpubExtractor;", "imageConverter", "Lorg/gotson/komga/infrastructure/image/ImageConverter;", "imageAnalyzer", "Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;", "hasher", "Lorg/gotson/komga/infrastructure/hash/Hasher;", "pageHashing", "", "komgaSettingsProvider", "Lorg/gotson/komga/infrastructure/configuration/KomgaSettingsProvider;", "thumbnailType", "Lorg/gotson/komga/infrastructure/image/ImageType;", "pdfImageType", "(Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;Ljava/util/List;Lorg/gotson/komga/infrastructure/mediacontainer/pdf/PdfExtractor;Lorg/gotson/komga/infrastructure/mediacontainer/epub/EpubExtractor;Lorg/gotson/komga/infrastructure/image/ImageConverter;Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;Lorg/gotson/komga/infrastructure/hash/Hasher;ILorg/gotson/komga/infrastructure/configuration/KomgaSettingsProvider;Lorg/gotson/komga/infrastructure/image/ImageType;Lorg/gotson/komga/infrastructure/image/ImageType;)V", "divinaExtractors", "", "", "getDivinaExtractors", "()Ljava/util/Map;", "analyze", "Lorg/gotson/komga/domain/model/Media;", "book", "Lorg/gotson/komga/domain/model/Book;", "analyzeDimensions", "", "analyzeDivina", "mediaType", "Lorg/gotson/komga/domain/model/MediaType;", "analyzeEpub", "analyzePdf", "generateThumbnail", "Lorg/gotson/komga/domain/model/ThumbnailBook;", "Lorg/gotson/komga/domain/model/BookWithMedia;", "getFileContent", "", "fileName", "getPageContent", "number", "getPageContentRaw", "Lorg/gotson/komga/domain/model/TypedBytes;", "getPdfPagesDynamic", "Lorg/gotson/komga/domain/model/BookPage;", "media", "getPoster", "hashPage", "page", "content", "hashPages", "komga"})
@SourceDebugExtension(value={"SMAP\nBookAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookAnalyzer.kt\norg/gotson/komga/domain/service/BookAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Epub.kt\norg/gotson/komga/infrastructure/mediacontainer/epub/EpubKt\n+ 5 ZipFileUtils.kt\norg/gotson/komga/infrastructure/util/ZipFileUtilsKt\n*L\n1#1,423:1\n1360#2:424\n1446#2,2:425\n1549#2:427\n1620#2,3:428\n1448#2,3:431\n3190#2,4:434\n3194#2,6:439\n1549#2:445\n1620#2,3:446\n766#2:449\n857#2,2:450\n1549#2:452\n1620#2,3:453\n1549#2:456\n1620#2,3:457\n3190#2,10:467\n1549#2:477\n1620#2,3:478\n1549#2:482\n1620#2,3:483\n1559#2:486\n1590#2,4:487\n1549#2:491\n1620#2,3:492\n1#3:438\n1#3:464\n21#4:460\n22#4,2:462\n24#4,2:465\n26#4:481\n8#5:461\n*S KotlinDebug\n*F\n+ 1 BookAnalyzer.kt\norg/gotson/komga/domain/service/BookAnalyzer\n*L\n57#1:424\n57#1:425,2\n57#1:427\n57#1:428,3\n57#1:431,3\n116#1:434,4\n116#1:439,6\n120#1:445\n120#1:446,3\n127#1:449\n127#1:450,2\n128#1:452\n128#1:453,3\n138#1:456\n138#1:457,3\n148#1:467,10\n202#1:477\n202#1:478,3\n236#1:482\n236#1:483,3\n376#1:486\n376#1:487,4\n415#1:491\n415#1:492,3\n147#1:464\n147#1:460\n147#1:462,2\n147#1:465,2\n147#1:481\n147#1:461\n*E\n"})
public class BookAnalyzer {
    @NotNull
    private final ContentDetector contentDetector;
    @NotNull
    private final PdfExtractor pdfExtractor;
    @NotNull
    private final EpubExtractor epubExtractor;
    @NotNull
    private final ImageConverter imageConverter;
    @NotNull
    private final ImageAnalyzer imageAnalyzer;
    @NotNull
    private final Hasher hasher;
    private final int pageHashing;
    @NotNull
    private final KomgaSettingsProvider komgaSettingsProvider;
    @NotNull
    private final ImageType thumbnailType;
    @NotNull
    private final ImageType pdfImageType;
    @NotNull
    private final Map<String, DivinaExtractor> divinaExtractors;

    /*
     * WARNING - void declaration
     */
    public BookAnalyzer(@NotNull ContentDetector contentDetector, @NotNull List<? extends DivinaExtractor> extractors, @NotNull PdfExtractor pdfExtractor, @NotNull EpubExtractor epubExtractor, @NotNull ImageConverter imageConverter, @NotNull ImageAnalyzer imageAnalyzer, @NotNull Hasher hasher, @Value(value="#{@komgaProperties.pageHashing}") int pageHashing, @NotNull KomgaSettingsProvider komgaSettingsProvider, @Qualifier(value="thumbnailType") @NotNull ImageType thumbnailType, @Qualifier(value="pdfImageType") @NotNull ImageType pdfImageType) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)contentDetector, (String)"contentDetector");
        Intrinsics.checkNotNullParameter(extractors, (String)"extractors");
        Intrinsics.checkNotNullParameter((Object)pdfExtractor, (String)"pdfExtractor");
        Intrinsics.checkNotNullParameter((Object)epubExtractor, (String)"epubExtractor");
        Intrinsics.checkNotNullParameter((Object)imageConverter, (String)"imageConverter");
        Intrinsics.checkNotNullParameter((Object)imageAnalyzer, (String)"imageAnalyzer");
        Intrinsics.checkNotNullParameter((Object)hasher, (String)"hasher");
        Intrinsics.checkNotNullParameter((Object)komgaSettingsProvider, (String)"komgaSettingsProvider");
        Intrinsics.checkNotNullParameter((Object)thumbnailType, (String)"thumbnailType");
        Intrinsics.checkNotNullParameter((Object)pdfImageType, (String)"pdfImageType");
        this.contentDetector = contentDetector;
        this.pdfExtractor = pdfExtractor;
        this.epubExtractor = epubExtractor;
        this.imageConverter = imageConverter;
        this.imageAnalyzer = imageAnalyzer;
        this.hasher = hasher;
        this.pageHashing = pageHashing;
        this.komgaSettingsProvider = komgaSettingsProvider;
        this.thumbnailType = thumbnailType;
        this.pdfImageType = pdfImageType;
        Iterable iterable = extractors;
        BookAnalyzer bookAnalyzer = this;
        boolean $i$f$flatMap = false;
        void var14_15 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            DivinaExtractor e = (DivinaExtractor)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = e.mediaTypes();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(TuplesKt.to((Object)it, (Object)e));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        bookAnalyzer.divinaExtractors = MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public Map<String, DivinaExtractor> getDivinaExtractors() {
        return this.divinaExtractors;
    }

    @NotNull
    public Media analyze(@NotNull Book book, boolean analyzeDimensions) {
        Media media;
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        BookAnalyzerKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        try {
            String it = this.contentDetector.detectMediaType(book.getPath());
            boolean bl = false;
            BookAnalyzerKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
            MediaType mediaType2 = MediaType.Companion.fromMediaType(it);
            if (mediaType2 == null) {
                Media.Status status = Media.Status.UNSUPPORTED;
                String string = book.getId();
                return new Media(status, it, null, 0, null, "ERR_1001", null, string, false, false, null, null, 3932, null);
            }
            MediaType mediaType3 = mediaType2;
            String string = PathsKt.getExtension((Path)book.getPath()).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            if (Intrinsics.areEqual((Object)string, (Object)"epub") && mediaType3 != MediaType.EPUB) {
                if (this.epubExtractor.isEpub(book.getPath())) {
                    mediaType3 = MediaType.EPUB;
                } else {
                    BookAnalyzerKt.access$getLogger$p().warn((Function0)new /* Unavailable Anonymous Inner Class!! */);
                    String string2 = mediaType3.getType();
                    Media.Status status = Media.Status.ERROR;
                    String string3 = book.getId();
                    return new Media(status, string2, null, 0, null, "ERR_1032", null, string3, false, false, null, null, 3932, null);
                }
            }
            media = Media.copy$default((Media)(switch (WhenMappings.$EnumSwitchMapping$0[mediaType3.getProfile().ordinal()]) {
                case 1 -> this.analyzeDivina(book, mediaType3, analyzeDimensions);
                case 2 -> this.analyzePdf(book, analyzeDimensions);
                case 3 -> this.analyzeEpub(book, analyzeDimensions);
                default -> throw new NoWhenBranchMatchedException();
            }), null, (String)mediaType3.getType(), null, (int)0, null, null, null, null, (boolean)false, (boolean)false, null, null, (int)4093, null);
        }
        catch (AccessDeniedException ade) {
            BookAnalyzerKt.access$getLogger$p().error((Throwable)ade, (Function0)new /* Unavailable Anonymous Inner Class!! */);
            media = new Media(Media.Status.ERROR, null, null, 0, null, "ERR_1000", null, null, false, false, null, null, 4062, null);
        }
        catch (NoSuchFileException ex) {
            BookAnalyzerKt.access$getLogger$p().error((Throwable)ex, (Function0)new /* Unavailable Anonymous Inner Class!! */);
            media = new Media(Media.Status.ERROR, null, null, 0, null, "ERR_1018", null, null, false, false, null, null, 4062, null);
        }
        catch (Exception ex) {
            BookAnalyzerKt.access$getLogger$p().error((Throwable)ex, (Function0)new /* Unavailable Anonymous Inner Class!! */);
            media = new Media(Media.Status.ERROR, null, null, 0, null, "ERR_1005", null, null, false, false, null, null, 4062, null);
        }
        return Media.copy$default((Media)media, null, null, null, (int)0, null, null, null, (String)book.getId(), (boolean)false, (boolean)false, null, null, (int)3967, null);
    }

    /*
     * WARNING - void declaration
     */
    private Media analyzeDivina(Book book, MediaType mediaType2, boolean analyzeDimensions) {
        String entriesErrorSummary2;
        Collection collection;
        Collection collection2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$mapTo$iv$iv2;
        MediaContainerEntry entry;
        void $this$partition$iv;
        Object object;
        try {
            Object object2 = (DivinaExtractor)this.getDivinaExtractors().get(mediaType2.getType());
            if (object2 == null || (object2 = object2.getEntries(book.getPath(), analyzeDimensions)) == null) {
                return new Media(Media.Status.UNSUPPORTED, null, null, 0, null, null, null, null, false, false, null, null, 4094, null);
            }
            object = object2;
        }
        catch (MediaUnsupportedException ex) {
            return new Media(Media.Status.UNSUPPORTED, null, null, 0, null, ex.getCode(), null, null, false, false, null, null, 4062, null);
        }
        catch (Exception ex) {
            BookAnalyzerKt.access$getLogger$p().error((Throwable)ex, (Function0)new /* Unavailable Anonymous Inner Class!! */);
            return new Media(Media.Status.ERROR, null, null, 0, null, "ERR_1008", null, null, false, false, null, null, 4062, null);
        }
        Object entries2 = object;
        Iterable ex = (Iterable)entries2;
        boolean $i$f$partition22 = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            boolean bl;
            entry = (MediaContainerEntry)element$iv;
            boolean bl2 = false;
            if (entry.getMediaType() != null) {
                String it;
                boolean bl3 = false;
                bl = this.contentDetector.isImage(it);
            } else {
                bl = false;
            }
            if (bl) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair $i$f$partition22 = new Pair(first$iv, second$iv);
        boolean bl = false;
        List images = (List)$i$f$partition22.component1();
        Iterable others = (List)$i$f$partition22.component2();
        Iterable $this$map$iv2 = images;
        boolean $i$f$map = false;
        Iterable bl3 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            MediaContainerEntry mediaContainerEntry = (MediaContainerEntry)item$iv$iv;
            Collection collection3 = destination$iv$iv;
            boolean bl4 = false;
            String string = it.getName();
            String string2 = it.getMediaType();
            Intrinsics.checkNotNull((Object)string2);
            collection3.add(new BookPage(string, string2, it.getDimension(), null, it.getFileSize(), 8, null));
        }
        List list = others;
        List list2 = (List)destination$iv$iv;
        object = new Pair((Object)list2, (Object)list);
        List pages = (List)object.component1();
        List others2 = (List)object.component2();
        others = others2;
        boolean $i$f$filter = false;
        entry = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MediaContainerEntry it = (MediaContainerEntry)element$iv$iv;
            boolean bl5 = false;
            CharSequence charSequence = it.getMediaType();
            boolean bl6 = charSequence == null || StringsKt.isBlank((CharSequence)charSequence);
            if (!bl6) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            MediaContainerEntry it = (MediaContainerEntry)item$iv$iv;
            collection2 = destination$iv$iv2;
            boolean bl7 = false;
            collection2.add(it.getName());
        }
        $this$map$iv = (List)destination$iv$iv2;
        if ($this$map$iv.isEmpty()) {
            boolean bl8 = false;
            collection = null;
        } else {
            collection = $this$map$iv;
        }
        images = (List)collection;
        String string = entriesErrorSummary2 = images != null ? CollectionsKt.joinToString$default((Iterable)images, null, (CharSequence)"ERR_1007 [", (CharSequence)"]", (int)0, null, (Function1)((Function1)analyzeDivina.entriesErrorSummary.4.INSTANCE), (int)25, null) : null;
        if (pages.isEmpty()) {
            BookAnalyzerKt.access$getLogger$p().warn((Function0)new /* Unavailable Anonymous Inner Class!! */);
            return new Media(Media.Status.ERROR, null, null, 0, null, "ERR_1006", null, null, false, false, null, null, 4062, null);
        }
        BookAnalyzerKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        $this$map$iv = others2;
        $i$f$map2 = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            MediaContainerEntry it = (MediaContainerEntry)item$iv$iv;
            collection2 = destination$iv$iv2;
            boolean bl9 = false;
            collection2.add(new MediaFile(it.getName(), it.getMediaType(), null, it.getFileSize(), 4, null));
        }
        List files = (List)destination$iv$iv2;
        return new Media(Media.Status.READY, null, pages, pages.size(), files, entriesErrorSummary2, null, null, false, false, null, null, 4034, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private Media analyzeEpub(Book book, boolean analyzeDimensions) {
        Path $this$epub$iv = book.getPath();
        boolean $i$f$epub = false;
        AbstractOriginSupplier abstractOriginSupplier = ZipFile.builder().setPath($this$epub$iv);
        Intrinsics.checkNotNullExpressionValue((Object)abstractOriginSupplier, (String)"setPath(...)");
        ZipFile.Builder $this$use$iv$iv = (ZipFile.Builder)abstractOriginSupplier;
        boolean $i$f$use = false;
        Closeable closeable = (Closeable)$this$use$iv$iv.get();
        Throwable throwable = null;
        try {
            Object object;
            Iterable iterable;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List e5;
            List e22;
            List e32;
            List e42;
            List list2;
            Document document;
            Document document2;
            ZipFile zip$iv = (ZipFile)closeable;
            boolean bl = false;
            String opfFile$iv = EpubKt.getPackagePath((ZipFile)zip$iv);
            InputStream inputStream = ZipFileUtilsKt.getEntryInputStream((ZipFile)zip$iv, (String)opfFile$iv);
            if (inputStream != null) {
                Closeable closeable2 = inputStream;
                Throwable throwable2 = null;
                try {
                    InputStream it$iv = (InputStream)closeable2;
                    boolean bl2 = false;
                    Document document3 = Jsoup.parse((InputStream)it$iv, null, (String)"", (Parser)Parser.xmlParser());
                    document2 = document3;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
            } else {
                document2 = null;
            }
            Document document4 = document = document2;
            if (document4 == null) {
                throw new MediaUnsupportedException("Could not open OPF resource", null, 2, null);
            }
            Intrinsics.checkNotNull(document4);
            Document opfDoc$iv = document;
            Path opfDir$iv = Paths.get(opfFile$iv, new String[0]).getParent();
            EpubPackage epub = new EpubPackage(zip$iv, opfDoc$iv, opfDir$iv, OpfKt.getManifest((Document)opfDoc$iv));
            boolean bl3 = false;
            Iterable $this$partition$iv = this.epubExtractor.getResources(epub);
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                MediaFile it = (MediaFile)element$iv;
                boolean list2 = false;
                if (it.getFileSize() != null) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List resources2 = (List)pair.component1();
            List missingResources = (List)pair.component2();
            boolean isFixedLayout = this.epubExtractor.isFixedLayout(epub);
            int pageCount = this.epubExtractor.computePageCount(epub);
            boolean isKepub2 = this.epubExtractor.isKepub(epub, resources2);
            List errors = new ArrayList();
            try {
                list2 = this.epubExtractor.getToc(epub);
            }
            catch (Exception e42) {
                BookAnalyzerKt.access$getLogger$p().error((Throwable)e42, (Function0)analyzeEpub.1.toc.1.INSTANCE);
                errors.add("ERR_1035");
                list2 = CollectionsKt.emptyList();
            }
            List toc2 = list2;
            try {
                e42 = this.epubExtractor.getLandmarks(epub);
            }
            catch (Exception e32) {
                BookAnalyzerKt.access$getLogger$p().error((Throwable)e32, (Function0)analyzeEpub.1.landmarks.1.INSTANCE);
                errors.add("ERR_1036");
                e42 = CollectionsKt.emptyList();
            }
            List landmarks2 = e42;
            try {
                e32 = this.epubExtractor.getPageList(epub);
            }
            catch (Exception e22) {
                BookAnalyzerKt.access$getLogger$p().error((Throwable)e22, (Function0)analyzeEpub.1.pageList.1.INSTANCE);
                errors.add("ERR_1037");
                e32 = CollectionsKt.emptyList();
            }
            List pageList2 = e32;
            try {
                e22 = this.epubExtractor.getDivinaPages(epub, isFixedLayout, pageCount, analyzeDimensions);
            }
            catch (Exception e5) {
                BookAnalyzerKt.access$getLogger$p().error((Throwable)e5, (Function0)analyzeEpub.1.divinaPages.1.INSTANCE);
                errors.add("ERR_1038");
                e22 = CollectionsKt.emptyList();
            }
            List divinaPages2 = e22;
            try {
                e5 = this.epubExtractor.computePositions(epub, book.getPath(), resources2, isFixedLayout, isKepub2);
            }
            catch (Exception e6) {
                BookAnalyzerKt.access$getLogger$p().error((Throwable)e6, (Function0)analyzeEpub.1.positions.1.INSTANCE);
                errors.add("ERR_1039");
                e5 = CollectionsKt.emptyList();
            }
            List positions2 = e5;
            Object object2 = missingResources;
            boolean $i$f$map = false;
            MediaExtensionEpub mediaExtensionEpub = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MediaFile mediaFile = (MediaFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(it.getFileName());
            }
            object2 = (List)destination$iv$iv;
            if (object2.isEmpty()) {
                boolean bl5 = false;
                iterable = null;
            } else {
                iterable = object2;
            }
            List e6 = (List)iterable;
            String entriesErrorSummary2 = e6 != null ? CollectionsKt.joinToString$default((Iterable)e6, null, (CharSequence)"ERR_1033 [", (CharSequence)"]", (int)0, null, (Function1)((Function1)analyzeEpub.1.entriesErrorSummary.3.INSTANCE), (int)25, null) : null;
            object2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.filterNotNull((Iterable)CollectionsKt.plus((Collection)errors, entriesErrorSummary2)), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
            if (StringsKt.isBlank((CharSequence)object2)) {
                boolean bl6 = false;
                object = null;
            } else {
                object = object2;
            }
            String allErrors = (String)object;
            object2 = Media.Status.READY;
            boolean bl7 = !((Collection)divinaPages2).isEmpty();
            mediaExtensionEpub = new MediaExtensionEpub(toc2, landmarks2, pageList2, isFixedLayout, positions2);
            Media media = new Media((Media.Status)object2, null, divinaPages2, pageCount, resources2, allErrors, (MediaExtension)mediaExtensionEpub, null, bl7, isKepub2, null, null, 3202, null);
            return media;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Media analyzePdf(Book book, boolean analyzeDimensions) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.pdfExtractor.getPages(book.getPath(), analyzeDimensions);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MediaContainerEntry mediaContainerEntry = (MediaContainerEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new BookPage(it.getName(), "", it.getDimension(), null, null, 24, null));
        }
        List pages = (List)destination$iv$iv;
        return new Media(Media.Status.READY, null, pages, 0, null, null, null, null, false, false, null, null, 4090, null);
    }

    @NotNull
    public ThumbnailBook generateThumbnail(@NotNull BookWithMedia book) throws MediaNotReadyException, NoThumbnailFoundException {
        Object object;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)book, (String)"book");
                BookAnalyzerKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
                if (book.getMedia().getStatus() != Media.Status.READY) {
                    BookAnalyzerKt.access$getLogger$p().warn((Function0)new /* Unavailable Anonymous Inner Class!! */);
                    throw new MediaNotReadyException();
                }
                object = this.getPoster(book);
                if (object == null) break block5;
                TypedBytes cover = object;
                boolean bl = false;
                byte[] byArray = this.imageConverter.resizeImageToByteArray(cover.getBytes(), this.thumbnailType, this.komgaSettingsProvider.getThumbnailSize().getMaxEdge());
                object = byArray;
                if (byArray != null) break block6;
            }
            throw new NoThumbnailFoundException();
        }
        Object thumbnail = object;
        ThumbnailBook.Type type = ThumbnailBook.Type.GENERATED;
        String string = book.getBook().getId();
        String string2 = this.thumbnailType.getMediaType();
        Dimension dimension = this.imageAnalyzer.getDimension((InputStream)new ByteArrayInputStream((byte[])thumbnail));
        if (dimension == null) {
            dimension = new Dimension(0, 0);
        }
        Dimension dimension2 = dimension;
        long l = ((TypedBytes)thumbnail).length;
        return new ThumbnailBook((byte[])thumbnail, null, false, type, string2, l, dimension2, null, string, null, null, 1670, null);
    }

    @Nullable
    public TypedBytes getPoster(@NotNull BookWithMedia book) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        MediaProfile mediaProfile2 = book.getMedia().getProfile();
        return switch (mediaProfile2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[mediaProfile2.ordinal()]) {
            case 1 -> {
                byte[] var3_3;
                DivinaExtractor var2_2 = (DivinaExtractor)this.getDivinaExtractors().get(book.getMedia().getMediaType());
                if (var2_2 != null && (var3_3 = var2_2.getEntryStream(book.getBook().getPath(), ((BookPage)CollectionsKt.first((List)book.getMedia().getPages())).getFileName())) != null) {
                    byte[] it = var3_3;
                    boolean $i$a$-let-BookAnalyzer$getPoster$1 = false;
                    yield new TypedBytes(it, ((BookPage)CollectionsKt.first((List)book.getMedia().getPages())).getMediaType());
                }
                yield null;
            }
            case 2 -> this.pdfExtractor.getPageContentAsImage(book.getBook().getPath(), 1);
            case 3 -> this.epubExtractor.getCover(book.getBook().getPath());
            case -1 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public byte[] getPageContent(@NotNull BookWithMedia book, int number) throws MediaNotReadyException, IndexOutOfBoundsException {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        BookAnalyzerKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
        if (book.getMedia().getStatus() != Media.Status.READY) {
            BookAnalyzerKt.access$getLogger$p().warn((Function0)getPageContent.2.INSTANCE);
            throw new MediaNotReadyException();
        }
        if (number > book.getMedia().getPageCount() || number <= 0) {
            BookAnalyzerKt.access$getLogger$p().error((Function0)new /* Unavailable Anonymous Inner Class!! */);
            throw new IndexOutOfBoundsException("Page " + number + " does not exist");
        }
        MediaProfile mediaProfile2 = book.getMedia().getProfile();
        return switch (mediaProfile2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[mediaProfile2.ordinal()]) {
            case 1 -> {
                Map v1 = this.getDivinaExtractors();
                String v2 = book.getMedia().getMediaType();
                Intrinsics.checkNotNull((Object)v2);
                yield ((DivinaExtractor)MapsKt.getValue((Map)v1, (Object)v2)).getEntryStream(book.getBook().getPath(), ((BookPage)book.getMedia().getPages().get(number - 1)).getFileName());
            }
            case 2 -> this.pdfExtractor.getPageContentAsImage(book.getBook().getPath(), number).getBytes();
            case 3 -> {
                if (book.getMedia().getEpubDivinaCompatible()) {
                    yield this.epubExtractor.getEntryStream(book.getBook().getPath(), ((BookPage)book.getMedia().getPages().get(number - 1)).getFileName());
                }
                throw new MediaUnsupportedException("Epub profile does not support getting page content", null, 2, null);
            }
            case -1 -> throw new MediaNotReadyException();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public TypedBytes getPageContentRaw(@NotNull BookWithMedia book, int number) throws MediaNotReadyException, IndexOutOfBoundsException {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        BookAnalyzerKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
        if (book.getMedia().getProfile() != MediaProfile.PDF) {
            throw new MediaUnsupportedException("Extractor does not support raw extraction of pages", null, 2, null);
        }
        if (book.getMedia().getStatus() != Media.Status.READY) {
            BookAnalyzerKt.access$getLogger$p().warn((Function0)getPageContentRaw.2.INSTANCE);
            throw new MediaNotReadyException();
        }
        if (number > book.getMedia().getPageCount() || number <= 0) {
            BookAnalyzerKt.access$getLogger$p().error((Function0)new /* Unavailable Anonymous Inner Class!! */);
            throw new IndexOutOfBoundsException("Page " + number + " does not exist");
        }
        return this.pdfExtractor.getPageContentAsPdf(book.getBook().getPath(), number);
    }

    @NotNull
    public byte[] getFileContent(@NotNull BookWithMedia book, @NotNull String fileName) throws MediaNotReadyException {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        BookAnalyzerKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
        if (book.getMedia().getStatus() != Media.Status.READY) {
            BookAnalyzerKt.access$getLogger$p().warn((Function0)getFileContent.2.INSTANCE);
            throw new MediaNotReadyException();
        }
        MediaProfile mediaProfile2 = book.getMedia().getProfile();
        return switch (mediaProfile2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[mediaProfile2.ordinal()]) {
            case 1 -> {
                Map v1 = this.getDivinaExtractors();
                String v2 = book.getMedia().getMediaType();
                Intrinsics.checkNotNull((Object)v2);
                yield ((DivinaExtractor)MapsKt.getValue((Map)v1, (Object)v2)).getEntryStream(book.getBook().getPath(), fileName);
            }
            case 3 -> this.epubExtractor.getEntryStream(book.getBook().getPath(), fileName);
            case -1, 2 -> throw new MediaUnsupportedException("Extractor does not support extraction of files", null, 2, null);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Media hashPages(@NotNull BookWithMedia book) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        Iterable $this$mapIndexed$iv = book.getMedia().getPages();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            BookPage bookPage;
            void index;
            void bookPage2;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            BookPage bookPage3 = (BookPage)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (StringsKt.isBlank((CharSequence)bookPage2.getFileHash()) && (index < this.pageHashing || index >= book.getMedia().getPageCount() - this.pageHashing)) {
                byte[] content = this.getPageContent(book, (int)(index + true));
                String hash = this.hashPage((BookPage)bookPage2, content);
                bookPage = BookPage.copy$default((BookPage)bookPage2, null, null, null, (String)hash, null, (int)23, null);
            } else {
                bookPage = bookPage2;
            }
            collection.add(bookPage);
        }
        List hashedPages = (List)destination$iv$iv;
        return Media.copy$default((Media)book.getMedia(), null, null, (List)hashedPages, (int)0, null, null, null, null, (boolean)false, (boolean)false, null, null, (int)4091, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String hashPage(@NotNull BookPage page, @NotNull byte[] content) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (Intrinsics.areEqual((Object)page.getMediaType(), (Object)ImageType.JPEG.getMediaType())) {
            Closeable closeable = new ByteArrayOutputStream();
            Throwable throwable = null;
            try {
                ByteArrayOutputStream buffer = (ByteArrayOutputStream)closeable;
                boolean bl = false;
                ImageIO.write((RenderedImage)ImageIO.read(new ByteArrayInputStream(content)), ImageType.JPEG.getImageIOFormat(), buffer);
                byte[] byArray2 = buffer.toByteArray();
                byArray = byArray2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            byArray = content;
        }
        byte[] bytes = byArray;
        Intrinsics.checkNotNull((Object)bytes);
        return this.hasher.computeHash((InputStream)new ByteArrayInputStream(bytes));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<BookPage> getPdfPagesDynamic(@NotNull Media media) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)media, (String)"media");
        if (media.getProfile() != MediaProfile.PDF) {
            throw new MediaUnsupportedException("Cannot get synthetic pages for non-PDF media", null, 2, null);
        }
        Iterable $this$map$iv = media.getPages();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Dimension dimension;
            void page;
            BookPage bookPage = (BookPage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v0 = page;
            String string = null;
            String string2 = this.pdfImageType.getMediaType();
            if (page.getDimension() != null) {
                void it;
                String string3 = string2;
                String string4 = string;
                void var14_14 = v0;
                boolean bl2 = false;
                Dimension dimension2 = this.pdfExtractor.scaleDimension((Dimension)it);
                v0 = var14_14;
                string = string4;
                string2 = string3;
                dimension = dimension2;
            } else {
                dimension = null;
            }
            collection.add(BookPage.copy$default((BookPage)v0, string, (String)string2, dimension, null, null, (int)25, null));
        }
        return (List)destination$iv$iv;
    }
}

