/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.domain.service;

import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.gotson.komga.application.tasks.TaskEmitter;
import org.gotson.komga.domain.model.Book;
import org.gotson.komga.domain.model.BookMetadata;
import org.gotson.komga.domain.model.CodedException;
import org.gotson.komga.domain.model.CopyMode;
import org.gotson.komga.domain.model.DomainEvent;
import org.gotson.komga.domain.model.ExceptionsKt;
import org.gotson.komga.domain.model.HistoricalEvent;
import org.gotson.komga.domain.model.Library;
import org.gotson.komga.domain.model.Media;
import org.gotson.komga.domain.model.PathContainedInPath;
import org.gotson.komga.domain.model.ReadList;
import org.gotson.komga.domain.model.ReadProgress;
import org.gotson.komga.domain.model.Series;
import org.gotson.komga.domain.model.Sidecar;
import org.gotson.komga.domain.model.ThumbnailBook;
import org.gotson.komga.domain.persistence.BookMetadataRepository;
import org.gotson.komga.domain.persistence.BookRepository;
import org.gotson.komga.domain.persistence.HistoricalEventRepository;
import org.gotson.komga.domain.persistence.LibraryRepository;
import org.gotson.komga.domain.persistence.MediaRepository;
import org.gotson.komga.domain.persistence.ReadListRepository;
import org.gotson.komga.domain.persistence.ReadProgressRepository;
import org.gotson.komga.domain.persistence.SeriesRepository;
import org.gotson.komga.domain.persistence.SidecarRepository;
import org.gotson.komga.domain.persistence.ThumbnailBookRepository;
import org.gotson.komga.domain.service.BookImporter;
import org.gotson.komga.domain.service.BookImporterKt;
import org.gotson.komga.domain.service.BookLifecycle;
import org.gotson.komga.domain.service.FileSystemScanner;
import org.gotson.komga.domain.service.FileSystemScannerKt;
import org.gotson.komga.domain.service.SeriesLifecycle;
import org.gotson.komga.language.LanguageUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B}\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\u0002\u0010 J8\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\n\b\u0002\u0010)\u001a\u0004\u0018\u00010*2\n\b\u0002\u0010+\u001a\u0004\u0018\u00010*H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/gotson/komga/domain/service/BookImporter;", "", "bookLifecycle", "Lorg/gotson/komga/domain/service/BookLifecycle;", "fileSystemScanner", "Lorg/gotson/komga/domain/service/FileSystemScanner;", "seriesLifecycle", "Lorg/gotson/komga/domain/service/SeriesLifecycle;", "bookRepository", "Lorg/gotson/komga/domain/persistence/BookRepository;", "mediaRepository", "Lorg/gotson/komga/domain/persistence/MediaRepository;", "metadataRepository", "Lorg/gotson/komga/domain/persistence/BookMetadataRepository;", "thumbnailBookRepository", "Lorg/gotson/komga/domain/persistence/ThumbnailBookRepository;", "readProgressRepository", "Lorg/gotson/komga/domain/persistence/ReadProgressRepository;", "readListRepository", "Lorg/gotson/komga/domain/persistence/ReadListRepository;", "libraryRepository", "Lorg/gotson/komga/domain/persistence/LibraryRepository;", "sidecarRepository", "Lorg/gotson/komga/domain/persistence/SidecarRepository;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "taskEmitter", "Lorg/gotson/komga/application/tasks/TaskEmitter;", "historicalEventRepository", "Lorg/gotson/komga/domain/persistence/HistoricalEventRepository;", "seriesRepository", "Lorg/gotson/komga/domain/persistence/SeriesRepository;", "(Lorg/gotson/komga/domain/service/BookLifecycle;Lorg/gotson/komga/domain/service/FileSystemScanner;Lorg/gotson/komga/domain/service/SeriesLifecycle;Lorg/gotson/komga/domain/persistence/BookRepository;Lorg/gotson/komga/domain/persistence/MediaRepository;Lorg/gotson/komga/domain/persistence/BookMetadataRepository;Lorg/gotson/komga/domain/persistence/ThumbnailBookRepository;Lorg/gotson/komga/domain/persistence/ReadProgressRepository;Lorg/gotson/komga/domain/persistence/ReadListRepository;Lorg/gotson/komga/domain/persistence/LibraryRepository;Lorg/gotson/komga/domain/persistence/SidecarRepository;Lorg/springframework/context/ApplicationEventPublisher;Lorg/gotson/komga/application/tasks/TaskEmitter;Lorg/gotson/komga/domain/persistence/HistoricalEventRepository;Lorg/gotson/komga/domain/persistence/SeriesRepository;)V", "importBook", "Lorg/gotson/komga/domain/model/Book;", "sourceFile", "Ljava/nio/file/Path;", "series", "Lorg/gotson/komga/domain/model/Series;", "copyMode", "Lorg/gotson/komga/domain/model/CopyMode;", "destinationName", "", "upgradeBookId", "komga"})
@SourceDebugExtension(value={"SMAP\nBookImporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookImporter.kt\norg/gotson/komga/domain/service/BookImporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,283:1\n1855#2,2:284\n1271#2,2:286\n1285#2,4:288\n1855#2,2:292\n1855#2,2:302\n1549#2:304\n1620#2,3:305\n1855#2,2:308\n1855#2:310\n1549#2:311\n1620#2,3:312\n1856#2:315\n215#3,2:294\n215#3,2:296\n215#3,2:298\n215#3,2:300\n215#3,2:316\n*S KotlinDebug\n*F\n+ 1 BookImporter.kt\norg/gotson/komga/domain/service/BookImporter\n*L\n79#1:284,2\n106#1:286,2\n106#1:288,4\n139#1:292,2\n217#1:302,2\n224#1:304\n224#1:305,3\n225#1:308,2\n230#1:310\n235#1:311\n235#1:312,3\n230#1:315\n150#1:294,2\n161#1:296,2\n173#1:298,2\n183#1:300,2\n258#1:316,2\n*E\n"})
public class BookImporter {
    @NotNull
    private final BookLifecycle bookLifecycle;
    @NotNull
    private final FileSystemScanner fileSystemScanner;
    @NotNull
    private final SeriesLifecycle seriesLifecycle;
    @NotNull
    private final BookRepository bookRepository;
    @NotNull
    private final MediaRepository mediaRepository;
    @NotNull
    private final BookMetadataRepository metadataRepository;
    @NotNull
    private final ThumbnailBookRepository thumbnailBookRepository;
    @NotNull
    private final ReadProgressRepository readProgressRepository;
    @NotNull
    private final ReadListRepository readListRepository;
    @NotNull
    private final LibraryRepository libraryRepository;
    @NotNull
    private final SidecarRepository sidecarRepository;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;
    @NotNull
    private final TaskEmitter taskEmitter;
    @NotNull
    private final HistoricalEventRepository historicalEventRepository;
    @NotNull
    private final SeriesRepository seriesRepository;

    public BookImporter(@NotNull BookLifecycle bookLifecycle, @NotNull FileSystemScanner fileSystemScanner, @NotNull SeriesLifecycle seriesLifecycle, @NotNull BookRepository bookRepository, @NotNull MediaRepository mediaRepository, @NotNull BookMetadataRepository metadataRepository, @NotNull ThumbnailBookRepository thumbnailBookRepository, @NotNull ReadProgressRepository readProgressRepository, @NotNull ReadListRepository readListRepository, @NotNull LibraryRepository libraryRepository, @NotNull SidecarRepository sidecarRepository, @NotNull ApplicationEventPublisher eventPublisher, @NotNull TaskEmitter taskEmitter, @NotNull HistoricalEventRepository historicalEventRepository, @NotNull SeriesRepository seriesRepository) {
        Intrinsics.checkNotNullParameter((Object)bookLifecycle, (String)"bookLifecycle");
        Intrinsics.checkNotNullParameter((Object)fileSystemScanner, (String)"fileSystemScanner");
        Intrinsics.checkNotNullParameter((Object)seriesLifecycle, (String)"seriesLifecycle");
        Intrinsics.checkNotNullParameter((Object)bookRepository, (String)"bookRepository");
        Intrinsics.checkNotNullParameter((Object)mediaRepository, (String)"mediaRepository");
        Intrinsics.checkNotNullParameter((Object)metadataRepository, (String)"metadataRepository");
        Intrinsics.checkNotNullParameter((Object)thumbnailBookRepository, (String)"thumbnailBookRepository");
        Intrinsics.checkNotNullParameter((Object)readProgressRepository, (String)"readProgressRepository");
        Intrinsics.checkNotNullParameter((Object)readListRepository, (String)"readListRepository");
        Intrinsics.checkNotNullParameter((Object)libraryRepository, (String)"libraryRepository");
        Intrinsics.checkNotNullParameter((Object)sidecarRepository, (String)"sidecarRepository");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)taskEmitter, (String)"taskEmitter");
        Intrinsics.checkNotNullParameter((Object)historicalEventRepository, (String)"historicalEventRepository");
        Intrinsics.checkNotNullParameter((Object)seriesRepository, (String)"seriesRepository");
        this.bookLifecycle = bookLifecycle;
        this.fileSystemScanner = fileSystemScanner;
        this.seriesLifecycle = seriesLifecycle;
        this.bookRepository = bookRepository;
        this.mediaRepository = mediaRepository;
        this.metadataRepository = metadataRepository;
        this.thumbnailBookRepository = thumbnailBookRepository;
        this.readProgressRepository = readProgressRepository;
        this.readListRepository = readListRepository;
        this.libraryRepository = libraryRepository;
        this.sidecarRepository = sidecarRepository;
        this.eventPublisher = eventPublisher;
        this.taskEmitter = taskEmitter;
        this.historicalEventRepository = historicalEventRepository;
        this.seriesRepository = seriesRepository;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Book importBook(@NotNull Path sourceFile, @NotNull Series series, @NotNull CopyMode copyMode, @Nullable String destinationName, @Nullable String upgradeBookId) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkNotNullParameter((Object)series, (String)"series");
        Intrinsics.checkNotNullParameter((Object)copyMode, (String)"copyMode");
        try {
            Object $this$forEach$iv;
            Book e32;
            CopyOption[] copyOptionArray;
            CopyOption[] copyOptionArray2;
            LinkOption[] linkOptionArray;
            Object sidecarPath;
            Object sidecar;
            Object it;
            boolean bl;
            Object object;
            String string;
            Path destDir;
            Book book;
            CharSequence charSequence;
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.notExists(sourceFile, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                throw ExceptionsKt.withCode((Exception)new FileNotFoundException("File not found: " + sourceFile), (String)"ERR_1018");
            }
            if (series.getOneshot() && ((charSequence = (CharSequence)upgradeBookId) == null || charSequence.length() == 0)) {
                throw new IllegalArgumentException("Destination series is oneshot but upgradeBookId is missing");
            }
            Iterable $this$forEach$iv2 = this.libraryRepository.findAll();
            boolean $i$f$forEach = false;
            Book book2 = $this$forEach$iv2.iterator();
            while (book2.hasNext()) {
                Object element$iv = book2.next();
                Library library = (Library)element$iv;
                boolean bl2 = false;
                if (!sourceFile.startsWith(library.getPath())) continue;
                throw new PathContainedInPath("Cannot import file that is part of an existing library", "ERR_1019");
            }
            if (upgradeBookId != null) {
                Book book3 = this.bookRepository.findByIdOrNull(upgradeBookId);
                if (book3 != null) {
                    Book it2 = book2 = book3;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it2.getSeriesId(), (Object)series.getId())) {
                        throw ExceptionsKt.withCode((Exception)new IllegalArgumentException("Book to upgrade (" + upgradeBookId + ") does not belong to series: " + series), (String)"ERR_1020");
                    }
                    book = book2;
                } else {
                    book = null;
                }
            } else {
                book = null;
            }
            Book bookToUpgrade = book;
            Path path2 = destDir = series.getOneshot() ? series.getPath().getParent() : series.getPath();
            if (destinationName != null) {
                Path path3 = Paths.get(destinationName + "." + PathsKt.getExtension((Path)sourceFile), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
                string = PathsKt.getName((Path)path3);
            } else {
                string = PathsKt.getName((Path)sourceFile);
            }
            Path destFile = destDir.resolve(string);
            Iterable $this$associateWith$iv = this.fileSystemScanner.scanBookSidecars(sourceFile);
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Object $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            Iterator iterator = $this$associateWithTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                String string2;
                Object t = iterator.next();
                Sidecar sidecar2 = (Sidecar)t;
                Object t2 = t;
                object = result$iv;
                bl = false;
                if (destinationName != null) {
                    URI uRI = it.getUrl().toURI();
                    Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toURI(...)");
                    Path path4 = Paths.get(uRI);
                    Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"get(...)");
                    string2 = StringsKt.replace((String)PathsKt.getName((Path)path4), (String)PathsKt.getNameWithoutExtension((Path)sourceFile), (String)destinationName, (boolean)true);
                } else {
                    URI uRI = it.getUrl().toURI();
                    Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toURI(...)");
                    Path path5 = Paths.get(uRI);
                    Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"get(...)");
                    string2 = PathsKt.getName((Path)path5);
                }
                Path path6 = destDir.resolve(string2);
                object.put(t2, path6);
            }
            Map sidecars = result$iv;
            boolean deletedUpgradedFile = false;
            Book book4 = bookToUpgrade;
            if ((book4 != null ? book4.getPath() : null) != null && Intrinsics.areEqual((Object)destFile, (Object)bookToUpgrade.getPath())) {
                BookImporterKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
                try {
                    Files.delete(bookToUpgrade.getPath());
                    this.historicalEventRepository.insert((HistoricalEvent)new HistoricalEvent.BookFileDeleted(bookToUpgrade, "File was deleted to import an upgrade"));
                    deletedUpgradedFile = true;
                }
                catch (NoSuchFileException e2) {
                    BookImporterKt.access$getLogger$p().warn((Function0)new /* Unavailable Anonymous Inner Class!! */);
                }
            } else {
                Intrinsics.checkNotNull((Object)destFile);
                LinkOption[] linkOptionArray3 = new LinkOption[]{};
                if (Files.exists(destFile, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) {
                    throw ExceptionsKt.withCode((Exception)new FileAlreadyExistsException("Destination file already exists: " + destFile), (String)"ERR_1021");
                }
            }
            Book book5 = bookToUpgrade;
            if ((book5 != null ? book5.getPath() : null) != null) {
                Iterable $this$forEach$iv3 = this.fileSystemScanner.scanBookSidecars(bookToUpgrade.getPath());
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv3) {
                    sidecar = (Sidecar)element$iv;
                    boolean bl4 = false;
                    URI uRI = sidecar.getUrl().toURI();
                    Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toURI(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)Paths.get(uRI), (String)"get(...)");
                    BookImporterKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
                    Files.deleteIfExists((Path)sidecarPath);
                }
            }
            switch (WhenMappings.$EnumSwitchMapping$0[copyMode.ordinal()]) {
                case 1: {
                    CopyOption[] copyOptionArray3;
                    BookImporterKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
                    $this$associateWithTo$iv$iv = sourceFile;
                    Intrinsics.checkNotNull((Object)destFile);
                    Path element$iv = destFile;
                    sidecarPath = new CopyOption[]{};
                    Intrinsics.checkNotNullExpressionValue((Object)Files.move((Path)$this$associateWithTo$iv$iv, element$iv, Arrays.copyOf(sidecarPath, ((CopyOption[])sidecarPath).length)), (String)"move(...)");
                    Object $this$forEach$iv4 = sidecars;
                    boolean $i$f$forEach3 = false;
                    for (Map.Entry entry : $this$forEach$iv4.entrySet()) {
                        Path sourcePath;
                        it = entry;
                        bl = false;
                        URI uRI = ((Sidecar)it.getKey()).getUrl().toURI();
                        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toURI(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)Paths.get(uRI), (String)"get(...)");
                        boolean bl2 = false;
                        BookImporterKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
                        linkOptionArray = sourcePath;
                        Object v = it.getValue();
                        Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                        copyOptionArray2 = (Path)v;
                        copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                        copyOptionArray3 = copyOptionArray;
                        Intrinsics.checkNotNullExpressionValue((Object)Files.move((Path)linkOptionArray, (Path)copyOptionArray2, Arrays.copyOf(copyOptionArray3, copyOptionArray3.length)), (String)"move(...)");
                    }
                    break;
                }
                case 2: {
                    CopyOption[] copyOptionArray3;
                    BookImporterKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
                    Object $this$forEach$iv4 = sourceFile;
                    Intrinsics.checkNotNull((Object)destFile);
                    Path $i$f$forEach3 = destFile;
                    it = new CopyOption[]{};
                    Intrinsics.checkNotNullExpressionValue((Object)Files.copy((Path)$this$forEach$iv4, $i$f$forEach3, Arrays.copyOf(it, ((CopyOption[])it).length)), (String)"copy(...)");
                    Map $this$forEach$iv3 = sidecars;
                    boolean $i$f$forEach2 = false;
                    for (Map.Entry entry : $this$forEach$iv3.entrySet()) {
                        Path sourcePath;
                        it = entry;
                        bl = false;
                        URI uRI = ((Sidecar)it.getKey()).getUrl().toURI();
                        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toURI(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)Paths.get(uRI), (String)"get(...)");
                        boolean bl3 = false;
                        BookImporterKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
                        linkOptionArray = sourcePath;
                        Object v = it.getValue();
                        Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                        copyOptionArray2 = (Path)v;
                        copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                        copyOptionArray3 = copyOptionArray;
                        Intrinsics.checkNotNullExpressionValue((Object)Files.copy((Path)linkOptionArray, (Path)copyOptionArray2, Arrays.copyOf(copyOptionArray3, copyOptionArray3.length)), (String)"copy(...)");
                    }
                    break;
                }
                case 3: {
                    Map $this$forEach$iv3;
                    try {
                        BookImporterKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
                        Files.createLink(destFile, sourceFile);
                        $this$forEach$iv3 = sidecars;
                        boolean $i$f$forEach4 = false;
                        for (Map.Entry entry : $this$forEach$iv3.entrySet()) {
                            Path sourcePath;
                            it = entry;
                            bl = false;
                            URI uRI = ((Sidecar)it.getKey()).getUrl().toURI();
                            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toURI(...)");
                            Intrinsics.checkNotNullExpressionValue((Object)Paths.get(uRI), (String)"get(...)");
                            boolean bl4 = false;
                            BookImporterKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
                            Object v = it.getValue();
                            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                            Files.deleteIfExists((Path)v);
                            Files.createLink((Path)it.getValue(), sourcePath);
                        }
                        break;
                    }
                    catch (Exception e32) {
                        BookImporterKt.access$getLogger$p().warn((Throwable)e32, (Function0)importBook.11.INSTANCE);
                        Path $i$f$forEach4 = sourceFile;
                        Intrinsics.checkNotNull((Object)destFile);
                        sidecar = destFile;
                        CopyOption[] bl5 = new CopyOption[]{};
                        Intrinsics.checkNotNullExpressionValue((Object)Files.copy($i$f$forEach4, (Path)sidecar, Arrays.copyOf(bl5, bl5.length)), (String)"copy(...)");
                        Map $this$forEach$iv5 = sidecars;
                        boolean $i$f$forEach5 = false;
                        Iterator iterator2 = $this$forEach$iv5.entrySet().iterator();
                        while (iterator2.hasNext()) {
                            Path bl4;
                            Map.Entry element$iv3;
                            Map.Entry it3 = element$iv3 = iterator2.next();
                            boolean bl52 = false;
                            URI uRI = ((Sidecar)it3.getKey()).getUrl().toURI();
                            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toURI(...)");
                            Intrinsics.checkNotNullExpressionValue((Object)Paths.get(uRI), (String)"get(...)");
                            Object v = it3.getValue();
                            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                            linkOptionArray = (LinkOption[])v;
                            copyOptionArray2 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                            copyOptionArray = copyOptionArray2;
                            Intrinsics.checkNotNullExpressionValue((Object)Files.copy(bl4, (Path)linkOptionArray, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"copy(...)");
                        }
                        break;
                    }
                }
            }
            Intrinsics.checkNotNull((Object)destFile);
            Book $i$f$forEach2 = this.fileSystemScanner.scanFile(destFile);
            if ($i$f$forEach2 == null || (e32 = Book.copy$default((Book)$i$f$forEach2, null, null, null, (long)0L, null, null, (int)0, null, null, (String)series.getLibraryId(), null, (boolean)series.getOneshot(), null, null, (int)13823, null)) == null) {
                throw ExceptionsKt.withCode((Exception)new IllegalStateException("Newly imported book could not be scanned: " + destFile), (String)"ERR_1022");
            }
            Book importedBook = e32;
            this.seriesLifecycle.addBooks(series, (Collection)CollectionsKt.listOf((Object)importedBook));
            if (bookToUpgrade != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Object element$iv;
                Media it4 = this.mediaRepository.findById(bookToUpgrade.getId());
                boolean bl6 = false;
                String $i$f$forEach5 = importedBook.getId();
                Media.Status status = Media.Status.OUTDATED;
                this.mediaRepository.update(Media.copy$default((Media)it4, (Media.Status)status, null, null, (int)0, null, null, null, (String)$i$f$forEach5, (boolean)false, (boolean)false, null, null, (int)3966, null));
                BookMetadata it2 = this.metadataRepository.findById(bookToUpgrade.getId());
                boolean $i$a$-let-BookImporter$importBook$1532 = false;
                this.metadataRepository.update(BookMetadata.copy$default((BookMetadata)it2, null, null, null, (float)0.0f, null, null, null, null, null, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (String)importedBook.getId(), null, null, (int)0x1BFFFF, null));
                $this$forEach$iv = this.thumbnailBookRepository.findAllByBookIdAndType(bookToUpgrade.getId(), SetsKt.setOf((Object)ThumbnailBook.Type.USER_UPLOADED));
                boolean $i$f$forEach6 = false;
                Iterator $i$a$-let-BookImporter$importBook$1532 = $this$forEach$iv.iterator();
                while ($i$a$-let-BookImporter$importBook$1532.hasNext()) {
                    element$iv = $i$a$-let-BookImporter$importBook$1532.next();
                    ThumbnailBook thumbnailBook = (ThumbnailBook)element$iv;
                    boolean bl62 = false;
                    this.thumbnailBookRepository.update(ThumbnailBook.copy$default((ThumbnailBook)thumbnailBook, null, null, (boolean)false, null, null, (long)0L, null, null, (String)importedBook.getId(), null, null, (int)1791, null));
                }
                $this$forEach$iv = this.readProgressRepository.findAllByBookId(bookToUpgrade.getId());
                boolean $i$f$map = false;
                $i$a$-let-BookImporter$importBook$1532 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean bl7 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it5;
                    ReadProgress bl52 = (ReadProgress)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl72 = false;
                    object.add(ReadProgress.copy$default((ReadProgress)it5, (String)importedBook.getId(), null, (int)0, (boolean)false, null, null, null, null, null, null, (int)1022, null));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$forEach3 = false;
                Iterator iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv = iterator2.next();
                    ReadProgress entry = (ReadProgress)element$iv;
                    boolean bl8 = false;
                    this.readProgressRepository.save(entry);
                }
                $this$forEach$iv = ReadListRepository.DefaultImpls.findAllContainingBookId$default((ReadListRepository)this.readListRepository, (String)bookToUpgrade.getId(), null, null, (int)4, null);
                $i$f$forEach3 = false;
                iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    Collection<String> collection;
                    void $this$mapTo$iv$iv2;
                    void $this$map$iv2;
                    element$iv = iterator2.next();
                    CopyOption[] copyOptionArray4 = (CopyOption[])element$iv;
                    boolean bl9 = false;
                    Collection collection2 = copyOptionArray4.getBookIds().values();
                    Intrinsics.checkNotNullExpressionValue(collection2, (String)"<get-values>(...)");
                    Iterable item$iv$iv = collection2;
                    boolean it5 = false;
                    String string3 = null;
                    linkOptionArray = null;
                    copyOptionArray2 = copyOptionArray4;
                    copyOptionArray = this.readListRepository;
                    boolean $i$f$map2 = false;
                    void var25_87 = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                        void it7;
                        String string4 = (String)item$iv$iv2;
                        collection = destination$iv$iv2;
                        boolean bl10 = false;
                        collection.add((String)(Intrinsics.areEqual((Object)it7, (Object)bookToUpgrade.getId()) ? importedBook.getId() : it7));
                    }
                    collection = (List)destination$iv$iv2;
                    copyOptionArray.update(ReadList.copy$default((ReadList)copyOptionArray2, (String)linkOptionArray, string3, (boolean)it5, (SortedMap)LanguageUtilsKt.toIndexedMap((List)collection), null, null, null, (boolean)false, (int)247, null));
                }
                if (!deletedUpgradedFile && Files.deleteIfExists(bookToUpgrade.getPath())) {
                    BookImporterKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
                    this.historicalEventRepository.insert((HistoricalEvent)new HistoricalEvent.BookFileDeleted(bookToUpgrade, "File was deleted to import an upgrade"));
                }
                this.bookLifecycle.deleteOne(bookToUpgrade);
                if (series.getOneshot()) {
                    SeriesRepository.DefaultImpls.update$default((SeriesRepository)this.seriesRepository, (Series)Series.copy$default((Series)series, null, (URL)importedBook.getUrl(), (LocalDateTime)importedBook.getFileLastModified(), null, null, (int)0, null, (boolean)false, null, null, (int)1017, null), (boolean)false, (int)2, null);
                }
            }
            this.seriesLifecycle.sortBooks(series);
            $this$forEach$iv = sidecars;
            boolean $i$f$forEach7 = false;
            Iterator iterator3 = $this$forEach$iv.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator3.next();
                boolean bl8 = false;
                Sidecar sourceSidecar = (Sidecar)entry.getKey();
                Path destPath = (Path)entry.getValue();
                switch (WhenMappings.$EnumSwitchMapping$1[sourceSidecar.getType().ordinal()]) {
                    case 1: {
                        TaskEmitter.refreshBookLocalArtwork$default((TaskEmitter)this.taskEmitter, (Book)importedBook, (int)0, (int)2, null);
                        break;
                    }
                    case 2: {
                        TaskEmitter.refreshBookMetadata$default((TaskEmitter)this.taskEmitter, (Book)importedBook, null, (int)0, (int)6, null);
                    }
                }
                URL uRL = destPath.toUri().toURL();
                Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
                URL uRL2 = destPath.getParent().toUri().toURL();
                Intrinsics.checkNotNullExpressionValue((Object)uRL2, (String)"toURL(...)");
                Intrinsics.checkNotNull((Object)destPath);
                Path path6 = destPath;
                linkOptionArray = new LinkOption[]{};
                BasicFileAttributes basicFileAttributes = Files.readAttributes(path6, BasicFileAttributes.class, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)basicFileAttributes, (String)"readAttributes(...)");
                Sidecar destSidecar = Sidecar.copy$default((Sidecar)sourceSidecar, (URL)uRL, (URL)uRL2, (LocalDateTime)FileSystemScannerKt.getUpdatedTime((BasicFileAttributes)basicFileAttributes), null, null, (int)24, null);
                this.sidecarRepository.save(importedBook.getLibraryId(), destSidecar);
            }
            this.historicalEventRepository.insert((HistoricalEvent)new HistoricalEvent.BookImported(importedBook, series, sourceFile, upgradeBookId != null));
            URL uRL = sourceFile.toUri().toURL();
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
            this.eventPublisher.publishEvent((Object)new DomainEvent.BookImported(importedBook, uRL, true, null, 8, null));
            return importedBook;
        }
        catch (Exception e) {
            String msg = e instanceof CodedException ? ((CodedException)((Object)e)).getCode() : e.getMessage();
            URL uRL = sourceFile.toUri().toURL();
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
            this.eventPublisher.publishEvent((Object)new DomainEvent.BookImported(null, uRL, false, msg));
            throw e;
        }
    }

    public static /* synthetic */ Book importBook$default(BookImporter bookImporter, Path path2, Series series, CopyMode copyMode, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: importBook");
        }
        if ((n & 8) != 0) {
            string = null;
        }
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        return bookImporter.importBook(path2, series, copyMode, string, string2);
    }
}

