/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.domain.service;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gotson.komga.domain.model.Book;
import org.gotson.komga.domain.model.BookAction;
import org.gotson.komga.domain.model.BookPage;
import org.gotson.komga.domain.model.BookWithMedia;
import org.gotson.komga.domain.model.DomainEvent;
import org.gotson.komga.domain.model.HistoricalEvent;
import org.gotson.komga.domain.model.ImageConversionException;
import org.gotson.komga.domain.model.KomgaUser;
import org.gotson.komga.domain.model.MarkSelectedPreference;
import org.gotson.komga.domain.model.Media;
import org.gotson.komga.domain.model.MediaExtension;
import org.gotson.komga.domain.model.MediaExtensionEpub;
import org.gotson.komga.domain.model.MediaFile;
import org.gotson.komga.domain.model.MediaNotReadyException;
import org.gotson.komga.domain.model.MediaProfile;
import org.gotson.komga.domain.model.NoThumbnailFoundException;
import org.gotson.komga.domain.model.R2Locator;
import org.gotson.komga.domain.model.R2Progression;
import org.gotson.komga.domain.model.ReadProgress;
import org.gotson.komga.domain.model.SearchCondition;
import org.gotson.komga.domain.model.SearchContext;
import org.gotson.komga.domain.model.SearchOperator;
import org.gotson.komga.domain.model.ThumbnailBook;
import org.gotson.komga.domain.model.TypedBytes;
import org.gotson.komga.domain.persistence.BookMetadataRepository;
import org.gotson.komga.domain.persistence.BookRepository;
import org.gotson.komga.domain.persistence.HistoricalEventRepository;
import org.gotson.komga.domain.persistence.LibraryRepository;
import org.gotson.komga.domain.persistence.MediaRepository;
import org.gotson.komga.domain.persistence.ReadListRepository;
import org.gotson.komga.domain.persistence.ReadProgressRepository;
import org.gotson.komga.domain.persistence.ThumbnailBookRepository;
import org.gotson.komga.domain.service.BookAnalyzer;
import org.gotson.komga.domain.service.BookLifecycle;
import org.gotson.komga.domain.service.BookLifecycleKt;
import org.gotson.komga.infrastructure.configuration.KomgaSettingsProvider;
import org.gotson.komga.infrastructure.hash.Hasher;
import org.gotson.komga.infrastructure.hash.KoreaderHasher;
import org.gotson.komga.infrastructure.image.ImageConverter;
import org.gotson.komga.infrastructure.image.ImageType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ce\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001B\u0087\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u0012\b\b\u0001\u0010 \u001a\u00020!\u00a2\u0006\u0002\u0010\"J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020(H\u0016J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u0010,\u001a\u00020-H\u0016J\u0016\u00100\u001a\u00020/2\f\u00101\u001a\b\u0012\u0004\u0012\u00020-02H\u0016J\u0010\u00103\u001a\u00020/2\u0006\u0010,\u001a\u00020-H\u0016J\u0018\u00104\u001a\u00020/2\u0006\u0010,\u001a\u00020-2\u0006\u00105\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020/2\u0006\u0010&\u001a\u00020%H\u0016J\u0016\u00108\u001a\b\u0012\u0004\u0012\u000209022\u0006\u0010:\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020/2\u0006\u0010,\u001a\u00020-H\u0016J5\u0010=\u001a\u00020>2\u0006\u0010,\u001a\u00020-2\u0006\u0010?\u001a\u00020@2\n\b\u0002\u0010A\u001a\u0004\u0018\u00010!2\n\b\u0002\u0010B\u001a\u0004\u0018\u00010@H\u0016\u00a2\u0006\u0002\u0010CJ\u0012\u0010D\u001a\u0004\u0018\u00010E2\u0006\u0010&\u001a\u00020%H\u0012J\u0012\u0010F\u001a\u0004\u0018\u00010%2\u0006\u0010G\u001a\u000209H\u0016J#\u0010H\u001a\u0004\u0018\u00010>2\u0006\u0010G\u001a\u0002092\n\b\u0002\u0010B\u001a\u0004\u0018\u00010@H\u0016\u00a2\u0006\u0002\u0010IJ\u0012\u0010J\u001a\u0004\u0018\u00010>2\u0006\u0010K\u001a\u000209H\u0016J\u0012\u0010L\u001a\u0004\u0018\u00010>2\u0006\u0010G\u001a\u000209H\u0016J\u0010\u0010M\u001a\u00020/2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010N\u001a\u00020/2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010O\u001a\u00020/2\u0006\u0010,\u001a\u00020-H\u0016J \u0010P\u001a\u00020/2\u0006\u0010,\u001a\u00020-2\u0006\u00105\u001a\u0002062\u0006\u0010Q\u001a\u00020RH\u0016J \u0010S\u001a\u00020/2\u0006\u0010,\u001a\u00020-2\u0006\u00105\u001a\u0002062\u0006\u0010T\u001a\u00020@H\u0016J\u0018\u0010U\u001a\u00020/2\u0006\u0010G\u001a\u0002092\u0006\u00105\u001a\u000206H\u0016J\u0016\u0010V\u001a\u00020/2\f\u00101\u001a\b\u0012\u0004\u0012\u00020-02H\u0016J\u0010\u0010W\u001a\u00020/2\u0006\u0010G\u001a\u000209H\u0012R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020!X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006X"}, d2={"Lorg/gotson/komga/domain/service/BookLifecycle;", "", "bookRepository", "Lorg/gotson/komga/domain/persistence/BookRepository;", "mediaRepository", "Lorg/gotson/komga/domain/persistence/MediaRepository;", "bookMetadataRepository", "Lorg/gotson/komga/domain/persistence/BookMetadataRepository;", "readProgressRepository", "Lorg/gotson/komga/domain/persistence/ReadProgressRepository;", "thumbnailBookRepository", "Lorg/gotson/komga/domain/persistence/ThumbnailBookRepository;", "readListRepository", "Lorg/gotson/komga/domain/persistence/ReadListRepository;", "libraryRepository", "Lorg/gotson/komga/domain/persistence/LibraryRepository;", "bookAnalyzer", "Lorg/gotson/komga/domain/service/BookAnalyzer;", "imageConverter", "Lorg/gotson/komga/infrastructure/image/ImageConverter;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "transactionTemplate", "Lorg/springframework/transaction/support/TransactionTemplate;", "hasher", "Lorg/gotson/komga/infrastructure/hash/Hasher;", "hasherKoreader", "Lorg/gotson/komga/infrastructure/hash/KoreaderHasher;", "historicalEventRepository", "Lorg/gotson/komga/domain/persistence/HistoricalEventRepository;", "komgaSettingsProvider", "Lorg/gotson/komga/infrastructure/configuration/KomgaSettingsProvider;", "pdfImageType", "Lorg/gotson/komga/infrastructure/image/ImageType;", "(Lorg/gotson/komga/domain/persistence/BookRepository;Lorg/gotson/komga/domain/persistence/MediaRepository;Lorg/gotson/komga/domain/persistence/BookMetadataRepository;Lorg/gotson/komga/domain/persistence/ReadProgressRepository;Lorg/gotson/komga/domain/persistence/ThumbnailBookRepository;Lorg/gotson/komga/domain/persistence/ReadListRepository;Lorg/gotson/komga/domain/persistence/LibraryRepository;Lorg/gotson/komga/domain/service/BookAnalyzer;Lorg/gotson/komga/infrastructure/image/ImageConverter;Lorg/springframework/context/ApplicationEventPublisher;Lorg/springframework/transaction/support/TransactionTemplate;Lorg/gotson/komga/infrastructure/hash/Hasher;Lorg/gotson/komga/infrastructure/hash/KoreaderHasher;Lorg/gotson/komga/domain/persistence/HistoricalEventRepository;Lorg/gotson/komga/infrastructure/configuration/KomgaSettingsProvider;Lorg/gotson/komga/infrastructure/image/ImageType;)V", "resizeTargetFormat", "addThumbnailForBook", "Lorg/gotson/komga/domain/model/ThumbnailBook;", "thumbnail", "markSelected", "Lorg/gotson/komga/domain/model/MarkSelectedPreference;", "analyzeAndPersist", "", "Lorg/gotson/komga/domain/model/BookAction;", "book", "Lorg/gotson/komga/domain/model/Book;", "deleteBookFiles", "", "deleteMany", "books", "", "deleteOne", "deleteReadProgress", "user", "Lorg/gotson/komga/domain/model/KomgaUser;", "deleteThumbnailForBook", "findBookThumbnailsToRegenerate", "", "forBiggerResultOnly", "", "generateThumbnailAndPersist", "getBookPage", "Lorg/gotson/komga/domain/model/TypedBytes;", "number", "", "convertTo", "resizeTo", "(Lorg/gotson/komga/domain/model/Book;ILorg/gotson/komga/infrastructure/image/ImageType;Ljava/lang/Integer;)Lorg/gotson/komga/domain/model/TypedBytes;", "getBytesFromThumbnailBook", "", "getThumbnail", "bookId", "getThumbnailBytes", "(Ljava/lang/String;Ljava/lang/Integer;)Lorg/gotson/komga/domain/model/TypedBytes;", "getThumbnailBytesByThumbnailId", "thumbnailId", "getThumbnailBytesOriginal", "hashAndPersist", "hashKoreaderAndPersist", "hashPagesAndPersist", "markProgression", "newProgression", "Lorg/gotson/komga/domain/model/R2Progression;", "markReadProgress", "page", "markReadProgressCompleted", "softDeleteMany", "thumbnailsHouseKeeping", "komga"})
@SourceDebugExtension(value={"SMAP\nBookLifecycle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookLifecycle.kt\norg/gotson/komga/domain/service/BookLifecycle\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,570:1\n766#2:571\n857#2,2:572\n1855#2,2:574\n1603#2,9:577\n1855#2:586\n1856#2:588\n1612#2:589\n766#2:590\n857#2,2:591\n1549#2:593\n1620#2,3:594\n1549#2:597\n1620#2,3:598\n1855#2,2:601\n1549#2:603\n1620#2,3:604\n1855#2,2:607\n1549#2:609\n1620#2,3:610\n766#2:613\n857#2,2:614\n288#2,2:616\n766#2:618\n857#2,2:619\n1963#2,14:621\n766#2:635\n857#2,2:636\n2333#2,14:638\n1603#2,9:652\n1855#2:661\n1856#2:663\n1612#2:664\n766#2:665\n857#2,2:666\n1855#2,2:668\n1549#2:670\n1620#2,3:671\n1#3:576\n1#3:587\n1#3:662\n*S KotlinDebug\n*F\n+ 1 BookLifecycle.kt\norg/gotson/komga/domain/service/BookLifecycle\n*L\n166#1:571\n166#1:572,2\n167#1:574,2\n275#1:577,9\n275#1:586\n275#1:588\n275#1:589\n285#1:590\n285#1:591,2\n303#1:593\n303#1:594,3\n383#1:597\n383#1:598,3\n385#1:601,2\n389#1:603\n389#1:604,3\n403#1:607,2\n493#1:609\n493#1:610,3\n500#1:613\n500#1:614,2\n505#1:616,2\n508#1:618\n508#1:619,2\n508#1:621,14\n509#1:635\n509#1:636,2\n509#1:638,14\n547#1:652,9\n547#1:661\n547#1:663\n547#1:664\n548#1:665\n548#1:666,2\n554#1:668,2\n89#1:670\n89#1:671,3\n275#1:587\n547#1:662\n*E\n"})
public class BookLifecycle {
    @NotNull
    private final BookRepository bookRepository;
    @NotNull
    private final MediaRepository mediaRepository;
    @NotNull
    private final BookMetadataRepository bookMetadataRepository;
    @NotNull
    private final ReadProgressRepository readProgressRepository;
    @NotNull
    private final ThumbnailBookRepository thumbnailBookRepository;
    @NotNull
    private final ReadListRepository readListRepository;
    @NotNull
    private final LibraryRepository libraryRepository;
    @NotNull
    private final BookAnalyzer bookAnalyzer;
    @NotNull
    private final ImageConverter imageConverter;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;
    @NotNull
    private final TransactionTemplate transactionTemplate;
    @NotNull
    private final Hasher hasher;
    @NotNull
    private final KoreaderHasher hasherKoreader;
    @NotNull
    private final HistoricalEventRepository historicalEventRepository;
    @NotNull
    private final KomgaSettingsProvider komgaSettingsProvider;
    @NotNull
    private final ImageType pdfImageType;
    @NotNull
    private final ImageType resizeTargetFormat;

    public BookLifecycle(@NotNull BookRepository bookRepository, @NotNull MediaRepository mediaRepository, @NotNull BookMetadataRepository bookMetadataRepository, @NotNull ReadProgressRepository readProgressRepository, @NotNull ThumbnailBookRepository thumbnailBookRepository, @NotNull ReadListRepository readListRepository, @NotNull LibraryRepository libraryRepository, @NotNull BookAnalyzer bookAnalyzer, @NotNull ImageConverter imageConverter, @NotNull ApplicationEventPublisher eventPublisher, @NotNull TransactionTemplate transactionTemplate, @NotNull Hasher hasher, @NotNull KoreaderHasher hasherKoreader, @NotNull HistoricalEventRepository historicalEventRepository, @NotNull KomgaSettingsProvider komgaSettingsProvider, @Qualifier(value="pdfImageType") @NotNull ImageType pdfImageType) {
        Intrinsics.checkNotNullParameter((Object)bookRepository, (String)"bookRepository");
        Intrinsics.checkNotNullParameter((Object)mediaRepository, (String)"mediaRepository");
        Intrinsics.checkNotNullParameter((Object)bookMetadataRepository, (String)"bookMetadataRepository");
        Intrinsics.checkNotNullParameter((Object)readProgressRepository, (String)"readProgressRepository");
        Intrinsics.checkNotNullParameter((Object)thumbnailBookRepository, (String)"thumbnailBookRepository");
        Intrinsics.checkNotNullParameter((Object)readListRepository, (String)"readListRepository");
        Intrinsics.checkNotNullParameter((Object)libraryRepository, (String)"libraryRepository");
        Intrinsics.checkNotNullParameter((Object)bookAnalyzer, (String)"bookAnalyzer");
        Intrinsics.checkNotNullParameter((Object)imageConverter, (String)"imageConverter");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)transactionTemplate, (String)"transactionTemplate");
        Intrinsics.checkNotNullParameter((Object)hasher, (String)"hasher");
        Intrinsics.checkNotNullParameter((Object)hasherKoreader, (String)"hasherKoreader");
        Intrinsics.checkNotNullParameter((Object)historicalEventRepository, (String)"historicalEventRepository");
        Intrinsics.checkNotNullParameter((Object)komgaSettingsProvider, (String)"komgaSettingsProvider");
        Intrinsics.checkNotNullParameter((Object)pdfImageType, (String)"pdfImageType");
        this.bookRepository = bookRepository;
        this.mediaRepository = mediaRepository;
        this.bookMetadataRepository = bookMetadataRepository;
        this.readProgressRepository = readProgressRepository;
        this.thumbnailBookRepository = thumbnailBookRepository;
        this.readListRepository = readListRepository;
        this.libraryRepository = libraryRepository;
        this.bookAnalyzer = bookAnalyzer;
        this.imageConverter = imageConverter;
        this.eventPublisher = eventPublisher;
        this.transactionTemplate = transactionTemplate;
        this.hasher = hasher;
        this.hasherKoreader = hasherKoreader;
        this.historicalEventRepository = historicalEventRepository;
        this.komgaSettingsProvider = komgaSettingsProvider;
        this.pdfImageType = pdfImageType;
        this.resizeTargetFormat = ImageType.JPEG;
    }

    @NotNull
    public Set<BookAction> analyzeAndPersist(@NotNull Book book) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        BookLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        Media media = this.bookAnalyzer.analyze(book, this.libraryRepository.findById(book.getLibraryId()).getAnalyzeDimensions());
        this.transactionTemplate.executeWithoutResult(arg_0 -> BookLifecycle.analyzeAndPersist$lambda$2(this, book, media, arg_0));
        this.eventPublisher.publishEvent((Object)new DomainEvent.BookUpdated(book));
        if (media.getStatus() == Media.Status.READY) {
            Object[] objectArray = new BookAction[]{BookAction.GENERATE_THUMBNAIL, BookAction.REFRESH_METADATA};
            set = SetsKt.setOf((Object[])objectArray);
        } else {
            set = SetsKt.emptySet();
        }
        return set;
    }

    public void hashAndPersist(@NotNull Book book) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        if (!this.libraryRepository.findById(book.getLibraryId()).getHashFiles()) {
            BookLifecycleKt.access$getLogger$p().info((Function0)hashAndPersist.1.INSTANCE);
            return;
        }
        BookLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        if (StringsKt.isBlank((CharSequence)book.getFileHash())) {
            String hash = this.hasher.computeHash(book.getPath());
            this.bookRepository.update(Book.copy$default((Book)book, null, null, null, (long)0L, (String)hash, null, (int)0, null, null, null, null, (boolean)false, null, null, (int)16367, null));
        } else {
            BookLifecycleKt.access$getLogger$p().info((Function0)hashAndPersist.3.INSTANCE);
        }
    }

    public void hashKoreaderAndPersist(@NotNull Book book) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        if (!this.libraryRepository.findById(book.getLibraryId()).getHashKoreader()) {
            BookLifecycleKt.access$getLogger$p().info((Function0)hashKoreaderAndPersist.1.INSTANCE);
            return;
        }
        BookLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        if (StringsKt.isBlank((CharSequence)book.getFileHashKoreader())) {
            String hash = this.hasherKoreader.computeHash(book.getPath());
            this.bookRepository.update(Book.copy$default((Book)book, null, null, null, (long)0L, null, (String)hash, (int)0, null, null, null, null, (boolean)false, null, null, (int)16351, null));
        } else {
            BookLifecycleKt.access$getLogger$p().info((Function0)hashKoreaderAndPersist.3.INSTANCE);
        }
    }

    public void hashPagesAndPersist(@NotNull Book book) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        if (!this.libraryRepository.findById(book.getLibraryId()).getHashPages()) {
            BookLifecycleKt.access$getLogger$p().info((Function0)hashPagesAndPersist.1.INSTANCE);
            return;
        }
        BookLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        this.mediaRepository.update(this.bookAnalyzer.hashPages(new BookWithMedia(book, this.mediaRepository.findById(book.getId()))));
    }

    public void generateThumbnailAndPersist(@NotNull Book book) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        BookLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        try {
            this.addThumbnailForBook(this.bookAnalyzer.generateThumbnail(new BookWithMedia(book, this.mediaRepository.findById(book.getId()))), MarkSelectedPreference.IF_NONE_OR_GENERATED);
        }
        catch (NoThumbnailFoundException ex) {
            BookLifecycleKt.access$getLogger$p().error((Function0)generateThumbnailAndPersist.2.INSTANCE);
        }
        catch (Exception ex) {
            BookLifecycleKt.access$getLogger$p().error((Throwable)ex, (Function0)generateThumbnailAndPersist.3.INSTANCE);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ThumbnailBook addThumbnailForBook(@NotNull ThumbnailBook thumbnail, @NotNull MarkSelectedPreference markSelected) {
        Intrinsics.checkNotNullParameter((Object)thumbnail, (String)"thumbnail");
        Intrinsics.checkNotNullParameter((Object)markSelected, (String)"markSelected");
        switch (WhenMappings.$EnumSwitchMapping$0[thumbnail.getType().ordinal()]) {
            case 1: {
                this.thumbnailBookRepository.deleteByBookIdAndType(thumbnail.getBookId(), ThumbnailBook.Type.GENERATED);
                this.thumbnailBookRepository.insert(ThumbnailBook.copy$default((ThumbnailBook)thumbnail, null, null, (boolean)false, null, null, (long)0L, null, null, null, null, null, (int)2043, null));
                break;
            }
            case 2: {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Iterable iterable = this.thumbnailBookRepository.findAllByBookIdAndType(thumbnail.getBookId(), SetsKt.setOf((Object)ThumbnailBook.Type.SIDECAR));
                boolean $i$f$filter = false;
                Iterator iterator = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    ThumbnailBook it = (ThumbnailBook)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getUrl(), (Object)thumbnail.getUrl())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ThumbnailBook it = (ThumbnailBook)element$iv;
                    boolean bl = false;
                    this.thumbnailBookRepository.delete(it.getId());
                }
                this.thumbnailBookRepository.insert(ThumbnailBook.copy$default((ThumbnailBook)thumbnail, null, null, (boolean)false, null, null, (long)0L, null, null, null, null, null, (int)2043, null));
                break;
            }
            case 3: {
                this.thumbnailBookRepository.insert(ThumbnailBook.copy$default((ThumbnailBook)thumbnail, null, null, (boolean)false, null, null, (long)0L, null, null, null, null, null, (int)2043, null));
            }
        }
        boolean selected = switch (WhenMappings.$EnumSwitchMapping$1[markSelected.ordinal()]) {
            case 1 -> true;
            case 2 -> {
                ThumbnailBook selectedThumbnail = this.thumbnailBookRepository.findSelectedByBookIdOrNull(thumbnail.getBookId());
                if (selectedThumbnail == null || selectedThumbnail.getType() == ThumbnailBook.Type.GENERATED) {
                    yield true;
                }
                yield false;
            }
            case 3 -> false;
            default -> throw new NoWhenBranchMatchedException();
        };
        if (selected) {
            this.thumbnailBookRepository.markSelected(thumbnail);
        } else {
            this.thumbnailsHouseKeeping(thumbnail.getBookId());
        }
        ThumbnailBook newThumbnail = ThumbnailBook.copy$default((ThumbnailBook)thumbnail, null, null, (boolean)selected, null, null, (long)0L, null, null, null, null, null, (int)2043, null);
        this.eventPublisher.publishEvent((Object)new DomainEvent.ThumbnailBookAdded(newThumbnail));
        return newThumbnail;
    }

    public void deleteThumbnailForBook(@NotNull ThumbnailBook thumbnail) {
        Intrinsics.checkNotNullParameter((Object)thumbnail, (String)"thumbnail");
        if (!(thumbnail.getType() == ThumbnailBook.Type.USER_UPLOADED)) {
            boolean bl = false;
            String string = "Only uploaded thumbnails can be deleted";
            throw new IllegalArgumentException(string.toString());
        }
        this.thumbnailBookRepository.delete(thumbnail.getId());
        this.thumbnailsHouseKeeping(thumbnail.getBookId());
        this.eventPublisher.publishEvent((Object)new DomainEvent.ThumbnailBookDeleted(thumbnail));
    }

    @Nullable
    public ThumbnailBook getThumbnail(@NotNull String bookId) {
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        ThumbnailBook selected = this.thumbnailBookRepository.findSelectedByBookIdOrNull(bookId);
        if (selected == null || !selected.exists()) {
            this.thumbnailsHouseKeeping(bookId);
            return this.thumbnailBookRepository.findSelectedByBookIdOrNull(bookId);
        }
        return selected;
    }

    @Nullable
    public TypedBytes getThumbnailBytes(@NotNull String bookId, @Nullable Integer resizeTo) {
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        ThumbnailBook thumbnailBook = this.getThumbnail(bookId);
        if (thumbnailBook != null) {
            byte[] byArray;
            ThumbnailBook it = thumbnailBook;
            boolean bl = false;
            if (it.getThumbnail() != null) {
                byArray = it.getThumbnail();
            } else if (it.getUrl() != null) {
                byArray = FilesKt.readBytes((File)new File(it.getUrl().toURI()));
            } else {
                return null;
            }
            byte[] thumbnailBytes = byArray;
            if (resizeTo != null) {
                try {
                    return new TypedBytes(this.imageConverter.resizeImageToByteArray(thumbnailBytes, this.resizeTargetFormat, resizeTo.intValue()), this.resizeTargetFormat.getMediaType());
                }
                catch (Exception e) {
                    BookLifecycleKt.access$getLogger$p().error((Throwable)e, (Function0)new /* Unavailable Anonymous Inner Class!! */);
                }
            }
            return new TypedBytes(thumbnailBytes, it.getMediaType());
        }
        return null;
    }

    public static /* synthetic */ TypedBytes getThumbnailBytes$default(BookLifecycle bookLifecycle, String string, Integer n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getThumbnailBytes");
        }
        if ((n2 & 2) != 0) {
            n = null;
        }
        return bookLifecycle.getThumbnailBytes(string, n);
    }

    @Nullable
    public TypedBytes getThumbnailBytesOriginal(@NotNull String bookId) {
        TypedBytes typedBytes;
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        ThumbnailBook thumbnailBook = this.getThumbnail(bookId);
        if (thumbnailBook == null) {
            return null;
        }
        ThumbnailBook thumbnail = thumbnailBook;
        if (thumbnail.getType() == ThumbnailBook.Type.GENERATED) {
            Book book = this.bookRepository.findByIdOrNull(bookId);
            if (book == null) {
                return null;
            }
            Book book2 = book;
            Media media = this.mediaRepository.findById(book2.getId());
            typedBytes = this.bookAnalyzer.getPoster(new BookWithMedia(book2, media));
        } else {
            typedBytes = BookLifecycle.getThumbnailBytes$default((BookLifecycle)this, (String)bookId, null, (int)2, null);
        }
        return typedBytes;
    }

    @Nullable
    public TypedBytes getThumbnailBytesByThumbnailId(@NotNull String thumbnailId) {
        TypedBytes typedBytes;
        Intrinsics.checkNotNullParameter((Object)thumbnailId, (String)"thumbnailId");
        ThumbnailBook thumbnailBook = this.thumbnailBookRepository.findByIdOrNull(thumbnailId);
        if (thumbnailBook != null) {
            ThumbnailBook thumbnail = thumbnailBook;
            boolean bl = false;
            byte[] byArray = this.getBytesFromThumbnailBook(thumbnail);
            if (byArray != null) {
                byte[] bytes = byArray;
                boolean bl2 = false;
                typedBytes = new TypedBytes(bytes, thumbnail.getMediaType());
            } else {
                typedBytes = null;
            }
        } else {
            typedBytes = null;
        }
        return typedBytes;
    }

    private byte[] getBytesFromThumbnailBook(ThumbnailBook thumbnail) {
        return thumbnail.getThumbnail() != null ? thumbnail.getThumbnail() : (byte[])(thumbnail.getUrl() != null ? FilesKt.readBytes((File)new File(thumbnail.getUrl().toURI())) : null);
    }

    /*
     * WARNING - void declaration
     */
    private void thumbnailsHouseKeeping(String bookId) {
        void $this$filterTo$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        BookLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        Iterable $this$mapNotNull$iv = this.thumbnailBookRepository.findAllByBookId(bookId);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<ThumbnailBook> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ThumbnailBook thumbnailBook;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ThumbnailBook it = (ThumbnailBook)element$iv$iv;
            boolean bl2 = false;
            if (!it.exists()) {
                BookLifecycleKt.access$getLogger$p().warn((Function0)thumbnailsHouseKeeping.all.1.1.INSTANCE);
                this.thumbnailBookRepository.delete(it.getId());
                thumbnailBook = null;
            } else {
                thumbnailBook = it;
            }
            if (thumbnailBook == null) continue;
            ThumbnailBook it$iv$iv = thumbnailBook;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List all2 = (List)destination$iv$iv;
        Iterable $this$filter$iv = all2;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ThumbnailBook it = (ThumbnailBook)element$iv$iv;
            boolean bl = false;
            if (!it.getSelected()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List selected = (List)destination$iv$iv2;
        if (selected.size() > 1) {
            BookLifecycleKt.access$getLogger$p().info((Function0)thumbnailsHouseKeeping.2.INSTANCE);
            this.thumbnailBookRepository.markSelected((ThumbnailBook)selected.get(0));
        } else if (selected.isEmpty() && !((Collection)all2).isEmpty()) {
            BookLifecycleKt.access$getLogger$p().info((Function0)thumbnailsHouseKeeping.3.INSTANCE);
            this.thumbnailBookRepository.markSelected((ThumbnailBook)CollectionsKt.first((List)all2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<String> findBookThumbnailsToRegenerate(boolean forBiggerResultOnly) {
        Collection collection;
        if (forBiggerResultOnly) {
            collection = this.thumbnailBookRepository.findAllBookIdsByThumbnailTypeAndDimensionSmallerThan(ThumbnailBook.Type.GENERATED, this.komgaSettingsProvider.getThumbnailSize().getMaxEdge());
        } else {
            void $this$mapTo$iv$iv;
            SearchCondition.Book book = (SearchCondition.Book)new SearchCondition.Deleted((SearchOperator.Boolean)SearchOperator.IsFalse.INSTANCE);
            SearchContext searchContext = SearchContext.Companion.empty();
            Pageable pageable = Pageable.unpaged();
            Intrinsics.checkNotNullExpressionValue((Object)pageable, (String)"unpaged(...)");
            List list = this.bookRepository.findAll(book, searchContext, pageable).getContent();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Book book2 = (Book)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getId());
            }
            collection = (List)destination$iv$iv;
        }
        return collection;
    }

    @NotNull
    public TypedBytes getBookPage(@NotNull Book book, int number, @Nullable ImageType convertTo, @Nullable Integer resizeTo) throws ImageConversionException, MediaNotReadyException, IndexOutOfBoundsException {
        String pageMediaType;
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        Media media = this.mediaRepository.findById(book.getId());
        byte[] pageContent = this.bookAnalyzer.getPageContent(new BookWithMedia(book, media), number);
        String string = pageMediaType = media.getProfile() == MediaProfile.PDF ? this.pdfImageType.getMediaType() : ((BookPage)media.getPages().get(number - 1)).getMediaType();
        if (resizeTo != null) {
            byte[] byArray;
            try {
                byArray = this.imageConverter.resizeImageToByteArray(pageContent, this.resizeTargetFormat, resizeTo.intValue());
            }
            catch (Exception e) {
                BookLifecycleKt.access$getLogger$p().error((Throwable)e, (Function0)new /* Unavailable Anonymous Inner Class!! */);
                throw e;
            }
            byte[] convertedPage2 = byArray;
            return new TypedBytes(convertedPage2, this.resizeTargetFormat.getMediaType());
        }
        ImageType imageType = convertTo;
        if (imageType != null) {
            ImageType it = imageType;
            boolean bl = false;
            String msg = "Convert page #" + number + " of book " + book + " from " + pageMediaType + " to " + it.getMediaType();
            if (!this.imageConverter.getSupportedReadMediaTypes().contains(pageMediaType)) {
                throw new ImageConversionException(msg + ": unsupported read format " + pageMediaType, null, 2, null);
            }
            if (!this.imageConverter.getSupportedWriteMediaTypes().contains(it.getMediaType())) {
                throw new ImageConversionException(msg + ": unsupported write format " + it.getMediaType(), null, 2, null);
            }
            if (Intrinsics.areEqual((Object)pageMediaType, (Object)it.getMediaType())) {
                BookLifecycleKt.access$getLogger$p().warn((Function0)new /* Unavailable Anonymous Inner Class!! */);
            } else {
                byte[] byArray;
                BookLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
                try {
                    byArray = this.imageConverter.convertImage(pageContent, it.getImageIOFormat());
                }
                catch (Exception e) {
                    BookLifecycleKt.access$getLogger$p().error((Throwable)e, (Function0)new /* Unavailable Anonymous Inner Class!! */);
                    throw e;
                }
                byte[] convertedPage3 = byArray;
                return new TypedBytes(convertedPage3, it.getMediaType());
            }
        }
        return new TypedBytes(pageContent, pageMediaType);
    }

    public static /* synthetic */ TypedBytes getBookPage$default(BookLifecycle bookLifecycle, Book book, int n, ImageType imageType, Integer n2, int n3, Object object) throws ImageConversionException, MediaNotReadyException, IndexOutOfBoundsException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getBookPage");
        }
        if ((n3 & 4) != 0) {
            imageType = null;
        }
        if ((n3 & 8) != 0) {
            n2 = null;
        }
        return bookLifecycle.getBookPage(book, n, imageType, n2);
    }

    public void deleteOne(@NotNull Book book) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        BookLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        this.transactionTemplate.executeWithoutResult(arg_0 -> BookLifecycle.deleteOne$lambda$13(this, book, arg_0));
        this.eventPublisher.publishEvent((Object)new DomainEvent.BookDeleted(book));
    }

    /*
     * WARNING - void declaration
     */
    public void softDeleteMany(@NotNull Collection<Book> books) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(books, (String)"books");
        BookLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        LocalDateTime deletedDate = LocalDateTime.now();
        Iterable iterable = books;
        BookRepository bookRepository = this.bookRepository;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Book book = (Book)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Book.copy$default((Book)it, null, null, null, (long)0L, null, null, (int)0, null, null, null, (LocalDateTime)deletedDate, (boolean)false, null, null, (int)15359, null));
        }
        bookRepository.update((Collection)((List)destination$iv$iv));
        Iterable $this$forEach$iv = books;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Book it = (Book)element$iv;
            boolean bl = false;
            this.eventPublisher.publishEvent((Object)new DomainEvent.BookUpdated(it));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void deleteMany(@NotNull Collection<Book> books) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(books, (String)"books");
        Iterable $this$map$iv = books;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Book book = (Book)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        List bookIds = (List)destination$iv$iv;
        BookLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        this.transactionTemplate.executeWithoutResult(arg_0 -> BookLifecycle.deleteMany$lambda$17(this, bookIds, arg_0));
        Iterable $this$forEach$iv = books;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Book it = (Book)element$iv;
            boolean bl = false;
            this.eventPublisher.publishEvent((Object)new DomainEvent.BookDeleted(it));
        }
    }

    public void markReadProgress(@NotNull Book book, @NotNull KomgaUser user, int page) {
        R2Locator r2Locator;
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Media media = this.mediaRepository.findById(book.getId());
        if (!(1 <= page ? page <= media.getPageCount() : false)) {
            boolean $i$a$-require-BookLifecycle$markReadProgress$22 = false;
            String $i$a$-require-BookLifecycle$markReadProgress$22 = "Page argument (" + page + ") must be within 1 and book page count (" + media.getPageCount() + ")";
            throw new IllegalArgumentException($i$a$-require-BookLifecycle$markReadProgress$22.toString());
        }
        if (media.getProfile() == MediaProfile.EPUB) {
            if (!media.getEpubDivinaCompatible()) {
                boolean bl = false;
                String string = "epub book is not Divina compatible";
                throw new IllegalArgumentException(string.toString());
            }
            MediaExtension mediaExtension = this.mediaRepository.findExtensionByIdOrNull(book.getId());
            MediaExtensionEpub mediaExtensionEpub = mediaExtension instanceof MediaExtensionEpub ? (MediaExtensionEpub)mediaExtension : null;
            if (mediaExtensionEpub == null) {
                throw new IllegalArgumentException("Epub extension not found");
            }
            MediaExtensionEpub extension = mediaExtensionEpub;
            r2Locator = (R2Locator)extension.getPositions().get(page - 1);
        } else {
            r2Locator = null;
        }
        R2Locator locator = r2Locator;
        ReadProgress progress = new ReadProgress(book.getId(), user.getId(), page, page == media.getPageCount(), null, null, null, locator, null, null, 880, null);
        this.readProgressRepository.save(progress);
        this.eventPublisher.publishEvent((Object)new DomainEvent.ReadProgressChanged(progress));
    }

    public void markReadProgressCompleted(@NotNull String bookId, @NotNull KomgaUser user) {
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Media media = this.mediaRepository.findById(bookId);
        ReadProgress progress = new ReadProgress(bookId, user.getId(), media.getPageCount(), true, null, null, null, null, null, null, 1008, null);
        this.readProgressRepository.save(progress);
        this.eventPublisher.publishEvent((Object)new DomainEvent.ReadProgressChanged(progress));
    }

    public void deleteReadProgress(@NotNull Book book, @NotNull KomgaUser user) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)book, (String)"book");
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            ReadProgress readProgress = this.readProgressRepository.findByBookIdAndUserIdOrNull(book.getId(), user.getId());
            if (readProgress == null) break block0;
            ReadProgress progress = readProgress;
            boolean bl = false;
            this.readProgressRepository.delete(book.getId(), user.getId());
            this.eventPublisher.publishEvent((Object)new DomainEvent.ReadProgressDeleted(progress));
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void markProgression(@NotNull Book book, @NotNull KomgaUser user, @NotNull R2Progression newProgression) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)newProgression, (String)"newProgression");
        v0 = this.readProgressRepository.findByBookIdAndUserIdOrNull(book.getId(), user.getId());
        if (v0 != null) {
            savedProgress = v0;
            $i$a$-let-BookLifecycle$markProgression$1 = false;
            if (!newProgression.getModified().withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime().isAfter(savedProgress.getReadDate())) {
                $i$a$-check-BookLifecycle$markProgression$1$1 = false;
                $i$a$-check-BookLifecycle$markProgression$1$1 = "Progression is older than existing";
                throw new IllegalStateException($i$a$-check-BookLifecycle$markProgression$1$1.toString());
            }
            v1 = Unit.INSTANCE;
        } else {
            v1 = null;
        }
        media = this.mediaRepository.findById(book.getId());
        if (media.getProfile() == null) {
            $i$a$-requireNotNull-BookLifecycle$markProgression$2 = false;
            var6_6 = "Media has no profile";
            throw new IllegalArgumentException(var6_6.toString());
        }
        v2 = media.getProfile();
        Intrinsics.checkNotNull((Object)v2);
        switch (WhenMappings.$EnumSwitchMapping$2[v2.ordinal()]) {
            case 1: 
            case 2: {
                $i$a$-check-BookLifecycle$markProgression$1$1 = new IntRange(1, media.getPageCount());
                v3 = newProgression.getLocator().getLocations();
                var9_14 = v3 != null ? v3.getPosition() : null;
                if (!(var9_14 != null && $i$a$-check-BookLifecycle$markProgression$1$1.contains(var9_14.intValue()) != false)) {
                    $i$a$-require-BookLifecycle$markProgression$progress$1 = false;
                    v4 = newProgression.getLocator().getLocations();
                    $i$a$-require-BookLifecycle$markProgression$progress$1 = "Page argument (" + (v4 != null ? v4.getPosition() : null) + ") must be within 1 and book page count (" + media.getPageCount() + ")";
                    throw new IllegalArgumentException($i$a$-require-BookLifecycle$markProgression$progress$1.toString());
                }
                v5 = book.getId();
                v6 = user.getId();
                v7 = newProgression.getLocator().getLocations();
                Intrinsics.checkNotNull((Object)v7);
                v8 = v7.getPosition();
                Intrinsics.checkNotNull((Object)v8);
                v9 = v8;
                v10 = newProgression.getLocator().getLocations().getPosition();
                $i$a$-check-BookLifecycle$markProgression$1$1 = media.getPageCount();
                v11 = v10 != null && v10 == $i$a$-check-BookLifecycle$markProgression$1$1;
                v12 = newProgression.getModified().withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"toLocalDateTime(...)");
                v13 = new ReadProgress(v5, v6, v9, v11, v12, newProgression.getDevice().getId(), newProgression.getDevice().getName(), newProgression.getLocator(), null, null, 768, null);
                break;
            }
            case 3: {
                it = StringsKt.removeSuffix((String)StringsKt.replaceAfter$default((String)newProgression.getLocator().getHref(), (String)"#", (String)"", null, (int)4, null), (CharSequence)"#");
                $i$a$-let-BookLifecycle$markProgression$progress$href$1 = false;
                href = URLDecoder.decode(it, Charsets.UTF_8);
                $this$map$iv = media.getFiles();
                $i$f$map = false;
                $i$a$-let-BookLifecycle$markProgression$progress$href$1 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var16_40 = (MediaFile)item$iv$iv;
                    var27_49 = destination$iv$iv;
                    $i$a$-map-BookLifecycle$markProgression$progress$2 = false;
                    var27_49.add(it.getFileName());
                }
                if (!((List)destination$iv$iv).contains(href)) {
                    $i$a$-require-BookLifecycle$markProgression$progress$3 = false;
                    $i$a$-require-BookLifecycle$markProgression$progress$3 = "Resource does not exist in book: " + href;
                    throw new IllegalArgumentException($i$a$-require-BookLifecycle$markProgression$progress$3.toString());
                }
                v14 = newProgression.getLocator().getLocations();
                if ((v14 != null ? v14.getProgression() : null) == null) {
                    $i$a$-requireNotNull-BookLifecycle$markProgression$progress$4 = false;
                    $i$a$-requireNotNull-BookLifecycle$markProgression$progress$4 = "location.progression is required";
                    throw new IllegalArgumentException($i$a$-requireNotNull-BookLifecycle$markProgression$progress$4.toString());
                }
                $this$mapTo$iv$iv = this.mediaRepository.findExtensionByIdOrNull(book.getId());
                v15 = $this$mapTo$iv$iv instanceof MediaExtensionEpub != false ? (MediaExtensionEpub)$this$mapTo$iv$iv : null;
                if (v15 == null) {
                    throw new IllegalArgumentException("Epub extension not found");
                }
                extension = v15;
                $this$filter$iv = extension.getPositions();
                $i$f$filter = false;
                $i$f$mapTo = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (R2Locator)element$iv$iv;
                    $i$a$-filter-BookLifecycle$markProgression$progress$matchingPositions$1 = false;
                    if (!Intrinsics.areEqual((Object)it.getHref(), (Object)href)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                matchingPositions = (List)destination$iv$iv;
                if (!extension.isFixedLayout() || matchingPositions.size() != 1) ** GOTO lbl93
                v16 = (R2Locator)CollectionsKt.first((List)matchingPositions);
                ** GOTO lbl232
lbl93:
                // 1 sources

                $this$firstOrNull$iv = matchingPositions;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    it = (R2Locator)element$iv;
                    $i$a$-firstOrNull-BookLifecycle$markProgression$progress$matchedPosition$1 = false;
                    v17 = it.getLocations();
                    Intrinsics.checkNotNull((Object)v17);
                    v18 = v17.getProgression();
                    v19 = newProgression.getLocator().getLocations();
                    Intrinsics.checkNotNull((Object)v19);
                    if (!Intrinsics.areEqual((Float)v18, (Float)v19.getProgression())) continue;
                    v20 = element$iv;
                    ** GOTO lbl107
                }
                v20 = null;
lbl107:
                // 2 sources

                if ((v16 = (R2Locator)v20) != null) ** GOTO lbl232
                $this$markProgression_u24lambda_u2436 = this;
                $i$a$-run-BookLifecycle$markProgression$progress$matchedPosition$2 = false;
                $this$filter$iv = matchingPositions;
                $i$f$filter = false;
                $i$a$-firstOrNull-BookLifecycle$markProgression$progress$matchedPosition$1 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (R2Locator)element$iv$iv;
                    $i$a$-filter-BookLifecycle$markProgression$progress$matchedPosition$2$before$1 = false;
                    v21 = it.getLocations();
                    Intrinsics.checkNotNull((Object)v21);
                    v22 = v21.getProgression();
                    Intrinsics.checkNotNull((Object)v22);
                    v23 = v22.floatValue();
                    v24 = newProgression.getLocator().getLocations();
                    Intrinsics.checkNotNull((Object)v24);
                    v25 = v24.getProgression();
                    Intrinsics.checkNotNull((Object)v25);
                    if (!(v23 < v25.floatValue())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$maxByOrNull = false;
                iterator$iv = $this$maxByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v26 = null;
                } else {
                    maxElem$iv /* !! */  = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v26 = maxElem$iv /* !! */ ;
                    } else {
                        it = (R2Locator)maxElem$iv /* !! */ ;
                        $i$a$-maxByOrNull-BookLifecycle$markProgression$progress$matchedPosition$2$before$2 = false;
                        v27 = it.getLocations();
                        Intrinsics.checkNotNull((Object)v27);
                        v28 = v27.getPosition();
                        Intrinsics.checkNotNull((Object)v28);
                        maxValue$iv = v28;
                        do {
                            e$iv = iterator$iv.next();
                            it = (R2Locator)e$iv;
                            $i$a$-maxByOrNull-BookLifecycle$markProgression$progress$matchedPosition$2$before$2 = false;
                            v29 = it.getLocations();
                            Intrinsics.checkNotNull((Object)v29);
                            v30 = v29.getPosition();
                            Intrinsics.checkNotNull((Object)v30);
                            v$iv = v30;
                            if (maxValue$iv >= v$iv) continue;
                            maxElem$iv /* !! */  = e$iv;
                            maxValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v26 = maxElem$iv /* !! */ ;
                    }
                }
                before = v26;
                $this$filter$iv = matchingPositions;
                $i$f$filter = false;
                maxElem$iv /* !! */  = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (R2Locator)element$iv$iv;
                    $i$a$-filter-BookLifecycle$markProgression$progress$matchedPosition$2$after$1 = false;
                    v31 = it.getLocations();
                    Intrinsics.checkNotNull((Object)v31);
                    v32 = v31.getProgression();
                    Intrinsics.checkNotNull((Object)v32);
                    v33 = v32.floatValue();
                    v34 = newProgression.getLocator().getLocations();
                    Intrinsics.checkNotNull((Object)v34);
                    v35 = v34.getProgression();
                    Intrinsics.checkNotNull((Object)v35);
                    if (!(v33 > v35.floatValue())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$minByOrNull = false;
                iterator$iv = $this$minByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v36 = null;
                } else {
                    minElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v36 = minElem$iv;
                    } else {
                        it = (R2Locator)minElem$iv;
                        $i$a$-minByOrNull-BookLifecycle$markProgression$progress$matchedPosition$2$after$2 = false;
                        v37 = it.getLocations();
                        Intrinsics.checkNotNull((Object)v37);
                        v38 = v37.getPosition();
                        Intrinsics.checkNotNull((Object)v38);
                        minValue$iv = v38;
                        do {
                            e$iv = iterator$iv.next();
                            it = (R2Locator)e$iv;
                            $i$a$-minByOrNull-BookLifecycle$markProgression$progress$matchedPosition$2$after$2 = false;
                            v39 = it.getLocations();
                            Intrinsics.checkNotNull((Object)v39);
                            v40 = v39.getPosition();
                            Intrinsics.checkNotNull((Object)v40);
                            v$iv = v40;
                            if (minValue$iv <= v$iv) continue;
                            minElem$iv = e$iv;
                            minValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v36 = minElem$iv;
                    }
                }
                after = v36;
                if (before == null || after == null) ** GOTO lbl229
                v41 = before.getLocations();
                Intrinsics.checkNotNull((Object)v41);
                v42 = v41.getPosition();
                Intrinsics.checkNotNull((Object)v42);
                v43 = v42;
                v44 = after.getLocations();
                Intrinsics.checkNotNull((Object)v44);
                v45 = v44.getPosition();
                Intrinsics.checkNotNull((Object)v45);
                if (v43 <= v45) ** GOTO lbl230
lbl229:
                // 2 sources

                throw new IllegalArgumentException("Invalid progression");
lbl230:
                // 1 sources

                v16 = before;
lbl232:
                // 3 sources

                matchedPosition = v16;
                v46 = matchedPosition.getLocations();
                totalProgression = v46 != null ? v46.getTotalProgression() : null;
                v47 = book.getId();
                v48 = user.getId();
                v49 = totalProgression;
                if (v49 != null) {
                    $i$a$-run-BookLifecycle$markProgression$progress$matchedPosition$2 = ((Number)v49).floatValue();
                    var29_80 = v48;
                    var28_81 = v47;
                    $i$a$-let-BookLifecycle$markProgression$progress$5 = false;
                    var30_82 = MathKt.roundToInt((float)((float)media.getPageCount() * it));
                    v47 = var28_81;
                    v48 = var29_80;
                    v50 = var30_82;
                } else {
                    v50 = 0;
                }
                v51 = totalProgression;
                if (v51 != null) {
                    it = ((Number)v51).floatValue();
                    var30_82 = v50;
                    var29_80 = v48;
                    var28_81 = v47;
                    $i$a$-let-BookLifecycle$markProgression$progress$6 = false;
                    var31_83 = it >= 0.99f;
                    v47 = var28_81;
                    v48 = var29_80;
                    v50 = var30_82;
                    v52 = var31_83;
                } else {
                    v52 = false;
                }
                v53 = newProgression.getModified().withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
                Intrinsics.checkNotNullExpressionValue((Object)v53, (String)"toLocalDateTime(...)");
                v54 = newProgression.getDevice().getId();
                v55 = newProgression.getDevice().getName();
                var13_28 = newProgression.getLocator();
                var14_32 = matchedPosition.getType();
                v56 = newProgression.getLocator().getKoboSpan();
                if (v56 == null) {
                    v56 = matchedPosition.getKoboSpan();
                }
                var15_39 = v56;
                v57 = newProgression.getLocator().getLocations();
                var16_43 = v57 != null ? R2Locator.Location.copy$default((R2Locator.Location)v57, null, null, null, (Float)totalProgression, (int)7, null) : null;
                var32_84 = null;
                var33_85 = 768;
                var34_86 = null;
                var35_87 = null;
                var36_88 = R2Locator.copy$default((R2Locator)var13_28, null, (String)var14_32, null, (R2Locator.Location)var16_43, null, (String)var15_39, (int)21, null);
                var37_89 = v55;
                var38_90 = v54;
                var39_91 = v53;
                var40_92 = v52;
                var41_93 = v50;
                var42_94 = v48;
                var43_95 = v47;
                v13 = new ReadProgress(var43_95, var42_94, var41_93, var40_92, var39_91, var38_90, var37_89, var36_88, var35_87, var34_86, var33_85, var32_84);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        progress = v13;
        this.readProgressRepository.save(progress);
        this.eventPublisher.publishEvent((Object)new DomainEvent.ReadProgressChanged(progress));
    }

    /*
     * WARNING - void declaration
     */
    public void deleteBookFiles(@NotNull Book book) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(book.getPath(), Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            BookLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
            return;
        }
        if (!Files.isWritable(book.getPath())) {
            BookLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
            return;
        }
        Iterable $this$mapNotNull$iv = this.thumbnailBookRepository.findAllByBookIdAndType(book.getId(), SetsKt.setOf((Object)ThumbnailBook.Type.SIDECAR));
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Path path2;
            URI uRI;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ThumbnailBook it = (ThumbnailBook)element$iv$iv;
            boolean bl2 = false;
            Serializable serializable = it.getUrl();
            if (serializable != null && (serializable = (uRI = serializable.toURI())) != null) {
                Intrinsics.checkNotNull((Object)serializable);
                Path path3 = Paths.get(uRI);
                path2 = path3;
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
            } else {
                path2 = null;
            }
            if (path2 == null) continue;
            Path it$iv$iv = path2;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Path it = (Path)element$iv$iv;
            boolean bl = false;
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            boolean bl4 = Files.exists(it, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) && Files.isWritable(it);
            if (!bl4) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List thumbnails = (List)destination$iv$iv;
        if (Files.deleteIfExists(book.getPath())) {
            BookLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
            this.historicalEventRepository.insert((HistoricalEvent)new HistoricalEvent.BookFileDeleted(book, "File was deleted by user request"));
        }
        Iterable $this$forEach$iv = thumbnails;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Path it = (Path)element$iv;
            boolean bl = false;
            if (!Files.deleteIfExists(it)) continue;
            BookLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        }
        Path path4 = book.getPath().getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"getParent(...)");
        if (PathsKt.listDirectoryEntries$default((Path)path4, null, (int)1, null).isEmpty()) {
            Path path5 = book.getPath().getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"getParent(...)");
            if (Files.deleteIfExists(path5)) {
                BookLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
                String string = book.getSeriesId();
                Path path6 = book.getPath().getParent();
                Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"getParent(...)");
                this.historicalEventRepository.insert((HistoricalEvent)new HistoricalEvent.SeriesFolderDeleted(string, path6, "Folder was deleted because it was empty"));
            }
        }
        this.softDeleteMany((Collection)CollectionsKt.listOf((Object)book));
    }

    /*
     * WARNING - void declaration
     */
    private static final void analyzeAndPersist$lambda$2(BookLifecycle this$0, Book $book, Media $media, TransactionStatus it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$book, (String)"$book");
        Intrinsics.checkNotNullParameter((Object)$media, (String)"$media");
        Media previous = this$0.mediaRepository.findById($book.getId());
        boolean bl = false;
        if (previous.getStatus() == Media.Status.OUTDATED && previous.getPageCount() != $media.getPageCount()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = this$0.readProgressRepository.findAllByBookId($book.getId());
            boolean $i$f$map = false;
            void var8_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                ReadProgress readProgress = (ReadProgress)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(ReadProgress.copy$default((ReadProgress)it2, null, null, (int)(it2.getCompleted() ? $media.getPageCount() : 1), (boolean)false, null, null, null, null, null, null, (int)1019, null));
            }
            List adjustedProgress = (List)destination$iv$iv;
            if (!((Collection)adjustedProgress).isEmpty()) {
                BookLifecycleKt.access$getLogger$p().info((Function0)analyzeAndPersist.2.1.1.INSTANCE);
                this$0.readProgressRepository.save((Collection)adjustedProgress);
            }
        }
        this$0.mediaRepository.update($media);
    }

    private static final void deleteOne$lambda$13(BookLifecycle this$0, Book $book, TransactionStatus it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$book, (String)"$book");
        this$0.readProgressRepository.deleteByBookId($book.getId());
        this$0.readListRepository.removeBookFromAll($book.getId());
        this$0.mediaRepository.delete($book.getId());
        this$0.thumbnailBookRepository.deleteByBookId($book.getId());
        this$0.bookMetadataRepository.delete($book.getId());
        this$0.bookRepository.delete($book.getId());
    }

    private static final void deleteMany$lambda$17(BookLifecycle this$0, List $bookIds, TransactionStatus it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$bookIds, (String)"$bookIds");
        this$0.readProgressRepository.deleteByBookIds((Collection)$bookIds);
        this$0.readListRepository.removeBooksFromAll((Collection)$bookIds);
        this$0.mediaRepository.delete((Collection)$bookIds);
        this$0.thumbnailBookRepository.deleteByBookIds((Collection)$bookIds);
        this$0.bookMetadataRepository.delete((Collection)$bookIds);
        this$0.bookRepository.delete((Collection)$bookIds);
    }
}

