/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.domain.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.domain.model.Book;
import org.gotson.komga.domain.model.BookPageNumbered;
import org.gotson.komga.domain.model.Library;
import org.gotson.komga.domain.model.MediaType;
import org.gotson.komga.domain.model.PageHashKnown;
import org.gotson.komga.domain.model.PageHashMatch;
import org.gotson.komga.domain.model.TypedBytes;
import org.gotson.komga.domain.persistence.BookRepository;
import org.gotson.komga.domain.persistence.MediaRepository;
import org.gotson.komga.domain.persistence.PageHashRepository;
import org.gotson.komga.domain.service.BookLifecycle;
import org.gotson.komga.domain.service.PageHashLifecycle;
import org.gotson.komga.domain.service.PageHashLifecycleKt;
import org.gotson.komga.infrastructure.configuration.KomgaProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\"\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00150\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J#\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0012\u001a\u00020\u000f2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/gotson/komga/domain/service/PageHashLifecycle;", "", "pageHashRepository", "Lorg/gotson/komga/domain/persistence/PageHashRepository;", "mediaRepository", "Lorg/gotson/komga/domain/persistence/MediaRepository;", "bookLifecycle", "Lorg/gotson/komga/domain/service/BookLifecycle;", "bookRepository", "Lorg/gotson/komga/domain/persistence/BookRepository;", "komgaProperties", "Lorg/gotson/komga/infrastructure/configuration/KomgaProperties;", "(Lorg/gotson/komga/domain/persistence/PageHashRepository;Lorg/gotson/komga/domain/persistence/MediaRepository;Lorg/gotson/komga/domain/service/BookLifecycle;Lorg/gotson/komga/domain/persistence/BookRepository;Lorg/gotson/komga/infrastructure/configuration/KomgaProperties;)V", "hashableMediaTypes", "", "", "createOrUpdate", "", "pageHash", "Lorg/gotson/komga/domain/model/PageHashKnown;", "getBookIdsWithMissingPageHash", "", "library", "Lorg/gotson/komga/domain/model/Library;", "getBookPagesToDeleteAutomatically", "", "Lorg/gotson/komga/domain/model/BookPageNumbered;", "getPage", "Lorg/gotson/komga/domain/model/TypedBytes;", "resizeTo", "", "(Ljava/lang/String;Ljava/lang/Integer;)Lorg/gotson/komga/domain/model/TypedBytes;", "komga"})
@SourceDebugExtension(value={"SMAP\nPageHashLifecycle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PageHashLifecycle.kt\norg/gotson/komga/domain/service/PageHashLifecycle\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n1#2:60\n*E\n"})
public class PageHashLifecycle {
    @NotNull
    private final PageHashRepository pageHashRepository;
    @NotNull
    private final MediaRepository mediaRepository;
    @NotNull
    private final BookLifecycle bookLifecycle;
    @NotNull
    private final BookRepository bookRepository;
    @NotNull
    private final KomgaProperties komgaProperties;
    @NotNull
    private final List<String> hashableMediaTypes;

    public PageHashLifecycle(@NotNull PageHashRepository pageHashRepository, @NotNull MediaRepository mediaRepository, @NotNull BookLifecycle bookLifecycle, @NotNull BookRepository bookRepository, @NotNull KomgaProperties komgaProperties) {
        Intrinsics.checkNotNullParameter((Object)pageHashRepository, (String)"pageHashRepository");
        Intrinsics.checkNotNullParameter((Object)mediaRepository, (String)"mediaRepository");
        Intrinsics.checkNotNullParameter((Object)bookLifecycle, (String)"bookLifecycle");
        Intrinsics.checkNotNullParameter((Object)bookRepository, (String)"bookRepository");
        Intrinsics.checkNotNullParameter((Object)komgaProperties, (String)"komgaProperties");
        this.pageHashRepository = pageHashRepository;
        this.mediaRepository = mediaRepository;
        this.bookLifecycle = bookLifecycle;
        this.bookRepository = bookRepository;
        this.komgaProperties = komgaProperties;
        this.hashableMediaTypes = CollectionsKt.listOf((Object)MediaType.ZIP.getType());
    }

    @NotNull
    public Collection<String> getBookIdsWithMissingPageHash(@NotNull Library library) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        if (library.getHashPages()) {
            Collection collection2;
            Collection it = collection2 = this.mediaRepository.findAllBookIdsByLibraryIdAndMediaTypeAndWithMissingPageHash(library.getId(), (Collection)this.hashableMediaTypes, this.komgaProperties.getPageHashing());
            boolean bl = false;
            PageHashLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
            collection = collection2;
        } else {
            PageHashLifecycleKt.access$getLogger$p().info((Function0)getBookIdsWithMissingPageHash.2.INSTANCE);
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    @Nullable
    public TypedBytes getPage(@NotNull String pageHash, @Nullable Integer resizeTo) {
        Intrinsics.checkNotNullParameter((Object)pageHash, (String)"pageHash");
        Pageable pageable = Pageable.ofSize((int)1);
        Intrinsics.checkNotNullExpressionValue((Object)pageable, (String)"ofSize(...)");
        PageHashMatch pageHashMatch = (PageHashMatch)CollectionsKt.firstOrNull((Iterable)((Iterable)this.pageHashRepository.findMatchesByHash(pageHash, pageable)));
        if (pageHashMatch == null) {
            return null;
        }
        PageHashMatch match = pageHashMatch;
        Book book = this.bookRepository.findByIdOrNull(match.getBookId());
        if (book == null) {
            return null;
        }
        Book book2 = book;
        return BookLifecycle.getBookPage$default((BookLifecycle)this.bookLifecycle, (Book)book2, (int)match.getPageNumber(), null, (Integer)resizeTo, (int)4, null);
    }

    public static /* synthetic */ TypedBytes getPage$default(PageHashLifecycle pageHashLifecycle, String string, Integer n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getPage");
        }
        if ((n2 & 2) != 0) {
            n = null;
        }
        return pageHashLifecycle.getPage(string, n);
    }

    @NotNull
    public Map<String, Collection<BookPageNumbered>> getBookPagesToDeleteAutomatically(@NotNull Library library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        return this.pageHashRepository.findMatchesByKnownHashAction(CollectionsKt.listOf((Object)PageHashKnown.Action.DELETE_AUTO), library.getId());
    }

    public void createOrUpdate(@NotNull PageHashKnown pageHash) {
        Intrinsics.checkNotNullParameter((Object)pageHash, (String)"pageHash");
        PageHashKnown existing = this.pageHashRepository.findKnown(pageHash.getHash());
        if (existing == null) {
            TypedBytes typedBytes = this.getPage(pageHash.getHash(), Integer.valueOf(500));
            this.pageHashRepository.insert(pageHash, (byte[])(typedBytes != null ? typedBytes.getBytes() : null));
        } else {
            this.pageHashRepository.update(PageHashKnown.copy$default((PageHashKnown)existing, null, null, (PageHashKnown.Action)pageHash.getAction(), (int)0, (int)0, (int)27, null));
        }
    }
}

