/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.hash;

import com.appmattus.crypto.Algorithm;
import com.appmattus.crypto.Digest;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.UByteArray;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gotson.komga.infrastructure.hash.Hasher;
import org.gotson.komga.infrastructure.hash.HasherKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016J\f\u0010\t\u001a\u00020\u0004*\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/gotson/komga/infrastructure/hash/Hasher;", "", "()V", "computeHash", "", "stream", "Ljava/io/InputStream;", "path", "Ljava/nio/file/Path;", "toHexString", "", "komga"})
public class Hasher {
    @NotNull
    public String computeHash(@NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        HasherKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(path2, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        return this.computeHash(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String computeHash(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Digest hash = new Algorithm.XXH3_128.Seeded(0L).createDigest();
        Closeable closeable = stream;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            byte[] buffer = new byte[8192];
            int len = 0;
            do {
                if ((len = it.read(buffer)) < 0) continue;
                hash.update(buffer, 0, len);
            } while (len >= 0);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return this.toHexString(hash.digest());
    }

    @NotNull
    public String toHexString(@NotNull byte[] $this$toHexString) {
        Intrinsics.checkNotNullParameter((Object)$this$toHexString, (String)"<this>");
        return CollectionsKt.joinToString$default((Iterable)UByteArray.box-impl((byte[])UByteArray.constructor-impl((byte[])$this$toHexString)), (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)toHexString.1.INSTANCE), (int)30, null);
    }
}

