/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.image;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.gotson.komga.infrastructure.configuration.KomgaSettingsProvider;
import org.gotson.komga.infrastructure.image.ImageConverter;
import org.gotson.komga.infrastructure.image.ImageType;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0092D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/gotson/komga/infrastructure/image/MosaicGenerator;", "", "komgaSettingsProvider", "Lorg/gotson/komga/infrastructure/configuration/KomgaSettingsProvider;", "thumbnailType", "Lorg/gotson/komga/infrastructure/image/ImageType;", "imageConverter", "Lorg/gotson/komga/infrastructure/image/ImageConverter;", "(Lorg/gotson/komga/infrastructure/configuration/KomgaSettingsProvider;Lorg/gotson/komga/infrastructure/image/ImageType;Lorg/gotson/komga/infrastructure/image/ImageConverter;)V", "ratio", "", "createMosaic", "", "images", "", "komga"})
@SourceDebugExtension(value={"SMAP\nMosaicGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MosaicGenerator.kt\norg/gotson/komga/infrastructure/image/MosaicGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n1549#2:45\n1620#2,3:46\n1864#2,2:49\n1866#2:52\n1#3:51\n*S KotlinDebug\n*F\n+ 1 MosaicGenerator.kt\norg/gotson/komga/infrastructure/image/MosaicGenerator\n*L\n23#1:45\n23#1:46,3\n33#1:49,2\n33#1:52\n*E\n"})
public class MosaicGenerator {
    @NotNull
    private final KomgaSettingsProvider komgaSettingsProvider;
    @NotNull
    private final ImageType thumbnailType;
    @NotNull
    private final ImageConverter imageConverter;
    private final double ratio;

    public MosaicGenerator(@NotNull KomgaSettingsProvider komgaSettingsProvider, @Qualifier(value="thumbnailType") @NotNull ImageType thumbnailType, @NotNull ImageConverter imageConverter) {
        Intrinsics.checkNotNullParameter((Object)komgaSettingsProvider, (String)"komgaSettingsProvider");
        Intrinsics.checkNotNullParameter((Object)thumbnailType, (String)"thumbnailType");
        Intrinsics.checkNotNullParameter((Object)imageConverter, (String)"imageConverter");
        this.komgaSettingsProvider = komgaSettingsProvider;
        this.thumbnailType = thumbnailType;
        this.imageConverter = imageConverter;
        this.ratio = 0.7066666667;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public byte[] createMosaic(@NotNull List<byte[]> images) {
        byte[] byArray;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(images, (String)"images");
        int height = this.komgaSettingsProvider.getThumbnailSize().getMaxEdge();
        int width = MathKt.roundToInt((double)((double)height * this.ratio));
        Iterable $this$map$iv = images;
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            byte[] byArray2 = (byte[])item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.imageConverter.resizeImageToBufferedImage((byte[])it, this.thumbnailType, height / 2));
        }
        List thumbs = (List)destination$iv$iv;
        Closeable closeable = new ByteArrayOutputStream();
        object = null;
        try {
            void $this$forEachIndexed$iv;
            Graphics2D graphics2D;
            ByteArrayOutputStream baos = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            BufferedImage mosaic = new BufferedImage(width, height, 1);
            Graphics2D $this$createMosaic_u24lambda_u244_u24lambda_u243 = graphics2D = mosaic.createGraphics();
            boolean bl2 = false;
            Object object2 = new Pair[]{TuplesKt.to((Object)0, (Object)0), TuplesKt.to((Object)(width / 2), (Object)0), TuplesKt.to((Object)0, (Object)(height / 2)), TuplesKt.to((Object)(width / 2), (Object)(height / 2))};
            object2 = CollectionsKt.listOf((Object[])object2);
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                BufferedImage it;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Pair pair = (Pair)item$iv;
                int index = n;
                boolean bl3 = false;
                int x = ((Number)pair.component1()).intValue();
                int y = ((Number)pair.component2()).intValue();
                if ((BufferedImage)CollectionsKt.getOrNull((List)thumbs, (int)index) == null) continue;
                boolean bl4 = false;
                $this$createMosaic_u24lambda_u244_u24lambda_u243.drawImage((Image)it, x, y, null);
            }
            ImageIO.write((RenderedImage)mosaic, this.thumbnailType.getImageIOFormat(), baos);
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"use(...)");
        return byArray;
    }
}

