/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.jooq.main;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.gotson.komga.domain.model.Author;
import org.gotson.komga.domain.model.WebLink;
import org.gotson.komga.domain.persistence.BookMetadataRepository;
import org.gotson.komga.infrastructure.jooq.UtilsKt;
import org.gotson.komga.infrastructure.jooq.main.BookMetadataDao;
import org.gotson.komga.jooq.main.Tables;
import org.gotson.komga.jooq.main.tables.BookMetadata;
import org.gotson.komga.jooq.main.tables.BookMetadataAuthor;
import org.gotson.komga.jooq.main.tables.BookMetadataLink;
import org.gotson.komga.jooq.main.tables.BookMetadataTag;
import org.gotson.komga.jooq.main.tables.records.BookMetadataAuthorRecord;
import org.gotson.komga.jooq.main.tables.records.BookMetadataRecord;
import org.gotson.komga.language.LanguageUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.BatchBindStep;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Query;
import org.jooq.RecordMapper;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\"\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u001bH\u0017J$\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u001bH\u0012J\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u001bH\u0016J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J<\u0010\"\u001a.\u0012\f\u0012\n \t*\u0004\u0018\u00010$0$ \t*\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010$0$0\u001d\u00a2\u0006\u0002\b%0#\u00a2\u0006\u0002\b%2\u0006\u0010\u0018\u001a\u00020\u0019H\u0012J<\u0010&\u001a.\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00190\u0019 \t*\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00190\u00190(\u00a2\u0006\u0002\b%0'\u00a2\u0006\u0002\b%2\u0006\u0010\u0018\u001a\u00020\u0019H\u0012J\u0016\u0010)\u001a\u00020\u00172\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001bH\u0017J\u0010\u0010)\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u001eH\u0017J\u0016\u0010,\u001a\u00020\u00172\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001bH\u0012J\u0016\u0010-\u001a\u00020\u00172\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001bH\u0012J\u0016\u0010.\u001a\u00020\u00172\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001bH\u0012J\u0016\u0010/\u001a\u00020\u00172\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001bH\u0017J\u0010\u0010/\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u001eH\u0017J\u0010\u00100\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u001eH\u0012J\f\u00101\u001a\u000202*\u000203H\u0012J6\u00101\u001a\u00020\u001e*\u0002042\f\u00105\u001a\b\u0012\u0004\u0012\u0002020\u001d2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u00190(2\f\u00107\u001a\b\u0012\u0004\u0012\u00020$0\u001dH\u0012R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \t*\u0004\u0018\u00010\u000b0\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \t*\u0004\u0018\u00010\r0\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \t*\u0004\u0018\u00010\u000f0\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0011X\u0092\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013\u00a8\u00068"}, d2={"Lorg/gotson/komga/infrastructure/jooq/main/BookMetadataDao;", "Lorg/gotson/komga/domain/persistence/BookMetadataRepository;", "dsl", "Lorg/jooq/DSLContext;", "batchSize", "", "(Lorg/jooq/DSLContext;I)V", "a", "Lorg/gotson/komga/jooq/main/tables/BookMetadataAuthor;", "kotlin.jvm.PlatformType", "bl", "Lorg/gotson/komga/jooq/main/tables/BookMetadataLink;", "bt", "Lorg/gotson/komga/jooq/main/tables/BookMetadataTag;", "d", "Lorg/gotson/komga/jooq/main/tables/BookMetadata;", "groupFields", "", "Lorg/jooq/Field;", "[Lorg/jooq/Field;", "count", "", "delete", "", "bookId", "", "bookIds", "", "find", "", "Lorg/gotson/komga/domain/model/BookMetadata;", "findAllByIds", "findById", "findByIdOrNull", "findLinks", "", "Lorg/gotson/komga/domain/model/WebLink;", "Lorg/jetbrains/annotations/NotNull;", "findTags", "", "", "insert", "metadatas", "metadata", "insertAuthors", "insertLinks", "insertTags", "update", "updateMetadata", "toDomain", "Lorg/gotson/komga/domain/model/Author;", "Lorg/gotson/komga/jooq/main/tables/records/BookMetadataAuthorRecord;", "Lorg/gotson/komga/jooq/main/tables/records/BookMetadataRecord;", "authors", "tags", "links", "komga"})
@SourceDebugExtension(value={"SMAP\nBookMetadataDao.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookMetadataDao.kt\norg/gotson/komga/infrastructure/jooq/main/BookMetadataDao\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,293:1\n125#2:294\n152#2,2:295\n154#2:304\n819#3:297\n847#3,2:298\n1549#3:300\n1620#3,3:301\n1855#3:305\n1855#3,2:306\n1856#3:308\n1855#3,2:309\n1747#3,3:311\n1855#3:314\n1855#3:315\n1855#3,2:316\n1856#3:318\n1856#3:319\n1747#3,3:320\n1855#3:323\n1855#3:324\n1855#3,2:325\n1856#3:327\n1856#3:328\n1747#3,3:329\n1855#3:332\n1855#3:333\n1855#3,2:334\n1856#3:336\n1856#3:337\n*S KotlinDebug\n*F\n+ 1 BookMetadataDao.kt\norg/gotson/komga/infrastructure/jooq/main/BookMetadataDao\n*L\n52#1:294\n52#1:295,2\n52#1:304\n53#1:297\n53#1:298,2\n53#1:300\n53#1:301,3\n79#1:305\n103#1:306,2\n79#1:308\n139#1:309,2\n183#1:311,3\n184#1:314\n191#1:315\n192#1:316,2\n191#1:318\n184#1:319\n202#1:320,3\n203#1:323\n210#1:324\n211#1:325,2\n210#1:327\n203#1:328\n221#1:329,3\n222#1:332\n229#1:333\n230#1:334,2\n229#1:336\n222#1:337\n*E\n"})
public class BookMetadataDao
implements BookMetadataRepository {
    @NotNull
    private final DSLContext dsl;
    private final int batchSize;
    private final BookMetadata d;
    private final BookMetadataAuthor a;
    private final BookMetadataTag bt;
    private final BookMetadataLink bl;
    @NotNull
    private final Field<?>[] groupFields;

    public BookMetadataDao(@NotNull DSLContext dsl, @Value(value="#{@komgaProperties.database.batchChunkSize}") int batchSize) {
        Intrinsics.checkNotNullParameter((Object)dsl, (String)"dsl");
        this.dsl = dsl;
        this.batchSize = batchSize;
        this.d = Tables.BOOK_METADATA;
        this.a = Tables.BOOK_METADATA_AUTHOR;
        this.bt = Tables.BOOK_METADATA_TAG;
        this.bl = Tables.BOOK_METADATA_LINK;
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        Field[] fieldArray = this.d.fields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"fields(...)");
        spreadBuilder.addSpread((Object)fieldArray);
        Field[] fieldArray2 = this.a.fields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray2, (String)"fields(...)");
        spreadBuilder.addSpread((Object)fieldArray2);
        this.groupFields = (Field[])spreadBuilder.toArray((Object[])new Field[spreadBuilder.size()]);
    }

    @NotNull
    public org.gotson.komga.domain.model.BookMetadata findById(@NotNull String bookId) {
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        return (org.gotson.komga.domain.model.BookMetadata)CollectionsKt.first((List)this.find(this.dsl, (Collection)CollectionsKt.listOf((Object)bookId)));
    }

    @Nullable
    public org.gotson.komga.domain.model.BookMetadata findByIdOrNull(@NotNull String bookId) {
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        return (org.gotson.komga.domain.model.BookMetadata)CollectionsKt.firstOrNull((List)this.find(this.dsl, (Collection)CollectionsKt.listOf((Object)bookId)));
    }

    @NotNull
    public Collection<org.gotson.komga.domain.model.BookMetadata> findAllByIds(@NotNull Collection<String> bookIds) {
        Intrinsics.checkNotNullParameter(bookIds, (String)"bookIds");
        return this.find(this.dsl, bookIds);
    }

    /*
     * WARNING - void declaration
     */
    private List<org.gotson.komga.domain.model.BookMetadata> find(DSLContext dsl, Collection<String> bookIds) {
        void $this$mapTo$iv$iv;
        Field[] fieldArray = this.groupFields;
        SelectConditionStep selectConditionStep = dsl.select((SelectFieldOrAsterisk[])Arrays.copyOf(fieldArray, fieldArray.length)).from((TableLike)this.d).leftJoin((TableLike)this.a).on(this.d.BOOK_ID.eq((Field)this.a.BOOK_ID)).where(this.d.BOOK_ID.in(bookIds));
        fieldArray = this.groupFields;
        Map map = selectConditionStep.groupBy((GroupField[])Arrays.copyOf(fieldArray, fieldArray.length)).fetchGroups((RecordMapper)new /* Unavailable Anonymous Inner Class!! */, (RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"fetchGroups(...)");
        Map $this$map$iv = map;
        boolean $i$f$map = false;
        Map map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            BookMetadataAuthorRecord it;
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            BookMetadataRecord dr = (BookMetadataRecord)entry.getKey();
            List ar = (List)entry.getValue();
            Intrinsics.checkNotNull((Object)dr);
            Intrinsics.checkNotNull((Object)ar);
            Iterable iterable = ar;
            BookMetadataRecord bookMetadataRecord = dr;
            BookMetadataDao bookMetadataDao = this;
            boolean $i$f$filterNot = false;
            void var18_19 = $this$filterNot$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                it = (BookMetadataAuthorRecord)element$iv$iv;
                boolean bl2 = false;
                if (it.getName() == null) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            Collection<Author> collection2 = (List)destination$iv$iv2;
            $this$filterNot$iv = collection2;
            boolean $i$f$map2 = false;
            $this$filterNotTo$iv$iv = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                it = (BookMetadataAuthorRecord)item$iv$iv2;
                collection2 = destination$iv$iv2;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)it);
                collection2.add(this.toDomain(it));
            }
            collection2 = (List)destination$iv$iv2;
            String string = dr.getBookId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBookId(...)");
            Set set = this.findTags(string);
            String string2 = dr.getBookId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getBookId(...)");
            collection.add(bookMetadataDao.toDomain(bookMetadataRecord, (List)collection2, set, this.findLinks(string2)));
        }
        return (List)destination$iv$iv;
    }

    private @NotNull Set<String> findTags(String bookId) {
        Set set = this.dsl.select((SelectField)this.bt.TAG).from((TableLike)this.bt).where(this.bt.BOOK_ID.eq((Object)bookId)).fetchSet((Field)this.bt.TAG);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"fetchSet(...)");
        return set;
    }

    private @NotNull List<WebLink> findLinks(String bookId) {
        List list = this.dsl.select((SelectField)this.bl.LABEL, (SelectField)this.bl.URL).from((TableLike)this.bl).where(this.bl.BOOK_ID.eq((Object)bookId)).fetchInto((Table)this.bl).map((RecordMapper)findLinks.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    @Transactional
    public void insert(@NotNull org.gotson.komga.domain.model.BookMetadata metadata) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        this.insert((Collection)CollectionsKt.listOf((Object)metadata));
    }

    @Transactional
    public void insert(@NotNull Collection<org.gotson.komga.domain.model.BookMetadata> metadatas) {
        Intrinsics.checkNotNullParameter(metadatas, (String)"metadatas");
        if (!metadatas.isEmpty()) {
            Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)metadatas, (int)this.batchSize);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BatchBindStep batchBindStep;
                List chunk = (List)element$iv;
                boolean bl = false;
                BatchBindStep step = batchBindStep = this.dsl.batch((Query)this.dsl.insertInto((Table)this.d, (Field)this.d.BOOK_ID, (Field)this.d.TITLE, (Field)this.d.TITLE_LOCK, (Field)this.d.SUMMARY, (Field)this.d.SUMMARY_LOCK, (Field)this.d.NUMBER, (Field)this.d.NUMBER_LOCK, (Field)this.d.NUMBER_SORT, (Field)this.d.NUMBER_SORT_LOCK, (Field)this.d.RELEASE_DATE, (Field)this.d.RELEASE_DATE_LOCK, (Field)this.d.AUTHORS_LOCK, (Field)this.d.TAGS_LOCK, (Field)this.d.ISBN, (Field)this.d.ISBN_LOCK, (Field)this.d.LINKS_LOCK).values(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null));
                boolean bl2 = false;
                Iterable $this$forEach$iv2 = chunk;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    org.gotson.komga.domain.model.BookMetadata it = (org.gotson.komga.domain.model.BookMetadata)element$iv2;
                    boolean bl3 = false;
                    Object[] objectArray = new Object[]{it.getBookId(), it.getTitle(), it.getTitleLock(), it.getSummary(), it.getSummaryLock(), it.getNumber(), it.getNumberLock(), Float.valueOf(it.getNumberSort()), it.getNumberSortLock(), it.getReleaseDate(), it.getReleaseDateLock(), it.getAuthorsLock(), it.getTagsLock(), it.getIsbn(), it.getIsbnLock(), it.getLinksLock()};
                    step.bind(objectArray);
                }
                batchBindStep.execute();
            }
            this.insertAuthors(metadatas);
            this.insertTags(metadatas);
            this.insertLinks(metadatas);
        }
    }

    @Transactional
    public void update(@NotNull org.gotson.komga.domain.model.BookMetadata metadata) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        this.updateMetadata(metadata);
    }

    @Transactional
    public void update(@NotNull Collection<org.gotson.komga.domain.model.BookMetadata> metadatas) {
        Intrinsics.checkNotNullParameter(metadatas, (String)"metadatas");
        Iterable $this$forEach$iv = metadatas;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            org.gotson.komga.domain.model.BookMetadata it = (org.gotson.komga.domain.model.BookMetadata)element$iv;
            boolean bl = false;
            this.updateMetadata(it);
        }
    }

    private void updateMetadata(org.gotson.komga.domain.model.BookMetadata metadata) {
        this.dsl.update((Table)this.d).set((Field)this.d.TITLE, (Object)metadata.getTitle()).set((Field)this.d.TITLE_LOCK, (Object)metadata.getTitleLock()).set((Field)this.d.SUMMARY, (Object)metadata.getSummary()).set((Field)this.d.SUMMARY_LOCK, (Object)metadata.getSummaryLock()).set((Field)this.d.NUMBER, (Object)metadata.getNumber()).set((Field)this.d.NUMBER_LOCK, (Object)metadata.getNumberLock()).set((Field)this.d.NUMBER_SORT, (Object)Float.valueOf(metadata.getNumberSort())).set((Field)this.d.NUMBER_SORT_LOCK, (Object)metadata.getNumberSortLock()).set((Field)this.d.RELEASE_DATE, (Object)metadata.getReleaseDate()).set((Field)this.d.RELEASE_DATE_LOCK, (Object)metadata.getReleaseDateLock()).set((Field)this.d.AUTHORS_LOCK, (Object)metadata.getAuthorsLock()).set((Field)this.d.TAGS_LOCK, (Object)metadata.getTagsLock()).set((Field)this.d.ISBN, (Object)metadata.getIsbn()).set((Field)this.d.ISBN_LOCK, (Object)metadata.getIsbnLock()).set((Field)this.d.LINKS_LOCK, (Object)metadata.getLinksLock()).set((Field)this.d.LAST_MODIFIED_DATE, (Object)LocalDateTime.now(ZoneId.of("Z"))).where(this.d.BOOK_ID.eq((Object)metadata.getBookId())).execute();
        this.dsl.deleteFrom((Table)this.a).where(this.a.BOOK_ID.eq((Object)metadata.getBookId())).execute();
        this.dsl.deleteFrom((Table)this.bt).where(this.bt.BOOK_ID.eq((Object)metadata.getBookId())).execute();
        this.dsl.deleteFrom((Table)this.bl).where(this.bl.BOOK_ID.eq((Object)metadata.getBookId())).execute();
        this.insertAuthors((Collection)CollectionsKt.listOf((Object)metadata));
        this.insertTags((Collection)CollectionsKt.listOf((Object)metadata));
        this.insertLinks((Collection)CollectionsKt.listOf((Object)metadata));
    }

    private void insertAuthors(Collection<org.gotson.komga.domain.model.BookMetadata> metadatas) {
        boolean bl;
        block7: {
            Iterable $this$any$iv = metadatas;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    org.gotson.komga.domain.model.BookMetadata it = (org.gotson.komga.domain.model.BookMetadata)element$iv;
                    boolean bl2 = false;
                    boolean bl3 = !((Collection)it.getAuthors()).isEmpty();
                    if (!bl3) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)metadatas, (int)this.batchSize);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BatchBindStep batchBindStep;
                List chunk = (List)element$iv;
                boolean bl4 = false;
                BatchBindStep step = batchBindStep = this.dsl.batch((Query)this.dsl.insertInto((Table)this.a, (Field)this.a.BOOK_ID, (Field)this.a.NAME, (Field)this.a.ROLE).values(null, null, null));
                boolean bl5 = false;
                Iterable $this$forEach$iv2 = chunk;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    org.gotson.komga.domain.model.BookMetadata metadata = (org.gotson.komga.domain.model.BookMetadata)element$iv2;
                    boolean bl6 = false;
                    Iterable $this$forEach$iv3 = metadata.getAuthors();
                    boolean $i$f$forEach3 = false;
                    for (Object element$iv3 : $this$forEach$iv3) {
                        Author it = (Author)element$iv3;
                        boolean bl7 = false;
                        Object[] objectArray = new Object[]{metadata.getBookId(), it.getName(), it.getRole()};
                        step.bind(objectArray);
                    }
                }
                batchBindStep.execute();
            }
        }
    }

    private void insertTags(Collection<org.gotson.komga.domain.model.BookMetadata> metadatas) {
        boolean bl;
        block7: {
            Iterable $this$any$iv = metadatas;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    org.gotson.komga.domain.model.BookMetadata it = (org.gotson.komga.domain.model.BookMetadata)element$iv;
                    boolean bl2 = false;
                    boolean bl3 = !((Collection)it.getTags()).isEmpty();
                    if (!bl3) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)metadatas, (int)this.batchSize);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BatchBindStep batchBindStep;
                List chunk = (List)element$iv;
                boolean bl4 = false;
                BatchBindStep step = batchBindStep = this.dsl.batch((Query)this.dsl.insertInto((Table)this.bt, (Field)this.bt.BOOK_ID, (Field)this.bt.TAG).values(null, null));
                boolean bl5 = false;
                Iterable $this$forEach$iv2 = chunk;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    org.gotson.komga.domain.model.BookMetadata metadata = (org.gotson.komga.domain.model.BookMetadata)element$iv2;
                    boolean bl6 = false;
                    Iterable $this$forEach$iv3 = metadata.getTags();
                    boolean $i$f$forEach3 = false;
                    for (Object element$iv3 : $this$forEach$iv3) {
                        String it = (String)element$iv3;
                        boolean bl7 = false;
                        Object[] objectArray = new Object[]{metadata.getBookId(), it};
                        step.bind(objectArray);
                    }
                }
                batchBindStep.execute();
            }
        }
    }

    private void insertLinks(Collection<org.gotson.komga.domain.model.BookMetadata> metadatas) {
        boolean bl;
        block7: {
            Iterable $this$any$iv = metadatas;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    org.gotson.komga.domain.model.BookMetadata it = (org.gotson.komga.domain.model.BookMetadata)element$iv;
                    boolean bl2 = false;
                    boolean bl3 = !((Collection)it.getLinks()).isEmpty();
                    if (!bl3) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)metadatas, (int)this.batchSize);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BatchBindStep batchBindStep;
                List chunk = (List)element$iv;
                boolean bl4 = false;
                BatchBindStep step = batchBindStep = this.dsl.batch((Query)this.dsl.insertInto((Table)this.bl, (Field)this.bl.BOOK_ID, (Field)this.bl.LABEL, (Field)this.bl.URL).values(null, null, null));
                boolean bl5 = false;
                Iterable $this$forEach$iv2 = chunk;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    org.gotson.komga.domain.model.BookMetadata metadata = (org.gotson.komga.domain.model.BookMetadata)element$iv2;
                    boolean bl6 = false;
                    Iterable $this$forEach$iv3 = metadata.getLinks();
                    boolean $i$f$forEach3 = false;
                    for (Object element$iv3 : $this$forEach$iv3) {
                        WebLink it = (WebLink)element$iv3;
                        boolean bl7 = false;
                        Object[] objectArray = new Object[]{metadata.getBookId(), it.getLabel(), it.getUrl().toString()};
                        step.bind(objectArray);
                    }
                }
                batchBindStep.execute();
            }
        }
    }

    @Transactional
    public void delete(@NotNull String bookId) {
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        this.dsl.deleteFrom((Table)this.a).where(this.a.BOOK_ID.eq((Object)bookId)).execute();
        this.dsl.deleteFrom((Table)this.bt).where(this.bt.BOOK_ID.eq((Object)bookId)).execute();
        this.dsl.deleteFrom((Table)this.bl).where(this.bl.BOOK_ID.eq((Object)bookId)).execute();
        this.dsl.deleteFrom((Table)this.d).where(this.d.BOOK_ID.eq((Object)bookId)).execute();
    }

    @Transactional
    public void delete(@NotNull Collection<String> bookIds) {
        Intrinsics.checkNotNullParameter(bookIds, (String)"bookIds");
        UtilsKt.insertTempStrings((DSLContext)this.dsl, (int)this.batchSize, bookIds);
        this.dsl.deleteFrom((Table)this.a).where(this.a.BOOK_ID.in((Select)UtilsKt.selectTempStrings((DSLContext)this.dsl))).execute();
        this.dsl.deleteFrom((Table)this.bt).where(this.bt.BOOK_ID.in((Select)UtilsKt.selectTempStrings((DSLContext)this.dsl))).execute();
        this.dsl.deleteFrom((Table)this.bl).where(this.bl.BOOK_ID.in((Select)UtilsKt.selectTempStrings((DSLContext)this.dsl))).execute();
        this.dsl.deleteFrom((Table)this.d).where(this.d.BOOK_ID.in((Select)UtilsKt.selectTempStrings((DSLContext)this.dsl))).execute();
    }

    public long count() {
        return this.dsl.fetchCount((Table)this.d);
    }

    private org.gotson.komga.domain.model.BookMetadata toDomain(BookMetadataRecord $this$toDomain, List<Author> authors, Set<String> tags, List<WebLink> links2) {
        String string = $this$toDomain.getTitle();
        String string2 = $this$toDomain.getSummary();
        String string3 = $this$toDomain.getNumber();
        Float f = $this$toDomain.getNumberSort();
        LocalDate localDate = $this$toDomain.getReleaseDate();
        String string4 = $this$toDomain.getIsbn();
        String string5 = $this$toDomain.getBookId();
        LocalDateTime localDateTime = $this$toDomain.getCreatedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"getCreatedDate(...)");
        LocalDateTime localDateTime2 = LanguageUtilsKt.toCurrentTimeZone((LocalDateTime)localDateTime);
        LocalDateTime localDateTime3 = $this$toDomain.getLastModifiedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime3, (String)"getLastModifiedDate(...)");
        LocalDateTime localDateTime4 = LanguageUtilsKt.toCurrentTimeZone((LocalDateTime)localDateTime3);
        Boolean bl = $this$toDomain.getTitleLock();
        Boolean bl2 = $this$toDomain.getSummaryLock();
        Boolean bl3 = $this$toDomain.getNumberLock();
        Boolean bl4 = $this$toDomain.getNumberSortLock();
        Boolean bl5 = $this$toDomain.getReleaseDateLock();
        Boolean bl6 = $this$toDomain.getAuthorsLock();
        Boolean bl7 = $this$toDomain.getTagsLock();
        Boolean bl8 = $this$toDomain.getIsbnLock();
        Boolean bl9 = $this$toDomain.getLinksLock();
        Intrinsics.checkNotNull((Object)string);
        Intrinsics.checkNotNull((Object)string2);
        Intrinsics.checkNotNull((Object)string3);
        Intrinsics.checkNotNull((Object)f);
        float f2 = f.floatValue();
        Intrinsics.checkNotNull((Object)string4);
        Intrinsics.checkNotNull((Object)bl);
        boolean bl10 = bl;
        Intrinsics.checkNotNull((Object)bl2);
        boolean bl11 = bl2;
        Intrinsics.checkNotNull((Object)bl3);
        boolean bl12 = bl3;
        Intrinsics.checkNotNull((Object)bl4);
        boolean bl13 = bl4;
        Intrinsics.checkNotNull((Object)bl5);
        boolean bl14 = bl5;
        Intrinsics.checkNotNull((Object)bl6);
        boolean bl15 = bl6;
        Intrinsics.checkNotNull((Object)bl7);
        boolean bl16 = bl7;
        Intrinsics.checkNotNull((Object)bl8);
        boolean bl17 = bl8;
        Intrinsics.checkNotNull((Object)bl9);
        boolean bl18 = bl9;
        Intrinsics.checkNotNull((Object)string5);
        return new org.gotson.komga.domain.model.BookMetadata(string, string2, string3, f2, localDate, authors, tags, string4, links2, bl10, bl11, bl12, bl13, bl14, bl15, bl16, bl17, bl18, string5, localDateTime2, localDateTime4);
    }

    private Author toDomain(BookMetadataAuthorRecord $this$toDomain) {
        String string = $this$toDomain.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = $this$toDomain.getRole();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getRole(...)");
        return new Author(string, string2);
    }

    public static final /* synthetic */ BookMetadata access$getD$p(BookMetadataDao $this) {
        return $this.d;
    }

    public static final /* synthetic */ BookMetadataAuthor access$getA$p(BookMetadataDao $this) {
        return $this.a;
    }
}

