/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.jooq.main;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.domain.model.AgeRestriction;
import org.gotson.komga.domain.model.AllowExclude;
import org.gotson.komga.domain.model.ApiKey;
import org.gotson.komga.domain.model.ContentRestrictions;
import org.gotson.komga.domain.model.KomgaUser;
import org.gotson.komga.domain.model.UserRoles;
import org.gotson.komga.domain.persistence.KomgaUserRepository;
import org.gotson.komga.infrastructure.jooq.main.KomgaUserDao;
import org.gotson.komga.jooq.main.Tables;
import org.gotson.komga.jooq.main.tables.AnnouncementsRead;
import org.gotson.komga.jooq.main.tables.User;
import org.gotson.komga.jooq.main.tables.UserApiKey;
import org.gotson.komga.jooq.main.tables.UserLibrarySharing;
import org.gotson.komga.jooq.main.tables.UserRole;
import org.gotson.komga.jooq.main.tables.UserSharing;
import org.gotson.komga.jooq.main.tables.records.AnnouncementsReadRecord;
import org.gotson.komga.jooq.main.tables.records.UserApiKeyRecord;
import org.gotson.komga.jooq.main.tables.records.UserLibrarySharingRecord;
import org.gotson.komga.jooq.main.tables.records.UserRecord;
import org.gotson.komga.jooq.main.tables.records.UserSharingRecord;
import org.gotson.komga.language.LanguageUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.InsertSetMoreStep;
import org.jooq.Record;
import org.jooq.RecordMapper;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectOnConditionStep;
import org.jooq.SelectSelectStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.UpdateSetMoreStep;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\b\u0010\u0018\u001a\u00020\u0015H\u0017J\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u0017H\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0016J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00170&2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020(0#2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001e\u0010)\u001a\u0010\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020(\u0018\u00010*2\u0006\u0010+\u001a\u00020\u0017H\u0016J\u0012\u0010,\u001a\u0004\u0018\u00010$2\u0006\u0010!\u001a\u00020\u0017H\u0016J\u0012\u0010-\u001a\u0004\u0018\u00010$2\u0006\u0010.\u001a\u00020\u0017H\u0016J\u0010\u0010/\u001a\u00020\u00152\u0006\u0010+\u001a\u00020(H\u0016J\u0010\u0010/\u001a\u00020\u00152\u0006\u00100\u001a\u00020$H\u0017J\u0010\u00101\u001a\u00020\u00152\u0006\u00100\u001a\u00020$H\u0012J\u0010\u00102\u001a\u00020\u00152\u0006\u00100\u001a\u00020$H\u0012J\u0010\u00103\u001a\u00020\u00152\u0006\u00100\u001a\u00020$H\u0012J\u001e\u00104\u001a\u00020\u00152\u0006\u00100\u001a\u00020$2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u00170&H\u0016J\u001b\u00106\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u0001080807\u00a2\u0006\u0002\b9H\u0012J\u0010\u0010:\u001a\u00020\u00152\u0006\u00100\u001a\u00020$H\u0017J\u0018\u0010;\u001a\b\u0012\u0004\u0012\u00020$0<*\b\u0012\u0004\u0012\u0002080=H\u0012J\f\u0010>\u001a\u00020(*\u00020?H\u0012R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\t0\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u0007*\u0004\u0018\u00010\u000b0\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u0007*\u0004\u0018\u00010\r0\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0007*\u0004\u0018\u00010\u000f0\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0007*\u0004\u0018\u00010\u00110\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lorg/gotson/komga/infrastructure/jooq/main/KomgaUserDao;", "Lorg/gotson/komga/domain/persistence/KomgaUserRepository;", "dsl", "Lorg/jooq/DSLContext;", "(Lorg/jooq/DSLContext;)V", "ar", "Lorg/gotson/komga/jooq/main/tables/AnnouncementsRead;", "kotlin.jvm.PlatformType", "u", "Lorg/gotson/komga/jooq/main/tables/User;", "uak", "Lorg/gotson/komga/jooq/main/tables/UserApiKey;", "ul", "Lorg/gotson/komga/jooq/main/tables/UserLibrarySharing;", "ur", "Lorg/gotson/komga/jooq/main/tables/UserRole;", "us", "Lorg/gotson/komga/jooq/main/tables/UserSharing;", "count", "", "delete", "", "userId", "", "deleteAll", "deleteApiKeyByIdAndUserId", "apiKeyId", "deleteApiKeyByUserId", "existsApiKeyByCommentAndUserId", "", "comment", "existsApiKeyByIdAndUserId", "existsByEmailIgnoreCase", "email", "findAll", "", "Lorg/gotson/komga/domain/model/KomgaUser;", "findAnnouncementIdsReadByUserId", "", "findApiKeyByUserId", "Lorg/gotson/komga/domain/model/ApiKey;", "findByApiKeyOrNull", "Lkotlin/Pair;", "apiKey", "findByEmailIgnoreCaseOrNull", "findByIdOrNull", "id", "insert", "user", "insertRoles", "insertSharedLibraries", "insertSharingRestrictions", "saveAnnouncementIdsRead", "announcementIds", "selectBase", "Lorg/jooq/SelectOnConditionStep;", "Lorg/jooq/Record;", "Lorg/jetbrains/annotations/NotNull;", "update", "fetchAndMap", "", "Lorg/jooq/ResultQuery;", "toDomain", "Lorg/gotson/komga/jooq/main/tables/records/UserApiKeyRecord;", "komga"})
@SourceDebugExtension(value={"SMAP\nKomgaUserDao.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KomgaUserDao.kt\norg/gotson/komga/infrastructure/jooq/main/KomgaUserDao\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,311:1\n125#2:312\n152#2,2:313\n154#2:342\n1603#3,9:315\n1855#3:324\n1856#3:326\n1612#3:327\n766#3:328\n857#3,2:329\n1549#3:331\n1620#3,3:332\n819#3:335\n847#3,2:336\n1549#3:338\n1620#3,3:339\n1549#3:343\n1620#3,3:344\n1855#3,2:347\n1855#3,2:349\n1855#3,2:351\n1855#3,2:353\n1#4:325\n*S KotlinDebug\n*F\n+ 1 KomgaUserDao.kt\norg/gotson/komga/infrastructure/jooq/main/KomgaUserDao\n*L\n65#1:312\n65#1:313,2\n65#1:342\n81#1:315,9\n81#1:324\n81#1:326\n81#1:327\n90#1:328\n90#1:329,2\n90#1:331\n90#1:332,3\n91#1:335\n91#1:336,2\n91#1:338\n91#1:339,3\n175#1:343\n175#1:344,3\n179#1:347,2\n189#1:349,2\n199#1:351,2\n207#1:353,2\n81#1:325\n*E\n"})
public class KomgaUserDao
implements KomgaUserRepository {
    @NotNull
    private final DSLContext dsl;
    private final User u;
    private final UserRole ur;
    private final UserLibrarySharing ul;
    private final UserSharing us;
    private final AnnouncementsRead ar;
    private final UserApiKey uak;

    public KomgaUserDao(@NotNull DSLContext dsl) {
        Intrinsics.checkNotNullParameter((Object)dsl, (String)"dsl");
        this.dsl = dsl;
        this.u = Tables.USER;
        this.ur = Tables.USER_ROLE;
        this.ul = Tables.USER_LIBRARY_SHARING;
        this.us = Tables.USER_SHARING;
        this.ar = Tables.ANNOUNCEMENTS_READ;
        this.uak = Tables.USER_API_KEY;
    }

    public long count() {
        return this.dsl.fetchCount((Table)this.u);
    }

    @NotNull
    public Collection<KomgaUser> findAll() {
        return this.fetchAndMap((ResultQuery)this.selectBase());
    }

    @NotNull
    public Collection<ApiKey> findApiKeyByUserId(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        List list = this.dsl.selectFrom((TableLike)this.uak).where(this.uak.USER_ID.eq((Object)userId)).fetchInto((Table)this.uak).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    @Nullable
    public KomgaUser findByIdOrNull(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        SelectConditionStep selectConditionStep = this.selectBase().where(this.u.ID.equal((Object)id));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"where(...)");
        return (KomgaUser)CollectionsKt.firstOrNull((List)this.fetchAndMap((ResultQuery)selectConditionStep));
    }

    private @NotNull SelectOnConditionStep<Record> selectBase() {
        Field[] fieldArray = this.u.fields();
        SelectSelectStep selectSelectStep = this.dsl.select((SelectFieldOrAsterisk[])Arrays.copyOf(fieldArray, fieldArray.length));
        fieldArray = new SelectFieldOrAsterisk[]{this.ul.LIBRARY_ID};
        SelectOnConditionStep selectOnConditionStep = selectSelectStep.select((SelectFieldOrAsterisk[])fieldArray).from((TableLike)this.u).leftJoin((TableLike)this.ul).onKey();
        Intrinsics.checkNotNullExpressionValue((Object)selectOnConditionStep, (String)"onKey(...)");
        return selectOnConditionStep;
    }

    /*
     * WARNING - void declaration
     */
    private List<KomgaUser> fetchAndMap(ResultQuery<Record> $this$fetchAndMap) {
        void $this$mapTo$iv$iv;
        Map map = $this$fetchAndMap.fetchGroups((RecordMapper)new /* Unavailable Anonymous Inner Class!! */, (RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"fetchGroups(...)");
        Map $this$map$iv = map;
        boolean $i$f$map = false;
        Map map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            String string;
            Iterable $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv2;
            UserSharingRecord it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            AgeRestriction ageRestriction;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            List roles2;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            UserRecord userRecord = (UserRecord)entry.getKey();
            List ulr = (List)entry.getValue();
            SelectConditionStep selectConditionStep = this.dsl.selectFrom((TableLike)this.us).where(this.us.USER_ID.eq((Object)userRecord.getId()));
            Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"where(...)");
            List usr = CollectionsKt.toList((Iterable)((Iterable)selectConditionStep));
            Intrinsics.checkNotNullExpressionValue((Object)this.dsl.select((SelectField)this.ur.ROLE).from((TableLike)this.ur).where(this.ur.USER_ID.eq((Object)userRecord.getId())).fetch((Field)this.ur.ROLE), (String)"fetch(...)");
            String string2 = userRecord.getEmail();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getEmail(...)");
            String string3 = userRecord.getPassword();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPassword(...)");
            Set set = UserRoles.Companion.valuesOf((Iterable)roles2);
            Intrinsics.checkNotNull((Object)ulr);
            Iterable iterable = ulr;
            Set set2 = set;
            String string4 = string3;
            String string5 = string2;
            boolean $i$f$mapNotNull = false;
            void var20_20 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                UserLibrarySharingRecord it2 = (UserLibrarySharingRecord)element$iv$iv;
                boolean bl3 = false;
                if (it2.getLibraryId() == null) continue;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Collection collection2 = (List)destination$iv$iv2;
            Set set3 = CollectionsKt.toSet((Iterable)collection2);
            Boolean bl5 = userRecord.getSharedAllLibraries();
            Intrinsics.checkNotNullExpressionValue((Object)bl5, (String)"getSharedAllLibraries(...)");
            boolean bl6 = bl5;
            if (userRecord.getAgeRestriction() != null && userRecord.getAgeRestrictionAllowOnly() != null) {
                Integer n = userRecord.getAgeRestriction();
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getAgeRestriction(...)");
                int n2 = ((Number)n).intValue();
                Boolean bl7 = userRecord.getAgeRestrictionAllowOnly();
                Intrinsics.checkNotNullExpressionValue((Object)bl7, (String)"getAgeRestrictionAllowOnly(...)");
                ageRestriction = new AgeRestriction(n2, bl7 != false ? AllowExclude.ALLOW_ONLY : AllowExclude.EXCLUDE);
            } else {
                ageRestriction = null;
            }
            $this$mapNotNull$iv = usr;
            AgeRestriction ageRestriction2 = ageRestriction;
            boolean bl8 = bl6;
            collection2 = set3;
            boolean $i$f$filter = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (UserSharingRecord)element$iv$iv;
                boolean bl9 = false;
                Boolean bl10 = it.getAllow();
                Intrinsics.checkNotNullExpressionValue((Object)bl10, (String)"getAllow(...)");
                if (!bl10.booleanValue()) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            Collection<String> collection3 = (List)destination$iv$iv2;
            $this$filter$iv = collection3;
            boolean $i$f$map2 = false;
            $this$filterTo$iv$iv = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                it = (UserSharingRecord)item$iv$iv2;
                collection3 = destination$iv$iv2;
                boolean bl11 = false;
                collection3.add(it.getLabel());
            }
            collection3 = (List)destination$iv$iv2;
            $this$map$iv2 = usr;
            collection3 = CollectionsKt.toSet((Iterable)collection3);
            boolean $i$f$filterNot = false;
            $this$mapTo$iv$iv2 = $this$filterNot$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                it = (UserSharingRecord)element$iv$iv;
                boolean bl12 = false;
                Boolean bl13 = it.getAllow();
                Intrinsics.checkNotNullExpressionValue((Object)bl13, (String)"getAllow(...)");
                if (bl13.booleanValue()) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            Collection<String> collection4 = (List)destination$iv$iv2;
            $this$filterNot$iv = collection4;
            $i$f$map2 = false;
            $this$filterNotTo$iv$iv = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            $i$f$mapTo2 = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv2) {
                it = (UserSharingRecord)item$iv$iv3;
                collection4 = destination$iv$iv2;
                boolean bl14 = false;
                collection4.add(it.getLabel());
            }
            collection4 = (List)destination$iv$iv2;
            Set set4 = CollectionsKt.toSet((Iterable)collection4);
            Collection<String> collection5 = collection3;
            AgeRestriction ageRestriction3 = ageRestriction2;
            ContentRestrictions contentRestrictions = new ContentRestrictions(ageRestriction3, collection5, set4);
            Intrinsics.checkNotNullExpressionValue((Object)userRecord.getId(), (String)"getId(...)");
            LocalDateTime localDateTime = userRecord.getCreatedDate();
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"getCreatedDate(...)");
            LocalDateTime localDateTime2 = LanguageUtilsKt.toCurrentTimeZone((LocalDateTime)localDateTime);
            LocalDateTime localDateTime3 = userRecord.getLastModifiedDate();
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime3, (String)"getLastModifiedDate(...)");
            LocalDateTime localDateTime4 = LanguageUtilsKt.toCurrentTimeZone((LocalDateTime)localDateTime3);
            LocalDateTime localDateTime5 = localDateTime2;
            ContentRestrictions contentRestrictions2 = contentRestrictions;
            boolean bl15 = bl8;
            Collection collection6 = collection2;
            Set set5 = set2;
            String string6 = string4;
            String string7 = string5;
            collection.add(new KomgaUser(string7, string6, set5, (Set)collection6, bl15, contentRestrictions2, string, localDateTime5, localDateTime4));
        }
        return (List)destination$iv$iv;
    }

    @Transactional
    public void insert(@NotNull KomgaUser user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        AgeRestriction ageRestriction = user.getRestrictions().getAgeRestriction();
        InsertSetMoreStep insertSetMoreStep = this.dsl.insertInto((Table)this.u).set((Field)this.u.ID, (Object)user.getId()).set((Field)this.u.EMAIL, (Object)user.getEmail()).set((Field)this.u.PASSWORD, (Object)user.getPassword()).set((Field)this.u.SHARED_ALL_LIBRARIES, (Object)user.getSharedAllLibraries()).set((Field)this.u.AGE_RESTRICTION, (Object)(ageRestriction != null ? Integer.valueOf(ageRestriction.getAge()) : null));
        Field field = (Field)this.u.AGE_RESTRICTION_ALLOW_ONLY;
        AgeRestriction ageRestriction2 = user.getRestrictions().getAgeRestriction();
        Object object = ageRestriction2 != null ? ageRestriction2.getRestriction() : null;
        insertSetMoreStep.set(field, (Object)(switch (object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object.ordinal()]) {
            case 1 -> true;
            case 2 -> false;
            case -1 -> null;
            default -> throw new NoWhenBranchMatchedException();
        })).execute();
        this.insertRoles(user);
        this.insertSharedLibraries(user);
        this.insertSharingRestrictions(user);
    }

    public void insert(@NotNull ApiKey apiKey) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        this.dsl.insertInto((Table)this.uak).set((Field)this.uak.ID, (Object)apiKey.getId()).set((Field)this.uak.USER_ID, (Object)apiKey.getUserId()).set((Field)this.uak.API_KEY, (Object)apiKey.getKey()).set((Field)this.uak.COMMENT, (Object)apiKey.getComment()).execute();
    }

    @Transactional
    public void update(@NotNull KomgaUser user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        AgeRestriction ageRestriction = user.getRestrictions().getAgeRestriction();
        UpdateSetMoreStep updateSetMoreStep = this.dsl.update((Table)this.u).set((Field)this.u.EMAIL, (Object)user.getEmail()).set((Field)this.u.PASSWORD, (Object)user.getPassword()).set((Field)this.u.SHARED_ALL_LIBRARIES, (Object)user.getSharedAllLibraries()).set((Field)this.u.AGE_RESTRICTION, (Object)(ageRestriction != null ? Integer.valueOf(ageRestriction.getAge()) : null));
        Field field = (Field)this.u.AGE_RESTRICTION_ALLOW_ONLY;
        AgeRestriction ageRestriction2 = user.getRestrictions().getAgeRestriction();
        Object object = ageRestriction2 != null ? ageRestriction2.getRestriction() : null;
        updateSetMoreStep.set(field, (Object)(switch (object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object.ordinal()]) {
            case 1 -> true;
            case 2 -> false;
            case -1 -> null;
            default -> throw new NoWhenBranchMatchedException();
        })).set((Field)this.u.LAST_MODIFIED_DATE, (Object)LocalDateTime.now(ZoneId.of("Z"))).where(this.u.ID.eq((Object)user.getId())).execute();
        this.dsl.deleteFrom((Table)this.ur).where(this.ur.USER_ID.eq((Object)user.getId())).execute();
        this.dsl.deleteFrom((Table)this.ul).where(this.ul.USER_ID.eq((Object)user.getId())).execute();
        this.dsl.deleteFrom((Table)this.us).where(this.us.USER_ID.eq((Object)user.getId())).execute();
        this.insertRoles(user);
        this.insertSharedLibraries(user);
        this.insertSharingRestrictions(user);
    }

    /*
     * WARNING - void declaration
     */
    public void saveAnnouncementIdsRead(@NotNull KomgaUser user, @NotNull Set<String> announcementIds) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter(announcementIds, (String)"announcementIds");
        Iterable iterable = announcementIds;
        DSLContext dSLContext = this.dsl;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new AnnouncementsReadRecord(user.getId(), (String)it));
        }
        dSLContext.batchStore((Collection)((List)destination$iv$iv)).execute();
    }

    private void insertRoles(KomgaUser user) {
        Iterable $this$forEach$iv = user.getRoles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UserRoles it = (UserRoles)element$iv;
            boolean bl = false;
            this.dsl.insertInto((Table)this.ur).columns((Field)this.ur.USER_ID, (Field)this.ur.ROLE).values((Object)user.getId(), (Object)it.name()).execute();
        }
    }

    private void insertSharedLibraries(KomgaUser user) {
        Iterable $this$forEach$iv = user.getSharedLibrariesIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.dsl.insertInto((Table)this.ul).columns((Field)this.ul.USER_ID, (Field)this.ul.LIBRARY_ID).values((Object)user.getId(), (Object)it).execute();
        }
    }

    private void insertSharingRestrictions(KomgaUser user) {
        String label;
        Iterable $this$forEach$iv = user.getRestrictions().getLabelsAllow();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            label = (String)element$iv;
            boolean bl = false;
            this.dsl.insertInto((Table)this.us).columns((Field)this.us.USER_ID, (Field)this.us.ALLOW, (Field)this.us.LABEL).values((Object)user.getId(), (Object)true, (Object)label).execute();
        }
        $this$forEach$iv = user.getRestrictions().getLabelsExclude();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            label = (String)element$iv;
            boolean bl = false;
            this.dsl.insertInto((Table)this.us).columns((Field)this.us.USER_ID, (Field)this.us.ALLOW, (Field)this.us.LABEL).values((Object)user.getId(), (Object)false, (Object)label).execute();
        }
    }

    @Transactional
    public void delete(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        this.dsl.deleteFrom((Table)this.uak).where(this.uak.USER_ID.equal((Object)userId)).execute();
        this.dsl.deleteFrom((Table)this.ar).where(this.ar.USER_ID.equal((Object)userId)).execute();
        this.dsl.deleteFrom((Table)this.us).where(this.us.USER_ID.equal((Object)userId)).execute();
        this.dsl.deleteFrom((Table)this.ul).where(this.ul.USER_ID.equal((Object)userId)).execute();
        this.dsl.deleteFrom((Table)this.ur).where(this.ur.USER_ID.equal((Object)userId)).execute();
        this.dsl.deleteFrom((Table)this.u).where(this.u.ID.equal((Object)userId)).execute();
    }

    @Transactional
    public void deleteAll() {
        this.dsl.deleteFrom((Table)this.uak).execute();
        this.dsl.deleteFrom((Table)this.ar).execute();
        this.dsl.deleteFrom((Table)this.us).execute();
        this.dsl.deleteFrom((Table)this.ul).execute();
        this.dsl.deleteFrom((Table)this.ur).execute();
        this.dsl.deleteFrom((Table)this.u).execute();
    }

    public void deleteApiKeyByIdAndUserId(@NotNull String apiKeyId, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)apiKeyId, (String)"apiKeyId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        this.dsl.deleteFrom((Table)this.uak).where(this.uak.ID.eq((Object)apiKeyId)).and(this.uak.USER_ID.eq((Object)userId)).execute();
    }

    public void deleteApiKeyByUserId(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        this.dsl.deleteFrom((Table)this.uak).where(this.uak.USER_ID.eq((Object)userId)).execute();
    }

    @NotNull
    public Set<String> findAnnouncementIdsReadByUserId(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Set set = this.dsl.select((SelectField)this.ar.ANNOUNCEMENT_ID).from((TableLike)this.ar).where(this.ar.USER_ID.eq((Object)userId)).fetchSet((Field)this.ar.ANNOUNCEMENT_ID);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"fetchSet(...)");
        return set;
    }

    public boolean existsByEmailIgnoreCase(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        return this.dsl.fetchExists((Select)this.dsl.selectFrom((TableLike)this.u).where(this.u.EMAIL.equalIgnoreCase(email)));
    }

    public boolean existsApiKeyByIdAndUserId(@NotNull String apiKeyId, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)apiKeyId, (String)"apiKeyId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return this.dsl.fetchExists((Table)this.uak, this.uak.ID.eq((Object)apiKeyId).and(this.uak.USER_ID.eq((Object)userId)));
    }

    public boolean existsApiKeyByCommentAndUserId(@NotNull String comment, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return this.dsl.fetchExists((Table)this.uak, this.uak.COMMENT.equalIgnoreCase(comment).and(this.uak.USER_ID.eq((Object)userId)));
    }

    @Nullable
    public KomgaUser findByEmailIgnoreCaseOrNull(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        SelectConditionStep selectConditionStep = this.selectBase().where(this.u.EMAIL.equalIgnoreCase(email));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"where(...)");
        return (KomgaUser)CollectionsKt.firstOrNull((List)this.fetchAndMap((ResultQuery)selectConditionStep));
    }

    @Nullable
    public Pair<KomgaUser, ApiKey> findByApiKeyOrNull(@NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        SelectConditionStep selectConditionStep = this.selectBase().leftJoin((TableLike)this.uak).on(this.u.ID.eq((Field)this.uak.USER_ID)).where(this.uak.API_KEY.eq((Object)apiKey));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"where(...)");
        KomgaUser komgaUser = (KomgaUser)CollectionsKt.firstOrNull((List)this.fetchAndMap((ResultQuery)selectConditionStep));
        if (komgaUser == null) {
            return null;
        }
        KomgaUser user = komgaUser;
        List list = this.dsl.selectFrom((TableLike)this.uak).where(this.uak.API_KEY.eq((Object)apiKey)).fetchInto((Table)this.uak).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        ApiKey apiKey2 = (ApiKey)CollectionsKt.firstOrNull((List)list);
        if (apiKey2 == null) {
            return null;
        }
        ApiKey key2 = apiKey2;
        return new Pair((Object)user, (Object)key2);
    }

    private ApiKey toDomain(UserApiKeyRecord $this$toDomain) {
        String string = $this$toDomain.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        String string2 = $this$toDomain.getUserId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUserId(...)");
        String string3 = $this$toDomain.getApiKey();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getApiKey(...)");
        String string4 = $this$toDomain.getComment();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getComment(...)");
        LocalDateTime localDateTime = $this$toDomain.getCreatedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"getCreatedDate(...)");
        LocalDateTime localDateTime2 = LanguageUtilsKt.toCurrentTimeZone((LocalDateTime)localDateTime);
        LocalDateTime localDateTime3 = $this$toDomain.getLastModifiedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime3, (String)"getLastModifiedDate(...)");
        return new ApiKey(string, string2, string3, string4, localDateTime2, LanguageUtilsKt.toCurrentTimeZone((LocalDateTime)localDateTime3));
    }

    public static final /* synthetic */ ApiKey access$toDomain(KomgaUserDao $this, UserApiKeyRecord $receiver) {
        return $this.toDomain($receiver);
    }

    public static final /* synthetic */ User access$getU$p(KomgaUserDao $this) {
        return $this.u;
    }

    public static final /* synthetic */ UserLibrarySharing access$getUl$p(KomgaUserDao $this) {
        return $this.ul;
    }
}

