/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.jooq.main;

import java.net.URL;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.domain.model.Library;
import org.gotson.komga.domain.persistence.LibraryRepository;
import org.gotson.komga.jooq.main.Tables;
import org.gotson.komga.jooq.main.tables.Library;
import org.gotson.komga.jooq.main.tables.LibraryExclusions;
import org.gotson.komga.jooq.main.tables.UserLibrarySharing;
import org.gotson.komga.jooq.main.tables.records.LibraryExclusionsRecord;
import org.gotson.komga.jooq.main.tables.records.LibraryRecord;
import org.gotson.komga.language.LanguageUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.BatchBindStep;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.RecordMapper;
import org.jooq.ResultQuery;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectOnConditionStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\b\u0010\u0012\u001a\u00020\u000fH\u0017J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u001b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J#\u0010\u001c\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u001e0\u001e0\u001d\u00a2\u0006\u0002\b\u001f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0012J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u0015H\u0017J\u0010\u0010\"\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u0015H\u0012J\u001b\u0010#\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u001e0\u001e0$\u00a2\u0006\u0002\b\u001fH\u0012J\u0010\u0010%\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u0015H\u0017J\u0018\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014*\b\u0012\u0004\u0012\u00020\u001e0'H\u0012J\u001a\u0010(\u001a\u00020\u0015*\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00110\u001bH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\t0\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u0007*\u0004\u0018\u00010\u000b0\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/gotson/komga/infrastructure/jooq/main/LibraryDao;", "Lorg/gotson/komga/domain/persistence/LibraryRepository;", "dsl", "Lorg/jooq/DSLContext;", "(Lorg/jooq/DSLContext;)V", "l", "Lorg/gotson/komga/jooq/main/tables/Library;", "kotlin.jvm.PlatformType", "le", "Lorg/gotson/komga/jooq/main/tables/LibraryExclusions;", "ul", "Lorg/gotson/komga/jooq/main/tables/UserLibrarySharing;", "count", "", "delete", "", "libraryId", "", "deleteAll", "findAll", "", "Lorg/gotson/komga/domain/model/Library;", "findAllByIds", "libraryIds", "findById", "findByIdOrNull", "findDirectoryExclusions", "", "findOne", "Lorg/jooq/SelectConditionStep;", "Lorg/jooq/Record;", "Lorg/jetbrains/annotations/NotNull;", "insert", "library", "insertDirectoryExclusions", "selectBase", "Lorg/jooq/SelectOnConditionStep;", "update", "fetchAndMap", "Lorg/jooq/ResultQuery;", "toDomain", "Lorg/gotson/komga/jooq/main/tables/records/LibraryRecord;", "directoryExclusions", "komga"})
@SourceDebugExtension(value={"SMAP\nLibraryDao.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryDao.kt\norg/gotson/komga/infrastructure/jooq/main/LibraryDao\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,214:1\n125#2:215\n152#2,2:216\n154#2:231\n1603#3,9:218\n1855#3:227\n1856#3:229\n1612#3:230\n1855#3,2:232\n1#4:228\n*S KotlinDebug\n*F\n+ 1 LibraryDao.kt\norg/gotson/komga/infrastructure/jooq/main/LibraryDao\n*L\n58#1:215\n58#1:216,2\n58#1:231\n59#1:218,9\n59#1:227\n59#1:229\n59#1:230\n171#1:232,2\n59#1:228\n*E\n"})
public class LibraryDao
implements LibraryRepository {
    @NotNull
    private final DSLContext dsl;
    private final Library l;
    private final UserLibrarySharing ul;
    private final LibraryExclusions le;

    public LibraryDao(@NotNull DSLContext dsl) {
        Intrinsics.checkNotNullParameter((Object)dsl, (String)"dsl");
        this.dsl = dsl;
        this.l = Tables.LIBRARY;
        this.ul = Tables.USER_LIBRARY_SHARING;
        this.le = Tables.LIBRARY_EXCLUSIONS;
    }

    @Nullable
    public org.gotson.komga.domain.model.Library findByIdOrNull(@NotNull String libraryId) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        return (org.gotson.komga.domain.model.Library)CollectionsKt.firstOrNull((Iterable)this.fetchAndMap((ResultQuery)this.findOne(libraryId)));
    }

    @NotNull
    public org.gotson.komga.domain.model.Library findById(@NotNull String libraryId) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        return (org.gotson.komga.domain.model.Library)CollectionsKt.first((Iterable)this.fetchAndMap((ResultQuery)this.findOne(libraryId)));
    }

    private @NotNull SelectConditionStep<Record> findOne(String libraryId) {
        SelectConditionStep selectConditionStep = this.selectBase().where(this.l.ID.eq((Object)libraryId));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"where(...)");
        return selectConditionStep;
    }

    @NotNull
    public Collection<org.gotson.komga.domain.model.Library> findAll() {
        return this.fetchAndMap((ResultQuery)this.selectBase());
    }

    @NotNull
    public Collection<org.gotson.komga.domain.model.Library> findAllByIds(@NotNull Collection<String> libraryIds) {
        Intrinsics.checkNotNullParameter(libraryIds, (String)"libraryIds");
        SelectConditionStep selectConditionStep = this.selectBase().where(this.l.ID.in(libraryIds));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"where(...)");
        return this.fetchAndMap((ResultQuery)selectConditionStep);
    }

    private @NotNull SelectOnConditionStep<Record> selectBase() {
        SelectOnConditionStep selectOnConditionStep = this.dsl.select(new SelectFieldOrAsterisk[0]).from((TableLike)this.l).leftJoin((TableLike)this.le).onKey();
        Intrinsics.checkNotNullExpressionValue((Object)selectOnConditionStep, (String)"onKey(...)");
        return selectOnConditionStep;
    }

    /*
     * WARNING - void declaration
     */
    private Collection<org.gotson.komga.domain.model.Library> fetchAndMap(ResultQuery<Record> $this$fetchAndMap) {
        void $this$mapTo$iv$iv;
        Map map = $this$fetchAndMap.fetchGroups((RecordMapper)new /* Unavailable Anonymous Inner Class!! */, (RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"fetchGroups(...)");
        Map $this$map$iv = map;
        boolean $i$f$map = false;
        Map map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            LibraryRecord lr = (LibraryRecord)entry.getKey();
            List ler = (List)entry.getValue();
            Intrinsics.checkNotNull((Object)lr);
            Intrinsics.checkNotNull((Object)ler);
            Iterable iterable = ler;
            LibraryRecord libraryRecord = lr;
            LibraryDao libraryDao = this;
            boolean $i$f$mapNotNull = false;
            void var17_17 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                LibraryExclusionsRecord it = (LibraryExclusionsRecord)element$iv$iv;
                boolean bl3 = false;
                if (it.getExclusion() == null) continue;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv2;
            collection.add(libraryDao.toDomain(libraryRecord, CollectionsKt.toSet((Iterable)list)));
        }
        return (List)destination$iv$iv;
    }

    @Transactional
    public void delete(@NotNull String libraryId) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        this.dsl.deleteFrom((Table)this.le).where(this.le.LIBRARY_ID.eq((Object)libraryId)).execute();
        this.dsl.deleteFrom((Table)this.ul).where(this.ul.LIBRARY_ID.eq((Object)libraryId)).execute();
        this.dsl.deleteFrom((Table)this.l).where(this.l.ID.eq((Object)libraryId)).execute();
    }

    @Transactional
    public void deleteAll() {
        this.dsl.deleteFrom((Table)this.le).execute();
        this.dsl.deleteFrom((Table)this.ul).execute();
        this.dsl.deleteFrom((Table)this.l).execute();
    }

    @Transactional
    public void insert(@NotNull org.gotson.komga.domain.model.Library library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        this.dsl.insertInto((Table)this.l).set((Field)this.l.ID, (Object)library.getId()).set((Field)this.l.NAME, (Object)library.getName()).set((Field)this.l.ROOT, (Object)library.getRoot().toString()).set((Field)this.l.IMPORT_COMICINFO_BOOK, (Object)library.getImportComicInfoBook()).set((Field)this.l.IMPORT_COMICINFO_SERIES, (Object)library.getImportComicInfoSeries()).set((Field)this.l.IMPORT_COMICINFO_COLLECTION, (Object)library.getImportComicInfoCollection()).set((Field)this.l.IMPORT_COMICINFO_READLIST, (Object)library.getImportComicInfoReadList()).set((Field)this.l.IMPORT_COMICINFO_SERIES_APPEND_VOLUME, (Object)library.getImportComicInfoSeriesAppendVolume()).set((Field)this.l.IMPORT_EPUB_BOOK, (Object)library.getImportEpubBook()).set((Field)this.l.IMPORT_EPUB_SERIES, (Object)library.getImportEpubSeries()).set((Field)this.l.IMPORT_MYLAR_SERIES, (Object)library.getImportMylarSeries()).set((Field)this.l.IMPORT_LOCAL_ARTWORK, (Object)library.getImportLocalArtwork()).set((Field)this.l.IMPORT_BARCODE_ISBN, (Object)library.getImportBarcodeIsbn()).set((Field)this.l.SCAN_FORCE_MODIFIED_TIME, (Object)library.getScanForceModifiedTime()).set((Field)this.l.SCAN_CBX, (Object)library.getScanCbx()).set((Field)this.l.SCAN_PDF, (Object)library.getScanPdf()).set((Field)this.l.SCAN_EPUB, (Object)library.getScanEpub()).set((Field)this.l.SCAN_STARTUP, (Object)library.getScanOnStartup()).set((Field)this.l.SCAN_INTERVAL, (Object)library.getScanInterval().toString()).set((Field)this.l.REPAIR_EXTENSIONS, (Object)library.getRepairExtensions()).set((Field)this.l.CONVERT_TO_CBZ, (Object)library.getConvertToCbz()).set((Field)this.l.EMPTY_TRASH_AFTER_SCAN, (Object)library.getEmptyTrashAfterScan()).set((Field)this.l.SERIES_COVER, (Object)library.getSeriesCover().toString()).set((Field)this.l.HASH_FILES, (Object)library.getHashFiles()).set((Field)this.l.HASH_PAGES, (Object)library.getHashPages()).set((Field)this.l.HASH_KOREADER, (Object)library.getHashKoreader()).set((Field)this.l.ANALYZE_DIMENSIONS, (Object)library.getAnalyzeDimensions()).set((Field)this.l.ONESHOTS_DIRECTORY, (Object)library.getOneshotsDirectory()).set((Field)this.l.UNAVAILABLE_DATE, (Object)library.getUnavailableDate()).execute();
        this.insertDirectoryExclusions(library);
    }

    @Transactional
    public void update(@NotNull org.gotson.komga.domain.model.Library library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        this.dsl.update((Table)this.l).set((Field)this.l.NAME, (Object)library.getName()).set((Field)this.l.ROOT, (Object)library.getRoot().toString()).set((Field)this.l.IMPORT_COMICINFO_BOOK, (Object)library.getImportComicInfoBook()).set((Field)this.l.IMPORT_COMICINFO_SERIES, (Object)library.getImportComicInfoSeries()).set((Field)this.l.IMPORT_COMICINFO_COLLECTION, (Object)library.getImportComicInfoCollection()).set((Field)this.l.IMPORT_COMICINFO_READLIST, (Object)library.getImportComicInfoReadList()).set((Field)this.l.IMPORT_COMICINFO_SERIES_APPEND_VOLUME, (Object)library.getImportComicInfoSeriesAppendVolume()).set((Field)this.l.IMPORT_EPUB_BOOK, (Object)library.getImportEpubBook()).set((Field)this.l.IMPORT_EPUB_SERIES, (Object)library.getImportEpubSeries()).set((Field)this.l.IMPORT_MYLAR_SERIES, (Object)library.getImportMylarSeries()).set((Field)this.l.IMPORT_LOCAL_ARTWORK, (Object)library.getImportLocalArtwork()).set((Field)this.l.IMPORT_BARCODE_ISBN, (Object)library.getImportBarcodeIsbn()).set((Field)this.l.SCAN_FORCE_MODIFIED_TIME, (Object)library.getScanForceModifiedTime()).set((Field)this.l.SCAN_CBX, (Object)library.getScanCbx()).set((Field)this.l.SCAN_PDF, (Object)library.getScanPdf()).set((Field)this.l.SCAN_EPUB, (Object)library.getScanEpub()).set((Field)this.l.SCAN_STARTUP, (Object)library.getScanOnStartup()).set((Field)this.l.SCAN_INTERVAL, (Object)library.getScanInterval().toString()).set((Field)this.l.REPAIR_EXTENSIONS, (Object)library.getRepairExtensions()).set((Field)this.l.CONVERT_TO_CBZ, (Object)library.getConvertToCbz()).set((Field)this.l.EMPTY_TRASH_AFTER_SCAN, (Object)library.getEmptyTrashAfterScan()).set((Field)this.l.SERIES_COVER, (Object)library.getSeriesCover().toString()).set((Field)this.l.HASH_FILES, (Object)library.getHashFiles()).set((Field)this.l.HASH_PAGES, (Object)library.getHashPages()).set((Field)this.l.HASH_KOREADER, (Object)library.getHashKoreader()).set((Field)this.l.ANALYZE_DIMENSIONS, (Object)library.getAnalyzeDimensions()).set((Field)this.l.ONESHOTS_DIRECTORY, (Object)library.getOneshotsDirectory()).set((Field)this.l.UNAVAILABLE_DATE, (Object)library.getUnavailableDate()).set((Field)this.l.LAST_MODIFIED_DATE, (Object)LocalDateTime.now(ZoneId.of("Z"))).where(this.l.ID.eq((Object)library.getId())).execute();
        this.dsl.deleteFrom((Table)this.le).where(this.le.LIBRARY_ID.eq((Object)library.getId())).execute();
        this.insertDirectoryExclusions(library);
    }

    public long count() {
        return this.dsl.fetchCount((Table)this.l);
    }

    @NotNull
    public Set<String> findDirectoryExclusions(@NotNull String libraryId) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        Set set = this.dsl.select((SelectField)this.le.EXCLUSION).from((TableLike)this.le).where(this.le.LIBRARY_ID.eq((Object)libraryId)).fetchSet((Field)this.le.EXCLUSION);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"fetchSet(...)");
        return set;
    }

    private void insertDirectoryExclusions(org.gotson.komga.domain.model.Library library) {
        if (!((Collection)library.getScanDirectoryExclusions()).isEmpty()) {
            BatchBindStep batchBindStep;
            BatchBindStep step = batchBindStep = this.dsl.batch((Query)this.dsl.insertInto((Table)this.le, (Field)this.le.LIBRARY_ID, (Field)this.le.EXCLUSION).values(null, null));
            boolean bl = false;
            Iterable $this$forEach$iv = library.getScanDirectoryExclusions();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                Object[] objectArray = new Object[]{library.getId(), it};
                step.bind(objectArray);
            }
            batchBindStep.execute();
        }
    }

    private org.gotson.komga.domain.model.Library toDomain(LibraryRecord $this$toDomain, Set<String> directoryExclusions) {
        String string = $this$toDomain.getName();
        URL uRL = new URL($this$toDomain.getRoot());
        Boolean bl = $this$toDomain.getImportComicinfoBook();
        Boolean bl2 = $this$toDomain.getImportComicinfoSeries();
        Boolean bl3 = $this$toDomain.getImportComicinfoCollection();
        Boolean bl4 = $this$toDomain.getImportComicinfoReadlist();
        Boolean bl5 = $this$toDomain.getImportComicinfoSeriesAppendVolume();
        Boolean bl6 = $this$toDomain.getImportEpubBook();
        Boolean bl7 = $this$toDomain.getImportEpubSeries();
        Boolean bl8 = $this$toDomain.getImportMylarSeries();
        Boolean bl9 = $this$toDomain.getImportLocalArtwork();
        Boolean bl10 = $this$toDomain.getImportBarcodeIsbn();
        Boolean bl11 = $this$toDomain.getScanForceModifiedTime();
        Boolean bl12 = $this$toDomain.getScanCbx();
        Boolean bl13 = $this$toDomain.getScanPdf();
        Boolean bl14 = $this$toDomain.getScanEpub();
        Boolean bl15 = $this$toDomain.getScanStartup();
        String string2 = $this$toDomain.getScanInterval();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getScanInterval(...)");
        Library.ScanInterval scanInterval = Library.ScanInterval.valueOf((String)string2);
        Boolean bl16 = $this$toDomain.getRepairExtensions();
        Boolean bl17 = $this$toDomain.getConvertToCbz();
        Boolean bl18 = $this$toDomain.getEmptyTrashAfterScan();
        String string3 = $this$toDomain.getSeriesCover();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getSeriesCover(...)");
        Library.SeriesCover seriesCover = Library.SeriesCover.valueOf((String)string3);
        Boolean bl19 = $this$toDomain.getHashFiles();
        Boolean bl20 = $this$toDomain.getHashPages();
        Boolean bl21 = $this$toDomain.getHashKoreader();
        Boolean bl22 = $this$toDomain.getAnalyzeDimensions();
        String string4 = $this$toDomain.getOneshotsDirectory();
        LocalDateTime localDateTime = $this$toDomain.getUnavailableDate();
        String string5 = $this$toDomain.getId();
        LocalDateTime localDateTime2 = $this$toDomain.getCreatedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"getCreatedDate(...)");
        LocalDateTime localDateTime3 = LanguageUtilsKt.toCurrentTimeZone((LocalDateTime)localDateTime2);
        LocalDateTime localDateTime4 = $this$toDomain.getLastModifiedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime4, (String)"getLastModifiedDate(...)");
        LocalDateTime localDateTime5 = LanguageUtilsKt.toCurrentTimeZone((LocalDateTime)localDateTime4);
        Intrinsics.checkNotNull((Object)string);
        Intrinsics.checkNotNull((Object)bl);
        boolean bl23 = bl;
        Intrinsics.checkNotNull((Object)bl2);
        boolean bl24 = bl2;
        Intrinsics.checkNotNull((Object)bl3);
        boolean bl25 = bl3;
        Intrinsics.checkNotNull((Object)bl4);
        boolean bl26 = bl4;
        Intrinsics.checkNotNull((Object)bl5);
        boolean bl27 = bl5;
        Intrinsics.checkNotNull((Object)bl6);
        boolean bl28 = bl6;
        Intrinsics.checkNotNull((Object)bl7);
        boolean bl29 = bl7;
        Intrinsics.checkNotNull((Object)bl8);
        boolean bl30 = bl8;
        Intrinsics.checkNotNull((Object)bl9);
        boolean bl31 = bl9;
        Intrinsics.checkNotNull((Object)bl10);
        boolean bl32 = bl10;
        Intrinsics.checkNotNull((Object)bl11);
        boolean bl33 = bl11;
        Intrinsics.checkNotNull((Object)bl15);
        boolean bl34 = bl15;
        Intrinsics.checkNotNull((Object)bl12);
        boolean bl35 = bl12;
        Intrinsics.checkNotNull((Object)bl13);
        boolean bl36 = bl13;
        Intrinsics.checkNotNull((Object)bl14);
        boolean bl37 = bl14;
        Intrinsics.checkNotNull((Object)bl16);
        boolean bl38 = bl16;
        Intrinsics.checkNotNull((Object)bl17);
        boolean bl39 = bl17;
        Intrinsics.checkNotNull((Object)bl18);
        boolean bl40 = bl18;
        Intrinsics.checkNotNull((Object)bl19);
        boolean bl41 = bl19;
        Intrinsics.checkNotNull((Object)bl20);
        boolean bl42 = bl20;
        Intrinsics.checkNotNull((Object)bl21);
        boolean bl43 = bl21;
        Intrinsics.checkNotNull((Object)bl22);
        boolean bl44 = bl22;
        Intrinsics.checkNotNull((Object)string5);
        return new org.gotson.komga.domain.model.Library(string, uRL, bl23, bl24, bl25, bl26, bl27, bl28, bl29, bl30, bl31, bl32, bl33, bl34, scanInterval, bl35, bl36, bl37, directoryExclusions, bl38, bl39, bl40, seriesCover, bl41, bl42, bl43, bl44, string4, localDateTime, string5, localDateTime3, localDateTime5);
    }

    public static final /* synthetic */ Library access$getL$p(LibraryDao $this) {
        return $this.l;
    }

    public static final /* synthetic */ LibraryExclusions access$getLe$p(LibraryDao $this) {
        return $this.le;
    }
}

