/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.jooq.main;

import java.net.URL;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.domain.model.SearchCondition;
import org.gotson.komga.domain.model.SearchContext;
import org.gotson.komga.domain.model.Series;
import org.gotson.komga.domain.persistence.SeriesRepository;
import org.gotson.komga.infrastructure.jooq.RequiredJoin;
import org.gotson.komga.infrastructure.jooq.SeriesSearchHelper;
import org.gotson.komga.infrastructure.jooq.UtilsKt;
import org.gotson.komga.jooq.main.Tables;
import org.gotson.komga.jooq.main.tables.BookMetadataAggregation;
import org.gotson.komga.jooq.main.tables.CollectionSeries;
import org.gotson.komga.jooq.main.tables.ReadProgressSeries;
import org.gotson.komga.jooq.main.tables.SeriesMetadata;
import org.gotson.komga.jooq.main.tables.records.SeriesRecord;
import org.gotson.komga.language.LanguageUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.RecordMapper;
import org.jooq.Result;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectJoinStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.UpdateSetMoreStep;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0014\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00050\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\u00020\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u0019H\u0017J\b\u0010\u001a\u001a\u00020\u0016H\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0019H\u0016J(\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J,\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001d2\u0006\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010\"\u001a\u00020#H\u0012J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001c0*2\u0006\u0010+\u001a\u00020\u0014H\u0016J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00192\u0006\u0010-\u001a\u00020\u0014H\u0016J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00140\u00192\u0006\u0010+\u001a\u00020\u0014H\u0016J$\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001c0*2\u0006\u0010+\u001a\u00020\u00142\f\u00100\u001a\b\u0012\u0004\u0012\u0002010\u0019H\u0017J\u0012\u00102\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\u001a\u00103\u001a\u0004\u0018\u00010\u001c2\u0006\u0010+\u001a\u00020\u00142\u0006\u00104\u001a\u000201H\u0016J\u0012\u00105\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\u0010\u00106\u001a\u00020\u00162\u0006\u00107\u001a\u00020\u001cH\u0016J\u0018\u00108\u001a\u00020\u00162\u0006\u00107\u001a\u00020\u001c2\u0006\u00109\u001a\u00020:H\u0016J\f\u0010;\u001a\u00020\u001c*\u00020<H\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \t*\u0004\u0018\u00010\u000b0\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \t*\u0004\u0018\u00010\r0\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \t*\u0004\u0018\u00010\u000f0\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/gotson/komga/infrastructure/jooq/main/SeriesDao;", "Lorg/gotson/komga/domain/persistence/SeriesRepository;", "dsl", "Lorg/jooq/DSLContext;", "batchSize", "", "(Lorg/jooq/DSLContext;I)V", "bma", "Lorg/gotson/komga/jooq/main/tables/BookMetadataAggregation;", "kotlin.jvm.PlatformType", "d", "Lorg/gotson/komga/jooq/main/tables/SeriesMetadata;", "rs", "Lorg/gotson/komga/jooq/main/tables/ReadProgressSeries;", "s", "Lorg/gotson/komga/jooq/main/tables/Series;", "count", "", "countGroupedByLibraryId", "", "", "delete", "", "seriesId", "seriesIds", "", "deleteAll", "findAll", "Lorg/gotson/komga/domain/model/Series;", "Lorg/springframework/data/domain/Page;", "searchCondition", "Lorg/gotson/komga/domain/model/SearchCondition$Series;", "searchContext", "Lorg/gotson/komga/domain/model/SearchContext;", "pageable", "Lorg/springframework/data/domain/Pageable;", "conditions", "Lorg/jooq/Condition;", "joins", "", "Lorg/gotson/komga/infrastructure/jooq/RequiredJoin;", "findAllByLibraryId", "", "libraryId", "findAllByTitleContaining", "title", "findAllIdsByLibraryId", "findAllNotDeletedByLibraryIdAndUrlNotIn", "urls", "Ljava/net/URL;", "findByIdOrNull", "findNotDeletedByLibraryIdAndUrlOrNull", "url", "getLibraryId", "insert", "series", "update", "updateModifiedTime", "", "toDomain", "Lorg/gotson/komga/jooq/main/tables/records/SeriesRecord;", "komga"})
@SourceDebugExtension(value={"SMAP\nSeriesDao.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeriesDao.kt\norg/gotson/komga/infrastructure/jooq/main/SeriesDao\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,235:1\n1549#2:236\n1620#2,3:237\n1855#2,2:240\n1#3:242\n*S KotlinDebug\n*F\n+ 1 SeriesDao.kt\norg/gotson/komga/infrastructure/jooq/main/SeriesDao\n*L\n65#1:236\n65#1:237,3\n132#1:240,2\n*E\n"})
public class SeriesDao
implements SeriesRepository {
    @NotNull
    private final DSLContext dsl;
    private final int batchSize;
    private final org.gotson.komga.jooq.main.tables.Series s;
    private final SeriesMetadata d;
    private final ReadProgressSeries rs;
    private final BookMetadataAggregation bma;

    public SeriesDao(@NotNull DSLContext dsl, @Value(value="#{@komgaProperties.database.batchChunkSize}") int batchSize) {
        Intrinsics.checkNotNullParameter((Object)dsl, (String)"dsl");
        this.dsl = dsl;
        this.batchSize = batchSize;
        this.s = Tables.SERIES;
        this.d = Tables.SERIES_METADATA;
        this.rs = Tables.READ_PROGRESS_SERIES;
        this.bma = Tables.BOOK_METADATA_AGGREGATION;
    }

    @NotNull
    public Collection<Series> findAll() {
        List list = this.dsl.selectFrom((TableLike)this.s).fetchInto((Table)this.s).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    @Nullable
    public Series findByIdOrNull(@NotNull String seriesId) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        SeriesRecord seriesRecord = (SeriesRecord)this.dsl.selectFrom((TableLike)this.s).where(this.s.ID.eq((Object)seriesId)).fetchOneInto((Table)this.s);
        return seriesRecord != null ? this.toDomain(seriesRecord) : null;
    }

    @NotNull
    public List<Series> findAllByLibraryId(@NotNull String libraryId) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        List list = this.dsl.selectFrom((TableLike)this.s).where(this.s.LIBRARY_ID.eq((Object)libraryId)).fetchInto((Table)this.s).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public List<Series> findAllNotDeletedByLibraryIdAndUrlNotIn(@NotNull String libraryId, @NotNull Collection<URL> urls) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        Iterable iterable = urls;
        int n = this.batchSize;
        DSLContext dSLContext = this.dsl;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            URL uRL = (URL)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        UtilsKt.insertTempStrings((DSLContext)dSLContext, (int)n, (Collection)collection);
        List list = this.dsl.selectFrom((TableLike)this.s).where(this.s.LIBRARY_ID.eq((Object)libraryId)).and(this.s.DELETED_DATE.isNull()).and(this.s.URL.notIn((Select)UtilsKt.selectTempStrings((DSLContext)this.dsl))).fetchInto((Table)this.s).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    @Nullable
    public Series findNotDeletedByLibraryIdAndUrlOrNull(@NotNull String libraryId, @NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Result result2 = this.dsl.selectFrom((TableLike)this.s).where(this.s.LIBRARY_ID.eq((Object)libraryId).and(this.s.URL.eq((Object)url.toString()))).and(this.s.DELETED_DATE.isNull()).orderBy((OrderField)this.s.LAST_MODIFIED_DATE.desc()).fetchInto((Table)this.s);
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"fetchInto(...)");
        SeriesRecord seriesRecord = (SeriesRecord)CollectionsKt.firstOrNull((List)((List)result2));
        return seriesRecord != null ? this.toDomain(seriesRecord) : null;
    }

    @NotNull
    public Collection<Series> findAllByTitleContaining(@NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Field[] fieldArray = this.s.fields();
        List list = this.dsl.selectDistinct((SelectFieldOrAsterisk[])Arrays.copyOf(fieldArray, fieldArray.length)).from((TableLike)this.s).leftJoin((TableLike)this.d).on(this.s.ID.eq((Field)this.d.SERIES_ID)).where(this.d.TITLE.containsIgnoreCase((Object)title)).fetchInto((Table)this.s).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    @Nullable
    public String getLibraryId(@NotNull String seriesId) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        return (String)this.dsl.select((SelectField)this.s.LIBRARY_ID).from((TableLike)this.s).where(this.s.ID.eq((Object)seriesId)).fetchOne(0, String.class);
    }

    @NotNull
    public Collection<String> findAllIdsByLibraryId(@NotNull String libraryId) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        List list = this.dsl.select((SelectField)this.s.ID).from((TableLike)this.s).where(this.s.LIBRARY_ID.eq((Object)libraryId)).fetch((Field)this.s.ID);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        return list;
    }

    @NotNull
    public Page<Series> findAll(@Nullable SearchCondition.Series searchCondition, @NotNull SearchContext searchContext, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)searchContext, (String)"searchContext");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Pair pair = new SeriesSearchHelper(searchContext).toCondition(searchCondition);
        Condition conditions = (Condition)pair.component1();
        Set joins = (Set)pair.component2();
        return this.findAll(conditions, joins, pageable);
    }

    private Page<Series> findAll(Condition conditions, Set<? extends RequiredJoin> joins, Pageable pageable) {
        SelectConditionStep selectConditionStep;
        SelectJoinStep selectJoinStep = this.s.fields();
        SelectJoinStep $this$findAll_u24lambda_u242 = selectJoinStep = this.dsl.selectDistinct((SelectFieldOrAsterisk[])Arrays.copyOf(selectJoinStep, ((Field[])selectJoinStep).length)).from((TableLike)this.s);
        boolean bl = false;
        Iterable $this$forEach$iv = joins;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RequiredJoin join = (RequiredJoin)element$iv;
            boolean bl2 = false;
            RequiredJoin requiredJoin = join;
            if (requiredJoin instanceof RequiredJoin.Collection) {
                CollectionSeries csAlias = UtilsKt.csAlias((String)((RequiredJoin.Collection)join).getCollectionId());
                $this$findAll_u24lambda_u242.leftJoin((TableLike)csAlias).on(this.s.ID.eq((Field)csAlias.SERIES_ID).and(csAlias.COLLECTION_ID.eq((Object)((RequiredJoin.Collection)join).getCollectionId())));
                continue;
            }
            if (Intrinsics.areEqual((Object)requiredJoin, (Object)RequiredJoin.BookMetadataAggregation.INSTANCE)) {
                $this$findAll_u24lambda_u242.leftJoin((TableLike)this.bma).on(this.s.ID.eq((Field)this.bma.SERIES_ID));
                continue;
            }
            if (Intrinsics.areEqual((Object)requiredJoin, (Object)RequiredJoin.SeriesMetadata.INSTANCE)) {
                $this$findAll_u24lambda_u242.innerJoin((TableLike)this.d).on(this.s.ID.eq((Field)this.d.SERIES_ID));
                continue;
            }
            if (requiredJoin instanceof RequiredJoin.ReadProgress) {
                $this$findAll_u24lambda_u242.leftJoin((TableLike)this.rs).on(this.rs.SERIES_ID.eq((Field)this.s.ID)).and(this.rs.USER_ID.eq((Object)((RequiredJoin.ReadProgress)join).getUserId()));
                continue;
            }
            if (!Intrinsics.areEqual((Object)requiredJoin, (Object)RequiredJoin.BookMetadata.INSTANCE) && !Intrinsics.areEqual((Object)requiredJoin, (Object)RequiredJoin.Media.INSTANCE) && !(requiredJoin instanceof RequiredJoin.ReadList)) continue;
        }
        SelectConditionStep selectConditionStep2 = selectJoinStep.where(conditions);
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep2, (String)"where(...)");
        SelectConditionStep query = selectConditionStep2;
        int count = this.dsl.fetchCount((Select)query);
        SelectConditionStep $this$findAll_u24lambda_u243 = selectConditionStep = query;
        boolean bl3 = false;
        if (pageable.isPaged()) {
            $this$findAll_u24lambda_u243.limit((Number)pageable.getPageSize()).offset((Number)pageable.getOffset());
        }
        List list = selectConditionStep.fetchInto((Table)this.s).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        List items2 = list;
        return (Page)new PageImpl(items2, (Pageable)(pageable.isPaged() ? PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)Sort.unsorted()) : PageRequest.of((int)0, (int)Math.max(count, 20), (Sort)Sort.unsorted())), (long)count);
    }

    public void insert(@NotNull Series series) {
        Intrinsics.checkNotNullParameter((Object)series, (String)"series");
        this.dsl.insertInto((Table)this.s).set((Field)this.s.ID, (Object)series.getId()).set((Field)this.s.NAME, (Object)series.getName()).set((Field)this.s.URL, (Object)series.getUrl().toString()).set((Field)this.s.FILE_LAST_MODIFIED, (Object)series.getFileLastModified()).set((Field)this.s.LIBRARY_ID, (Object)series.getLibraryId()).set((Field)this.s.DELETED_DATE, (Object)series.getDeletedDate()).set((Field)this.s.ONESHOT, (Object)series.getOneshot()).execute();
    }

    public void update(@NotNull Series series, boolean updateModifiedTime) {
        UpdateSetMoreStep updateSetMoreStep;
        Intrinsics.checkNotNullParameter((Object)series, (String)"series");
        UpdateSetMoreStep $this$update_u24lambda_u244 = updateSetMoreStep = this.dsl.update((Table)this.s).set((Field)this.s.NAME, (Object)series.getName()).set((Field)this.s.URL, (Object)series.getUrl().toString()).set((Field)this.s.FILE_LAST_MODIFIED, (Object)series.getFileLastModified()).set((Field)this.s.LIBRARY_ID, (Object)series.getLibraryId()).set((Field)this.s.BOOK_COUNT, (Object)series.getBookCount()).set((Field)this.s.DELETED_DATE, (Object)series.getDeletedDate()).set((Field)this.s.ONESHOT, (Object)series.getOneshot());
        boolean bl = false;
        if (updateModifiedTime) {
            $this$update_u24lambda_u244.set((Field)this.s.LAST_MODIFIED_DATE, (Object)LocalDateTime.now(ZoneId.of("Z")));
        }
        updateSetMoreStep.where(this.s.ID.eq((Object)series.getId())).execute();
    }

    public void delete(@NotNull String seriesId) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        this.dsl.deleteFrom((Table)this.s).where(this.s.ID.eq((Object)seriesId)).execute();
    }

    public void deleteAll() {
        this.dsl.deleteFrom((Table)this.s).execute();
    }

    @Transactional
    public void delete(@NotNull Collection<String> seriesIds) {
        Intrinsics.checkNotNullParameter(seriesIds, (String)"seriesIds");
        UtilsKt.insertTempStrings((DSLContext)this.dsl, (int)this.batchSize, seriesIds);
        this.dsl.deleteFrom((Table)this.s).where(this.s.ID.in((Select)UtilsKt.selectTempStrings((DSLContext)this.dsl))).execute();
    }

    public long count() {
        return this.dsl.fetchCount((Table)this.s);
    }

    @NotNull
    public Map<String, Integer> countGroupedByLibraryId() {
        GroupField[] groupFieldArray = new GroupField[]{this.s.LIBRARY_ID};
        Map map = this.dsl.select((SelectField)this.s.LIBRARY_ID, (SelectField)DSL.count((Field)((Field)this.s.ID))).from((TableLike)this.s).groupBy(groupFieldArray).fetchMap((Field)this.s.LIBRARY_ID, (Field)DSL.count((Field)((Field)this.s.ID)));
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"fetchMap(...)");
        return map;
    }

    private Series toDomain(SeriesRecord $this$toDomain) {
        String string = $this$toDomain.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        URL uRL = new URL($this$toDomain.getUrl());
        LocalDateTime localDateTime = $this$toDomain.getFileLastModified();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"getFileLastModified(...)");
        String string2 = $this$toDomain.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
        String string3 = $this$toDomain.getLibraryId();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getLibraryId(...)");
        Integer n = $this$toDomain.getBookCount();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getBookCount(...)");
        int n2 = ((Number)n).intValue();
        LocalDateTime localDateTime2 = $this$toDomain.getDeletedDate();
        Boolean bl = $this$toDomain.getOneshot();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getOneshot(...)");
        boolean bl2 = bl;
        LocalDateTime localDateTime3 = $this$toDomain.getCreatedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime3, (String)"getCreatedDate(...)");
        LocalDateTime localDateTime4 = LanguageUtilsKt.toCurrentTimeZone((LocalDateTime)localDateTime3);
        LocalDateTime localDateTime5 = $this$toDomain.getLastModifiedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime5, (String)"getLastModifiedDate(...)");
        return new Series(string, uRL, localDateTime, string2, string3, n2, localDateTime2, bl2, localDateTime4, LanguageUtilsKt.toCurrentTimeZone((LocalDateTime)localDateTime5));
    }

    public static final /* synthetic */ Series access$toDomain(SeriesDao $this, SeriesRecord $receiver) {
        return $this.toDomain($receiver);
    }
}

