/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.kobo;

import jakarta.annotation.PostConstruct;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gotson.komga.domain.model.BookWithMedia;
import org.gotson.komga.domain.model.MediaType;
import org.gotson.komga.infrastructure.configuration.KomgaSettingsProvider;
import org.gotson.komga.infrastructure.configuration.SettingChangedEvent;
import org.gotson.komga.infrastructure.kobo.KepubConverter;
import org.gotson.komga.infrastructure.kobo.KepubConverterKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0018\u001a\u00020\bH\u0016J\b\u0010\u0019\u001a\u00020\u0016H\u0013J\b\u0010\u001a\u001a\u00020\u0016H\u0013J\u001e\u0010\u001b\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\rH\u0016J\u001e\u0010\u001f\u001a\u0004\u0018\u00010\r2\u0006\u0010 \u001a\u00020\r2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\rH\u0012R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@RX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\"\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\u0007\u001a\u0004\u0018\u00010\r@RX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\r8RX\u0092\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006#"}, d2={"Lorg/gotson/komga/infrastructure/kobo/KepubConverter;", "", "settingsProvider", "Lorg/gotson/komga/infrastructure/configuration/KomgaSettingsProvider;", "kepubifyConfigurationPath", "", "(Lorg/gotson/komga/infrastructure/configuration/KomgaSettingsProvider;Ljava/lang/String;)V", "<set-?>", "", "isAvailable", "()Z", "getKepubifyConfigurationPath", "()Ljava/lang/String;", "Ljava/nio/file/Path;", "kepubifyPath", "getKepubifyPath", "()Ljava/nio/file/Path;", "tmpDir", "getTmpDir", "tmpDir$delegate", "Lkotlin/Lazy;", "configureKepubify", "", "newValue", "fallback", "configureKepubifyOnSettingsChange", "configureKepubifyOnStartup", "convertEpubToKepub", "bookWithMedia", "Lorg/gotson/komga/domain/model/BookWithMedia;", "destinationDir", "convertEpubToKepubWithoutChecks", "epub", "isExecutable", "path", "komga"})
@SourceDebugExtension(value={"SMAP\nKepubConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KepubConverter.kt\norg/gotson/komga/infrastructure/kobo/KepubConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ReadWrite.kt\nkotlin/io/TextStreamsKt\n*L\n1#1,170:1\n1#2:171\n1#2:173\n52#3:172\n*S KotlinDebug\n*F\n+ 1 KepubConverter.kt\norg/gotson/komga/infrastructure/kobo/KepubConverter\n*L\n154#1:173\n154#1:172\n*E\n"})
public class KepubConverter {
    @NotNull
    private final KomgaSettingsProvider settingsProvider;
    @Nullable
    private final String kepubifyConfigurationPath;
    @Nullable
    private Path kepubifyPath;
    private boolean isAvailable;
    @NotNull
    private final Lazy tmpDir$delegate;

    public KepubConverter(@NotNull KomgaSettingsProvider settingsProvider, @Value(value="${komga.kobo.kepubify-path:#{null}}") @Nullable String kepubifyConfigurationPath) {
        Intrinsics.checkNotNullParameter((Object)settingsProvider, (String)"settingsProvider");
        this.settingsProvider = settingsProvider;
        this.kepubifyConfigurationPath = kepubifyConfigurationPath;
        this.tmpDir$delegate = LazyKt.lazy((Function0)((Function0)tmpDir.2.INSTANCE));
    }

    @Nullable
    public String getKepubifyConfigurationPath() {
        return this.kepubifyConfigurationPath;
    }

    @Nullable
    public final Path getKepubifyPath() {
        return this.kepubifyPath;
    }

    public final boolean isAvailable() {
        return this.isAvailable;
    }

    private Path getTmpDir() {
        Lazy lazy = this.tmpDir$delegate;
        return (Path)lazy.getValue();
    }

    @PostConstruct
    private void configureKepubifyOnStartup() {
        CharSequence charSequence = this.settingsProvider.getKepubifyPath();
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            this.configureKepubify(this.settingsProvider.getKepubifyPath(), true);
        } else {
            charSequence = this.getKepubifyConfigurationPath();
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                KepubConverter.configureKepubify$default((KepubConverter)this, (String)this.getKepubifyConfigurationPath(), (boolean)false, (int)2, null);
            } else {
                KepubConverterKt.access$getLogger$p().info((Function0)configureKepubifyOnStartup.1.INSTANCE);
            }
        }
    }

    @EventListener(value={SettingChangedEvent.KepubifyPath.class})
    private void configureKepubifyOnSettingsChange() {
        this.configureKepubify(this.settingsProvider.getKepubifyPath(), true);
    }

    public void configureKepubify(@Nullable String newValue, boolean fallback) {
        CharSequence charSequence = newValue;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            this.isAvailable = false;
            this.kepubifyPath = null;
            if (fallback && !((charSequence = (CharSequence)this.getKepubifyConfigurationPath()) == null || StringsKt.isBlank((CharSequence)charSequence))) {
                KepubConverter.configureKepubify$default((KepubConverter)this, (String)this.getKepubifyConfigurationPath(), (boolean)false, (int)2, null);
            }
        } else {
            Path path2 = Paths.get(newValue, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
            Path newPath = path2;
            if (!this.isExecutable(newPath)) {
                CharSequence charSequence2;
                KepubConverterKt.access$getLogger$p().warn((Function0)new /* Unavailable Anonymous Inner Class!! */);
                this.isAvailable = false;
                if (fallback && !((charSequence2 = (CharSequence)this.getKepubifyConfigurationPath()) == null || StringsKt.isBlank((CharSequence)charSequence2))) {
                    KepubConverter.configureKepubify$default((KepubConverter)this, (String)this.getKepubifyConfigurationPath(), (boolean)false, (int)2, null);
                }
            } else {
                KepubConverterKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
                this.isAvailable = true;
            }
            this.kepubifyPath = newPath;
        }
    }

    public static /* synthetic */ void configureKepubify$default(KepubConverter kepubConverter, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: configureKepubify");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        kepubConverter.configureKepubify(string, bl);
    }

    private boolean isExecutable(Path path2) {
        try {
            if (Files.isExecutable(path2)) {
                return true;
            }
            Process process2 = Runtime.getRuntime().exec(((Object)path2).toString());
            process2.waitFor(3L, TimeUnit.SECONDS);
            return process2.exitValue() == 0;
        }
        catch (Exception e) {
            KepubConverterKt.access$getLogger$p().warn((Throwable)e, (Function0)new /* Unavailable Anonymous Inner Class!! */);
            return false;
        }
    }

    @Nullable
    public Path convertEpubToKepub(@NotNull BookWithMedia bookWithMedia, @Nullable Path destinationDir) {
        Intrinsics.checkNotNullParameter((Object)bookWithMedia, (String)"bookWithMedia");
        if (!Intrinsics.areEqual((Object)bookWithMedia.getMedia().getMediaType(), (Object)MediaType.EPUB.getType())) {
            boolean $i$a$-require-KepubConverter$convertEpubToKepub$42 = false;
            String $i$a$-require-KepubConverter$convertEpubToKepub$42 = "Cannot convert, not an EPUB: " + bookWithMedia.getBook().getPath();
            throw new IllegalArgumentException($i$a$-require-KepubConverter$convertEpubToKepub$42.toString());
        }
        if (!(!bookWithMedia.getMedia().getEpubIsKepub())) {
            boolean $i$a$-require-KepubConverter$convertEpubToKepub$52 = false;
            String $i$a$-require-KepubConverter$convertEpubToKepub$52 = "Cannot convert, EPUB is already a KEPUB: " + bookWithMedia.getBook().getPath();
            throw new IllegalArgumentException($i$a$-require-KepubConverter$convertEpubToKepub$52.toString());
        }
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(bookWithMedia.getBook().getPath(), Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            boolean bl = false;
            String string = "Source file does not exist: " + bookWithMedia.getBook().getPath();
            throw new IllegalArgumentException(string.toString());
        }
        return this.convertEpubToKepubWithoutChecks(bookWithMedia.getBook().getPath(), destinationDir);
    }

    public static /* synthetic */ Path convertEpubToKepub$default(KepubConverter kepubConverter, BookWithMedia bookWithMedia, Path path2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: convertEpubToKepub");
        }
        if ((n & 2) != 0) {
            path2 = null;
        }
        return kepubConverter.convertEpubToKepub(bookWithMedia, path2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Path convertEpubToKepubWithoutChecks(@NotNull Path epub, @Nullable Path destinationDir) {
        Process process2;
        Path path2;
        Intrinsics.checkNotNullParameter((Object)epub, (String)"epub");
        if (!this.isAvailable) {
            boolean $i$a$-check-KepubConverter$convertEpubToKepubWithoutChecks$22 = false;
            String $i$a$-check-KepubConverter$convertEpubToKepubWithoutChecks$22 = "Kepub conversion is not available, kepubify path may not be set, or may be invalid";
            throw new IllegalStateException($i$a$-check-KepubConverter$convertEpubToKepubWithoutChecks$22.toString());
        }
        if (destinationDir != null) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.isDirectory(destinationDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                boolean $i$a$-require-KepubConverter$convertEpubToKepubWithoutChecks$32 = false;
                String $i$a$-require-KepubConverter$convertEpubToKepubWithoutChecks$32 = "Destination directory does not exist: " + destinationDir;
                throw new IllegalArgumentException($i$a$-require-KepubConverter$convertEpubToKepubWithoutChecks$32.toString());
            }
        }
        if ((path2 = destinationDir) == null) {
            path2 = this.getTmpDir();
        }
        Path destinationPath = path2.resolve(PathsKt.getNameWithoutExtension((Path)epub) + ".kepub.epub");
        Intrinsics.checkNotNull((Object)destinationPath);
        Files.deleteIfExists(destinationPath);
        String[] stringArray = new String[]{String.valueOf(this.kepubifyPath), ((Object)epub).toString(), "-o", ((Object)destinationPath).toString()};
        String[] command = stringArray;
        KepubConverterKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
        try {
            process2 = Runtime.getRuntime().exec(command);
        }
        catch (Exception e) {
            KepubConverterKt.access$getLogger$p().error((Throwable)e, (Function0)convertEpubToKepubWithoutChecks.process.1.INSTANCE);
            return null;
        }
        Process process3 = process2;
        if (!process3.waitFor(10L, TimeUnit.SECONDS)) {
            KepubConverterKt.access$getLogger$p().error((Function0)new /* Unavailable Anonymous Inner Class!! */);
            return null;
        }
        if (process3.exitValue() != 0) {
            String string;
            BufferedReader bufferedReader = process3.errorReader();
            Intrinsics.checkNotNullExpressionValue((Object)bufferedReader, (String)"errorReader(...)");
            Reader $this$useLines$iv = bufferedReader;
            boolean $i$f$useLines = false;
            Closeable closeable = $this$useLines$iv;
            closeable = (BufferedReader)closeable;
            Throwable throwable = null;
            try {
                BufferedReader it$iv = (BufferedReader)closeable;
                boolean bl = false;
                Sequence it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                boolean bl2 = false;
                string = SequencesKt.joinToString$default((Sequence)it, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            String error = string;
            KepubConverterKt.access$getLogger$p().error((Function0)new /* Unavailable Anonymous Inner Class!! */);
            return null;
        }
        KepubConverterKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(destinationPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            KepubConverterKt.access$getLogger$p().error((Function0)new /* Unavailable Anonymous Inner Class!! */);
            return null;
        }
        return destinationPath;
    }

    public static /* synthetic */ Path convertEpubToKepubWithoutChecks$default(KepubConverter kepubConverter, Path path2, Path path3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: convertEpubToKepubWithoutChecks");
        }
        if ((n & 2) != 0) {
            path3 = null;
        }
        return kepubConverter.convertEpubToKepubWithoutChecks(path2, path3);
    }
}

