/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.mediacontainer;

import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Path;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@kotlin.Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;", "", "tika", "Lorg/apache/tika/config/TikaConfig;", "(Lorg/apache/tika/config/TikaConfig;)V", "detectMediaType", "", "stream", "Ljava/io/InputStream;", "path", "Ljava/nio/file/Path;", "isImage", "", "mediaType", "mediaTypeToExtension", "komga"})
public class ContentDetector {
    @NotNull
    private final TikaConfig tika;

    public ContentDetector(@NotNull TikaConfig tika) {
        Intrinsics.checkNotNullParameter((Object)tika, (String)"tika");
        this.tika = tika;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String detectMediaType(@NotNull Path path2) {
        String string;
        Metadata metadata;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Metadata it = metadata = new Metadata();
        boolean bl = false;
        it.set("tika.mime.file", PathsKt.getName((Path)path2));
        Metadata metadata2 = metadata;
        Closeable closeable = (Closeable)TikaInputStream.get((Path)path2);
        Throwable throwable = null;
        try {
            TikaInputStream it2 = (TikaInputStream)closeable;
            boolean bl2 = false;
            MediaType mediaType2 = this.tika.getDetector().detect((InputStream)it2, metadata2);
            String string2 = mediaType2.toString();
            string = string2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"use(...)");
        return string;
    }

    @NotNull
    public String detectMediaType(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        String string = this.tika.getDetector().detect(stream, new Metadata()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public boolean isImage(@NotNull String mediaType2) {
        Intrinsics.checkNotNullParameter((Object)mediaType2, (String)"mediaType");
        return StringsKt.startsWith$default((String)mediaType2, (String)"image/", (boolean)false, (int)2, null);
    }

    @Nullable
    public String mediaTypeToExtension(@NotNull String mediaType2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)mediaType2, (String)"mediaType");
        try {
            string = this.tika.getMimeRepository().forName(mediaType2).getExtension();
        }
        catch (Exception e) {
            string = null;
        }
        return string;
    }
}

