/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.mediacontainer.divina;

import com.github.junrar.Archive;
import com.github.junrar.rarfile.FileHeader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.greypanther.natsort.CaseInsensitiveSimpleNaturalComparator;
import org.gotson.komga.domain.model.Dimension;
import org.gotson.komga.domain.model.MediaContainerEntry;
import org.gotson.komga.domain.model.MediaType;
import org.gotson.komga.domain.model.MediaUnsupportedException;
import org.gotson.komga.infrastructure.image.ImageAnalyzer;
import org.gotson.komga.infrastructure.mediacontainer.ContentDetector;
import org.gotson.komga.infrastructure.mediacontainer.divina.DivinaExtractor;
import org.gotson.komga.infrastructure.mediacontainer.divina.RarExtractor$getEntries$lambda$6$;
import org.gotson.komga.infrastructure.mediacontainer.divina.RarExtractorKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\tH\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/gotson/komga/infrastructure/mediacontainer/divina/RarExtractor;", "Lorg/gotson/komga/infrastructure/mediacontainer/divina/DivinaExtractor;", "contentDetector", "Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;", "imageAnalyzer", "Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;", "(Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;)V", "natSortComparator", "Ljava/util/Comparator;", "", "Lkotlin/Comparator;", "getEntries", "", "Lorg/gotson/komga/domain/model/MediaContainerEntry;", "path", "Ljava/nio/file/Path;", "analyzeDimensions", "", "getEntryStream", "", "entryName", "mediaTypes", "komga"})
@SourceDebugExtension(value={"SMAP\nRarExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RarExtractor.kt\norg/gotson/komga/infrastructure/mediacontainer/divina/RarExtractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n766#2:63\n857#2,2:64\n1549#2:66\n1620#2,2:67\n1622#2:70\n1#3:69\n*S KotlinDebug\n*F\n+ 1 RarExtractor.kt\norg/gotson/komga/infrastructure/mediacontainer/divina/RarExtractor\n*L\n34#1:63\n34#1:64,2\n35#1:66\n35#1:67,2\n35#1:70\n*E\n"})
public class RarExtractor
implements DivinaExtractor {
    @NotNull
    private final ContentDetector contentDetector;
    @NotNull
    private final ImageAnalyzer imageAnalyzer;
    @NotNull
    private final Comparator<String> natSortComparator;

    public RarExtractor(@NotNull ContentDetector contentDetector, @NotNull ImageAnalyzer imageAnalyzer) {
        Intrinsics.checkNotNullParameter((Object)contentDetector, (String)"contentDetector");
        Intrinsics.checkNotNullParameter((Object)imageAnalyzer, (String)"imageAnalyzer");
        this.contentDetector = contentDetector;
        this.imageAnalyzer = imageAnalyzer;
        Comparator comparator = CaseInsensitiveSimpleNaturalComparator.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)comparator, (String)"getInstance(...)");
        this.natSortComparator = comparator;
    }

    @NotNull
    public List<String> mediaTypes() {
        Object[] objectArray = new String[]{MediaType.RAR_GENERIC.getType(), MediaType.RAR_4.getType()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public List<MediaContainerEntry> getEntries(@NotNull Path path2, boolean analyzeDimensions) {
        List list;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Closeable closeable = (Closeable)new Archive(path2.toFile());
        Throwable throwable = null;
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            FileHeader it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Archive rar = (Archive)closeable;
            boolean bl = false;
            if (rar.isPasswordProtected()) {
                throw new MediaUnsupportedException("Encrypted RAR archives are not supported", "ERR_1002");
            }
            if (rar.getMainHeader().isSolid()) {
                throw new MediaUnsupportedException("Solid RAR archives are not supported", "ERR_1003");
            }
            if (rar.getMainHeader().isMultiVolume()) {
                throw new MediaUnsupportedException("Multi-Volume RAR archives are not supported", "ERR_1004");
            }
            List list2 = rar.getFileHeaders();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getFileHeaders(...)");
            Object object = list2;
            boolean $i$f$filter = false;
            void var9_11 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (FileHeader)element$iv$iv;
                boolean bl2 = false;
                if (!(!it.isDirectory())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                MediaContainerEntry mediaContainerEntry;
                void entry;
                it = (FileHeader)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                try {
                    Dimension dimension;
                    Object object2;
                    Object object3;
                    Closeable closeable2 = rar.getInputStream((FileHeader)entry);
                    Object object4 = null;
                    try {
                        InputStream it2 = (InputStream)closeable2;
                        boolean bl4 = false;
                        Intrinsics.checkNotNull((Object)it2);
                        object3 = ByteStreamsKt.readBytes((InputStream)it2);
                    }
                    catch (Throwable throwable2) {
                        object4 = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object4);
                    }
                    byte[] buffer = object3;
                    object4 = new ByteArrayInputStream(buffer);
                    object3 = null;
                    try {
                        ByteArrayInputStream it3 = (ByteArrayInputStream)object4;
                        boolean bl5 = false;
                        object2 = this.contentDetector.detectMediaType((InputStream)it3);
                    }
                    catch (Throwable throwable3) {
                        object3 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object4, (Throwable)object3);
                    }
                    String mediaType2 = object2;
                    if (analyzeDimensions && this.contentDetector.isImage(mediaType2)) {
                        object3 = new ByteArrayInputStream(buffer);
                        object2 = null;
                        try {
                            ByteArrayInputStream it4 = (ByteArrayInputStream)object3;
                            boolean bl6 = false;
                            Dimension dimension2 = this.imageAnalyzer.getDimension((InputStream)it4);
                            dimension = dimension2;
                        }
                        catch (Throwable throwable4) {
                            object2 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object3, (Throwable)object2);
                        }
                    } else {
                        dimension = null;
                    }
                    Dimension dimension3 = dimension;
                    long fileSize = entry.getFullUnpackSize();
                    String string = entry.getFileName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
                    mediaContainerEntry = new MediaContainerEntry(string, mediaType2, null, dimension3, Long.valueOf(fileSize), 4, null);
                }
                catch (Exception e) {
                    RarExtractorKt.access$getLogger$p().warn((Throwable)e, (Function0)new /* Unavailable Anonymous Inner Class!! */);
                    String string = entry.getFileName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
                    mediaContainerEntry = new MediaContainerEntry(string, null, e.getMessage(), null, null, 26, null);
                }
                collection.add(mediaContainerEntry);
            }
            object = this.natSortComparator;
            list = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)((Comparator)new getEntries$lambda$6$$inlined$compareBy$1((Comparator)object)));
        }
        catch (Throwable throwable5) {
            throwable = throwable5;
            throw throwable5;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public byte[] getEntryStream(@NotNull Path path2, @NotNull String entryName) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)entryName, (String)"entryName");
        Closeable closeable = (Closeable)new Archive(path2.toFile());
        Throwable throwable = null;
        try {
            Object v1;
            Object object2;
            Object object3;
            Archive rar;
            block11: {
                rar = (Archive)closeable;
                boolean bl = false;
                List list = rar.getFileHeaders();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFileHeaders(...)");
                object3 = list;
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    Object t = object2.next();
                    FileHeader it = (FileHeader)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getFileName(), (Object)entryName)) continue;
                    v1 = t;
                    break block11;
                }
                v1 = null;
            }
            FileHeader header = v1;
            Closeable closeable2 = rar.getInputStream(header);
            object3 = null;
            try {
                InputStream it = (InputStream)closeable2;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                object2 = ByteStreamsKt.readBytes((InputStream)it);
            }
            catch (Throwable throwable2) {
                object3 = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object3);
            }
            object = object2;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return object;
    }
}

