/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.mediacontainer.epub;

import java.io.Closeable;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.gotson.komga.domain.model.BookPage;
import org.gotson.komga.domain.model.EpubTocEntry;
import org.gotson.komga.domain.model.MediaFile;
import org.gotson.komga.domain.model.MediaUnsupportedException;
import org.gotson.komga.domain.model.R2Locator;
import org.gotson.komga.domain.model.TypedBytes;
import org.gotson.komga.infrastructure.image.ImageAnalyzer;
import org.gotson.komga.infrastructure.kobo.KepubConverter;
import org.gotson.komga.infrastructure.mediacontainer.ContentDetector;
import org.gotson.komga.infrastructure.mediacontainer.epub.Epub2Nav;
import org.gotson.komga.infrastructure.mediacontainer.epub.Epub3Nav;
import org.gotson.komga.infrastructure.mediacontainer.epub.EpubExtractor;
import org.gotson.komga.infrastructure.mediacontainer.epub.EpubExtractorKt;
import org.gotson.komga.infrastructure.mediacontainer.epub.EpubKt;
import org.gotson.komga.infrastructure.mediacontainer.epub.EpubPackage;
import org.gotson.komga.infrastructure.mediacontainer.epub.ManifestItem;
import org.gotson.komga.infrastructure.mediacontainer.epub.NavKt;
import org.gotson.komga.infrastructure.mediacontainer.epub.NcxKt;
import org.gotson.komga.infrastructure.mediacontainer.epub.OpfKt;
import org.gotson.komga.infrastructure.mediacontainer.epub.ResourceContent;
import org.gotson.komga.infrastructure.util.ZipFileUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J<\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016JL\u0010\u0018\u001a\"\u0012\u0004\u0012\u00020\u001a\u0012\u0018\u0012\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001c0\u001b\u0018\u00010\u000f0\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00140\u000f2\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u001fH\u0012J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J.\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u0016H\u0016J\u0018\u0010&\u001a\u00020'2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u001aH\u0016J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020*0\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00140\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020*0\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010.\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/gotson/komga/infrastructure/mediacontainer/epub/EpubExtractor;", "", "contentDetector", "Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;", "imageAnalyzer", "Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;", "kepubConverter", "Lorg/gotson/komga/infrastructure/kobo/KepubConverter;", "letterCountThreshold", "", "(Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;Lorg/gotson/komga/infrastructure/kobo/KepubConverter;I)V", "computePageCount", "epub", "Lorg/gotson/komga/infrastructure/mediacontainer/epub/EpubPackage;", "computePositions", "", "Lorg/gotson/komga/domain/model/R2Locator;", "path", "Ljava/nio/file/Path;", "resources", "Lorg/gotson/komga/domain/model/MediaFile;", "isFixedLayout", "", "isKepub", "computePositionsFromKoboSpan", "", "", "Lkotlin/Pair;", "", "readingOrder", "resourceSupplier", "Lkotlin/Function1;", "getCover", "Lorg/gotson/komga/domain/model/TypedBytes;", "getDivinaPages", "Lorg/gotson/komga/domain/model/BookPage;", "pageCount", "analyzeDimensions", "getEntryStream", "", "entryName", "getLandmarks", "Lorg/gotson/komga/domain/model/EpubTocEntry;", "getPageList", "getResources", "getToc", "isEpub", "komga"})
@SourceDebugExtension(value={"SMAP\nEpubExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EpubExtractor.kt\norg/gotson/komga/infrastructure/mediacontainer/epub/EpubExtractor\n+ 2 Epub.kt\norg/gotson/komga/infrastructure/mediacontainer/epub/EpubKt\n+ 3 ZipFileUtils.kt\norg/gotson/komga/infrastructure/util/ZipFileUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,345:1\n21#2:346\n22#2,2:348\n24#2,2:351\n26#2:358\n8#3:347\n1#4:350\n1#4:355\n1#4:373\n1#4:392\n1#4:408\n1#4:443\n1#4:450\n1#4:466\n1#4:475\n1#4:522\n1#4:526\n288#5,2:353\n288#5,2:356\n1549#5:359\n1620#5,3:360\n1603#5,9:363\n1855#5:372\n1856#5:374\n1612#5:375\n1549#5:376\n1620#5,3:377\n819#5:380\n847#5,2:381\n1549#5:383\n1620#5,3:384\n1549#5:387\n1620#5,2:388\n288#5,2:390\n1622#5:393\n1549#5:394\n1620#5,3:395\n1603#5,9:398\n1855#5:407\n1856#5:409\n1612#5:410\n1549#5:411\n1620#5,2:412\n1549#5:414\n1620#5,3:415\n1549#5:418\n1620#5,3:419\n1549#5:422\n1620#5,3:423\n1622#5:426\n1549#5:427\n1620#5,3:428\n1603#5,9:431\n1855#5:440\n288#5,2:441\n1856#5:444\n1612#5:445\n766#5:446\n857#5,2:447\n1855#5:449\n1856#5:451\n1549#5:452\n1620#5,3:453\n1603#5,9:456\n1855#5:465\n1856#5:467\n1612#5:468\n766#5:469\n857#5,2:470\n766#5:472\n857#5,2:473\n1549#5:476\n1620#5,3:477\n1360#5:480\n1446#5,2:481\n1549#5:483\n1620#5,2:484\n2333#5,14:486\n1622#5:500\n1448#5,3:501\n1549#5:504\n1620#5,3:505\n1179#5,2:508\n1253#5,2:510\n1603#5,9:512\n1855#5:521\n1856#5:523\n1612#5:524\n1256#5:525\n*S KotlinDebug\n*F\n+ 1 EpubExtractor.kt\norg/gotson/komga/infrastructure/mediacontainer/epub/EpubExtractor\n*L\n57#1:346\n57#1:348,2\n57#1:351,2\n57#1:358\n57#1:347\n57#1:350\n89#1:373\n130#1:408\n162#1:443\n208#1:466\n309#1:522\n60#1:353,2\n68#1:356,2\n88#1:359\n88#1:360,3\n89#1:363,9\n89#1:372\n89#1:374\n89#1:375\n92#1:376\n92#1:377,3\n101#1:380\n101#1:381,2\n101#1:383\n101#1:384,3\n110#1:387\n110#1:388,2\n111#1:390,2\n110#1:393\n129#1:394\n129#1:395,3\n130#1:398,9\n130#1:407\n130#1:409\n130#1:410\n131#1:411\n131#1:412,2\n140#1:414\n140#1:415,3\n145#1:418\n145#1:419,3\n147#1:422\n147#1:423,3\n131#1:426\n155#1:427\n155#1:428,3\n162#1:431,9\n162#1:440\n165#1:441,2\n162#1:444\n162#1:445\n191#1:446\n191#1:447,2\n193#1:449\n193#1:451\n207#1:452\n207#1:453,3\n208#1:456,9\n208#1:465\n208#1:467\n208#1:468\n212#1:469\n212#1:470,2\n227#1:472\n227#1:473,2\n258#1:476\n258#1:477,3\n269#1:480\n269#1:481,2\n271#1:483\n271#1:484,2\n278#1:486,14\n271#1:500\n269#1:501,3\n292#1:504\n292#1:505,3\n306#1:508,2\n306#1:510,2\n309#1:512,9\n309#1:521\n309#1:523\n309#1:524\n306#1:525\n*E\n"})
public class EpubExtractor {
    @NotNull
    private final ContentDetector contentDetector;
    @NotNull
    private final ImageAnalyzer imageAnalyzer;
    @NotNull
    private final KepubConverter kepubConverter;
    private final int letterCountThreshold;

    public EpubExtractor(@NotNull ContentDetector contentDetector, @NotNull ImageAnalyzer imageAnalyzer, @NotNull KepubConverter kepubConverter, @Value(value="#{@komgaProperties.epubDivinaLetterCountThreshold}") int letterCountThreshold) {
        Intrinsics.checkNotNullParameter((Object)contentDetector, (String)"contentDetector");
        Intrinsics.checkNotNullParameter((Object)imageAnalyzer, (String)"imageAnalyzer");
        Intrinsics.checkNotNullParameter((Object)kepubConverter, (String)"kepubConverter");
        this.contentDetector = contentDetector;
        this.imageAnalyzer = imageAnalyzer;
        this.kepubConverter = kepubConverter;
        this.letterCountThreshold = letterCountThreshold;
    }

    @NotNull
    public byte[] getEntryStream(@NotNull Path path2, @NotNull String entryName) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)entryName, (String)"entryName");
        return ZipFileUtilsKt.getZipEntryBytes((Path)path2, (String)entryName);
    }

    public boolean isEpub(@NotNull Path path2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        try {
            bl = Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)StringsKt.decodeToString((byte[])this.getEntryStream(path2, "mimetype")))).toString(), (Object)"application/epub+zip");
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public TypedBytes getCover(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        $this$epub$iv = path;
        $i$f$epub = false;
        v0 = ZipFile.builder().setPath($this$epub$iv);
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"setPath(...)");
        $this$use$iv$iv = (ZipFile.Builder)v0;
        $i$f$use = false;
        var6_6 = (Closeable)$this$use$iv$iv.get();
        var7_7 = null;
        try {
            block27: {
                block24: {
                    zip$iv = (ZipFile)var6_6;
                    $i$a$-use-EpubKt$epub$1$iv = false;
                    opfFile$iv = EpubKt.getPackagePath((ZipFile)zip$iv);
                    v1 = ZipFileUtilsKt.getEntryInputStream((ZipFile)zip$iv, (String)opfFile$iv);
                    if (v1 != null) {
                        var11_13 = v1;
                        var12_14 = null;
                        try {
                            it$iv = (InputStream)var11_13;
                            $i$a$-use-EpubKt$epub$1$opfDoc$1$iv = false;
                            var13_15 = Jsoup.parse((InputStream)it$iv, null, (String)"", (Parser)Parser.xmlParser());
                            v2 = var13_15;
                        }
                        catch (Throwable var13_16) {
                            var12_14 = var13_16;
                            throw var13_16;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)var11_13, (Throwable)var12_14);
                        }
                    } else {
                        v2 = null;
                    }
                    v3 = var15_19 = v2;
                    if (v3 == null) {
                        throw new MediaUnsupportedException("Could not open OPF resource", null, 2, null);
                    }
                    Intrinsics.checkNotNull(v3);
                    opfDoc$iv = var15_19;
                    opfDir$iv = Paths.get(opfFile$iv, new String[0]).getParent();
                    var17_21 = new EpubPackage(zip$iv, opfDoc$iv, opfDir$iv, OpfKt.getManifest((Document)opfDoc$iv));
                    $i$a$-epub-EpubExtractor$getCover$1 = false;
                    zip = var17_21.component1();
                    opfDoc = var17_21.component2();
                    opfDir = var17_21.component3();
                    manifest = var17_21.component4();
                    $this$firstOrNull$iv = manifest.values();
                    $i$f$firstOrNull = false;
                    var25_31 = $this$firstOrNull$iv.iterator();
                    while (var25_31.hasNext()) {
                        element$iv = var25_31.next();
                        it /* !! */  = (ManifestItem)element$iv;
                        $i$a$-firstOrNull-EpubExtractor$getCover$1$coverManifestItem$1 = false;
                        if (!it /* !! */ .getProperties().contains("cover-image")) continue;
                        v4 = element$iv;
                        break block24;
                    }
                    v4 = null;
                }
                if ((v5 = (ManifestItem)v4) != null) break block27;
                $i$f$firstOrNull = opfDoc.selectFirst("metadata > meta[name=cover]");
                if ($i$f$firstOrNull == null || (var25_31 = $i$f$firstOrNull.attr("content")) == null) ** GOTO lbl-1000
                it /* !! */  = (CharSequence)var25_31;
                if (StringsKt.isBlank((CharSequence)it /* !! */ )) {
                    $i$a$-ifBlank-EpubExtractor$getCover$1$coverManifestItem$2 = false;
                    v6 /* !! */  = null;
                } else {
                    v6 /* !! */  = it /* !! */ ;
                }
                var26_33 = (String)v6 /* !! */ ;
                if (var26_33 != null) {
                    it = var26_33;
                    $i$a$-let-EpubExtractor$getCover$1$coverManifestItem$3 = false;
                    v7 = (ManifestItem)manifest.get(it);
                } else lbl-1000:
                // 2 sources

                {
                    v7 = v5 = null;
                }
                if (v7 == null) {
                    block25: {
                        $this$firstOrNull$iv = manifest.values();
                        $i$f$firstOrNull = false;
                        for (E element$iv : $this$firstOrNull$iv) {
                            it = (ManifestItem)element$iv;
                            $i$a$-firstOrNull-EpubExtractor$getCover$1$coverManifestItem$4 = false;
                            if (!Intrinsics.areEqual((Object)it.getId(), (Object)"cover-image")) continue;
                            v8 = element$iv;
                            break block25;
                        }
                        v8 = null;
                    }
                    v5 = v8;
                }
            }
            if ((coverManifestItem = v5) != null) {
                href = coverManifestItem.getHref();
                mediaType = coverManifestItem.getMediaType();
                coverPath = OpfKt.normalizeHref((Path)opfDir, (String)href);
                v9 = ZipFileUtilsKt.getEntryBytes((ZipFile)zip, (String)coverPath);
                if (v9 != null) {
                    coverBytes = v9;
                    $i$a$-let-EpubExtractor$getCover$1$1 = false;
                    v10 = new TypedBytes(coverBytes, mediaType);
                } else {
                    v10 = null;
                }
            } else {
                v10 = null;
            }
            var8_8 = v10;
        }
        catch (Throwable var8_9) {
            var7_7 = var8_9;
            throw var8_9;
        }
        finally {
            CloseableKt.closeFinally((Closeable)var6_6, (Throwable)var7_7);
        }
        return var8_8;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<MediaFile> getResources(@NotNull EpubPackage epub) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        void $this$filterNotTo$iv$iv;
        void $this$mapTo$iv$iv3;
        void $this$mapNotNullTo$iv$iv;
        Iterator it;
        Collection collection;
        Iterable $this$mapTo$iv$iv4;
        Intrinsics.checkNotNullParameter((Object)epub, (String)"epub");
        Elements elements = epub.getOpfDoc().select("spine > itemref");
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
        Iterable $this$map$iv2 = (Iterable)elements;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Iterable<ManifestItem> destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv4) {
            Element element = (Element)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.attr("idref"));
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv4 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            ManifestItem it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            String it2 = (String)element$iv$iv;
            boolean bl2 = false;
            if ((ManifestItem)epub.getManifest().get(it2) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List spine = (List)destination$iv$iv;
        Iterable $this$map$iv3 = spine;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv3;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void page;
            ManifestItem element$iv$iv$iv = (ManifestItem)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            Path path2 = epub.getOpfDir();
            String string = URLDecoder.decode(page.getHref(), Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(...)");
            collection.add(new MediaFile(OpfKt.normalizeHref((Path)path2, (String)string), page.getMediaType(), MediaFile.SubType.EPUB_PAGE, null, 8, null));
        }
        List pages = (List)destination$iv$iv2;
        Iterable $this$filterNot$iv = epub.getManifest().values();
        boolean $i$f$filterNot = false;
        destination$iv$iv2 = $this$filterNot$iv;
        Iterable destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            ManifestItem it3 = (ManifestItem)element$iv$iv;
            boolean bl = false;
            if (spine.contains(it3)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv3;
        boolean $i$f$map3 = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            ManifestItem it3 = (ManifestItem)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            Path path3 = epub.getOpfDir();
            String string = URLDecoder.decode(it3.getHref(), Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(...)");
            collection.add(new MediaFile(OpfKt.normalizeHref((Path)path3, (String)string), it3.getMediaType(), MediaFile.SubType.EPUB_ASSET, null, 8, null));
        }
        List assets = (List)destination$iv$iv3;
        Enumeration enumeration = epub.getZip().getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"getEntries(...)");
        ArrayList arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
        List zipEntries = arrayList;
        Iterable $this$map$iv4 = CollectionsKt.plus((Collection)pages, (Iterable)assets);
        boolean $i$f$map4 = false;
        destination$iv$iv3 = $this$map$iv4;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Long l;
            Long l2;
            void var19_47;
            String string;
            String string2;
            MediaFile.SubType subType;
            block9: {
                void $this$firstOrNull$iv;
                void resource;
                MediaFile bl = (MediaFile)item$iv$iv;
                collection = destination$iv$iv4;
                boolean bl4 = false;
                Iterable bl2 = zipEntries;
                subType = null;
                string2 = null;
                string = null;
                var19_47 = resource;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ZipArchiveEntry it4 = (ZipArchiveEntry)element$iv;
                    boolean bl5 = false;
                    if (!Intrinsics.areEqual((Object)it4.getName(), (Object)resource.getFileName())) continue;
                    l2 = (Long)element$iv;
                    break block9;
                }
                l2 = null;
            }
            Long l3 = l2;
            void v8 = var19_47;
            String string3 = string;
            String string4 = string2;
            MediaFile.SubType subType2 = subType;
            if ((ZipArchiveEntry)l3 != null) {
                void it5;
                subType = subType2;
                string2 = string4;
                string = string3;
                var19_47 = v8;
                boolean bl = false;
                l3 = it5.getSize() == -1L ? null : Long.valueOf(it5.getSize());
                v8 = var19_47;
                string3 = string;
                string4 = string2;
                subType2 = subType;
                l = l3;
            } else {
                l = null;
            }
            collection.add(MediaFile.copy$default((MediaFile)v8, string3, string4, subType2, l, (int)7, null));
        }
        return (List)destination$iv$iv4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public List<BookPage> getDivinaPages(@NotNull EpubPackage epub, boolean isFixedLayout, int pageCount, boolean analyzeDimensions) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapTo$iv$iv;
        Iterable svg;
        InputStream it;
        Element element;
        Object it$iv$iv;
        Object it2;
        Object element$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv2;
        Iterable $this$mapNotNull$iv;
        Object it3;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)epub, (String)"epub");
        if (!isFixedLayout) {
            EpubExtractorKt.access$getLogger$p().info((Function0)getDivinaPages.1.INSTANCE);
            return CollectionsKt.emptyList();
        }
        Elements elements = epub.getOpfDoc().select("spine > itemref");
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
        Iterable iterable = (Iterable)elements;
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            Element element2 = (Element)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it3.attr("idref"));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv2 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        it3 = $this$forEach$iv$iv$iv.iterator();
        while (it3.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = it3.next();
            boolean bl5 = false;
            String idref = (String)element$iv$iv;
            boolean bl2 = false;
            Object object = (ManifestItem)epub.getManifest().get(idref);
            if (object != null && (object = object.getHref()) != null) {
                it2 = object;
                boolean bl3 = false;
                string = OpfKt.normalizeHref((Path)epub.getOpfDir(), (String)it2);
            } else {
                string = null;
            }
            if (string == null) continue;
            it$iv$iv = string;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapNotNullTo$iv$iv2 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            List list;
            InputStream inputStream;
            void pagePath;
            it3 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            InputStream inputStream2 = ZipFileUtilsKt.getEntryInputStream((ZipFile)epub.getZip(), (String)pagePath);
            if (inputStream2 != null) {
                element$iv$iv = inputStream2;
                Throwable bl5 = null;
                try {
                    InputStream it4 = (InputStream)element$iv$iv;
                    boolean bl6 = false;
                    it4 = Jsoup.parse((InputStream)it4, null, (String)"");
                    inputStream = it4;
                }
                catch (Throwable it4) {
                    bl5 = it4;
                    throw it4;
                }
                finally {
                    CloseableKt.closeFinally(element$iv$iv, (Throwable)bl5);
                }
            } else {
                inputStream = null;
            }
            Object object = it2 = inputStream;
            if (object == null) {
                list = CollectionsKt.emptyList();
            } else {
                Iterable $this$mapTo$iv$iv3;
                Iterable $this$map$iv2;
                Collection collection2;
                void $this$mapTo$iv$iv4;
                void $this$map$iv3;
                Intrinsics.checkNotNull((Object)object);
                Object doc = it2;
                if (doc.body().text().length() > this.letterCountThreshold) {
                    return CollectionsKt.emptyList();
                }
                Elements elements2 = doc.getElementsByTag("img");
                Intrinsics.checkNotNullExpressionValue((Object)elements2, (String)"getElementsByTag(...)");
                it$iv$iv = (Iterable)elements2;
                boolean $i$f$map22 = false;
                void bl5 = $this$map$iv3;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv4) {
                    element = (Element)item$iv$iv2;
                    collection2 = destination$iv$iv2;
                    boolean bl7 = false;
                    collection2.add(it.attr("src"));
                }
                List img = (List)destination$iv$iv2;
                Elements elements3 = doc.select("svg > image[xlink:href]");
                Intrinsics.checkNotNullExpressionValue((Object)elements3, (String)"select(...)");
                Iterable $i$f$map22 = (Iterable)elements3;
                boolean $i$f$map3 = false;
                destination$iv$iv2 = $this$map$iv2;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo3 = false;
                for (Object item$iv$iv3 : $this$mapTo$iv$iv3) {
                    void it5;
                    Element bl7 = (Element)item$iv$iv3;
                    collection2 = destination$iv$iv3;
                    boolean bl8 = false;
                    collection2.add(it5.attr("xlink:href"));
                }
                svg = (List)destination$iv$iv3;
                $this$map$iv2 = CollectionsKt.plus((Collection)img, (Iterable)svg);
                $i$f$map3 = false;
                $this$mapTo$iv$iv3 = $this$map$iv2;
                destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                $i$f$mapTo3 = false;
                for (Object item$iv$iv3 : $this$mapTo$iv$iv3) {
                    String it5 = (String)item$iv$iv3;
                    collection2 = destination$iv$iv3;
                    boolean bl9 = false;
                    Path path2 = Paths.get((String)pagePath, new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                    Path path3 = path2.getParent();
                    if (path3 == null) {
                        Path path4 = Paths.get("", new String[0]);
                        path3 = path4;
                        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"get(...)");
                    }
                    Path path5 = path3.resolve(it5).normalize();
                    Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"normalize(...)");
                    collection2.add(PathsKt.getInvariantSeparatorsPathString((Path)path5));
                }
                list = (List)destination$iv$iv3;
            }
            collection.add(list);
        }
        List pagesWithImages = (List)destination$iv$iv;
        if (pagesWithImages.size() != pageCount) {
            EpubExtractorKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv4 = pagesWithImages;
        boolean $i$f$map4 = false;
        destination$iv$iv = $this$map$iv4;
        Iterable destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it6;
            List bl = (List)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl10 = false;
            collection.add(CollectionsKt.distinct((Iterable)((Iterable)it6)));
        }
        List imagesPath = CollectionsKt.flatten((Iterable)((List)destination$iv$iv4));
        if (imagesPath.size() != pageCount) {
            EpubExtractorKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
            return CollectionsKt.emptyList();
        }
        Iterable $this$mapNotNull$iv2 = imagesPath;
        boolean $i$f$mapNotNull2 = false;
        destination$iv$iv4 = $this$mapNotNull$iv2;
        Collection destination$iv$iv5 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator = $this$forEach$iv$iv$iv2.iterator();
        while (iterator.hasNext()) {
            BookPage bookPage;
            block32: {
                Element element3;
                ZipArchiveEntry zipEntry;
                String mediaType2;
                String imagePath;
                block35: {
                    block34: {
                        Object object;
                        block33: {
                            String $this$firstOrNull$iv;
                            block31: {
                                Object v13;
                                block30: {
                                    Object element$iv$iv$iv;
                                    Object element$iv$iv2 = element$iv$iv$iv = iterator.next();
                                    boolean bl = false;
                                    imagePath = (String)element$iv$iv2;
                                    boolean bl11 = false;
                                    svg = epub.getManifest().values();
                                    boolean $i$f$firstOrNull = false;
                                    object = $this$firstOrNull$iv.iterator();
                                    while (object.hasNext()) {
                                        Object element$iv = object.next();
                                        ManifestItem it7 = (ManifestItem)element$iv;
                                        boolean bl12 = false;
                                        if (!Intrinsics.areEqual((Object)OpfKt.normalizeHref((Path)epub.getOpfDir(), (String)it7.getHref()), (Object)imagePath)) continue;
                                        v13 = element$iv;
                                        break block30;
                                    }
                                    v13 = null;
                                }
                                ManifestItem bl9 = v13;
                                if (bl9 != null && ($this$firstOrNull$iv = bl9.getMediaType()) != null) break block31;
                                bookPage = null;
                                break block32;
                            }
                            mediaType2 = $this$firstOrNull$iv;
                            zipEntry = epub.getZip().getEntry(imagePath);
                            if (this.contentDetector.isImage(mediaType2)) break block33;
                            bookPage = null;
                            break block32;
                        }
                        if (!analyzeDimensions) break block34;
                        Closeable $i$f$firstOrNull = epub.getZip().getInputStream(zipEntry);
                        object = null;
                        try {
                            it = (InputStream)$i$f$firstOrNull;
                            boolean bl = false;
                            Intrinsics.checkNotNull((Object)it);
                            element = this.imageAnalyzer.getDimension(it);
                        }
                        catch (Throwable throwable) {
                            try {
                                object = throwable;
                                throw throwable;
                            }
                            catch (Throwable throwable2) {
                                CloseableKt.closeFinally((Closeable)$i$f$firstOrNull, object);
                                throw throwable2;
                            }
                        }
                        CloseableKt.closeFinally((Closeable)$i$f$firstOrNull, (Throwable)object);
                        element3 = element;
                        break block35;
                    }
                    element3 = null;
                }
                Element dimension = element3;
                Long fileSize = zipEntry.getSize() == -1L ? null : Long.valueOf(zipEntry.getSize());
                bookPage = new BookPage(imagePath, mediaType2, dimension, null, fileSize, 8, null);
            }
            if (bookPage == null) continue;
            BookPage it$iv$iv2 = bookPage;
            boolean bl = false;
            destination$iv$iv5.add(it$iv$iv2);
        }
        List divinaPages2 = (List)destination$iv$iv5;
        if (divinaPages2.size() != pageCount) {
            EpubExtractorKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
            return CollectionsKt.emptyList();
        }
        return divinaPages2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public boolean isKepub(@NotNull EpubPackage epub, @NotNull List<MediaFile> resources2) {
        Intrinsics.checkNotNullParameter((Object)epub, (String)"epub");
        Intrinsics.checkNotNullParameter(resources2, (String)"resources");
        try {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = resources2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                MediaFile it = (MediaFile)element$iv$iv;
                boolean bl = false;
                if (!(it.getSubType() == MediaFile.SubType.EPUB_PAGE)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List readingOrder = (List)destination$iv$iv;
            Iterable $this$forEach$iv = readingOrder;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Document doc;
                Document document;
                MediaFile mediaFile = (MediaFile)element$iv;
                boolean bl = false;
                InputStream inputStream = ZipFileUtilsKt.getEntryInputStream((ZipFile)epub.getZip(), (String)mediaFile.getFileName());
                if (inputStream != null) {
                    Closeable closeable = inputStream;
                    Throwable throwable = null;
                    try {
                        InputStream it = (InputStream)closeable;
                        boolean bl2 = false;
                        Document document2 = Jsoup.parse((InputStream)it, null, (String)"");
                        document = document2;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                } else {
                    document = null;
                }
                Document document3 = doc = document;
                Collection collection = (Collection)(document3 != null ? document3.getElementsByClass("koboSpan") : null);
                if (collection == null || collection.isEmpty()) continue;
                return true;
            }
        }
        catch (Exception e) {
            EpubExtractorKt.access$getLogger$p().warn((Throwable)e, (Function0)isKepub.2.INSTANCE);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public int computePageCount(@NotNull EpubPackage epub) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        ZipArchiveEntry it;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)epub, (String)"epub");
        Elements elements = epub.getOpfDoc().select("spine > itemref");
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
        Iterable $this$map$iv = (Iterable)elements;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Element element = (Element)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.attr("idref"));
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            String idref = (String)element$iv$iv;
            boolean bl2 = false;
            Object object = (ManifestItem)epub.getManifest().get(idref);
            if (object != null && (object = object.getHref()) != null) {
                Object it2 = object;
                boolean bl3 = false;
                string = OpfKt.normalizeHref((Path)epub.getOpfDir(), (String)it2);
            } else {
                string = null;
            }
            if (string == null) continue;
            String it$iv$iv = string;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List spine = (List)destination$iv$iv;
        Enumeration enumeration = epub.getZip().getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"getEntries(...)");
        ArrayList arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
        Iterable $this$filter$iv = arrayList;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ZipArchiveEntry)element$iv$iv;
            boolean bl = false;
            if (!spine.contains(it.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        int n = 0;
        for (Object e : iterable2) {
            void it3;
            ZipArchiveEntry $i$f$filterTo2 = (ZipArchiveEntry)e;
            int n2 = n;
            boolean bl = false;
            int n3 = (int)Math.ceil((double)it3.getCompressedSize() / 1024.0);
            n = n2 + n3;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isFixedLayout(@NotNull EpubPackage epub) {
        Intrinsics.checkNotNullParameter((Object)epub, (String)"epub");
        Element element = epub.getOpfDoc().selectFirst("metadata > *|meta[property=rendition:layout]");
        if (Intrinsics.areEqual((Object)(element != null ? element.text() : null), (Object)"pre-paginated")) return true;
        Element element2 = epub.getOpfDoc().selectFirst("metadata > *|meta[name=fixed-layout]");
        if (!Intrinsics.areEqual((Object)(element2 != null ? element2.attr("content") : null), (Object)"true")) return false;
        return true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public List<R2Locator> computePositions(@NotNull EpubPackage epub, @NotNull Path path, @NotNull List<MediaFile> resources, boolean isFixedLayout, boolean isKepub) {
        block26: {
            block25: {
                Intrinsics.checkNotNullParameter((Object)epub, (String)"epub");
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter(resources, (String)"resources");
                $this$filter$iv = resources;
                $i$f$filter = false;
                var9_10 = $this$filter$iv;
                destination$iv$iv /* !! */  = new ArrayList<E>();
                $i$f$filterTo = false;
                var12_14 = $this$filterTo$iv$iv.iterator();
                while (var12_14.hasNext()) {
                    element$iv$iv = var12_14.next();
                    it = (MediaFile)element$iv$iv;
                    $i$a$-filter-EpubExtractor$computePositions$readingOrder$1 = false;
                    if (!(it.getSubType() == MediaFile.SubType.EPUB_PAGE)) continue;
                    destination$iv$iv /* !! */ .add(element$iv$iv);
                }
                readingOrder = (List)destination$iv$iv /* !! */ ;
                startPosition = 0;
                startPosition = 1;
                if (isFixedLayout) {
                    v0 = MapsKt.emptyMap();
                } else if (isKepub) {
                    v0 = this.computePositionsFromKoboSpan(readingOrder, (Function1)new /* Unavailable Anonymous Inner Class!! */);
                } else if (this.kepubConverter.isAvailable()) {
                    try {
                        destination$iv$iv /* !! */  = KepubConverter.convertEpubToKepubWithoutChecks$default((KepubConverter)this.kepubConverter, (Path)path, null, (int)2, null);
                        if (destination$iv$iv /* !! */  == null) {
                            throw new IllegalStateException();
                        }
                        it = var12_14 = destination$iv$iv /* !! */ ;
                        $i$a$-also-EpubExtractor$computePositions$koboPositions$kepub$1 = false;
                        it.toFile().deleteOnExit();
                        kepub = var12_14;
                        positions = this.computePositionsFromKoboSpan(readingOrder, (Function1)new /* Unavailable Anonymous Inner Class!! */);
                        Files.deleteIfExists((Path)kepub);
                        kepub = positions;
                    }
                    catch (Exception e) {
                        EpubExtractorKt.access$getLogger$p().warn((Function0)new /* Unavailable Anonymous Inner Class!! */);
                        kepub = MapsKt.emptyMap();
                    }
                    v0 = kepub;
                } else {
                    v0 = koboPositions = MapsKt.emptyMap();
                }
                if (!isFixedLayout) break block25;
                $this$map$iv = readingOrder;
                $i$f$map = false;
                var12_14 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var17_24 = (MediaFile)item$iv$iv;
                    var42_22 = destination$iv$iv;
                    $i$a$-map-EpubExtractor$computePositions$positions$1 = false;
                    var19_26 = it.getFileName();
                    v1 = it.getMediaType();
                    if (v1 == null) {
                        v1 = "application/octet-stream";
                    }
                    var20_29 = v1;
                    var21_32 = startPosition;
                    startPosition = var21_32 + 1;
                    var22_34 = new R2Locator.Location(null, Float.valueOf(0.0f), Integer.valueOf(var21_32), null, 9, null);
                    var42_22.add(new R2Locator(var19_26, var20_29, null, (R2Locator.Location)var22_34, null, "kobo.1.1", 20, null));
                }
                v2 = (List)destination$iv$iv;
                break block26;
            }
            $this$flatMap$iv = readingOrder;
            $i$f$flatMap = false;
            $this$mapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$flatMapTo = false;
            for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                file = (MediaFile)element$iv$iv;
                $i$a$-flatMap-EpubExtractor$computePositions$positions$2 = false;
                var19_27 = 1;
                v3 = file.getFileSize();
                var20_30 = MathKt.roundToInt((double)Math.ceil((double)(v3 != null ? v3 : 0L) / 1024.0));
                positionCount = Math.max(var19_27, var20_30);
                $this$map$iv = (Iterable)RangesKt.until((int)0, (int)positionCount);
                $i$f$map = false;
                var22_34 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                var25_37 = $this$mapTo$iv$iv.iterator();
                while (var25_37.hasNext()) {
                    block28: {
                        block27: {
                            var27_39 = item$iv$iv = ((IntIterator)var25_37).nextInt();
                            var28_40 = destination$iv$iv;
                            $i$a$-map-EpubExtractor$computePositions$positions$2$1 = false;
                            progression = (float)p / (float)positionCount;
                            if (positionCount != 1 && p != false) break block27;
                            v4 = "kobo.1.1";
                            break block28;
                        }
                        var31_44 = (List)koboPositions.get(file.getFileName());
                        if (var31_44 == null) ** GOTO lbl-1000
                        var32_45 = var31_44;
                        $i$f$minByOrNull = false;
                        iterator$iv = $this$minByOrNull$iv.iterator();
                        if (!iterator$iv.hasNext()) {
                            v5 = null;
                        } else {
                            minElem$iv = iterator$iv.next();
                            if (!iterator$iv.hasNext()) {
                                v5 = minElem$iv;
                            } else {
                                it = (Pair)minElem$iv;
                                $i$a$-minByOrNull-EpubExtractor$computePositions$positions$2$1$koboSpan$1 = false;
                                minValue$iv = Math.abs(progression - ((Number)it.getSecond()).floatValue());
                                do {
                                    e$iv = iterator$iv.next();
                                    it = (Pair)e$iv;
                                    $i$a$-minByOrNull-EpubExtractor$computePositions$positions$2$1$koboSpan$1 = false;
                                    v$iv = Math.abs(progression - ((Number)it.getSecond()).floatValue());
                                    if (Float.compare(minValue$iv, v$iv) <= 0) continue;
                                    minElem$iv = e$iv;
                                    minValue$iv = v$iv;
                                } while (iterator$iv.hasNext());
                                v5 = minElem$iv;
                            }
                        }
                        var40_56 = v5;
                        if (var40_56 != null) {
                            v4 = (String)var40_56.getFirst();
                        } else lbl-1000:
                        // 2 sources

                        {
                            v4 = null;
                        }
                    }
                    koboSpan = v4;
                    v6 = file.getFileName();
                    v7 = file.getMediaType();
                    if (v7 == null) {
                        v7 = "application/octet-stream";
                    }
                    var31_43 = startPosition;
                    startPosition = var31_43 + 1;
                    var28_40.add(new R2Locator(v6, v7, null, new R2Locator.Location(null, Float.valueOf(progression), Integer.valueOf(var31_43), null, 9, null), null, koboSpan, 20, null));
                }
                list$iv$iv /* !! */  = (List)destination$iv$iv;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv /* !! */ );
            }
            v2 = (List)destination$iv$iv;
        }
        positions = v2;
        $this$map$iv = positions;
        $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv /* !! */  = (R2Locator)item$iv$iv;
            var42_22 = destination$iv$iv;
            $i$a$-map-EpubExtractor$computePositions$1 = false;
            v8 /* !! */  = locator.getLocations();
            if (v8 /* !! */  != null && (v8 /* !! */  = v8 /* !! */ .getPosition()) != null) {
                it = ((Number)v8 /* !! */ ).intValue();
                $i$a$-let-EpubExtractor$computePositions$1$totalProgression$1 = false;
                v9 = Float.valueOf((float)it / (float)positions.size());
            } else {
                v9 = null;
            }
            totalProgression = v9;
            v10 = locator.getLocations();
            var42_22.add(R2Locator.copy$default((R2Locator)locator, null, null, null, (R2Locator.Location)(v10 != null ? R2Locator.Location.copy$default((R2Locator.Location)v10, null, null, null, (Float)totalProgression, (int)7, null) : null), null, null, (int)55, null));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, List<Pair<String, Float>>> computePositionsFromKoboSpan(List<MediaFile> readingOrder, Function1<? super String, String> resourceSupplier) {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = readingOrder;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            List list;
            Elements elements;
            Document document;
            Map map = destination$iv$iv;
            MediaFile file = (MediaFile)element$iv$iv;
            boolean bl = false;
            if ((String)resourceSupplier.invoke((Object)file.getFileName()) != null) {
                String resource;
                boolean bl2 = false;
                document = Jsoup.parse((String)resource, (Parser)Parser.htmlParser().setTrackPosition(true));
            } else {
                document = null;
            }
            Document doc = document;
            String string = file.getFileName();
            Document document2 = doc;
            if (document2 != null && (document2 = (elements = document2.select("span.koboSpan"))) != null) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Intrinsics.checkNotNull((Object)document2);
                Iterable iterable2 = (Iterable)elements;
                String string2 = string;
                boolean $i$f$mapNotNull = false;
                void bl2 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Pair pair;
                    Object element$iv$iv$iv;
                    Object element$iv$iv2 = element$iv$iv$iv = iterator.next();
                    boolean bl3 = false;
                    Element koboSpan = (Element)element$iv$iv2;
                    boolean bl4 = false;
                    String id = koboSpan.id();
                    CharSequence charSequence = id;
                    if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                        float f = koboSpan.sourceRange().endPos();
                        Long l = file.getFileSize();
                        Intrinsics.checkNotNull((Object)l);
                        float progression = f / (float)l.longValue();
                        Intrinsics.checkNotNull((Object)id);
                        pair = new Pair((Object)id, (Object)Float.valueOf(progression));
                    } else {
                        pair = null;
                    }
                    if (pair == null) continue;
                    Pair it$iv$iv = pair;
                    boolean bl5 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                list = (List)destination$iv$iv2;
                string = string2;
            } else {
                list = null;
            }
            Pair pair = TuplesKt.to((Object)string, list);
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    @NotNull
    public List<EpubTocEntry> getToc(@NotNull EpubPackage epub) {
        Intrinsics.checkNotNullParameter((Object)epub, (String)"epub");
        ResourceContent resourceContent = NavKt.getNavResource((EpubPackage)epub);
        if (resourceContent != null) {
            ResourceContent it = resourceContent;
            boolean bl = false;
            return NavKt.processNav((ResourceContent)it, (Epub3Nav)Epub3Nav.TOC);
        }
        ResourceContent resourceContent2 = NcxKt.getNcxResource((EpubPackage)epub);
        if (resourceContent2 != null) {
            ResourceContent it = resourceContent2;
            boolean bl = false;
            return NcxKt.processNcx((ResourceContent)it, (Epub2Nav)Epub2Nav.TOC);
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<EpubTocEntry> getPageList(@NotNull EpubPackage epub) {
        Intrinsics.checkNotNullParameter((Object)epub, (String)"epub");
        ResourceContent resourceContent = NavKt.getNavResource((EpubPackage)epub);
        if (resourceContent != null) {
            ResourceContent it = resourceContent;
            boolean bl = false;
            return NavKt.processNav((ResourceContent)it, (Epub3Nav)Epub3Nav.PAGELIST);
        }
        ResourceContent resourceContent2 = NcxKt.getNcxResource((EpubPackage)epub);
        if (resourceContent2 != null) {
            ResourceContent it = resourceContent2;
            boolean bl = false;
            return NcxKt.processNcx((ResourceContent)it, (Epub2Nav)Epub2Nav.PAGELIST);
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<EpubTocEntry> getLandmarks(@NotNull EpubPackage epub) {
        Intrinsics.checkNotNullParameter((Object)epub, (String)"epub");
        ResourceContent resourceContent = NavKt.getNavResource((EpubPackage)epub);
        if (resourceContent != null) {
            ResourceContent it = resourceContent;
            boolean bl = false;
            return NavKt.processNav((ResourceContent)it, (Epub3Nav)Epub3Nav.LANDMARKS);
        }
        return OpfKt.processOpfGuide((Document)epub.getOpfDoc(), (Path)epub.getOpfDir());
    }
}

