/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.metadata.barcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.RGBLuminanceSource;
import com.google.zxing.Result;
import com.google.zxing.common.HybridBinarizer;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.apache.commons.validator.routines.ISBNValidator;
import org.gotson.komga.domain.model.BookMetadataPatch;
import org.gotson.komga.domain.model.BookMetadataPatchCapability;
import org.gotson.komga.domain.model.BookWithMedia;
import org.gotson.komga.domain.model.Library;
import org.gotson.komga.domain.model.MediaProfile;
import org.gotson.komga.domain.model.MetadataPatchTarget;
import org.gotson.komga.domain.service.BookAnalyzer;
import org.gotson.komga.infrastructure.metadata.BookMetadataProvider;
import org.gotson.komga.infrastructure.metadata.barcode.IsbnBarcodeProvider;
import org.gotson.komga.infrastructure.metadata.barcode.IsbnBarcodeProviderKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\"\u0010\f\u001a\u0016\u0012\u0004\u0012\u00020\u000e\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f0\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/gotson/komga/infrastructure/metadata/barcode/IsbnBarcodeProvider;", "Lorg/gotson/komga/infrastructure/metadata/BookMetadataProvider;", "bookAnalyzer", "Lorg/gotson/komga/domain/service/BookAnalyzer;", "validator", "Lorg/apache/commons/validator/routines/ISBNValidator;", "(Lorg/gotson/komga/domain/service/BookAnalyzer;Lorg/apache/commons/validator/routines/ISBNValidator;)V", "capabilities", "", "Lorg/gotson/komga/domain/model/BookMetadataPatchCapability;", "getCapabilities", "()Ljava/util/Set;", "hints", "", "Lcom/google/zxing/DecodeHintType;", "Ljava/io/Serializable;", "kotlin.jvm.PlatformType", "getBookMetadataFromBook", "Lorg/gotson/komga/domain/model/BookMetadataPatch;", "book", "Lorg/gotson/komga/domain/model/BookWithMedia;", "shouldLibraryHandlePatch", "", "library", "Lorg/gotson/komga/domain/model/Library;", "target", "Lorg/gotson/komga/domain/model/MetadataPatchTarget;", "komga"})
public class IsbnBarcodeProvider
implements BookMetadataProvider {
    @NotNull
    private final BookAnalyzer bookAnalyzer;
    @NotNull
    private final ISBNValidator validator;
    @NotNull
    private final Map<DecodeHintType, Serializable> hints;
    @NotNull
    private final Set<BookMetadataPatchCapability> capabilities;

    public IsbnBarcodeProvider(@NotNull BookAnalyzer bookAnalyzer, @NotNull ISBNValidator validator) {
        Intrinsics.checkNotNullParameter((Object)bookAnalyzer, (String)"bookAnalyzer");
        Intrinsics.checkNotNullParameter((Object)validator, (String)"validator");
        this.bookAnalyzer = bookAnalyzer;
        this.validator = validator;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)DecodeHintType.POSSIBLE_FORMATS, EnumSet.of((Enum)BarcodeFormat.EAN_13)), TuplesKt.to((Object)DecodeHintType.TRY_HARDER, (Object)true)};
        this.hints = MapsKt.mapOf((Pair[])pairArray);
        this.capabilities = SetsKt.setOf((Object)BookMetadataPatchCapability.ISBN);
    }

    @NotNull
    public Set<BookMetadataPatchCapability> getCapabilities() {
        return this.capabilities;
    }

    @Nullable
    public BookMetadataPatch getBookMetadataFromBook(@NotNull BookWithMedia book) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        if (book.getMedia().getProfile() == MediaProfile.EPUB) {
            return null;
        }
        List it = CollectionsKt.toList((Iterable)((Iterable)new IntRange(1, book.getMedia().getPageCount())));
        boolean bl = false;
        List pagesToTry = CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)CollectionsKt.reversed((Iterable)CollectionsKt.takeLast((List)it, (int)3)), (Iterable)CollectionsKt.take((Iterable)it, (int)3)));
        Iterator iterator = pagesToTry.iterator();
        while (iterator.hasNext()) {
            int p = ((Number)iterator.next()).intValue();
            try {
                Result result2;
                BufferedImage image;
                byte[] imageBytes = this.bookAnalyzer.getPageContent(book, p);
                if (ImageIO.read(new ByteArrayInputStream(imageBytes)) == null) continue;
                boolean bl2 = false;
                int[] pixels = image.getRGB(0, 0, image.getWidth(), image.getHeight(), null, 0, image.getWidth());
                RGBLuminanceSource source = new RGBLuminanceSource(image.getWidth(), image.getHeight(), pixels);
                BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
                try {
                    result2 = new MultiFormatReader().decode(bitmap, this.hints);
                }
                catch (Exception e) {
                    result2 = null;
                }
                Result result3 = result2;
                if (result3 == null || result3.getText() == null) {
                    IsbnBarcodeProviderKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
                    continue;
                }
                if (this.validator.isValid(result3.getText())) {
                    IsbnBarcodeProviderKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
                    return new BookMetadataPatch(null, null, null, null, null, null, this.validator.validate(result3.getText()), null, null, null, 959, null);
                }
                IsbnBarcodeProviderKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (Exception e) {
                IsbnBarcodeProviderKt.access$getLogger$p().error((Throwable)e, (Function0)getBookMetadataFromBook.2.INSTANCE);
            }
        }
        return null;
    }

    public boolean shouldLibraryHandlePatch(@NotNull Library library, @NotNull MetadataPatchTarget target) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return WhenMappings.$EnumSwitchMapping$0[target.ordinal()] == 1 ? library.getImportBarcodeIsbn() : false;
    }
}

