/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.openapi;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.servers.ServerVariable;
import io.swagger.v3.oas.models.servers.ServerVariables;
import io.swagger.v3.oas.models.tags.Tag;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.gotson.komga.infrastructure.openapi.OpenApiConfiguration;
import org.jetbrains.annotations.NotNull;
import org.springdoc.core.customizers.OperationCustomizer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.method.HandlerMethod;

@Configuration
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001:\u0003\u0013\u0014\u0015B\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0017J\b\u0010\u0011\u001a\u00020\u0012H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/gotson/komga/infrastructure/openapi/OpenApiConfiguration;", "", "appVersion", "", "env", "Lorg/springframework/core/env/Environment;", "(Ljava/lang/String;Lorg/springframework/core/env/Environment;)V", "generateOpenApi", "", "tagGroups", "", "Lorg/gotson/komga/infrastructure/openapi/OpenApiConfiguration$TagGroup;", "tags", "Lio/swagger/v3/oas/models/tags/Tag;", "kotlin.jvm.PlatformType", "openApi", "Lio/swagger/v3/oas/models/OpenAPI;", "roleDescriptionCustomizer", "Lorg/springdoc/core/customizers/OperationCustomizer;", "SecuritySchemes", "TagGroup", "TagNames", "komga"})
public class OpenApiConfiguration {
    @NotNull
    private final String appVersion;
    private final boolean generateOpenApi;
    @NotNull
    private final List<TagGroup> tagGroups;
    @NotNull
    private final List<Tag> tags;

    public OpenApiConfiguration(@Value(value="${application.version}") @NotNull String appVersion, @NotNull Environment env) {
        Intrinsics.checkNotNullParameter((Object)appVersion, (String)"appVersion");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        this.appVersion = appVersion;
        String[] stringArray = env.getActiveProfiles();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getActiveProfiles(...)");
        this.generateOpenApi = ArraysKt.contains((Object[])stringArray, (Object)"generate-openapi");
        Object[] objectArray = new TagGroup[10];
        objectArray[0] = new TagGroup("Deprecation", CollectionsKt.listOf((Object)"Deprecated"));
        objectArray[1] = new TagGroup("Libraries", CollectionsKt.listOf((Object)"Libraries"));
        Object[] objectArray2 = new String[]{"Series", "Series Poster"};
        objectArray[2] = new TagGroup("Series", CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new String[]{"Books", "Book Pages", "Book Poster", "Import", "Duplicate Pages", "WebPub Manifest", "Fonts"};
        objectArray[3] = new TagGroup("Books", CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new String[]{"Collections", "Collection Series", "Collection Poster"};
        objectArray[4] = new TagGroup("Collections", CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new String[]{"Readlists", "Readlist Books", "Readlist Poster"};
        objectArray[5] = new TagGroup("Readlists", CollectionsKt.listOf((Object[])objectArray2));
        objectArray[6] = new TagGroup("Referential", CollectionsKt.listOf((Object)"Referential metadata"));
        objectArray2 = new String[]{"Current user", "Users", "API Keys", "User session", "OAuth2", "Sync points"};
        objectArray[7] = new TagGroup("Users", CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new String[]{"Claim server", "Server settings", "Tasks", "History", "File system", "Releases", "Announcements"};
        objectArray[8] = new TagGroup("Server", CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new String[]{"Client settings", "Mihon", "ComicRack"};
        objectArray[9] = new TagGroup("Integrations", CollectionsKt.listOf((Object[])objectArray2));
        this.tagGroups = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Tag[]{new Tag().name("Deprecated"), new Tag().name("Libraries").description("Manage libraries."), new Tag().name("Series").description("Manage series."), new Tag().name("Series Poster").description("Manage posters for series."), new Tag().name("Books").description("Manage books."), new Tag().name("Book Poster").description("Manage posters for books."), new Tag().name("Book Pages"), new Tag().name("WebPub Manifest"), new Tag().name("Import"), new Tag().name("Fonts").description("Provide font files and CSS for the Epub Reader."), new Tag().name("Duplicate Pages").description("Manage duplicate pages. Duplicate pages are identified by a page hash."), new Tag().name("Collections").description("Manage collections."), new Tag().name("Collection Poster").description("Manage posters for collections."), new Tag().name("Collection Series"), new Tag().name("Readlists").description("Manage readlists."), new Tag().name("Readlist Poster").description("Manage posters for readlists."), new Tag().name("Readlist Books"), new Tag().name("Referential metadata").description("Retrieve referential metadata from all items in the Komga server."), new Tag().name("Current user").description("Manage current user."), new Tag().name("Users").description("Manage users."), new Tag().name("API Keys").description("Manage API Keys"), new Tag().name("User session"), new Tag().name("OAuth2").description("List registered OAuth2 providers"), new Tag().name("Sync points").description("Sync points are automatically created during a Kobo sync."), new Tag().name("Claim server").description("Claim a freshly installed Komga server."), new Tag().name("Tasks").description("Manage server tasks"), new Tag().name("History").description("Server events history"), new Tag().name("File system").description("List files from the host server's file system"), new Tag().name("Server settings").description("Store and retrieve server settings"), new Tag().name("Releases").description("Retrieve releases information"), new Tag().name("Announcements").description("Retrieve announcements from the Komga website"), new Tag().name("Mihon"), new Tag().name("ComicRack"), new Tag().name("Client settings").description("Store and retrieve global and per-user settings. Those settings are not used by Komga itself, but can be stored for convenience by client applications.")};
        this.tags = CollectionsKt.listOf((Object[])objectArray);
    }

    @Bean
    @NotNull
    public OpenAPI openApi() {
        Operation logoutOperation = new Operation().tags(CollectionsKt.listOf((Object)"User session")).summary("Logout").description("Invalidates the current session and clean up any remember-me authentication.").responses(new ApiResponses().addApiResponse("204", new ApiResponse().description("No Content")));
        SecurityRequirement[] securityRequirementArray = new SecurityRequirement[]{new SecurityRequirement().addList("basicAuth"), new SecurityRequirement().addList("apiKey")};
        SecurityRequirement[] $this$openApi_u24lambda_u240 = securityRequirementArray = new OpenAPI().info(new Info().title("Komga API").version(this.appVersion).description("Komga REST API.\n\n## Reference\n\nCheck the API reference:\n- on the [Komga website](https://komga.org/docs/openapi/komga-api)\n- on any running Komga instance at `/swagger-ui.html`\n- on [GitHub](https://raw.githubusercontent.com/gotson/komga/refs/heads/master/komga/docs/openapi.json)\n\n## Authentication\n\nMost endpoints require authentication. Authentication is done using either:\n- Basic Authentication\n- Passing an API Key in the `X-API-Key` header\n\n## Sessions\n\nUpon successful authentication, a session is created, and can be reused.\n\n- By default, a `KOMGA-SESSION` cookie is set via `Set-Cookie` response header. This works well for browsers and clients that can handle cookies.\n- If you specify a header `X-Auth-Token` during authentication, the session ID will be returned via this same header. You can then pass that header again for subsequent requests to reuse the session.\n\nIf you need to set the session cookie later on, you can call `/api/v1/login/set-cookie` with `X-Auth-Token`. The response will contain the `Set-Cookie` header.\n\n## Remember Me\n\nDuring authentication, if a request parameter `remember-me` is passed and set to `true`, the server will also return a `komga-remember-me` cookie. This cookie will be used to login automatically even if the session has expired.\n\n## Logout\n\nYou can explicitly logout an existing session by calling `/api/logout`. This would return a `204`.\n\n## Deprecation\n\nAPI endpoints marked as deprecated will be removed in the next major version.").license(new License().name("MIT").url("https://github.com/gotson/komga/blob/master/LICENSE"))).externalDocs(new ExternalDocumentation().description("Komga documentation").url("https://komga.org")).components(new Components().addSecuritySchemes("basicAuth", new SecurityScheme().type(SecurityScheme.Type.HTTP).scheme("basic")).addSecuritySchemes("apiKey", new SecurityScheme().type(SecurityScheme.Type.APIKEY).in(SecurityScheme.In.HEADER).name("X-API-Key"))).security(CollectionsKt.listOf((Object[])securityRequirementArray)).tags(this.tags).extensions(MapsKt.mapOf((Pair)TuplesKt.to((Object)"x-tagGroups", (Object)this.tagGroups)));
        boolean bl = false;
        if (this.generateOpenApi) {
            Object[] objectArray = new Server[]{new Server().url("https://demo.komga.org").description("Demo server"), new Server().url("http://localhost:{port}").description("Local development server").variables(new ServerVariables().addServerVariable("port", new ServerVariable().addEnumItem("8080").addEnumItem("25600")._default("25600")))};
            $this$openApi_u24lambda_u240.servers(CollectionsKt.listOf((Object[])objectArray));
        }
        OpenAPI openAPI = securityRequirementArray.path("/api/logout", new PathItem().summary("Logout current session").get(logoutOperation.operationId("getLogout")).post(logoutOperation.operationId("postLogout")));
        Intrinsics.checkNotNullExpressionValue((Object)openAPI, (String)"path(...)");
        return openAPI;
    }

    @Bean
    @NotNull
    public OperationCustomizer roleDescriptionCustomizer() {
        Regex hasRoleRegex = new Regex("hasRole\\('(?<role>\\w+)'\\)");
        return (arg_0, arg_1) -> OpenApiConfiguration.roleDescriptionCustomizer$lambda$1(hasRoleRegex, arg_0, arg_1);
    }

    private static final Operation roleDescriptionCustomizer$lambda$1(Regex $hasRoleRegex, Operation operation, HandlerMethod handlerMethod) {
        List roles2;
        PreAuthorize preAuthorize;
        Intrinsics.checkNotNullParameter((Object)$hasRoleRegex, (String)"$hasRoleRegex");
        PreAuthorize preAuthorize2 = (PreAuthorize)handlerMethod.getMethodAnnotation(PreAuthorize.class);
        if (preAuthorize2 == null) {
            preAuthorize2 = handlerMethod.getBeanType().getAnnotation(PreAuthorize.class);
        }
        if ((preAuthorize = preAuthorize2) != null && !((Collection)(roles2 = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)Regex.findAll$default((Regex)$hasRoleRegex, (CharSequence)preAuthorize.value(), (int)0, (int)2, null), (Function1)((Function1)roleDescriptionCustomizer.1.roles.1.INSTANCE))))).isEmpty()) {
            String description = operation.getDescription() == null ? "" : operation.getDescription() + "\n\n";
            operation.setDescription(description + "Required role: **" + CollectionsKt.joinToString$default((Iterable)roles2, null, null, null, (int)0, null, null, (int)63, null) + "**");
        }
        return operation;
    }
}

