/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.search;

import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.SingleInstanceLockFactory;
import org.gotson.komga.infrastructure.configuration.KomgaProperties;
import org.gotson.komga.infrastructure.search.MultiLingualAnalyzer;
import org.gotson.komga.infrastructure.search.MultiLingualNGramAnalyzer;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0017J\b\u0010\u0007\u001a\u00020\bH\u0017J\b\u0010\t\u001a\u00020\u0006H\u0017J\b\u0010\n\u001a\u00020\u000bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/gotson/komga/infrastructure/search/LuceneConfiguration;", "", "komgaProperties", "Lorg/gotson/komga/infrastructure/configuration/KomgaProperties;", "(Lorg/gotson/komga/infrastructure/configuration/KomgaProperties;)V", "diskDirectory", "Lorg/apache/lucene/store/Directory;", "indexAnalyzer", "Lorg/gotson/komga/infrastructure/search/MultiLingualNGramAnalyzer;", "memoryDirectory", "searchAnalyzer", "Lorg/gotson/komga/infrastructure/search/MultiLingualAnalyzer;", "komga"})
public class LuceneConfiguration {
    @NotNull
    private final KomgaProperties komgaProperties;

    public LuceneConfiguration(@NotNull KomgaProperties komgaProperties) {
        Intrinsics.checkNotNullParameter((Object)komgaProperties, (String)"komgaProperties");
        this.komgaProperties = komgaProperties;
    }

    @Bean
    @NotNull
    public MultiLingualNGramAnalyzer indexAnalyzer() {
        KomgaProperties.Lucene.IndexAnalyzer $this$indexAnalyzer_u24lambda_u240 = this.komgaProperties.getLucene().getIndexAnalyzer();
        boolean bl = false;
        return new MultiLingualNGramAnalyzer($this$indexAnalyzer_u24lambda_u240.getMinGram(), $this$indexAnalyzer_u24lambda_u240.getMaxGram(), $this$indexAnalyzer_u24lambda_u240.getPreserveOriginal());
    }

    @Bean
    @NotNull
    public MultiLingualAnalyzer searchAnalyzer() {
        return new MultiLingualAnalyzer();
    }

    @Bean
    @Profile(value={"test"})
    @NotNull
    public Directory memoryDirectory() {
        return (Directory)new ByteBuffersDirectory();
    }

    @Bean
    @Profile(value={"!test"})
    @NotNull
    public Directory diskDirectory() {
        FSDirectory fSDirectory = FSDirectory.open((Path)Paths.get(this.komgaProperties.getLucene().getDataDirectory(), new String[0]), (LockFactory)((LockFactory)new SingleInstanceLockFactory()));
        Intrinsics.checkNotNullExpressionValue((Object)fSDirectory, (String)"open(...)");
        return (Directory)fSDirectory;
    }
}

