/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.web;

import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.CacheControl;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0006\u0010\b\u001a\u00020\t\u001a\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0007\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u000e\u001a\n\u0010\u000f\u001a\u00020\u0007*\u00020\u0005\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0010"}, d2={"cachePrivate", "Lorg/springframework/http/CacheControl;", "getCachePrivate", "()Lorg/springframework/http/CacheControl;", "filePathToUrl", "Ljava/net/URL;", "filePath", "", "getCurrentRequest", "Ljakarta/servlet/http/HttpServletRequest;", "getMediaTypeOrDefault", "Lorg/springframework/http/MediaType;", "mediaTypeString", "setCachePrivate", "Lorg/springframework/http/ResponseEntity$BodyBuilder;", "toFilePath", "komga"})
public final class UtilsKt {
    @NotNull
    private static final CacheControl cachePrivate;

    @NotNull
    public static final String toFilePath(@NotNull URL $this$toFilePath) {
        Intrinsics.checkNotNullParameter((Object)$this$toFilePath, (String)"<this>");
        URI uRI = $this$toFilePath.toURI();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toURI(...)");
        Path path2 = Paths.get(uRI);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        return ((Object)path2).toString();
    }

    @NotNull
    public static final URL filePathToUrl(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        URL uRL = Paths.get(filePath, new String[0]).toUri().toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
        return uRL;
    }

    @NotNull
    public static final ResponseEntity.BodyBuilder setCachePrivate(@NotNull ResponseEntity.BodyBuilder $this$setCachePrivate) {
        Intrinsics.checkNotNullParameter((Object)$this$setCachePrivate, (String)"<this>");
        ResponseEntity.HeadersBuilder headersBuilder = $this$setCachePrivate.cacheControl(cachePrivate);
        Intrinsics.checkNotNullExpressionValue((Object)headersBuilder, (String)"cacheControl(...)");
        return (ResponseEntity.BodyBuilder)headersBuilder;
    }

    @NotNull
    public static final CacheControl getCachePrivate() {
        return cachePrivate;
    }

    @NotNull
    public static final MediaType getMediaTypeOrDefault(@Nullable String mediaTypeString) {
        String string = mediaTypeString;
        if (string != null) {
            String it = string;
            boolean bl = false;
            try {
                MediaType mediaType2 = MediaType.parseMediaType((String)mediaTypeString);
                Intrinsics.checkNotNullExpressionValue((Object)mediaType2, (String)"parseMediaType(...)");
                return mediaType2;
            }
            catch (Exception exception) {
            }
        }
        MediaType mediaType3 = MediaType.APPLICATION_OCTET_STREAM;
        Intrinsics.checkNotNullExpressionValue((Object)mediaType3, (String)"APPLICATION_OCTET_STREAM");
        return mediaType3;
    }

    @NotNull
    public static final HttpServletRequest getCurrentRequest() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        Object object = servletRequestAttributes != null ? servletRequestAttributes.getRequest() : null;
        if (object == null) {
            throw new IllegalStateException("Could not get current request");
        }
        return object;
    }

    static {
        CacheControl cacheControl = CacheControl.maxAge((long)0L, (TimeUnit)TimeUnit.SECONDS).noTransform().cachePrivate().mustRevalidate();
        Intrinsics.checkNotNullExpressionValue((Object)cacheControl, (String)"mustRevalidate(...)");
        cachePrivate = cacheControl;
    }
}

