/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.api;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.gotson.komga.domain.model.Book;
import org.gotson.komga.domain.model.KomgaUser;
import org.gotson.komga.domain.model.SeriesMetadata;
import org.gotson.komga.domain.persistence.BookRepository;
import org.gotson.komga.domain.persistence.SeriesMetadataRepository;
import org.gotson.komga.interfaces.api.rest.dto.BookDto;
import org.gotson.komga.interfaces.api.rest.dto.SeriesDto;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ResponseStatusException;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000fH\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/gotson/komga/interfaces/api/ContentRestrictionChecker;", "", "seriesMetadataRepository", "Lorg/gotson/komga/domain/persistence/SeriesMetadataRepository;", "bookRepository", "Lorg/gotson/komga/domain/persistence/BookRepository;", "(Lorg/gotson/komga/domain/persistence/SeriesMetadataRepository;Lorg/gotson/komga/domain/persistence/BookRepository;)V", "checkContentRestriction", "", "komgaUser", "Lorg/gotson/komga/domain/model/KomgaUser;", "bookId", "", "book", "Lorg/gotson/komga/domain/model/Book;", "Lorg/gotson/komga/interfaces/api/rest/dto/BookDto;", "series", "Lorg/gotson/komga/interfaces/api/rest/dto/SeriesDto;", "komga"})
public class ContentRestrictionChecker {
    @NotNull
    private final SeriesMetadataRepository seriesMetadataRepository;
    @NotNull
    private final BookRepository bookRepository;

    public ContentRestrictionChecker(@NotNull SeriesMetadataRepository seriesMetadataRepository, @NotNull BookRepository bookRepository) {
        Intrinsics.checkNotNullParameter((Object)seriesMetadataRepository, (String)"seriesMetadataRepository");
        Intrinsics.checkNotNullParameter((Object)bookRepository, (String)"bookRepository");
        this.seriesMetadataRepository = seriesMetadataRepository;
        this.bookRepository = bookRepository;
    }

    public void checkContentRestriction(@NotNull KomgaUser komgaUser, @NotNull BookDto book) {
        Intrinsics.checkNotNullParameter((Object)komgaUser, (String)"komgaUser");
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        if (!komgaUser.canAccessLibrary(book.getLibraryId())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        if (komgaUser.getRestrictions().isRestricted()) {
            SeriesMetadata it = this.seriesMetadataRepository.findById(book.getSeriesId());
            boolean bl = false;
            if (!komgaUser.isContentAllowed(it.getAgeRating(), it.getSharingLabels())) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
            }
        }
    }

    public void checkContentRestriction(@NotNull KomgaUser komgaUser, @NotNull Book book) {
        Intrinsics.checkNotNullParameter((Object)komgaUser, (String)"komgaUser");
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        if (!komgaUser.canAccessLibrary(book.getLibraryId())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        if (komgaUser.getRestrictions().isRestricted()) {
            SeriesMetadata it = this.seriesMetadataRepository.findById(book.getSeriesId());
            boolean bl = false;
            if (!komgaUser.isContentAllowed(it.getAgeRating(), it.getSharingLabels())) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
            }
        }
    }

    public void checkContentRestriction(@NotNull KomgaUser komgaUser, @NotNull String bookId) {
        Intrinsics.checkNotNullParameter((Object)komgaUser, (String)"komgaUser");
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        if (!komgaUser.canAccessAllLibraries()) {
            Unit unit;
            String string = this.bookRepository.getLibraryIdOrNull(bookId);
            if (string != null) {
                String it = string;
                boolean bl = false;
                if (!komgaUser.canAccessLibrary(it)) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
            }
        }
        if (komgaUser.getRestrictions().isRestricted()) {
            Unit unit;
            String string = this.bookRepository.getSeriesIdOrNull(bookId);
            if (string != null) {
                String seriesId = string;
                boolean bl = false;
                SeriesMetadata it = this.seriesMetadataRepository.findById(seriesId);
                boolean bl2 = false;
                if (!komgaUser.isContentAllowed(it.getAgeRating(), it.getSharingLabels())) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
            }
        }
    }

    public void checkContentRestriction(@NotNull KomgaUser komgaUser, @NotNull SeriesDto series) {
        Intrinsics.checkNotNullParameter((Object)komgaUser, (String)"komgaUser");
        Intrinsics.checkNotNullParameter((Object)series, (String)"series");
        if (!komgaUser.canAccessLibrary(series.getLibraryId())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        if (!komgaUser.isContentAllowed(series.getMetadata().getAgeRating(), series.getMetadata().getSharingLabels())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
    }
}

