/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.api.kosync;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.gotson.komga.domain.model.Book;
import org.gotson.komga.domain.model.Media;
import org.gotson.komga.domain.model.MediaExtensionEpub;
import org.gotson.komga.domain.model.MediaProfile;
import org.gotson.komga.domain.model.R2Device;
import org.gotson.komga.domain.model.R2Locator;
import org.gotson.komga.domain.model.R2Progression;
import org.gotson.komga.domain.model.ReadProgress;
import org.gotson.komga.domain.persistence.BookRepository;
import org.gotson.komga.domain.persistence.MediaRepository;
import org.gotson.komga.domain.persistence.ReadProgressRepository;
import org.gotson.komga.domain.service.BookLifecycle;
import org.gotson.komga.infrastructure.security.KomgaPrincipal;
import org.gotson.komga.interfaces.api.kosync.KoreaderSyncController;
import org.gotson.komga.interfaces.api.kosync.dto.DocumentProgressDto;
import org.gotson.komga.interfaces.api.kosync.dto.UserAuthenticationDto;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/koreader"}, produces={"application/vnd.koreader.v1+json"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000e\u001a\u00020\u000fH\u0017J\u001c\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0017J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0017H\u0017J\u001c\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u001a\u001a\u00020\u0011H\u0017R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/gotson/komga/interfaces/api/kosync/KoreaderSyncController;", "", "bookRepository", "Lorg/gotson/komga/domain/persistence/BookRepository;", "mediaRepository", "Lorg/gotson/komga/domain/persistence/MediaRepository;", "readProgressRepository", "Lorg/gotson/komga/domain/persistence/ReadProgressRepository;", "bookLifecycle", "Lorg/gotson/komga/domain/service/BookLifecycle;", "(Lorg/gotson/komga/domain/persistence/BookRepository;Lorg/gotson/komga/domain/persistence/MediaRepository;Lorg/gotson/komga/domain/persistence/ReadProgressRepository;Lorg/gotson/komga/domain/service/BookLifecycle;)V", "resourceRegex1", "Lkotlin/text/Regex;", "resourceRegex2", "authorize", "Lorg/gotson/komga/interfaces/api/kosync/dto/UserAuthenticationDto;", "getProgress", "Lorg/gotson/komga/interfaces/api/kosync/dto/DocumentProgressDto;", "principal", "Lorg/gotson/komga/infrastructure/security/KomgaPrincipal;", "bookHash", "", "registerUser", "Lorg/springframework/http/ResponseEntity;", "updateProgress", "", "koreaderProgress", "komga"})
@SourceDebugExtension(value={"SMAP\nKoreaderSyncController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KoreaderSyncController.kt\norg/gotson/komga/interfaces/api/kosync/KoreaderSyncController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,184:1\n1477#2:185\n1502#2,3:186\n1505#2,3:196\n1477#2:199\n1502#2,3:200\n1505#2,3:210\n372#3,7:189\n372#3,7:203\n*S KotlinDebug\n*F\n+ 1 KoreaderSyncController.kt\norg/gotson/komga/interfaces/api/kosync/KoreaderSyncController\n*L\n80#1:185\n80#1:186,3\n80#1:196,3\n151#1:199\n151#1:200,3\n151#1:210,3\n80#1:189,7\n151#1:203,7\n*E\n"})
public class KoreaderSyncController {
    @NotNull
    private final BookRepository bookRepository;
    @NotNull
    private final MediaRepository mediaRepository;
    @NotNull
    private final ReadProgressRepository readProgressRepository;
    @NotNull
    private final BookLifecycle bookLifecycle;
    @NotNull
    private final Regex resourceRegex1;
    @NotNull
    private final Regex resourceRegex2;

    public KoreaderSyncController(@NotNull BookRepository bookRepository, @NotNull MediaRepository mediaRepository, @NotNull ReadProgressRepository readProgressRepository, @NotNull BookLifecycle bookLifecycle) {
        Intrinsics.checkNotNullParameter((Object)bookRepository, (String)"bookRepository");
        Intrinsics.checkNotNullParameter((Object)mediaRepository, (String)"mediaRepository");
        Intrinsics.checkNotNullParameter((Object)readProgressRepository, (String)"readProgressRepository");
        Intrinsics.checkNotNullParameter((Object)bookLifecycle, (String)"bookLifecycle");
        this.bookRepository = bookRepository;
        this.mediaRepository = mediaRepository;
        this.readProgressRepository = readProgressRepository;
        this.bookLifecycle = bookLifecycle;
        this.resourceRegex1 = new Regex("DocFragment\\[(\\d+)]", RegexOption.IGNORE_CASE);
        this.resourceRegex2 = new Regex("#_doc_fragment_(\\d+)_", RegexOption.IGNORE_CASE);
    }

    @PostMapping(value={"users/create"})
    @NotNull
    public ResponseEntity<String> registerUser() {
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, "User creation is disabled");
    }

    @GetMapping(value={"users/auth"})
    @NotNull
    public UserAuthenticationDto authorize() {
        return new UserAuthenticationDto(null, 1, null);
    }

    @GetMapping(value={"syncs/progress/{bookHash}"})
    @NotNull
    public DocumentProgressDto getProgress(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String bookHash) {
        Float f;
        R2Locator.Location location;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)bookHash, (String)"bookHash");
        Collection books = this.bookRepository.findAllByHashKoreader(bookHash);
        if (books.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Book not found");
        }
        if (books.size() > 1) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, "More than 1 book found with the same hash");
        }
        Book book = (Book)CollectionsKt.first((Iterable)books);
        Media media = this.mediaRepository.findById(book.getId());
        ReadProgress readProgress = this.readProgressRepository.findByBookIdAndUserIdOrNull(book.getId(), principal.getUser().getId());
        if (readProgress == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.OK, "No progress found for this book");
        }
        ReadProgress readProgress2 = readProgress;
        R2Locator r2Locator = readProgress2.getLocator();
        float progressPercentage = r2Locator != null && (location = r2Locator.getLocations()) != null && (f = location.getTotalProgression()) != null ? f.floatValue() : (float)readProgress2.getPage() / (float)this.mediaRepository.findById(book.getId()).getPageCount();
        MediaProfile mediaProfile2 = media.getProfile();
        String progress = switch (mediaProfile2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[mediaProfile2.ordinal()]) {
            case 1, 2 -> String.valueOf(readProgress2.getPage());
            case 3 -> {
                void $this$groupByTo$iv$iv;
                void $this$groupBy$iv;
                Object var13_11 = this.mediaRepository.findExtensionByIdOrNull(book.getId());
                MediaExtensionEpub v3 = var13_11 instanceof MediaExtensionEpub ? (MediaExtensionEpub)var13_11 : null;
                if (v3 == null) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Epub extension not found");
                }
                MediaExtensionEpub extension = v3;
                var13_11 = extension.getPositions();
                boolean $i$f$groupBy = false;
                void var15_14 = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                    Object v4;
                    R2Locator it = (R2Locator)element$iv$iv;
                    boolean $i$a$-groupBy-KoreaderSyncController$getProgress$progress$resourceIndex$1 = false;
                    String key$iv$iv = it.getHref();
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean $i$a$-getOrPut-CollectionsKt___CollectionsKt$groupByTo$list$1$iv$iv = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        v4 = answer$iv$iv$iv;
                    } else {
                        v4 = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)v4;
                    list$iv$iv.add(element$iv$iv);
                }
                R2Locator v5 = readProgress2.getLocator();
                int resourceIndex = CollectionsKt.indexOf((Iterable)destination$iv$iv.keySet(), (Object)(v5 != null ? v5.getHref() : null));
                yield "/body/DocFragment[" + (resourceIndex + 1) + "].0";
            }
            case -1 -> throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Book has no media profile");
            default -> throw new NoWhenBranchMatchedException();
        };
        return new DocumentProgressDto(bookHash, progressPercentage, progress, readProgress2.getDeviceName(), readProgress2.getDeviceId());
    }

    @PutMapping(value={"syncs/progress"})
    public void updateProgress(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestBody @NotNull DocumentProgressDto koreaderProgress) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)koreaderProgress, (String)"koreaderProgress");
        Collection books = this.bookRepository.findAllByHashKoreader(koreaderProgress.getDocument());
        if (books.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Book not found");
        }
        if (books.size() > 1) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, "More than 1 book found with the same hash");
        }
        Book book = (Book)CollectionsKt.first((Iterable)books);
        Media media = this.mediaRepository.findById(book.getId());
        MediaProfile mediaProfile2 = media.getProfile();
        R2Locator locator = switch (mediaProfile2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[mediaProfile2.ordinal()]) {
            case 1, 2 -> new R2Locator("", "", null, new R2Locator.Location(null, null, Integer.valueOf(Integer.parseInt(koreaderProgress.getProgress())), Float.valueOf(koreaderProgress.getPercentage()), 3, null), null, null, 52, null);
            case 3 -> {
                void $this$groupByTo$iv$iv;
                void $this$groupBy$iv;
                int v2;
                Integer var14_11;
                String var13_9;
                Object var12_8;
                MatchGroupCollection var11_7;
                MatchResult var10_6 = Regex.find$default((Regex)this.resourceRegex1, (CharSequence)koreaderProgress.getProgress(), (int)0, (int)2, null);
                if (var10_6 != null && (var11_7 = var10_6.getGroups()) != null && (var12_8 = var11_7.get(1)) != null && (var13_9 = var12_8.getValue()) != null && (var14_11 = StringsKt.toIntOrNull((String)var13_9)) != null) {
                    v2 = var14_11 - 1;
                } else {
                    String var20_15;
                    MatchGroup var19_14;
                    MatchGroupCollection var18_13;
                    MatchResult var17_12 = Regex.find$default((Regex)this.resourceRegex2, (CharSequence)koreaderProgress.getProgress(), (int)0, (int)2, null);
                    Integer v3 = var17_12 != null && (var18_13 = var17_12.getGroups()) != null && (var19_14 = var18_13.get(1)) != null && (var20_15 = var19_14.getValue()) != null ? StringsKt.toIntOrNull((String)var20_15) : null;
                    if (v3 != null) {
                        v2 = v3;
                    } else {
                        throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Could not get Epub resource index from progress: " + koreaderProgress.getProgress());
                    }
                }
                int resourceIndex = v2;
                var12_8 = this.mediaRepository.findExtensionByIdOrNull(book.getId());
                MediaExtensionEpub v4 = var12_8 instanceof MediaExtensionEpub ? (MediaExtensionEpub)var12_8 : null;
                if (v4 == null) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Epub extension not found");
                }
                MediaExtensionEpub extension = v4;
                var12_8 = extension.getPositions();
                boolean $i$f$groupBy = false;
                var14_11 = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                    Object v5;
                    R2Locator it = (R2Locator)element$iv$iv;
                    boolean $i$a$-groupBy-KoreaderSyncController$updateProgress$locator$href$1 = false;
                    String key$iv$iv = it.getHref();
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean $i$a$-getOrPut-CollectionsKt___CollectionsKt$groupByTo$list$1$iv$iv = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        v5 = answer$iv$iv$iv;
                    } else {
                        v5 = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)v5;
                    list$iv$iv.add(element$iv$iv);
                }
                String href = (String)CollectionsKt.elementAt((Iterable)destination$iv$iv.keySet(), (int)resourceIndex);
                yield new R2Locator(href, "application/xhtml+xml", null, new R2Locator.Location(null, Float.valueOf(0.0f), null, Float.valueOf(koreaderProgress.getPercentage()), 5, null), null, null, 52, null);
            }
            case -1 -> throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Book has no media profile");
            default -> throw new NoWhenBranchMatchedException();
        };
        R2Device r2Device = new R2Device(koreaderProgress.getDeviceId(), koreaderProgress.getDevice());
        ZonedDateTime zonedDateTime = ZonedDateTime.now();
        Intrinsics.checkNotNull((Object)zonedDateTime);
        R2Progression r2Progression = new R2Progression(zonedDateTime, r2Device, locator);
        this.bookLifecycle.markProgression(book, principal.getUser(), r2Progression);
    }
}

