/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.api.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Pattern;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.infrastructure.jooq.main.ClientSettingsDtoDao;
import org.gotson.komga.infrastructure.security.KomgaPrincipal;
import org.gotson.komga.interfaces.api.rest.dto.ClientSettingDto;
import org.gotson.komga.interfaces.api.rest.dto.ClientSettingGlobalUpdateDto;
import org.gotson.komga.interfaces.api.rest.dto.ClientSettingUserUpdateDto;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/v1/client-settings"}, produces={"application/json"})
@Tag(name="Client settings")
@Validated
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J'\u0010\u0005\u001a\u00020\u00062\u001d\b\u0001\u0010\u0007\u001a\u0017\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f0\bH\u0017J1\u0010\r\u001a\u00020\u00062\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\u001d\b\u0001\u0010\u0007\u001a\u0017\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f0\bH\u0017J \u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00120\u00112\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0017J\u001e\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00120\u00112\b\b\u0001\u0010\u000e\u001a\u00020\u000fH\u0017J7\u0010\u0014\u001a\u00020\u00062-\b\u0001\u0010\u0015\u001a'\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u000e\u0012\f0\u0016\u00a2\u0006\u0002\b\u0017\u00a2\u0006\u0002\b\u00180\u0011H\u0017JA\u0010\u0019\u001a\u00020\u00062\b\b\u0001\u0010\u000e\u001a\u00020\u000f2-\b\u0001\u0010\u0015\u001a'\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u000e\u0012\f0\u001a\u00a2\u0006\u0002\b\u0017\u00a2\u0006\u0002\b\u00180\u0011H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/gotson/komga/interfaces/api/rest/ClientSettingsController;", "", "clientSettingsDtoDao", "Lorg/gotson/komga/infrastructure/jooq/main/ClientSettingsDtoDao;", "(Lorg/gotson/komga/infrastructure/jooq/main/ClientSettingsDtoDao;)V", "deleteGlobalSettings", "", "keysToDelete", "", "", "Ljakarta/validation/constraints/Pattern;", "regexp", "^[a-z](?:[a-z0-9_-]*[a-z0-9])*(?:\\.[a-z0-9](?:[a-z0-9_-]*[a-z0-9])*)*$", "deleteUserSettings", "principal", "Lorg/gotson/komga/infrastructure/security/KomgaPrincipal;", "getGlobalSettings", "", "Lorg/gotson/komga/interfaces/api/rest/dto/ClientSettingDto;", "getUserSettings", "saveGlobalSetting", "newSettings", "Lorg/gotson/komga/interfaces/api/rest/dto/ClientSettingGlobalUpdateDto;", "Ljakarta/validation/constraints/NotNull;", "Ljakarta/validation/Valid;", "saveUserSetting", "Lorg/gotson/komga/interfaces/api/rest/dto/ClientSettingUserUpdateDto;", "komga"})
@SourceDebugExtension(value={"SMAP\nClientSettingsController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientSettingsController.kt\norg/gotson/komga/interfaces/api/rest/ClientSettingsController\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,177:1\n215#2,2:178\n215#2,2:180\n*S KotlinDebug\n*F\n+ 1 ClientSettingsController.kt\norg/gotson/komga/interfaces/api/rest/ClientSettingsController\n*L\n88#1:178,2\n126#1:180,2\n*E\n"})
public class ClientSettingsController {
    @NotNull
    private final ClientSettingsDtoDao clientSettingsDtoDao;

    public ClientSettingsController(@NotNull ClientSettingsDtoDao clientSettingsDtoDao) {
        Intrinsics.checkNotNullParameter((Object)clientSettingsDtoDao, (String)"clientSettingsDtoDao");
        this.clientSettingsDtoDao = clientSettingsDtoDao;
    }

    @GetMapping(value={"global/list"})
    @Operation(summary="Retrieve global client settings", description="For unauthenticated users, only settings with 'allowUnauthorized=true' will be returned.")
    @SecurityRequirements
    @NotNull
    public Map<String, ClientSettingDto> getGlobalSettings(@AuthenticationPrincipal @Nullable KomgaPrincipal principal) {
        return this.clientSettingsDtoDao.findAllGlobal(principal == null);
    }

    @GetMapping(value={"user/list"})
    @Operation(summary="Retrieve user client settings")
    @NotNull
    public Map<String, ClientSettingDto> getUserSettings(@AuthenticationPrincipal @NotNull KomgaPrincipal principal) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        return this.clientSettingsDtoDao.findAllUser(principal.getUser().getId());
    }

    @PatchMapping(value={"global"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="Save global settings", description="Setting key should be a valid lowercase namespace string like 'application.domain.key'")
    @io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(examples={@ExampleObject(value="{\n              \"application.key1\": {\n                \"value\": \"a string value\",\n                \"allowUnauthorized\": true\n              },\n              \"application.key2\": {\n                \"value\": \"{\\\"json\\\":\\\"object\\\"}\",\n                \"allowUnauthorized\": false\n              }\n            }\n            ")})})
    public void saveGlobalSetting(@RequestBody @NotNull Map<@Pattern(regexp="^[a-z](?:[a-z0-9_-]*[a-z0-9])*(?:\\.[a-z0-9](?:[a-z0-9_-]*[a-z0-9])*)*$") String, @jakarta.validation.constraints.NotNull @Valid ClientSettingGlobalUpdateDto> newSettings) {
        Intrinsics.checkNotNullParameter(newSettings, (String)"newSettings");
        Map<String, ClientSettingGlobalUpdateDto> $this$forEach$iv = newSettings;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ClientSettingGlobalUpdateDto>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ClientSettingGlobalUpdateDto> element$iv;
            Map.Entry<String, ClientSettingGlobalUpdateDto> entry = element$iv = iterator.next();
            boolean bl = false;
            String key2 = entry.getKey();
            ClientSettingGlobalUpdateDto setting = entry.getValue();
            this.clientSettingsDtoDao.saveGlobal(key2, setting.getValue(), setting.getAllowUnauthorized());
        }
    }

    @PatchMapping(value={"user"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Save user settings", description="Setting key should be a valid lowercase namespace string like 'application.domain.key'")
    @io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(examples={@ExampleObject(value="{\n              \"application.key1\": {\n                \"value\": \"a string value\"\n              },\n              \"application.key2\": {\n                \"value\": \"{\\\"json\\\":\\\"object\\\"}\"\n              }\n            }\n            ")})})
    public void saveUserSetting(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestBody @NotNull Map<@Pattern(regexp="^[a-z](?:[a-z0-9_-]*[a-z0-9])*(?:\\.[a-z0-9](?:[a-z0-9_-]*[a-z0-9])*)*$") String, @jakarta.validation.constraints.NotNull @Valid ClientSettingUserUpdateDto> newSettings) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter(newSettings, (String)"newSettings");
        Map<String, ClientSettingUserUpdateDto> $this$forEach$iv = newSettings;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ClientSettingUserUpdateDto>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ClientSettingUserUpdateDto> element$iv;
            Map.Entry<String, ClientSettingUserUpdateDto> entry = element$iv = iterator.next();
            boolean bl = false;
            String key2 = entry.getKey();
            ClientSettingUserUpdateDto setting = entry.getValue();
            this.clientSettingsDtoDao.saveForUser(principal.getUser().getId(), key2, setting.getValue());
        }
    }

    @DeleteMapping(value={"global"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="Delete global settings", description="Setting key should be a valid lowercase namespace string like 'application.domain.key'")
    @io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(examples={@ExampleObject(value="[\"application.key1\", \"application.key2\"]")})})
    public void deleteGlobalSettings(@RequestBody @NotNull Set<@Pattern(regexp="^[a-z](?:[a-z0-9_-]*[a-z0-9])*(?:\\.[a-z0-9](?:[a-z0-9_-]*[a-z0-9])*)*$") String> keysToDelete) {
        Intrinsics.checkNotNullParameter(keysToDelete, (String)"keysToDelete");
        this.clientSettingsDtoDao.deleteGlobalByKeys((Collection)keysToDelete);
    }

    @DeleteMapping(value={"user"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Delete user settings", description="Setting key should be a valid lowercase namespace string like 'application.domain.key'")
    @io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(examples={@ExampleObject(value="[\"application.key1\", \"application.key2\"]")})})
    public void deleteUserSettings(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestBody @NotNull Set<@Pattern(regexp="^[a-z](?:[a-z0-9_-]*[a-z0-9])*(?:\\.[a-z0-9](?:[a-z0-9_-]*[a-z0-9])*)*$") String> keysToDelete) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter(keysToDelete, (String)"keysToDelete");
        this.clientSettingsDtoDao.deleteByUserIdAndKeys(principal.getUser().getId(), (Collection)keysToDelete);
    }
}

