/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.api.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.validation.Valid;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gotson.komga.domain.model.Author;
import org.gotson.komga.domain.model.Dimension;
import org.gotson.komga.domain.model.DomainEvent;
import org.gotson.komga.domain.model.DuplicateNameException;
import org.gotson.komga.domain.model.ReadStatus;
import org.gotson.komga.domain.model.SearchCondition;
import org.gotson.komga.domain.model.SearchContext;
import org.gotson.komga.domain.model.SearchOperator;
import org.gotson.komga.domain.model.SeriesCollection;
import org.gotson.komga.domain.model.SeriesMetadata;
import org.gotson.komga.domain.model.SeriesSearch;
import org.gotson.komga.domain.model.ThumbnailSeriesCollection;
import org.gotson.komga.domain.persistence.SeriesCollectionRepository;
import org.gotson.komga.domain.persistence.ThumbnailSeriesCollectionRepository;
import org.gotson.komga.domain.service.SeriesCollectionLifecycle;
import org.gotson.komga.infrastructure.image.ImageAnalyzer;
import org.gotson.komga.infrastructure.jooq.UnpagedSorted;
import org.gotson.komga.infrastructure.mediacontainer.ContentDetector;
import org.gotson.komga.infrastructure.openapi.AuthorsAsQueryParam;
import org.gotson.komga.infrastructure.openapi.PageableWithoutSortAsQueryParam;
import org.gotson.komga.infrastructure.security.KomgaPrincipal;
import org.gotson.komga.infrastructure.web.Authors;
import org.gotson.komga.interfaces.api.persistence.SeriesDtoRepository;
import org.gotson.komga.interfaces.api.rest.SeriesCollectionController;
import org.gotson.komga.interfaces.api.rest.dto.CollectionCreationDto;
import org.gotson.komga.interfaces.api.rest.dto.CollectionDto;
import org.gotson.komga.interfaces.api.rest.dto.CollectionDtoKt;
import org.gotson.komga.interfaces.api.rest.dto.CollectionUpdateDto;
import org.gotson.komga.interfaces.api.rest.dto.SeriesDto;
import org.gotson.komga.interfaces.api.rest.dto.ThumbnailSeriesCollectionDto;
import org.gotson.komga.interfaces.api.rest.dto.ThumbnailSeriesCollectionDtoKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"api/v1/collections"}, produces={"application/json"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J0\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0003\u0010\u0019\u001a\u00020\u001aH\u0017J\u0012\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010\u001d\u001a\u00020\u001eH\u0017J\u0012\u0010\u001f\u001a\u00020 2\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0017J&\u0010!\u001a\u00020 2\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\"\u001a\u00020\u0016H\u0017J\u001c\u0010#\u001a\u00020\u001c2\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0017J\"\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0017J&\u0010'\u001a\u00020&2\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\"\u001a\u00020\u0016H\u0017J\"\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00120)2\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0017JJ\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001c0+2\b\b\u0001\u0010\u0013\u001a\u00020\u00142\n\b\u0001\u0010,\u001a\u0004\u0018\u00010\u00162\u0010\b\u0001\u0010-\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010.2\b\b\u0003\u0010/\u001a\u00020\u001a2\b\b\u0001\u00100\u001a\u000201H\u0017J\u0087\u0002\u00102\u001a\b\u0012\u0004\u0012\u0002030+2\b\b\u0001\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\u0013\u001a\u00020\u00142\u0010\b\u0001\u0010-\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010.2\u0010\b\u0001\u00104\u001a\n\u0012\u0004\u0012\u000205\u0018\u00010.2\u0010\b\u0001\u00106\u001a\n\u0012\u0004\u0012\u000207\u0018\u00010.2\u0010\b\u0001\u00108\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010.2\u0010\b\u0001\u00109\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010.2\u0010\b\u0001\u0010:\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010.2\u0010\b\u0001\u0010;\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010.2\u0010\b\u0001\u0010<\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010.2\u0010\b\u0001\u0010=\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010.2\n\b\u0001\u0010>\u001a\u0004\u0018\u00010\u001a2\n\b\u0001\u0010?\u001a\u0004\u0018\u00010\u001a2\b\b\u0003\u0010/\u001a\u00020\u001a2\u0010\b\u0001\u0010@\u001a\n\u0012\u0004\u0012\u00020A\u0018\u00010.2\b\b\u0001\u00100\u001a\u000201H\u0017\u00a2\u0006\u0002\u0010BJ&\u0010C\u001a\u00020 2\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\"\u001a\u00020\u0016H\u0017J\u001c\u0010D\u001a\u00020 2\b\b\u0001\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\u001d\u001a\u00020EH\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lorg/gotson/komga/interfaces/api/rest/SeriesCollectionController;", "", "collectionRepository", "Lorg/gotson/komga/domain/persistence/SeriesCollectionRepository;", "collectionLifecycle", "Lorg/gotson/komga/domain/service/SeriesCollectionLifecycle;", "seriesDtoRepository", "Lorg/gotson/komga/interfaces/api/persistence/SeriesDtoRepository;", "contentDetector", "Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;", "imageAnalyzer", "Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;", "thumbnailSeriesCollectionRepository", "Lorg/gotson/komga/domain/persistence/ThumbnailSeriesCollectionRepository;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "(Lorg/gotson/komga/domain/persistence/SeriesCollectionRepository;Lorg/gotson/komga/domain/service/SeriesCollectionLifecycle;Lorg/gotson/komga/interfaces/api/persistence/SeriesDtoRepository;Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;Lorg/gotson/komga/domain/persistence/ThumbnailSeriesCollectionRepository;Lorg/springframework/context/ApplicationEventPublisher;)V", "addUserUploadedCollectionThumbnail", "Lorg/gotson/komga/interfaces/api/rest/dto/ThumbnailSeriesCollectionDto;", "principal", "Lorg/gotson/komga/infrastructure/security/KomgaPrincipal;", "id", "", "file", "Lorg/springframework/web/multipart/MultipartFile;", "selected", "", "createCollection", "Lorg/gotson/komga/interfaces/api/rest/dto/CollectionDto;", "collection", "Lorg/gotson/komga/interfaces/api/rest/dto/CollectionCreationDto;", "deleteCollectionById", "", "deleteUserUploadedCollectionThumbnail", "thumbnailId", "getCollectionById", "getCollectionThumbnail", "Lorg/springframework/http/ResponseEntity;", "", "getCollectionThumbnailById", "getCollectionThumbnails", "", "getCollections", "Lorg/springframework/data/domain/Page;", "searchTerm", "libraryIds", "", "unpaged", "page", "Lorg/springframework/data/domain/Pageable;", "getSeriesByCollectionId", "Lorg/gotson/komga/interfaces/api/rest/dto/SeriesDto;", "metadataStatus", "Lorg/gotson/komga/domain/model/SeriesMetadata$Status;", "readStatus", "Lorg/gotson/komga/domain/model/ReadStatus;", "publishers", "languages", "genres", "tags", "ageRatings", "releaseYears", "deleted", "complete", "authors", "Lorg/gotson/komga/domain/model/Author;", "(Ljava/lang/String;Lorg/gotson/komga/infrastructure/security/KomgaPrincipal;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/lang/Boolean;Ljava/lang/Boolean;ZLjava/util/List;Lorg/springframework/data/domain/Pageable;)Lorg/springframework/data/domain/Page;", "markCollectionThumbnailSelected", "updateCollectionById", "Lorg/gotson/komga/interfaces/api/rest/dto/CollectionUpdateDto;", "komga"})
@SourceDebugExtension(value={"SMAP\nSeriesCollectionController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeriesCollectionController.kt\norg/gotson/komga/interfaces/api/rest/SeriesCollectionController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,358:1\n1549#2:359\n1620#2,3:360\n1549#2:364\n1620#2,3:365\n1549#2:368\n1620#2,3:369\n1549#2:372\n1620#2,3:373\n1549#2:376\n1620#2,3:377\n1549#2:380\n1620#2,3:381\n1549#2:384\n1620#2,3:385\n1549#2:388\n1620#2,3:389\n1603#2,9:392\n1855#2:401\n1856#2:403\n1612#2:404\n1549#2:405\n1620#2,3:406\n1549#2:409\n1620#2,3:410\n1549#2:413\n1620#2,3:414\n1#3:363\n1#3:402\n*S KotlinDebug\n*F\n+ 1 SeriesCollectionController.kt\norg/gotson/komga/interfaces/api/rest/SeriesCollectionController\n*L\n160#1:359\n160#1:360,3\n327#1:364\n327#1:365,3\n330#1:368\n330#1:369,3\n331#1:372\n331#1:373,3\n332#1:376\n332#1:377,3\n333#1:380\n333#1:381,3\n334#1:384\n334#1:385,3\n335#1:388\n335#1:389,3\n339#1:392,9\n339#1:401\n339#1:403\n339#1:404\n339#1:405\n339#1:406,3\n347#1:409\n347#1:410,3\n348#1:413\n348#1:414,3\n339#1:402\n*E\n"})
public class SeriesCollectionController {
    @NotNull
    private final SeriesCollectionRepository collectionRepository;
    @NotNull
    private final SeriesCollectionLifecycle collectionLifecycle;
    @NotNull
    private final SeriesDtoRepository seriesDtoRepository;
    @NotNull
    private final ContentDetector contentDetector;
    @NotNull
    private final ImageAnalyzer imageAnalyzer;
    @NotNull
    private final ThumbnailSeriesCollectionRepository thumbnailSeriesCollectionRepository;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;

    public SeriesCollectionController(@NotNull SeriesCollectionRepository collectionRepository, @NotNull SeriesCollectionLifecycle collectionLifecycle, @NotNull SeriesDtoRepository seriesDtoRepository, @NotNull ContentDetector contentDetector, @NotNull ImageAnalyzer imageAnalyzer, @NotNull ThumbnailSeriesCollectionRepository thumbnailSeriesCollectionRepository, @NotNull ApplicationEventPublisher eventPublisher) {
        Intrinsics.checkNotNullParameter((Object)collectionRepository, (String)"collectionRepository");
        Intrinsics.checkNotNullParameter((Object)collectionLifecycle, (String)"collectionLifecycle");
        Intrinsics.checkNotNullParameter((Object)seriesDtoRepository, (String)"seriesDtoRepository");
        Intrinsics.checkNotNullParameter((Object)contentDetector, (String)"contentDetector");
        Intrinsics.checkNotNullParameter((Object)imageAnalyzer, (String)"imageAnalyzer");
        Intrinsics.checkNotNullParameter((Object)thumbnailSeriesCollectionRepository, (String)"thumbnailSeriesCollectionRepository");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        this.collectionRepository = collectionRepository;
        this.collectionLifecycle = collectionLifecycle;
        this.seriesDtoRepository = seriesDtoRepository;
        this.contentDetector = contentDetector;
        this.imageAnalyzer = imageAnalyzer;
        this.thumbnailSeriesCollectionRepository = thumbnailSeriesCollectionRepository;
        this.eventPublisher = eventPublisher;
    }

    @Operation(tags={"Collections"}, summary="List collections")
    @PageableWithoutSortAsQueryParam
    @GetMapping
    @NotNull
    public Page<CollectionDto> getCollections(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="search", required=false) @Nullable String searchTerm, @RequestParam(name="library_id", required=false) @Nullable List<String> libraryIds, @RequestParam(name="unpaged", required=false) boolean unpaged, @Parameter(hidden=true) @NotNull Pageable page) {
        Pageable pageable;
        Sort sort;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        String[] stringArray = (String[])searchTerm;
        if (!(stringArray == null || StringsKt.isBlank((CharSequence)stringArray))) {
            stringArray = new String[]{"relevance"};
            sort = Sort.by((String[])stringArray);
        } else {
            stringArray = new Sort.Order[]{Sort.Order.asc((String)"name")};
            sort = Sort.by((Sort.Order[])stringArray);
        }
        Sort sort2 = sort;
        Intrinsics.checkNotNull((Object)sort2);
        Sort sort3 = sort2;
        if (unpaged) {
            pageable = (Pageable)new UnpagedSorted(sort3);
        } else {
            PageRequest pageRequest = PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)sort3);
            Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
            pageable = (Pageable)pageRequest;
        }
        Pageable pageRequest = pageable;
        Page page2 = this.collectionRepository.findAll(principal.getUser().getAuthorizedLibraryIds((Collection)libraryIds), principal.getUser().getAuthorizedLibraryIds(null), searchTerm, pageRequest, principal.getUser().getRestrictions()).map(arg_0 -> SeriesCollectionController.getCollections$lambda$0((Function1)getCollections.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
        return page2;
    }

    public static /* synthetic */ Page getCollections$default(SeriesCollectionController seriesCollectionController, KomgaPrincipal komgaPrincipal, String string, List list, boolean bl, Pageable pageable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getCollections");
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return seriesCollectionController.getCollections(komgaPrincipal, string, list, bl, pageable);
    }

    @Operation(tags={"Collections"}, summary="Get collection details")
    @GetMapping(value={"{id}"})
    @NotNull
    public CollectionDto getCollectionById(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String id) {
        CollectionDto collectionDto;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        SeriesCollection seriesCollection = this.collectionRepository.findByIdOrNull(id, principal.getUser().getAuthorizedLibraryIds(null), principal.getUser().getRestrictions());
        if (seriesCollection == null || (collectionDto = CollectionDtoKt.toDto((SeriesCollection)seriesCollection)) == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return collectionDto;
    }

    @Operation(tags={"Collection Poster"}, summary="Get collection's poster image")
    @ApiResponse(content={@Content(schema=@Schema(format="binary", type="string"))})
    @GetMapping(value={"{id}/thumbnail"}, produces={"image/jpeg"})
    @NotNull
    public ResponseEntity<byte[]> getCollectionThumbnail(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        SeriesCollection seriesCollection = this.collectionRepository.findByIdOrNull(id, principal.getUser().getAuthorizedLibraryIds(null), principal.getUser().getRestrictions());
        if (seriesCollection != null) {
            SeriesCollection it = seriesCollection;
            boolean bl = false;
            ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.maxAge((long)1L, (TimeUnit)TimeUnit.HOURS).cachePrivate())).body((Object)this.collectionLifecycle.getThumbnailBytes(it, principal.getUser().getId()));
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @Operation(tags={"Collection Poster"}, summary="Get collection poster image")
    @ApiResponse(content={@Content(schema=@Schema(format="binary", type="string"))})
    @GetMapping(value={"{id}/thumbnails/{thumbnailId}"}, produces={"image/jpeg"})
    @NotNull
    public byte[] getCollectionThumbnailById(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable(name="id") @NotNull String id, @PathVariable(name="thumbnailId") @NotNull String thumbnailId) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)thumbnailId, (String)"thumbnailId");
        SeriesCollection seriesCollection = this.collectionRepository.findByIdOrNull(id, principal.getUser().getAuthorizedLibraryIds(null), principal.getUser().getRestrictions());
        if (seriesCollection != null) {
            SeriesCollection it = seriesCollection;
            boolean bl = false;
            byte[] byArray = this.collectionLifecycle.getThumbnailBytes(thumbnailId);
            if (byArray == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            return byArray;
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    /*
     * WARNING - void declaration
     */
    @Operation(tags={"Collection Poster"}, summary="List collection's posters")
    @GetMapping(value={"{id}/thumbnails"}, produces={"application/json"})
    @NotNull
    public Collection<ThumbnailSeriesCollectionDto> getCollectionThumbnails(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable(name="id") @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        SeriesCollection seriesCollection = this.collectionRepository.findByIdOrNull(id, principal.getUser().getAuthorizedLibraryIds(null), principal.getUser().getRestrictions());
        if (seriesCollection != null) {
            void $this$mapTo$iv$iv;
            SeriesCollection it = seriesCollection;
            boolean bl = false;
            Iterable $this$map$iv = this.thumbnailSeriesCollectionRepository.findAllByCollectionId(id);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                ThumbnailSeriesCollection thumbnailSeriesCollection = (ThumbnailSeriesCollection)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(ThumbnailSeriesCollectionDtoKt.toDto((ThumbnailSeriesCollection)it2));
            }
            return (List)destination$iv$iv;
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(tags={"Collection Poster"}, summary="Add collection poster")
    @PostMapping(value={"{id}/thumbnails"}, consumes={"multipart/form-data"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @NotNull
    public ThumbnailSeriesCollectionDto addUserUploadedCollectionThumbnail(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable(name="id") @NotNull String id, @RequestParam(value="file") @NotNull MultipartFile file, @RequestParam(value="selected") boolean selected) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        SeriesCollection seriesCollection = SeriesCollectionRepository.DefaultImpls.findByIdOrNull$default((SeriesCollectionRepository)this.collectionRepository, (String)id, (Collection)principal.getUser().getAuthorizedLibraryIds(null), null, (int)4, null);
        if (seriesCollection != null) {
            String string;
            SeriesCollection collection = seriesCollection;
            boolean bl = false;
            InputStream inputStream = file.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            Object object = inputStream;
            int n = 8192;
            object = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
            Object object2 = null;
            try {
                BufferedInputStream it = (BufferedInputStream)object;
                boolean bl2 = false;
                string = this.contentDetector.detectMediaType((InputStream)it);
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            String mediaType2 = string;
            if (!this.contentDetector.isImage(mediaType2)) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNSUPPORTED_MEDIA_TYPE);
            }
            object = collection.getId();
            object2 = file.getBytes();
            string = ThumbnailSeriesCollection.Type.USER_UPLOADED;
            long l = file.getBytes().length;
            InputStream inputStream2 = file.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getInputStream(...)");
            InputStream inputStream3 = inputStream2;
            int n2 = 8192;
            Dimension dimension = this.imageAnalyzer.getDimension((InputStream)(inputStream3 instanceof BufferedInputStream ? (BufferedInputStream)inputStream3 : new BufferedInputStream(inputStream3, n2)));
            if (dimension == null) {
                dimension = new Dimension(0, 0);
            }
            Dimension dimension2 = dimension;
            Intrinsics.checkNotNull((Object)object2);
            return ThumbnailSeriesCollectionDtoKt.toDto((ThumbnailSeriesCollection)this.collectionLifecycle.addThumbnail(new ThumbnailSeriesCollection((byte[])object2, selected, (ThumbnailSeriesCollection.Type)string, mediaType2, l, dimension2, null, (String)object, null, null, 832, null)));
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    public static /* synthetic */ ThumbnailSeriesCollectionDto addUserUploadedCollectionThumbnail$default(SeriesCollectionController seriesCollectionController, KomgaPrincipal komgaPrincipal, String string, MultipartFile multipartFile, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addUserUploadedCollectionThumbnail");
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        return seriesCollectionController.addUserUploadedCollectionThumbnail(komgaPrincipal, string, multipartFile, bl);
    }

    @Operation(tags={"Collection Poster"}, summary="Mark collection poster as selected")
    @PutMapping(value={"{id}/thumbnails/{thumbnailId}/selected"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void markCollectionThumbnailSelected(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable(name="id") @NotNull String id, @PathVariable(name="thumbnailId") @NotNull String thumbnailId) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)thumbnailId, (String)"thumbnailId");
        SeriesCollection seriesCollection = SeriesCollectionRepository.DefaultImpls.findByIdOrNull$default((SeriesCollectionRepository)this.collectionRepository, (String)id, (Collection)principal.getUser().getAuthorizedLibraryIds(null), null, (int)4, null);
        if (seriesCollection != null) {
            SeriesCollection it = seriesCollection;
            boolean bl = false;
            ThumbnailSeriesCollection thumbnailSeriesCollection = this.thumbnailSeriesCollectionRepository.findByIdOrNull(thumbnailId);
            if (thumbnailSeriesCollection != null) {
                ThumbnailSeriesCollection it2 = thumbnailSeriesCollection;
                boolean bl2 = false;
                this.collectionLifecycle.markSelectedThumbnail(it2);
                this.eventPublisher.publishEvent((Object)new DomainEvent.ThumbnailSeriesCollectionAdded(ThumbnailSeriesCollection.copy$default((ThumbnailSeriesCollection)it2, null, (boolean)true, null, null, (long)0L, null, null, null, null, null, (int)1021, null)));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @Operation(tags={"Collection Poster"}, summary="Delete collection poster")
    @DeleteMapping(value={"{id}/thumbnails/{thumbnailId}"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void deleteUserUploadedCollectionThumbnail(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable(name="id") @NotNull String id, @PathVariable(name="thumbnailId") @NotNull String thumbnailId) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)thumbnailId, (String)"thumbnailId");
        SeriesCollection seriesCollection = SeriesCollectionRepository.DefaultImpls.findByIdOrNull$default((SeriesCollectionRepository)this.collectionRepository, (String)id, (Collection)principal.getUser().getAuthorizedLibraryIds(null), null, (int)4, null);
        if (seriesCollection != null) {
            Unit unit2;
            SeriesCollection it = seriesCollection;
            boolean bl = false;
            ThumbnailSeriesCollection thumbnailSeriesCollection = this.thumbnailSeriesCollectionRepository.findByIdOrNull(thumbnailId);
            if (thumbnailSeriesCollection != null) {
                ThumbnailSeriesCollection it2 = thumbnailSeriesCollection;
                boolean bl2 = false;
                this.collectionLifecycle.deleteThumbnail(it2);
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = null;
            }
            if (unit2 == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @Operation(tags={"Collections"}, summary="Create collection")
    @PostMapping
    @PreAuthorize(value="hasRole('ADMIN')")
    @NotNull
    public CollectionDto createCollection(@Valid @RequestBody @NotNull CollectionCreationDto collection) {
        CollectionDto collectionDto;
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        try {
            collectionDto = CollectionDtoKt.toDto((SeriesCollection)this.collectionLifecycle.addCollection(new SeriesCollection(collection.getName(), collection.getOrdered(), collection.getSeriesIds(), null, null, null, false, 120, null)));
        }
        catch (DuplicateNameException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getMessage());
        }
        return collectionDto;
    }

    @Operation(tags={"Collections"}, summary="Update collection")
    @PatchMapping(value={"{id}"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateCollectionById(@PathVariable @NotNull String id, @Valid @RequestBody @NotNull CollectionUpdateDto collection) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        SeriesCollection seriesCollection = SeriesCollectionRepository.DefaultImpls.findByIdOrNull$default((SeriesCollectionRepository)this.collectionRepository, (String)id, null, null, (int)6, null);
        if (seriesCollection != null) {
            SeriesCollection existing = seriesCollection;
            boolean bl = false;
            String string = collection.getName();
            if (string == null) {
                string = existing.getName();
            }
            Boolean bl2 = collection.getOrdered();
            boolean bl3 = bl2 != null ? bl2.booleanValue() : existing.getOrdered();
            List list = collection.getSeriesIds();
            if (list == null) {
                list = existing.getSeriesIds();
            }
            SeriesCollection updated = SeriesCollection.copy$default((SeriesCollection)existing, (String)string, (boolean)bl3, (List)list, null, null, null, (boolean)false, (int)120, null);
            try {
                this.collectionLifecycle.updateCollection(updated);
            }
            catch (DuplicateNameException e) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getMessage());
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @Operation(tags={"Collections"}, summary="Delete collection")
    @DeleteMapping(value={"{id}"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteCollectionById(@PathVariable @NotNull String id) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        SeriesCollection seriesCollection = SeriesCollectionRepository.DefaultImpls.findByIdOrNull$default((SeriesCollectionRepository)this.collectionRepository, (String)id, null, null, (int)6, null);
        if (seriesCollection != null) {
            SeriesCollection it = seriesCollection;
            boolean bl = false;
            this.collectionLifecycle.deleteCollection(it);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Operation(tags={"Collection Series"}, summary="List collection's series")
    @PageableWithoutSortAsQueryParam
    @AuthorsAsQueryParam
    @GetMapping(value={"{id}/series"})
    @NotNull
    public Page<SeriesDto> getSeriesByCollectionId(@PathVariable @NotNull String id, @AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="library_id", required=false) @Nullable List<String> libraryIds, @RequestParam(name="status", required=false) @Nullable List<? extends SeriesMetadata.Status> metadataStatus, @RequestParam(name="read_status", required=false) @Nullable List<? extends ReadStatus> readStatus, @RequestParam(name="publisher", required=false) @Nullable List<String> publishers, @RequestParam(name="language", required=false) @Nullable List<String> languages2, @RequestParam(name="genre", required=false) @Nullable List<String> genres, @RequestParam(name="tag", required=false) @Nullable List<String> tags, @RequestParam(name="age_rating", required=false) @Nullable List<String> ageRatings, @RequestParam(name="release_year", required=false) @Nullable List<String> releaseYears, @RequestParam(name="deleted", required=false) @Nullable Boolean deleted, @RequestParam(name="complete", required=false) @Nullable Boolean complete, @RequestParam(name="unpaged", required=false) boolean unpaged, @Parameter(hidden=true) @Authors @Nullable List<Author> authors, @Parameter(hidden=true) @NotNull Pageable page) {
        Page page2;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        SeriesCollection seriesCollection = this.collectionRepository.findByIdOrNull(id, principal.getUser().getAuthorizedLibraryIds(null), principal.getUser().getRestrictions());
        if (seriesCollection != null) {
            boolean it;
            Object it2;
            Collection collection;
            boolean $i$f$mapTo;
            Collection destination$iv$iv;
            Iterable $this$map$iv;
            boolean $i$f$map;
            List list;
            List list2;
            Pageable pageable;
            Sort sort;
            SeriesCollection collection2 = seriesCollection;
            boolean bl = false;
            if (collection2.getOrdered()) {
                var20_19 = new Sort.Order[]{Sort.Order.asc((String)"collection.number")};
                sort = Sort.by((Sort.Order[])var20_19);
            } else {
                var20_19 = new Sort.Order[]{Sort.Order.asc((String)"metadata.titleSort")};
                sort = Sort.by((Sort.Order[])var20_19);
            }
            Sort sort2 = sort;
            Intrinsics.checkNotNull((Object)sort2);
            Sort sort3 = sort2;
            if (unpaged) {
                pageable = (Pageable)new UnpagedSorted(sort3);
            } else {
                PageRequest pageRequest = PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)sort3);
                Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
                pageable = (Pageable)pageRequest;
            }
            Pageable pageRequest = pageable;
            List $this$getSeriesByCollectionId_u24lambda_u2429_u24lambda_u2427 = list2 = CollectionsKt.createListBuilder();
            boolean bl2 = false;
            $this$getSeriesByCollectionId_u24lambda_u2429_u24lambda_u2427.add(new SearchCondition.CollectionId((SearchOperator.Equality)new SearchOperator.Is((Object)collection2.getId())));
            Iterable iterable = libraryIds;
            if (!(iterable == null || iterable.isEmpty())) {
                void $this$mapTo$iv$iv;
                iterable = libraryIds;
                list = $this$getSeriesByCollectionId_u24lambda_u2429_u24lambda_u2427;
                $i$f$map = false;
                void var29_28 = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String string = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(new SearchCondition.LibraryId((SearchOperator.Equality)new SearchOperator.Is(it2)));
                }
                List list3 = (List)destination$iv$iv;
                list.add(new SearchCondition.AnyOfSeries(list3));
            }
            Boolean bl4 = deleted;
            if (bl4 != null) {
                it = bl4;
                boolean bl5 = false;
                v5 = $this$getSeriesByCollectionId_u24lambda_u2429_u24lambda_u2427.add(new SearchCondition.Deleted(it ? (SearchOperator.Boolean)SearchOperator.IsTrue.INSTANCE : (SearchOperator.Boolean)SearchOperator.IsFalse.INSTANCE));
            } else {
                v5 = null;
            }
            Boolean bl6 = complete;
            if (bl6 != null) {
                it = bl6;
                boolean bl7 = false;
                v7 = $this$getSeriesByCollectionId_u24lambda_u2429_u24lambda_u2427.add(new SearchCondition.Complete(it ? (SearchOperator.Boolean)SearchOperator.IsTrue.INSTANCE : (SearchOperator.Boolean)SearchOperator.IsFalse.INSTANCE));
            } else {
                v7 = null;
            }
            $this$map$iv = metadataStatus;
            if (!($this$map$iv == null || $this$map$iv.isEmpty())) {
                void $this$mapTo$iv$iv;
                $this$map$iv = metadataStatus;
                list = $this$getSeriesByCollectionId_u24lambda_u2429_u24lambda_u2427;
                $i$f$map = false;
                Iterable bl7 = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it2 = (SeriesMetadata.Status)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl8 = false;
                    collection.add(new SearchCondition.SeriesStatus((SearchOperator.Equality)new SearchOperator.Is(it2)));
                }
                List list4 = (List)destination$iv$iv;
                list.add(new SearchCondition.AnyOfSeries(list4));
            }
            if (!(($this$map$iv = (Collection)publishers) == null || $this$map$iv.isEmpty())) {
                $this$map$iv = publishers;
                list = $this$getSeriesByCollectionId_u24lambda_u2429_u24lambda_u2427;
                $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it2 = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl9 = false;
                    collection.add(new SearchCondition.Publisher((SearchOperator.Equality)new SearchOperator.Is(it2)));
                }
                List list5 = (List)destination$iv$iv;
                list.add(new SearchCondition.AnyOfSeries(list5));
            }
            if (!(($this$map$iv = (Collection)languages2) == null || $this$map$iv.isEmpty())) {
                $this$map$iv = languages2;
                list = $this$getSeriesByCollectionId_u24lambda_u2429_u24lambda_u2427;
                $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it2 = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl10 = false;
                    collection.add(new SearchCondition.Language((SearchOperator.Equality)new SearchOperator.Is(it2)));
                }
                List list6 = (List)destination$iv$iv;
                list.add(new SearchCondition.AnyOfSeries(list6));
            }
            if (!(($this$map$iv = (Collection)tags) == null || $this$map$iv.isEmpty())) {
                $this$map$iv = tags;
                list = $this$getSeriesByCollectionId_u24lambda_u2429_u24lambda_u2427;
                $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it2 = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl11 = false;
                    collection.add(new SearchCondition.Tag((SearchOperator.EqualityNullable)new SearchOperator.Is(it2)));
                }
                List list7 = (List)destination$iv$iv;
                list.add(new SearchCondition.AnyOfSeries(list7));
            }
            if (!(($this$map$iv = (Collection)genres) == null || $this$map$iv.isEmpty())) {
                $this$map$iv = genres;
                list = $this$getSeriesByCollectionId_u24lambda_u2429_u24lambda_u2427;
                $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it2 = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl12 = false;
                    collection.add(new SearchCondition.Genre((SearchOperator.EqualityNullable)new SearchOperator.Is(it2)));
                }
                List list8 = (List)destination$iv$iv;
                list.add(new SearchCondition.AnyOfSeries(list8));
            }
            if (!(($this$map$iv = (Collection)ageRatings) == null || $this$map$iv.isEmpty())) {
                $this$map$iv = ageRatings;
                list = $this$getSeriesByCollectionId_u24lambda_u2429_u24lambda_u2427;
                $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    SearchCondition.AgeRating ageRating;
                    it2 = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl13 = false;
                    Integer n = StringsKt.toIntOrNull((String)it2);
                    if (n != null) {
                        int ageRating2 = ((Number)n).intValue();
                        boolean bl14 = false;
                        ageRating = new SearchCondition.AgeRating((SearchOperator.NumericNullable)new SearchOperator.Is((Object)ageRating2));
                    } else {
                        ageRating = new SearchCondition.AgeRating((SearchOperator.NumericNullable)new SearchOperator.IsNullT());
                    }
                    collection.add(ageRating);
                }
                List list9 = (List)destination$iv$iv;
                list.add(new SearchCondition.AnyOfSeries(list9));
            }
            if (!(($this$map$iv = (Collection)releaseYears) == null || $this$map$iv.isEmpty())) {
                Iterable $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv;
                $this$map$iv = releaseYears;
                list = $this$getSeriesByCollectionId_u24lambda_u2429_u24lambda_u2427;
                boolean $i$f$mapNotNull = false;
                void $this$mapTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                it2 = $this$forEach$iv$iv$iv.iterator();
                while (it2.hasNext()) {
                    Integer it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = it2.next();
                    boolean bl15 = false;
                    String it3 = (String)element$iv$iv;
                    boolean bl16 = false;
                    if (StringsKt.toIntOrNull((String)it3) == null) continue;
                    boolean bl17 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$mapNotNullTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void releaseYear;
                    int it4 = ((Number)item$iv$iv).intValue();
                    collection = destination$iv$iv;
                    boolean bl18 = false;
                    SearchCondition.Series[] seriesArray = new SearchCondition.Series[2];
                    ZonedDateTime zonedDateTime = ZonedDateTime.of((int)(releaseYear - true), 12, 31, 12, 0, 0, 0, ZoneOffset.UTC);
                    Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"of(...)");
                    seriesArray[0] = new SearchCondition.ReleaseDate((SearchOperator.Date)new SearchOperator.After(zonedDateTime));
                    ZonedDateTime zonedDateTime2 = ZonedDateTime.of((int)(releaseYear + true), 1, 1, 12, 0, 0, 0, ZoneOffset.UTC);
                    Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime2, (String)"of(...)");
                    seriesArray[1] = new SearchCondition.ReleaseDate((SearchOperator.Date)new SearchOperator.Before(zonedDateTime2));
                    collection.add(new SearchCondition.AllOfSeries(seriesArray));
                }
                List list10 = (List)destination$iv$iv;
                list.add(new SearchCondition.AnyOfSeries(list10));
            }
            if (!(($this$map$iv = (Collection)readStatus) == null || $this$map$iv.isEmpty())) {
                $this$map$iv = readStatus;
                list = $this$getSeriesByCollectionId_u24lambda_u2429_u24lambda_u2427;
                $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it5;
                    ReadStatus releaseYear = (ReadStatus)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl19 = false;
                    collection.add(new SearchCondition.ReadStatus((SearchOperator.Equality)new SearchOperator.Is((Object)it5)));
                }
                List list11 = (List)destination$iv$iv;
                list.add(new SearchCondition.AnyOfSeries(list11));
            }
            if (!(($this$map$iv = (Collection)authors) == null || $this$map$iv.isEmpty())) {
                $this$map$iv = authors;
                list = $this$getSeriesByCollectionId_u24lambda_u2429_u24lambda_u2427;
                $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Author it5 = (Author)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl20 = false;
                    collection.add(new SearchCondition.Author((SearchOperator.Equality)new SearchOperator.Is((Object)new SearchCondition.AuthorMatch(it5.getName(), it5.getRole()))));
                }
                List list12 = (List)destination$iv$iv;
                list.add(new SearchCondition.AnyOfSeries(list12));
            }
            List list13 = CollectionsKt.build((List)list2);
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 6;
            Pair pair = null;
            String string = null;
            SearchCondition.Series series = (SearchCondition.Series)new SearchCondition.AllOfSeries(list13);
            SeriesSearch search = new SeriesSearch(series, string, pair, n, defaultConstructorMarker);
            v12 = this.seriesDtoRepository.findAll(search, new SearchContext(principal.getUser()), pageRequest).map(arg_0 -> SeriesCollectionController.getSeriesByCollectionId$lambda$29$lambda$28((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
        } else {
            v12 = page2 = null;
        }
        if (page2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return page2;
    }

    public static /* synthetic */ Page getSeriesByCollectionId$default(SeriesCollectionController seriesCollectionController, String string, KomgaPrincipal komgaPrincipal, List list, List list2, List list3, List list4, List list5, List list6, List list7, List list8, List list9, Boolean bl, Boolean bl2, boolean bl3, List list10, Pageable pageable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getSeriesByCollectionId");
        }
        if ((n & 0x2000) != 0) {
            bl3 = false;
        }
        return seriesCollectionController.getSeriesByCollectionId(string, komgaPrincipal, list, list2, list3, list4, list5, list6, list7, list8, list9, bl, bl2, bl3, list10, pageable);
    }

    private static final CollectionDto getCollections$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CollectionDto)$tmp0.invoke(p0);
    }

    private static final SeriesDto getSeriesByCollectionId$lambda$29$lambda$28(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (SeriesDto)$tmp0.invoke(p0);
    }
}

