/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.api.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gotson.komga.application.tasks.TasksRepository;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(produces={"application/json"})
@Tag(name="Tasks")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/gotson/komga/interfaces/api/rest/TaskController;", "", "tasksRepository", "Lorg/gotson/komga/application/tasks/TasksRepository;", "(Lorg/gotson/komga/application/tasks/TasksRepository;)V", "emptyTaskQueue", "", "komga"})
public class TaskController {
    @NotNull
    private final TasksRepository tasksRepository;

    public TaskController(@NotNull TasksRepository tasksRepository) {
        Intrinsics.checkNotNullParameter((Object)tasksRepository, (String)"tasksRepository");
        this.tasksRepository = tasksRepository;
    }

    @DeleteMapping(value={"api/v1/tasks"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="Clear task queue", description="Cancel all tasks queued")
    public int emptyTaskQueue() {
        return this.tasksRepository.deleteAllWithoutOwner();
    }
}

