/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.api.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.domain.model.AgeRestriction;
import org.gotson.komga.domain.model.ApiKey;
import org.gotson.komga.domain.model.AuthenticationActivity;
import org.gotson.komga.domain.model.ContentRestrictions;
import org.gotson.komga.domain.model.DuplicateNameException;
import org.gotson.komga.domain.model.KomgaUser;
import org.gotson.komga.domain.model.Library;
import org.gotson.komga.domain.model.UserEmailAlreadyExistsException;
import org.gotson.komga.domain.model.UserRoles;
import org.gotson.komga.domain.persistence.AuthenticationActivityRepository;
import org.gotson.komga.domain.persistence.KomgaUserRepository;
import org.gotson.komga.domain.persistence.LibraryRepository;
import org.gotson.komga.domain.service.KomgaUserLifecycle;
import org.gotson.komga.infrastructure.jooq.UnpagedSorted;
import org.gotson.komga.infrastructure.security.KomgaPrincipal;
import org.gotson.komga.interfaces.api.rest.UserController;
import org.gotson.komga.interfaces.api.rest.dto.AgeRestrictionUpdateDto;
import org.gotson.komga.interfaces.api.rest.dto.ApiKeyDto;
import org.gotson.komga.interfaces.api.rest.dto.ApiKeyDtoKt;
import org.gotson.komga.interfaces.api.rest.dto.ApiKeyRequestDto;
import org.gotson.komga.interfaces.api.rest.dto.AuthenticationActivityDto;
import org.gotson.komga.interfaces.api.rest.dto.AuthenticationActivityDtoKt;
import org.gotson.komga.interfaces.api.rest.dto.PasswordUpdateDto;
import org.gotson.komga.interfaces.api.rest.dto.SharedLibrariesUpdateDto;
import org.gotson.komga.interfaces.api.rest.dto.UserCreationDto;
import org.gotson.komga.interfaces.api.rest.dto.UserDto;
import org.gotson.komga.interfaces.api.rest.dto.UserDtoKt;
import org.gotson.komga.interfaces.api.rest.dto.UserUpdateDto;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springdoc.core.converters.models.PageableAsQueryParam;
import org.springframework.core.env.Environment;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"api/v2/users"}, produces={"application/json"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0017J\u001c\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\u0017\u001a\u00020\u0018H\u0017J\u001c\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\u001b\u001a\u00020\u001cH\u0017J\u001c\u0010\u001d\u001a\u00020\u001a2\b\b\u0001\u0010\u001e\u001a\u00020\u001c2\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0017J\u0018\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00140 2\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0017J\"\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\b\b\u0003\u0010$\u001a\u00020\u000e2\b\b\u0001\u0010%\u001a\u00020&H\u0017J,\u0010'\u001a\b\u0012\u0004\u0012\u00020#0\"2\b\b\u0001\u0010\u0015\u001a\u00020\u00162\b\b\u0003\u0010$\u001a\u00020\u000e2\b\b\u0001\u0010%\u001a\u00020&H\u0017J\u0012\u0010(\u001a\u00020\u00102\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0017J(\u0010)\u001a\u00020#2\b\b\u0001\u0010\u001e\u001a\u00020\u001c2\b\b\u0001\u0010\u0015\u001a\u00020\u00162\n\b\u0001\u0010*\u001a\u0004\u0018\u00010\u001cH\u0017J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00100,H\u0017J&\u0010-\u001a\u00020\u001a2\b\b\u0001\u0010\u001e\u001a\u00020\u001c2\b\b\u0001\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010.\u001a\u00020/H\u0017J\u001c\u00100\u001a\u00020\u001a2\b\b\u0001\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010.\u001a\u00020/H\u0017J&\u00101\u001a\u00020\u001a2\b\b\u0001\u0010\u001e\u001a\u00020\u001c2\b\b\u0001\u00102\u001a\u0002032\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0017R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/gotson/komga/interfaces/api/rest/UserController;", "", "userLifecycle", "Lorg/gotson/komga/domain/service/KomgaUserLifecycle;", "userRepository", "Lorg/gotson/komga/domain/persistence/KomgaUserRepository;", "libraryRepository", "Lorg/gotson/komga/domain/persistence/LibraryRepository;", "authenticationActivityRepository", "Lorg/gotson/komga/domain/persistence/AuthenticationActivityRepository;", "env", "Lorg/springframework/core/env/Environment;", "(Lorg/gotson/komga/domain/service/KomgaUserLifecycle;Lorg/gotson/komga/domain/persistence/KomgaUserRepository;Lorg/gotson/komga/domain/persistence/LibraryRepository;Lorg/gotson/komga/domain/persistence/AuthenticationActivityRepository;Lorg/springframework/core/env/Environment;)V", "demo", "", "addUser", "Lorg/gotson/komga/interfaces/api/rest/dto/UserDto;", "newUser", "Lorg/gotson/komga/interfaces/api/rest/dto/UserCreationDto;", "createApiKeyForCurrentUser", "Lorg/gotson/komga/interfaces/api/rest/dto/ApiKeyDto;", "principal", "Lorg/gotson/komga/infrastructure/security/KomgaPrincipal;", "apiKeyRequest", "Lorg/gotson/komga/interfaces/api/rest/dto/ApiKeyRequestDto;", "deleteApiKeyByKeyId", "", "keyId", "", "deleteUserById", "id", "getApiKeysForCurrentUser", "", "getAuthenticationActivity", "Lorg/springframework/data/domain/Page;", "Lorg/gotson/komga/interfaces/api/rest/dto/AuthenticationActivityDto;", "unpaged", "page", "Lorg/springframework/data/domain/Pageable;", "getAuthenticationActivityForCurrentUser", "getCurrentUser", "getLatestAuthenticationActivityByUserId", "apiKeyId", "getUsers", "", "updatePasswordByUserId", "newPasswordDto", "Lorg/gotson/komga/interfaces/api/rest/dto/PasswordUpdateDto;", "updatePasswordForCurrentUser", "updateUserById", "patch", "Lorg/gotson/komga/interfaces/api/rest/dto/UserUpdateDto;", "komga"})
@SourceDebugExtension(value={"SMAP\nUserController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserController.kt\norg/gotson/komga/interfaces/api/rest/UserController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,290:1\n1549#2:291\n1620#2,3:292\n1549#2:295\n1620#2,3:296\n1549#2:299\n1620#2,3:300\n*S KotlinDebug\n*F\n+ 1 UserController.kt\norg/gotson/komga/interfaces/api/rest/UserController\n*L\n86#1:291\n86#1:292,3\n136#1:295\n136#1:296,3\n260#1:299\n260#1:300,3\n*E\n"})
public class UserController {
    @NotNull
    private final KomgaUserLifecycle userLifecycle;
    @NotNull
    private final KomgaUserRepository userRepository;
    @NotNull
    private final LibraryRepository libraryRepository;
    @NotNull
    private final AuthenticationActivityRepository authenticationActivityRepository;
    private final boolean demo;

    public UserController(@NotNull KomgaUserLifecycle userLifecycle, @NotNull KomgaUserRepository userRepository, @NotNull LibraryRepository libraryRepository, @NotNull AuthenticationActivityRepository authenticationActivityRepository, @NotNull Environment env) {
        Intrinsics.checkNotNullParameter((Object)userLifecycle, (String)"userLifecycle");
        Intrinsics.checkNotNullParameter((Object)userRepository, (String)"userRepository");
        Intrinsics.checkNotNullParameter((Object)libraryRepository, (String)"libraryRepository");
        Intrinsics.checkNotNullParameter((Object)authenticationActivityRepository, (String)"authenticationActivityRepository");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        this.userLifecycle = userLifecycle;
        this.userRepository = userRepository;
        this.libraryRepository = libraryRepository;
        this.authenticationActivityRepository = authenticationActivityRepository;
        String[] stringArray = env.getActiveProfiles();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getActiveProfiles(...)");
        this.demo = ArraysKt.contains((Object[])stringArray, (Object)"demo");
    }

    @GetMapping(value={"me"})
    @Operation(tags={"Current user"}, summary="Retrieve current user")
    @NotNull
    public UserDto getCurrentUser(@AuthenticationPrincipal @NotNull KomgaPrincipal principal) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        return UserDtoKt.toDto((KomgaPrincipal)principal);
    }

    @PatchMapping(value={"me/password"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(tags={"Current user"}, summary="Update current user's password")
    public void updatePasswordForCurrentUser(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @Valid @RequestBody @NotNull PasswordUpdateDto newPasswordDto) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)newPasswordDto, (String)"newPasswordDto");
        if (this.demo) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        KomgaUser komgaUser = this.userRepository.findByEmailIgnoreCaseOrNull(principal.getUsername());
        if (komgaUser != null) {
            KomgaUser user = komgaUser;
            boolean bl = false;
            this.userLifecycle.updatePassword(user, newPasswordDto.getPassword(), false);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping
    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(tags={"Users"}, summary="List users")
    @NotNull
    public List<UserDto> getUsers() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.userRepository.findAll();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KomgaUser komgaUser = (KomgaUser)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(UserDtoKt.toDto((KomgaUser)it));
        }
        return (List)destination$iv$iv;
    }

    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(tags={"Users"}, summary="Create user")
    @NotNull
    public UserDto addUser(@Valid @RequestBody @NotNull UserCreationDto newUser) {
        UserDto userDto;
        Intrinsics.checkNotNullParameter((Object)newUser, (String)"newUser");
        try {
            userDto = UserDtoKt.toDto((KomgaUser)this.userLifecycle.createUser(newUser.toDomain()));
        }
        catch (UserEmailAlreadyExistsException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "A user with this email already exists");
        }
        return userDto;
    }

    @DeleteMapping(value={"{id}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @PreAuthorize(value="hasRole('ADMIN') and #principal.user.id != #id")
    @Operation(tags={"Users"}, summary="Delete user")
    public void deleteUserById(@PathVariable @NotNull String id, @AuthenticationPrincipal @NotNull KomgaPrincipal principal) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        KomgaUser komgaUser = this.userRepository.findByIdOrNull(id);
        if (komgaUser != null) {
            KomgaUser it = komgaUser;
            boolean bl = false;
            this.userLifecycle.deleteUser(it);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PatchMapping(value={"{id}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @PreAuthorize(value="hasRole('ADMIN') and #principal.user.id != #id")
    @Operation(tags={"Users"}, summary="Update user")
    public void updateUserById(@PathVariable @NotNull String id, @Valid @RequestBody @NotNull UserUpdateDto patch2, @AuthenticationPrincipal @NotNull KomgaPrincipal principal) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)patch2, (String)"patch");
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        KomgaUser komgaUser = this.userRepository.findByIdOrNull(id);
        if (komgaUser != null) {
            Set set;
            Set set2;
            AgeRestriction ageRestriction;
            Set set3;
            boolean bl;
            Set set4;
            KomgaUser existing = komgaUser;
            boolean bl2 = false;
            UserUpdateDto $this$updateUserById_u24lambda_u245_u24lambda_u244 = patch2;
            boolean bl3 = false;
            if ($this$updateUserById_u24lambda_u245_u24lambda_u244.isSet("roles")) {
                Set set5 = $this$updateUserById_u24lambda_u245_u24lambda_u244.getRoles();
                Intrinsics.checkNotNull((Object)set5);
                v2 = UserRoles.Companion.valuesOf((Iterable)set5);
            } else {
                v2 = set4 = existing.getRoles();
            }
            if ($this$updateUserById_u24lambda_u245_u24lambda_u244.isSet("sharedLibraries")) {
                SharedLibrariesUpdateDto sharedLibrariesUpdateDto = $this$updateUserById_u24lambda_u245_u24lambda_u244.getSharedLibraries();
                Intrinsics.checkNotNull((Object)sharedLibrariesUpdateDto);
                v4 = sharedLibrariesUpdateDto.getAll();
            } else {
                v4 = bl = existing.getSharedAllLibraries();
            }
            if ($this$updateUserById_u24lambda_u245_u24lambda_u244.isSet("sharedLibraries")) {
                SharedLibrariesUpdateDto sharedLibrariesUpdateDto = $this$updateUserById_u24lambda_u245_u24lambda_u244.getSharedLibraries();
                Intrinsics.checkNotNull((Object)sharedLibrariesUpdateDto);
                if (sharedLibrariesUpdateDto.getAll()) {
                    v6 = SetsKt.emptySet();
                } else {
                    void $this$mapTo$iv$iv;
                    SharedLibrariesUpdateDto sharedLibrariesUpdateDto2 = $this$updateUserById_u24lambda_u245_u24lambda_u244.getSharedLibraries();
                    Intrinsics.checkNotNull((Object)sharedLibrariesUpdateDto2);
                    Iterable $this$map$iv = this.libraryRepository.findAllByIds((Collection)sharedLibrariesUpdateDto2.getLibraryIds());
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Library library = (Library)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl4 = false;
                        collection.add(it.getId());
                    }
                    v6 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                }
            } else {
                v6 = set3 = existing.getSharedLibrariesIds();
            }
            if ($this$updateUserById_u24lambda_u245_u24lambda_u244.isSet("ageRestriction")) {
                if ($this$updateUserById_u24lambda_u245_u24lambda_u244.getAgeRestriction() == null) {
                    ageRestriction = null;
                } else {
                    AgeRestrictionUpdateDto ageRestrictionUpdateDto = $this$updateUserById_u24lambda_u245_u24lambda_u244.getAgeRestriction();
                    Intrinsics.checkNotNull((Object)ageRestrictionUpdateDto);
                    int n = ageRestrictionUpdateDto.getAge();
                    AgeRestrictionUpdateDto ageRestrictionUpdateDto2 = $this$updateUserById_u24lambda_u245_u24lambda_u244.getAgeRestriction();
                    Intrinsics.checkNotNull((Object)ageRestrictionUpdateDto2);
                    ageRestriction = new AgeRestriction(n, ageRestrictionUpdateDto2.getRestriction());
                }
            } else {
                ageRestriction = existing.getRestrictions().getAgeRestriction();
            }
            if ($this$updateUserById_u24lambda_u245_u24lambda_u244.isSet("labelsAllow")) {
                set2 = $this$updateUserById_u24lambda_u245_u24lambda_u244.getLabelsAllow();
                if (set2 == null) {
                    set2 = SetsKt.emptySet();
                }
            } else {
                set2 = existing.getRestrictions().getLabelsAllow();
            }
            if ($this$updateUserById_u24lambda_u245_u24lambda_u244.isSet("labelsExclude")) {
                set = $this$updateUserById_u24lambda_u245_u24lambda_u244.getLabelsExclude();
                if (set == null) {
                    set = SetsKt.emptySet();
                }
            } else {
                set = existing.getRestrictions().getLabelsExclude();
            }
            ContentRestrictions contentRestrictions = new ContentRestrictions(ageRestriction, set2, set);
            KomgaUser updatedUser = KomgaUser.copy$default((KomgaUser)existing, null, null, (Set)set4, (Set)set3, (boolean)bl, (ContentRestrictions)contentRestrictions, null, null, null, (int)451, null);
            this.userLifecycle.updateUser(updatedUser);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @PatchMapping(value={"{id}/password"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @PreAuthorize(value="hasRole('ADMIN') or #principal.user.id == #id")
    @Operation(tags={"Users"}, summary="Update user's password")
    public void updatePasswordByUserId(@PathVariable @NotNull String id, @AuthenticationPrincipal @NotNull KomgaPrincipal principal, @Valid @RequestBody @NotNull PasswordUpdateDto newPasswordDto) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)newPasswordDto, (String)"newPasswordDto");
        if (this.demo) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        KomgaUser komgaUser = this.userRepository.findByIdOrNull(id);
        if (komgaUser != null) {
            KomgaUser user = komgaUser;
            boolean bl = false;
            this.userLifecycle.updatePassword(user, newPasswordDto.getPassword(), !Intrinsics.areEqual((Object)user.getId(), (Object)principal.getUser().getId()));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @GetMapping(value={"me/authentication-activity"})
    @PageableAsQueryParam
    @Operation(tags={"Current user"}, summary="Retrieve authentication activity for the current user")
    @NotNull
    public Page<AuthenticationActivityDto> getAuthenticationActivityForCurrentUser(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="unpaged", required=false) boolean unpaged, @Parameter(hidden=true) @NotNull Pageable page) {
        Pageable pageable;
        Sort sort;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        if (this.demo && !principal.getUser().isAdmin()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        if (page.getSort().isSorted()) {
            sort = page.getSort();
        } else {
            Sort.Order[] orderArray = new Sort.Order[]{Sort.Order.desc((String)"dateTime")};
            sort = Sort.by((Sort.Order[])orderArray);
        }
        Sort sort2 = sort;
        Intrinsics.checkNotNull((Object)sort2);
        Sort sort3 = sort2;
        if (unpaged) {
            pageable = (Pageable)new UnpagedSorted(sort3);
        } else {
            PageRequest pageRequest = PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)sort3);
            Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
            pageable = (Pageable)pageRequest;
        }
        Pageable pageRequest = pageable;
        Page page2 = this.authenticationActivityRepository.findAllByUser(principal.getUser(), pageRequest).map(arg_0 -> UserController.getAuthenticationActivityForCurrentUser$lambda$7((Function1)getAuthenticationActivityForCurrentUser.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
        return page2;
    }

    public static /* synthetic */ Page getAuthenticationActivityForCurrentUser$default(UserController userController, KomgaPrincipal komgaPrincipal, boolean bl, Pageable pageable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getAuthenticationActivityForCurrentUser");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return userController.getAuthenticationActivityForCurrentUser(komgaPrincipal, bl, pageable);
    }

    @GetMapping(value={"authentication-activity"})
    @PageableAsQueryParam
    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(tags={"Users"}, summary="Retrieve authentication activity")
    @NotNull
    public Page<AuthenticationActivityDto> getAuthenticationActivity(@RequestParam(name="unpaged", required=false) boolean unpaged, @Parameter(hidden=true) @NotNull Pageable page) {
        Pageable pageable;
        Sort sort;
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        if (page.getSort().isSorted()) {
            sort = page.getSort();
        } else {
            Sort.Order[] orderArray = new Sort.Order[]{Sort.Order.desc((String)"dateTime")};
            sort = Sort.by((Sort.Order[])orderArray);
        }
        Sort sort2 = sort;
        Intrinsics.checkNotNull((Object)sort2);
        Sort sort3 = sort2;
        if (unpaged) {
            pageable = (Pageable)new UnpagedSorted(sort3);
        } else {
            PageRequest pageRequest = PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)sort3);
            Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
            pageable = (Pageable)pageRequest;
        }
        Pageable pageRequest = pageable;
        Page page2 = this.authenticationActivityRepository.findAll(pageRequest).map(arg_0 -> UserController.getAuthenticationActivity$lambda$8((Function1)getAuthenticationActivity.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
        return page2;
    }

    public static /* synthetic */ Page getAuthenticationActivity$default(UserController userController, boolean bl, Pageable pageable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getAuthenticationActivity");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return userController.getAuthenticationActivity(bl, pageable);
    }

    @GetMapping(value={"{id}/authentication-activity/latest"})
    @PreAuthorize(value="hasRole('ADMIN') or #principal.user.id == #id")
    @Operation(tags={"Users"}, summary="Retrieve latest authentication activity for a user")
    @NotNull
    public AuthenticationActivityDto getLatestAuthenticationActivityByUserId(@PathVariable @NotNull String id, @AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="apikey_id", required=false) @Nullable String apiKeyId) {
        KomgaUser komgaUser;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
                komgaUser = this.userRepository.findByIdOrNull(id);
                if (komgaUser == null) break block4;
                KomgaUser user = komgaUser;
                boolean bl = false;
                AuthenticationActivity authenticationActivity = this.authenticationActivityRepository.findMostRecentByUser(user, apiKeyId);
                if (authenticationActivity == null || (authenticationActivity = AuthenticationActivityDtoKt.toDto((AuthenticationActivity)authenticationActivity)) == null) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
                }
                komgaUser = authenticationActivity;
                if (authenticationActivity != null) break block5;
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return komgaUser;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"me/api-keys"})
    @Operation(tags={"API Keys"}, summary="Retrieve API keys")
    @NotNull
    public Collection<ApiKeyDto> getApiKeysForCurrentUser(@AuthenticationPrincipal @NotNull KomgaPrincipal principal) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        if (this.demo && !principal.getUser().isAdmin()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        Iterable $this$map$iv = this.userRepository.findApiKeyByUserId(principal.getUser().getId());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ApiKey apiKey = (ApiKey)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ApiKeyDtoKt.redacted((ApiKeyDto)ApiKeyDtoKt.toDto((ApiKey)it)));
        }
        return (List)destination$iv$iv;
    }

    @PostMapping(value={"me/api-keys"})
    @Operation(tags={"API Keys"}, summary="Create API key")
    @NotNull
    public ApiKeyDto createApiKeyForCurrentUser(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @Valid @RequestBody @NotNull ApiKeyRequestDto apiKeyRequest) {
        ApiKeyDto apiKeyDto;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)apiKeyRequest, (String)"apiKeyRequest");
        if (this.demo && !principal.getUser().isAdmin()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        try {
            ApiKey apiKey = this.userLifecycle.createApiKey(principal.getUser(), apiKeyRequest.getComment());
            apiKeyDto = apiKey != null ? ApiKeyDtoKt.toDto((ApiKey)apiKey) : null;
        }
        catch (DuplicateNameException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getCode());
        }
        ApiKeyDto apiKeyDto2 = apiKeyDto;
        if (apiKeyDto2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE, "Failed to generate API key");
        }
        return apiKeyDto2;
    }

    @DeleteMapping(value={"me/api-keys/{keyId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(tags={"API Keys"}, summary="Delete API key")
    public void deleteApiKeyByKeyId(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String keyId) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)keyId, (String)"keyId");
        if (!this.userRepository.existsApiKeyByIdAndUserId(keyId, principal.getUser().getId())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        this.userRepository.deleteApiKeyByIdAndUserId(keyId, principal.getUser().getId());
    }

    private static final AuthenticationActivityDto getAuthenticationActivityForCurrentUser$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (AuthenticationActivityDto)$tmp0.invoke(p0);
    }

    private static final AuthenticationActivityDto getAuthenticationActivity$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (AuthenticationActivityDto)$tmp0.invoke(p0);
    }
}

