/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.scheduler;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.MultiGauge;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.gotson.komga.domain.model.DomainEvent;
import org.gotson.komga.domain.persistence.BookRepository;
import org.gotson.komga.domain.persistence.LibraryRepository;
import org.gotson.komga.domain.persistence.ReadListRepository;
import org.gotson.komga.domain.persistence.SeriesCollectionRepository;
import org.gotson.komga.domain.persistence.SeriesRepository;
import org.gotson.komga.domain.persistence.SidecarRepository;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Profile;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Profile(value={"!test"})
@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010!\u001a\u00020\"H\u0017J\u0010\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u0013H\u0012J\u0010\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020'H\u0013R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00150\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR \u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001f0\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001dR\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/gotson/komga/interfaces/scheduler/MetricsPublisherController;", "", "libraryRepository", "Lorg/gotson/komga/domain/persistence/LibraryRepository;", "bookRepository", "Lorg/gotson/komga/domain/persistence/BookRepository;", "seriesRepository", "Lorg/gotson/komga/domain/persistence/SeriesRepository;", "collectionRepository", "Lorg/gotson/komga/domain/persistence/SeriesCollectionRepository;", "readListRepository", "Lorg/gotson/komga/domain/persistence/ReadListRepository;", "sidecarRepository", "Lorg/gotson/komga/domain/persistence/SidecarRepository;", "meterRegistry", "Lio/micrometer/core/instrument/MeterRegistry;", "(Lorg/gotson/komga/domain/persistence/LibraryRepository;Lorg/gotson/komga/domain/persistence/BookRepository;Lorg/gotson/komga/domain/persistence/SeriesRepository;Lorg/gotson/komga/domain/persistence/SeriesCollectionRepository;Lorg/gotson/komga/domain/persistence/ReadListRepository;Lorg/gotson/komga/domain/persistence/SidecarRepository;Lio/micrometer/core/instrument/MeterRegistry;)V", "allEntities", "", "", "bookFileSizeGauge", "Lio/micrometer/core/instrument/MultiGauge;", "getBookFileSizeGauge", "()Lio/micrometer/core/instrument/MultiGauge;", "entitiesMultiTag", "entitiesNoTags", "multiGauges", "", "getMultiGauges", "()Ljava/util/Map;", "noTagGauges", "Ljava/util/concurrent/atomic/AtomicLong;", "getNoTagGauges", "pushAllMetrics", "", "pushMetricsCount", "entity", "pushMetricsOnEvent", "event", "Lorg/gotson/komga/domain/model/DomainEvent;", "komga"})
@SourceDebugExtension(value={"SMAP\nMetricsPublisherController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetricsPublisherController.kt\norg/gotson/komga/interfaces/scheduler/MetricsPublisherController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,128:1\n1271#2,2:129\n1285#2,4:131\n1271#2,2:135\n1285#2,4:137\n1855#2,2:141\n1855#2,2:143\n1855#2,2:145\n125#3:147\n152#3,3:148\n125#3:151\n152#3,3:152\n125#3:155\n152#3,3:156\n125#3:159\n152#3,3:160\n*S KotlinDebug\n*F\n+ 1 MetricsPublisherController.kt\norg/gotson/komga/interfaces/scheduler/MetricsPublisherController\n*L\n65#1:129,2\n65#1:131,4\n74#1:135,2\n74#1:137,4\n94#1:141,2\n99#1:143,2\n112#1:145,2\n121#1:147\n121#1:148,3\n122#1:151\n122#1:152,3\n123#1:155\n123#1:156,3\n124#1:159\n124#1:160,3\n*E\n"})
public class MetricsPublisherController {
    @NotNull
    private final LibraryRepository libraryRepository;
    @NotNull
    private final BookRepository bookRepository;
    @NotNull
    private final SeriesRepository seriesRepository;
    @NotNull
    private final SeriesCollectionRepository collectionRepository;
    @NotNull
    private final ReadListRepository readListRepository;
    @NotNull
    private final SidecarRepository sidecarRepository;
    @NotNull
    private final MeterRegistry meterRegistry;
    @NotNull
    private final List<String> entitiesMultiTag;
    @NotNull
    private final List<String> entitiesNoTags;
    @NotNull
    private final List<String> allEntities;
    @NotNull
    private final Map<String, MultiGauge> multiGauges;
    @NotNull
    private final Map<String, AtomicLong> noTagGauges;
    @NotNull
    private final MultiGauge bookFileSizeGauge;

    public MetricsPublisherController(@NotNull LibraryRepository libraryRepository, @NotNull BookRepository bookRepository, @NotNull SeriesRepository seriesRepository, @NotNull SeriesCollectionRepository collectionRepository, @NotNull ReadListRepository readListRepository, @NotNull SidecarRepository sidecarRepository, @NotNull MeterRegistry meterRegistry) {
        Object object;
        String entity;
        Map map;
        Object t;
        Iterable $this$associateWith$iv;
        Intrinsics.checkNotNullParameter((Object)libraryRepository, (String)"libraryRepository");
        Intrinsics.checkNotNullParameter((Object)bookRepository, (String)"bookRepository");
        Intrinsics.checkNotNullParameter((Object)seriesRepository, (String)"seriesRepository");
        Intrinsics.checkNotNullParameter((Object)collectionRepository, (String)"collectionRepository");
        Intrinsics.checkNotNullParameter((Object)readListRepository, (String)"readListRepository");
        Intrinsics.checkNotNullParameter((Object)sidecarRepository, (String)"sidecarRepository");
        Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"meterRegistry");
        this.libraryRepository = libraryRepository;
        this.bookRepository = bookRepository;
        this.seriesRepository = seriesRepository;
        this.collectionRepository = collectionRepository;
        this.readListRepository = readListRepository;
        this.sidecarRepository = sidecarRepository;
        this.meterRegistry = meterRegistry;
        Timer.builder((String)"komga.tasks.execution").description("Task execution time").register(this.meterRegistry);
        Counter.builder((String)"komga.tasks.failure").description("Count of failed tasks").register(this.meterRegistry);
        Object object2 = new String[]{"series", "books", "books.filesize", "sidecars"};
        this.entitiesMultiTag = CollectionsKt.listOf((Object[])object2);
        object2 = new String[]{"libraries", "collections", "readlists"};
        this.entitiesNoTags = CollectionsKt.listOf((Object[])object2);
        this.allEntities = CollectionsKt.plus((Collection)this.entitiesMultiTag, (Iterable)this.entitiesNoTags);
        object2 = this.entitiesMultiTag;
        MetricsPublisherController metricsPublisherController = this;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            String string = (String)element$iv$iv;
            t = element$iv$iv;
            map = result$iv;
            boolean bl = false;
            object = MultiGauge.builder((String)("komga." + entity)).description("The number of " + entity).baseUnit("count").register(this.meterRegistry);
            map.put(t, object);
        }
        metricsPublisherController.multiGauges = result$iv;
        $this$associateWith$iv = this.entitiesNoTags;
        metricsPublisherController = this;
        $i$f$associateWith = false;
        result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        $this$associateWithTo$iv$iv = $this$associateWith$iv;
        $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            AtomicLong atomicLong;
            entity = (String)element$iv$iv;
            t = element$iv$iv;
            map = result$iv;
            boolean bl = false;
            AtomicLong value = atomicLong = new AtomicLong(0L);
            boolean bl2 = false;
            Gauge.builder((String)("komga." + entity), (Object)value, arg_0 -> MetricsPublisherController.noTagGauges$lambda$3$lambda$2$lambda$1(value, arg_0)).description("The number of " + entity).baseUnit("count").register(this.meterRegistry);
            object = atomicLong;
            map.put(t, object);
        }
        metricsPublisherController.noTagGauges = result$iv;
        MultiGauge multiGauge = MultiGauge.builder((String)"komga.books.filesize").description("The cumulated filesize of books").baseUnit("bytes").register(this.meterRegistry);
        Intrinsics.checkNotNullExpressionValue((Object)multiGauge, (String)"register(...)");
        this.bookFileSizeGauge = multiGauge;
    }

    @NotNull
    public Map<String, MultiGauge> getMultiGauges() {
        return this.multiGauges;
    }

    @NotNull
    public Map<String, AtomicLong> getNoTagGauges() {
        return this.noTagGauges;
    }

    @NotNull
    public MultiGauge getBookFileSizeGauge() {
        return this.bookFileSizeGauge;
    }

    @EventListener
    private void pushMetricsOnEvent(DomainEvent event) {
        block5: {
            DomainEvent domainEvent;
            block10: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block4: {
                                    domainEvent = event;
                                    if (!(domainEvent instanceof DomainEvent.LibraryScanned)) break block4;
                                    Iterable $this$forEach$iv = this.entitiesMultiTag;
                                    boolean $i$f$forEach = false;
                                    for (Object element$iv : $this$forEach$iv) {
                                        String it = (String)element$iv;
                                        boolean bl = false;
                                        this.pushMetricsCount(it);
                                    }
                                    break block5;
                                }
                                if (!(domainEvent instanceof DomainEvent.LibraryAdded)) break block6;
                                AtomicLong atomicLong = (AtomicLong)this.getNoTagGauges().get("libraries");
                                if (atomicLong == null) break block5;
                                atomicLong.incrementAndGet();
                                break block5;
                            }
                            if (!(domainEvent instanceof DomainEvent.LibraryDeleted)) break block7;
                            AtomicLong atomicLong = (AtomicLong)this.getNoTagGauges().get("libraries");
                            if (atomicLong != null) {
                                atomicLong.decrementAndGet();
                            }
                            Iterable $this$forEach$iv = this.entitiesMultiTag;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                String it = (String)element$iv;
                                boolean bl = false;
                                this.pushMetricsCount(it);
                            }
                            break block5;
                        }
                        if (!(domainEvent instanceof DomainEvent.CollectionAdded)) break block8;
                        AtomicLong atomicLong = (AtomicLong)this.getNoTagGauges().get("collections");
                        if (atomicLong == null) break block5;
                        atomicLong.incrementAndGet();
                        break block5;
                    }
                    if (!(domainEvent instanceof DomainEvent.CollectionDeleted)) break block9;
                    AtomicLong atomicLong = (AtomicLong)this.getNoTagGauges().get("collections");
                    if (atomicLong == null) break block5;
                    atomicLong.decrementAndGet();
                    break block5;
                }
                if (!(domainEvent instanceof DomainEvent.ReadListAdded)) break block10;
                AtomicLong atomicLong = (AtomicLong)this.getNoTagGauges().get("readlists");
                if (atomicLong == null) break block5;
                atomicLong.incrementAndGet();
                break block5;
            }
            if (!(domainEvent instanceof DomainEvent.ReadListDeleted)) break block5;
            AtomicLong atomicLong = (AtomicLong)this.getNoTagGauges().get("readlists");
            if (atomicLong != null) {
                atomicLong.decrementAndGet();
            }
        }
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void pushAllMetrics() {
        Iterable $this$forEach$iv = this.allEntities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.pushMetricsCount(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void pushMetricsCount(String entity) {
        switch (entity) {
            case "libraries": {
                AtomicLong atomicLong = (AtomicLong)this.getNoTagGauges().get("libraries");
                if (atomicLong != null) {
                    atomicLong.set(this.libraryRepository.count());
                }
                break;
            }
            case "collections": {
                AtomicLong atomicLong = (AtomicLong)this.getNoTagGauges().get("collections");
                if (atomicLong != null) {
                    atomicLong.set(this.collectionRepository.count());
                }
                break;
            }
            case "readlists": {
                AtomicLong atomicLong = (AtomicLong)this.getNoTagGauges().get("readlists");
                if (atomicLong != null) {
                    atomicLong.set(this.readListRepository.count());
                }
                break;
            }
            case "series": {
                MultiGauge multiGauge = (MultiGauge)this.getMultiGauges().get("series");
                if (multiGauge != null) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Map map = this.seriesRepository.countGroupedByLibraryId();
                    MultiGauge multiGauge2 = multiGauge;
                    boolean $i$f$map = false;
                    void var6_15 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList($this$map$iv.size());
                    boolean $i$f$mapTo = false;
                    Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        void it;
                        Map.Entry item$iv$iv;
                        Map.Entry entry = item$iv$iv = iterator.next();
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(MultiGauge.Row.of((Tags)Tags.of((String)"library", (String)((String)it.getKey())), (Number)((Number)it.getValue())));
                    }
                    multiGauge2.register((Iterable)((List)destination$iv$iv), true);
                }
                break;
            }
            case "books": {
                MultiGauge multiGauge = (MultiGauge)this.getMultiGauges().get("books");
                if (multiGauge != null) {
                    Map $this$map$iv = this.bookRepository.countGroupedByLibraryId();
                    MultiGauge multiGauge3 = multiGauge;
                    boolean $i$f$map2 = false;
                    Map $this$mapTo$iv$iv = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList($this$map$iv.size());
                    boolean $i$f$mapTo2 = false;
                    Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry item$iv$iv2;
                        Map.Entry it = item$iv$iv2 = iterator.next();
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(MultiGauge.Row.of((Tags)Tags.of((String)"library", (String)((String)it.getKey())), (Number)((Number)it.getValue())));
                    }
                    multiGauge3.register((Iterable)((List)destination$iv$iv), true);
                }
                break;
            }
            case "books.filesize": {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Map map = this.bookRepository.getFilesizeGroupedByLibraryId();
                MultiGauge multiGauge = this.getBookFileSizeGauge();
                boolean $i$f$map = false;
                void $i$f$map2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator $i$f$mapTo2 = $this$mapTo$iv$iv.entrySet().iterator();
                while ($i$f$mapTo2.hasNext()) {
                    void it;
                    Map.Entry item$iv$iv;
                    Map.Entry item$iv$iv2 = item$iv$iv = $i$f$mapTo2.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(MultiGauge.Row.of((Tags)Tags.of((String)"library", (String)((String)it.getKey())), (Number)((Number)it.getValue())));
                }
                multiGauge.register((Iterable)((List)destination$iv$iv), true);
                break;
            }
            case "sidecars": {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                MultiGauge multiGauge = (MultiGauge)this.getMultiGauges().get("sidecars");
                if (multiGauge == null) break;
                Map $i$f$map = this.sidecarRepository.countGroupedByLibraryId();
                MultiGauge multiGauge4 = multiGauge;
                boolean $i$f$map3 = false;
                void destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    void it;
                    Map.Entry item$iv$iv;
                    Map.Entry bl = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(MultiGauge.Row.of((Tags)Tags.of((String)"library", (String)((String)it.getKey())), (Number)((Number)it.getValue())));
                }
                multiGauge4.register((Iterable)((List)destination$iv$iv2), true);
                break;
            }
        }
    }

    private static final double noTagGauges$lambda$3$lambda$2$lambda$1(AtomicLong $value, AtomicLong it) {
        Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
        return $value.get();
    }
}

