/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.scheduler;

import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gotson.komga.application.tasks.TaskEmitter;
import org.gotson.komga.infrastructure.search.LuceneEntity;
import org.gotson.komga.infrastructure.search.LuceneHelper;
import org.gotson.komga.interfaces.scheduler.SearchIndexController;
import org.gotson.komga.interfaces.scheduler.SearchIndexControllerKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Profile;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Profile(value={"!test"})
@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/gotson/komga/interfaces/scheduler/SearchIndexController;", "", "luceneHelper", "Lorg/gotson/komga/infrastructure/search/LuceneHelper;", "taskEmitter", "Lorg/gotson/komga/application/tasks/TaskEmitter;", "(Lorg/gotson/komga/infrastructure/search/LuceneHelper;Lorg/gotson/komga/application/tasks/TaskEmitter;)V", "createIndexIfNoneExist", "", "komga"})
public class SearchIndexController {
    @NotNull
    private final LuceneHelper luceneHelper;
    @NotNull
    private final TaskEmitter taskEmitter;

    public SearchIndexController(@NotNull LuceneHelper luceneHelper, @NotNull TaskEmitter taskEmitter) {
        Intrinsics.checkNotNullParameter((Object)luceneHelper, (String)"luceneHelper");
        Intrinsics.checkNotNullParameter((Object)taskEmitter, (String)"taskEmitter");
        this.luceneHelper = luceneHelper;
        this.taskEmitter = taskEmitter;
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void createIndexIfNoneExist() {
        if (!this.luceneHelper.indexExists()) {
            SearchIndexControllerKt.access$getLogger$p().info((Function0)createIndexIfNoneExist.1.INSTANCE);
            TaskEmitter.rebuildIndex$default((TaskEmitter)this.taskEmitter, (int)8, null, (int)2, null);
        } else {
            int indexVersion = this.luceneHelper.getIndexVersion();
            SearchIndexControllerKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
            if (indexVersion < 6) {
                this.taskEmitter.upgradeIndex(8);
                this.taskEmitter.rebuildIndex(8, SetsKt.setOf((Object)LuceneEntity.Series));
            } else if (indexVersion < 8) {
                this.taskEmitter.rebuildIndex(8, SetsKt.setOf((Object)LuceneEntity.Series));
            }
        }
    }
}

