/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.application.tasks;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.application.tasks.Task;
import org.gotson.komga.application.tasks.TaskAddedEvent;
import org.gotson.komga.application.tasks.TaskHandler;
import org.gotson.komga.application.tasks.TaskProcessorKt;
import org.gotson.komga.application.tasks.TasksRepository;
import org.gotson.komga.infrastructure.configuration.KomgaSettingsProvider;
import org.gotson.komga.infrastructure.configuration.SettingChangedEvent;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.task.ThreadPoolTaskExecutorBuilder;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0017J\b\u0010\u0019\u001a\u00020\u0017H\u0017J\b\u0010\u001a\u001a\u00020\u0017H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001b"}, d2={"Lorg/gotson/komga/application/tasks/TaskProcessor;", "Lorg/springframework/beans/factory/InitializingBean;", "tasksRepository", "Lorg/gotson/komga/application/tasks/TasksRepository;", "taskHandler", "Lorg/gotson/komga/application/tasks/TaskHandler;", "settingsProvider", "Lorg/gotson/komga/infrastructure/configuration/KomgaSettingsProvider;", "taskExecutorBuilder", "Lorg/springframework/boot/task/ThreadPoolTaskExecutorBuilder;", "<init>", "(Lorg/gotson/komga/application/tasks/TasksRepository;Lorg/gotson/komga/application/tasks/TaskHandler;Lorg/gotson/komga/infrastructure/configuration/KomgaSettingsProvider;Lorg/springframework/boot/task/ThreadPoolTaskExecutorBuilder;)V", "executor", "Lorg/springframework/scheduling/concurrent/ThreadPoolTaskExecutor;", "getExecutor", "()Lorg/springframework/scheduling/concurrent/ThreadPoolTaskExecutor;", "processTasks", "", "getProcessTasks", "()Z", "setProcessTasks", "(Z)V", "afterPropertiesSet", "", "taskPoolSizeChanged", "processAvailableTask", "takeAndProcess", "komga"})
@SourceDebugExtension(value={"SMAP\nTaskProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskProcessor.kt\norg/gotson/komga/application/tasks/TaskProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1#2:75\n*E\n"})
public class TaskProcessor
implements InitializingBean {
    @NotNull
    private final TasksRepository tasksRepository;
    @NotNull
    private final TaskHandler taskHandler;
    @NotNull
    private final KomgaSettingsProvider settingsProvider;
    @NotNull
    private final ThreadPoolTaskExecutor executor;
    private boolean processTasks;

    /*
     * WARNING - void declaration
     */
    public TaskProcessor(@NotNull TasksRepository tasksRepository, @NotNull TaskHandler taskHandler, @NotNull KomgaSettingsProvider settingsProvider, @NotNull ThreadPoolTaskExecutorBuilder taskExecutorBuilder) {
        void $this$executor_u24lambda_u240;
        ThreadPoolTaskExecutor threadPoolTaskExecutor;
        Intrinsics.checkNotNullParameter((Object)tasksRepository, (String)"tasksRepository");
        Intrinsics.checkNotNullParameter((Object)taskHandler, (String)"taskHandler");
        Intrinsics.checkNotNullParameter((Object)settingsProvider, (String)"settingsProvider");
        Intrinsics.checkNotNullParameter((Object)taskExecutorBuilder, (String)"taskExecutorBuilder");
        this.tasksRepository = tasksRepository;
        this.taskHandler = taskHandler;
        this.settingsProvider = settingsProvider;
        ThreadPoolTaskExecutor threadPoolTaskExecutor2 = threadPoolTaskExecutor = taskExecutorBuilder.threadNamePrefix("taskProcessor-").corePoolSize(this.settingsProvider.getTaskPoolSize()).build();
        TaskProcessor taskProcessor = this;
        boolean bl = false;
        $this$executor_u24lambda_u240.initialize();
        ThreadPoolTaskExecutor threadPoolTaskExecutor3 = threadPoolTaskExecutor;
        Intrinsics.checkNotNullExpressionValue((Object)threadPoolTaskExecutor3, (String)"apply(...)");
        taskProcessor.executor = threadPoolTaskExecutor3;
    }

    @NotNull
    public ThreadPoolTaskExecutor getExecutor() {
        return this.executor;
    }

    public boolean getProcessTasks() {
        return this.processTasks;
    }

    public void setProcessTasks(boolean bl) {
        this.processTasks = bl;
    }

    public void afterPropertiesSet() {
        int disowned = this.tasksRepository.disown();
        if (disowned > 0) {
            TaskProcessorKt.access$getLogger$p().info(() -> TaskProcessor.afterPropertiesSet$lambda$1(disowned));
        }
        this.setProcessTasks(true);
    }

    @EventListener(value={SettingChangedEvent.TaskPoolSize.class})
    public void taskPoolSizeChanged() {
        this.getExecutor().setCorePoolSize(this.settingsProvider.getTaskPoolSize());
    }

    @EventListener(value={TaskAddedEvent.class, ApplicationReadyEvent.class})
    public void processAvailableTask() {
        if (this.getProcessTasks()) {
            TaskProcessorKt.access$getLogger$p().debug(() -> TaskProcessor.processAvailableTask$lambda$2(this));
            if (this.getExecutor().getCorePoolSize() == 1) {
                this.getExecutor().execute(() -> TaskProcessor.processAvailableTask$lambda$3(this));
            } else {
                while (this.tasksRepository.hasAvailable() && this.getExecutor().getActiveCount() < this.getExecutor().getCorePoolSize()) {
                    this.getExecutor().execute(() -> TaskProcessor.processAvailableTask$lambda$4(this));
                }
            }
        } else {
            TaskProcessorKt.access$getLogger$p().debug(TaskProcessor::processAvailableTask$lambda$5);
        }
    }

    private void takeAndProcess() {
        TaskProcessorKt.access$getLogger$p().debug(TaskProcessor::takeAndProcess$lambda$6);
        Task task = TasksRepository.takeFirst$default((TasksRepository)this.tasksRepository, null, (int)1, null);
        if (task != null) {
            TaskProcessorKt.access$getLogger$p().debug(() -> TaskProcessor.takeAndProcess$lambda$7(task));
            this.taskHandler.handleTask(task);
            TaskProcessorKt.access$getLogger$p().debug(() -> TaskProcessor.takeAndProcess$lambda$8(task));
            this.tasksRepository.delete(task.getUniqueId());
            this.processAvailableTask();
        } else {
            TaskProcessorKt.access$getLogger$p().debug(TaskProcessor::takeAndProcess$lambda$9);
        }
    }

    private static final Object afterPropertiesSet$lambda$1(int $disowned) {
        return "Reset " + $disowned + " tasks that were not finished";
    }

    private static final Object processAvailableTask$lambda$2(TaskProcessor this$0) {
        return "Active count: " + this$0.getExecutor().getActiveCount() + ", Core Pool Size: " + this$0.getExecutor().getCorePoolSize() + ", Pool Size: " + this$0.getExecutor().getPoolSize();
    }

    private static final void processAvailableTask$lambda$3(TaskProcessor this$0) {
        this$0.takeAndProcess();
    }

    private static final void processAvailableTask$lambda$4(TaskProcessor this$0) {
        this$0.takeAndProcess();
    }

    private static final Object processAvailableTask$lambda$5() {
        return "Not processing tasks";
    }

    private static final Object takeAndProcess$lambda$6() {
        return "Try to process first available task";
    }

    private static final Object takeAndProcess$lambda$7(Task $task) {
        return "Found task to process: " + $task;
    }

    private static final Object takeAndProcess$lambda$8(Task $task) {
        return "Task processed, remove it from the queue: " + $task;
    }

    private static final Object takeAndProcess$lambda$9() {
        return "No available task found";
    }
}

