/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.domain.service;

import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.application.scheduler.LibraryScanScheduler;
import org.gotson.komga.application.tasks.TaskEmitter;
import org.gotson.komga.domain.model.DirectoryNotFoundException;
import org.gotson.komga.domain.model.DomainEvent;
import org.gotson.komga.domain.model.DuplicateNameException;
import org.gotson.komga.domain.model.Library;
import org.gotson.komga.domain.model.PathContainedInPath;
import org.gotson.komga.domain.persistence.LibraryRepository;
import org.gotson.komga.domain.persistence.SeriesRepository;
import org.gotson.komga.domain.persistence.SidecarRepository;
import org.gotson.komga.domain.service.LibraryLifecycleKt;
import org.gotson.komga.domain.service.SeriesLifecycle;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionTemplate;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0015H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0015H\u0012J\u001e\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u00152\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u001fH\u0012J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/gotson/komga/domain/service/LibraryLifecycle;", "", "libraryRepository", "Lorg/gotson/komga/domain/persistence/LibraryRepository;", "seriesLifecycle", "Lorg/gotson/komga/domain/service/SeriesLifecycle;", "seriesRepository", "Lorg/gotson/komga/domain/persistence/SeriesRepository;", "sidecarRepository", "Lorg/gotson/komga/domain/persistence/SidecarRepository;", "taskEmitter", "Lorg/gotson/komga/application/tasks/TaskEmitter;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "transactionTemplate", "Lorg/springframework/transaction/support/TransactionTemplate;", "libraryScanScheduler", "Lorg/gotson/komga/application/scheduler/LibraryScanScheduler;", "<init>", "(Lorg/gotson/komga/domain/persistence/LibraryRepository;Lorg/gotson/komga/domain/service/SeriesLifecycle;Lorg/gotson/komga/domain/persistence/SeriesRepository;Lorg/gotson/komga/domain/persistence/SidecarRepository;Lorg/gotson/komga/application/tasks/TaskEmitter;Lorg/springframework/context/ApplicationEventPublisher;Lorg/springframework/transaction/support/TransactionTemplate;Lorg/gotson/komga/application/scheduler/LibraryScanScheduler;)V", "addLibrary", "Lorg/gotson/komga/domain/model/Library;", "library", "updateLibrary", "", "toUpdate", "checkLibraryShouldRescan", "", "existing", "updated", "checkLibraryValidity", "", "deleteLibrary", "komga"})
@SourceDebugExtension(value={"SMAP\nLibraryLifecycle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryLifecycle.kt\norg/gotson/komga/domain/service/LibraryLifecycle\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n774#2:134\n865#2,2:135\n230#2,2:137\n1563#2:139\n1634#2,3:140\n1869#2,2:143\n*S KotlinDebug\n*F\n+ 1 LibraryLifecycle.kt\norg/gotson/komga/domain/service/LibraryLifecycle\n*L\n58#1:134\n58#1:135,2\n59#1:137,2\n108#1:139\n108#1:140,3\n111#1:143,2\n*E\n"})
public class LibraryLifecycle {
    @NotNull
    private final LibraryRepository libraryRepository;
    @NotNull
    private final SeriesLifecycle seriesLifecycle;
    @NotNull
    private final SeriesRepository seriesRepository;
    @NotNull
    private final SidecarRepository sidecarRepository;
    @NotNull
    private final TaskEmitter taskEmitter;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;
    @NotNull
    private final TransactionTemplate transactionTemplate;
    @NotNull
    private final LibraryScanScheduler libraryScanScheduler;

    public LibraryLifecycle(@NotNull LibraryRepository libraryRepository, @NotNull SeriesLifecycle seriesLifecycle, @NotNull SeriesRepository seriesRepository, @NotNull SidecarRepository sidecarRepository, @NotNull TaskEmitter taskEmitter, @NotNull ApplicationEventPublisher eventPublisher, @NotNull TransactionTemplate transactionTemplate, @NotNull LibraryScanScheduler libraryScanScheduler) {
        Intrinsics.checkNotNullParameter((Object)libraryRepository, (String)"libraryRepository");
        Intrinsics.checkNotNullParameter((Object)seriesLifecycle, (String)"seriesLifecycle");
        Intrinsics.checkNotNullParameter((Object)seriesRepository, (String)"seriesRepository");
        Intrinsics.checkNotNullParameter((Object)sidecarRepository, (String)"sidecarRepository");
        Intrinsics.checkNotNullParameter((Object)taskEmitter, (String)"taskEmitter");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)transactionTemplate, (String)"transactionTemplate");
        Intrinsics.checkNotNullParameter((Object)libraryScanScheduler, (String)"libraryScanScheduler");
        this.libraryRepository = libraryRepository;
        this.seriesLifecycle = seriesLifecycle;
        this.seriesRepository = seriesRepository;
        this.sidecarRepository = sidecarRepository;
        this.taskEmitter = taskEmitter;
        this.eventPublisher = eventPublisher;
        this.transactionTemplate = transactionTemplate;
        this.libraryScanScheduler = libraryScanScheduler;
    }

    @NotNull
    public Library addLibrary(@NotNull Library library) throws FileNotFoundException, DirectoryNotFoundException, DuplicateNameException, PathContainedInPath {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        LibraryLifecycleKt.access$getLogger$p().info(() -> LibraryLifecycle.addLibrary$lambda$0(library));
        Collection existing = this.libraryRepository.findAll();
        this.checkLibraryValidity(library, existing);
        this.libraryRepository.insert(library);
        TaskEmitter.scanLibrary$default((TaskEmitter)this.taskEmitter, (String)library.getId(), (boolean)false, (int)0, (int)6, null);
        this.eventPublisher.publishEvent((Object)new DomainEvent.LibraryAdded(library));
        return this.libraryRepository.findById(library.getId());
    }

    /*
     * WARNING - void declaration
     */
    public void updateLibrary(@NotNull Library toUpdate) {
        Object element$iv2;
        List otherLibraries;
        block9: {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)toUpdate, (String)"toUpdate");
            LibraryLifecycleKt.access$getLogger$p().info(() -> LibraryLifecycle.updateLibrary$lambda$1(toUpdate));
            Collection libraries = this.libraryRepository.findAll();
            Iterable $this$filter$iv = libraries;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Library it = (Library)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it.getId(), (Object)toUpdate.getId()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            otherLibraries = (List)destination$iv$iv;
            Iterable $this$first$iv = libraries;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                Library it = (Library)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)toUpdate.getId())) continue;
                break block9;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Library current = (Library)element$iv2;
        this.checkLibraryValidity(toUpdate, (Collection)otherLibraries);
        this.libraryRepository.update(toUpdate);
        if (current.getScanInterval() != toUpdate.getScanInterval()) {
            this.libraryScanScheduler.scheduleScan(toUpdate);
        }
        if (this.checkLibraryShouldRescan(current, toUpdate)) {
            TaskEmitter.scanLibrary$default((TaskEmitter)this.taskEmitter, (String)toUpdate.getId(), (boolean)false, (int)0, (int)6, null);
        }
        if (toUpdate.getHashFiles() && !current.getHashFiles()) {
            this.taskEmitter.hashBooksWithoutHash(toUpdate);
        }
        if (toUpdate.getHashKoreader() && !current.getHashKoreader()) {
            this.taskEmitter.hashBooksWithoutHashKoreader(toUpdate);
        }
        if (toUpdate.getHashPages() && !current.getHashPages()) {
            this.taskEmitter.findBooksWithMissingPageHash(toUpdate, 0);
        }
        if (toUpdate.getRepairExtensions() && !current.getRepairExtensions()) {
            this.taskEmitter.repairExtensions(toUpdate, 0);
        }
        if (toUpdate.getConvertToCbz() && !current.getConvertToCbz()) {
            this.taskEmitter.findBooksToConvert(toUpdate, 0);
        }
        this.eventPublisher.publishEvent((Object)new DomainEvent.LibraryUpdated(toUpdate));
    }

    private boolean checkLibraryShouldRescan(Library existing, Library updated) {
        if (!Intrinsics.areEqual((Object)existing.getRoot(), (Object)updated.getRoot())) {
            return true;
        }
        if (!Intrinsics.areEqual((Object)existing.getOneshotsDirectory(), (Object)updated.getOneshotsDirectory())) {
            return true;
        }
        if (existing.getScanCbx() != updated.getScanCbx()) {
            return true;
        }
        if (existing.getScanPdf() != updated.getScanPdf()) {
            return true;
        }
        if (existing.getScanEpub() != updated.getScanEpub()) {
            return true;
        }
        if (existing.getScanForceModifiedTime() != updated.getScanForceModifiedTime()) {
            return true;
        }
        return !Intrinsics.areEqual((Object)existing.getScanDirectoryExclusions(), (Object)updated.getScanDirectoryExclusions());
    }

    /*
     * WARNING - void declaration
     */
    private void checkLibraryValidity(Library library, Collection<Library> existing) {
        void $this$mapTo$iv$iv;
        if (!Files.exists(library.getPath(), new LinkOption[0])) {
            throw new FileNotFoundException("Library root folder does not exist: " + library.getRoot());
        }
        if (!Files.isDirectory(library.getPath(), new LinkOption[0])) {
            throw new DirectoryNotFoundException("Library root folder is not a folder: " + library.getRoot(), null, 2, null);
        }
        Iterable $this$map$iv = existing;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Library library2 = (Library)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        if (((List)destination$iv$iv).contains(library.getName())) {
            throw new DuplicateNameException("Library name already exists", null, 2, null);
        }
        Iterable $this$forEach$iv = existing;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Library it = (Library)element$iv;
            boolean bl = false;
            if (library.getPath().startsWith(it.getPath())) {
                throw new PathContainedInPath("Library path " + library.getPath() + " is a child of existing library " + it.getName() + ": " + it.getPath(), null, 2, null);
            }
            if (!it.getPath().startsWith(library.getPath())) continue;
            throw new PathContainedInPath("Library path " + library.getPath() + " is a parent of existing library " + it.getName() + ": " + it.getPath(), null, 2, null);
        }
    }

    public void deleteLibrary(@NotNull Library library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        LibraryLifecycleKt.access$getLogger$p().info(() -> LibraryLifecycle.deleteLibrary$lambda$6(library));
        Collection series = this.seriesRepository.findAllByLibraryId(library.getId());
        this.transactionTemplate.executeWithoutResult(arg_0 -> LibraryLifecycle.deleteLibrary$lambda$7(this, series, library, arg_0));
        this.eventPublisher.publishEvent((Object)new DomainEvent.LibraryDeleted(library));
    }

    private static final Object addLibrary$lambda$0(Library $library) {
        return "Adding new library: " + $library.getName() + " with root folder: " + $library.getRoot();
    }

    private static final Object updateLibrary$lambda$1(Library $toUpdate) {
        return "Updating library: " + $toUpdate.getId();
    }

    private static final Object deleteLibrary$lambda$6(Library $library) {
        return "Deleting library: " + $library;
    }

    private static final void deleteLibrary$lambda$7(LibraryLifecycle this$0, Collection $series, Library $library, TransactionStatus it) {
        this$0.seriesLifecycle.deleteMany($series);
        this$0.sidecarRepository.deleteByLibraryId($library.getId());
        this$0.libraryRepository.delete($library.getId());
    }
}

