/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.hash;

import com.appmattus.crypto.Algorithm;
import com.appmattus.crypto.Digest;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UByteArray;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.text.UStringsKt;
import org.gotson.komga.infrastructure.hash.HasherKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\f\u0010\u000b\u001a\u00020\u0005*\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/gotson/komga/infrastructure/hash/Hasher;", "", "<init>", "()V", "computeHash", "", "path", "Ljava/nio/file/Path;", "string", "stream", "Ljava/io/InputStream;", "toHexString", "", "komga"})
public class Hasher {
    @NotNull
    public String computeHash(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        HasherKt.access$getLogger$p().debug(() -> Hasher.computeHash$lambda$0(path));
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        return this.computeHash(inputStream);
    }

    @NotNull
    public String computeHash(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        String string2 = string;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return this.computeHash((InputStream)new ByteArrayInputStream(byArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String computeHash(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Digest hash = new Algorithm.XXH3_128.Seeded(0L).createDigest();
        Closeable closeable = stream;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            byte[] buffer = new byte[8192];
            int len = 0;
            do {
                if ((len = it.read(buffer)) < 0) continue;
                hash.update(buffer, 0, len);
            } while (len >= 0);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return this.toHexString(hash.digest());
    }

    @NotNull
    public String toHexString(@NotNull byte[] $this$toHexString) {
        Intrinsics.checkNotNullParameter((Object)$this$toHexString, (String)"<this>");
        return CollectionsKt.joinToString$default((Iterable)((Iterable)UByteArray.box-impl((byte[])UByteArray.constructor-impl((byte[])$this$toHexString))), (CharSequence)"", null, null, (int)0, null, Hasher::toHexString$lambda$2, (int)30, null);
    }

    private static final Object computeHash$lambda$0(Path $path) {
        return "Hashing: " + $path;
    }

    private static final CharSequence toHexString$lambda$2(UByte it) {
        return StringsKt.padStart((String)UStringsKt.toString-LxnNnR4((byte)it.unbox-impl(), (int)16), (int)2, (char)'0');
    }
}

