/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.jooq.main;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.gotson.komga.domain.model.BookPageNumbered;
import org.gotson.komga.domain.model.PageHashKnown;
import org.gotson.komga.domain.model.PageHashMatch;
import org.gotson.komga.domain.model.PageHashUnknown;
import org.gotson.komga.domain.persistence.PageHashRepository;
import org.gotson.komga.infrastructure.jooq.SplitDslDaoBase;
import org.gotson.komga.infrastructure.jooq.UtilsKt;
import org.gotson.komga.infrastructure.jooq.main.PageHashDao;
import org.gotson.komga.infrastructure.jooq.main.PageHashDaoKt;
import org.gotson.komga.jooq.main.Tables;
import org.gotson.komga.jooq.main.tables.Book;
import org.gotson.komga.jooq.main.tables.MediaPage;
import org.gotson.komga.jooq.main.tables.PageHash;
import org.gotson.komga.jooq.main.tables.PageHashThumbnail;
import org.gotson.komga.jooq.main.tables.records.PageHashRecord;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.AggregateFunction;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Record1;
import org.jooq.RecordMapper;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectHavingConditionStep;
import org.jooq.SelectHavingStep;
import org.jooq.SelectOnConditionStep;
import org.jooq.SelectSeekStepN;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0013H\u0016J&\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u001b2\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u001b2\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 H\u0016J4\u0010%\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0&0\u00122\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001d2\b\u0010(\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u0019\u001a\u00020\u0013H\u0016J\u001a\u0010+\u001a\u00020,2\u0006\u0010\u0019\u001a\u00020\u00182\b\u0010-\u001a\u0004\u0018\u00010*H\u0017J\u0010\u0010.\u001a\u00020,2\u0006\u0010\u0019\u001a\u00020\u0018H\u0016R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \n*\u0004\u0018\u00010\f0\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \n*\u0004\u0018\u00010\u000e0\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \n*\u0004\u0018\u00010\u00100\u0010X\u0092\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u0011\u001a6\u0012\u0004\u0012\u00020\u0013\u0012,\u0012*\u0012\u000e\b\u0001\u0012\n \n*\u0004\u0018\u00010\u00150\u0015 \n*\u0014\u0012\u000e\b\u0001\u0012\n \n*\u0004\u0018\u00010\u00150\u0015\u0018\u00010\u00140\u00140\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u0016\u001a6\u0012\u0004\u0012\u00020\u0013\u0012,\u0012*\u0012\u000e\b\u0001\u0012\n \n*\u0004\u0018\u00010\u00150\u0015 \n*\u0014\u0012\u000e\b\u0001\u0012\n \n*\u0004\u0018\u00010\u00150\u0015\u0018\u00010\u00140\u00140\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/gotson/komga/infrastructure/jooq/main/PageHashDao;", "Lorg/gotson/komga/infrastructure/jooq/SplitDslDaoBase;", "Lorg/gotson/komga/domain/persistence/PageHashRepository;", "dslRW", "Lorg/jooq/DSLContext;", "dslRO", "<init>", "(Lorg/jooq/DSLContext;Lorg/jooq/DSLContext;)V", "p", "Lorg/gotson/komga/jooq/main/tables/MediaPage;", "kotlin.jvm.PlatformType", "b", "Lorg/gotson/komga/jooq/main/tables/Book;", "ph", "Lorg/gotson/komga/jooq/main/tables/PageHash;", "pht", "Lorg/gotson/komga/jooq/main/tables/PageHashThumbnail;", "sortsKnown", "", "", "Lorg/jooq/Field;", "", "sortsUnknown", "findKnown", "Lorg/gotson/komga/domain/model/PageHashKnown;", "pageHash", "findAllKnown", "Lorg/springframework/data/domain/Page;", "actions", "", "Lorg/gotson/komga/domain/model/PageHashKnown$Action;", "pageable", "Lorg/springframework/data/domain/Pageable;", "findAllUnknown", "Lorg/gotson/komga/domain/model/PageHashUnknown;", "findMatchesByHash", "Lorg/gotson/komga/domain/model/PageHashMatch;", "findMatchesByKnownHashAction", "", "Lorg/gotson/komga/domain/model/BookPageNumbered;", "libraryId", "getKnownThumbnail", "", "insert", "", "thumbnail", "update", "komga"})
@SourceDebugExtension(value={"SMAP\nPageHashDao.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PageHashDao.kt\norg/gotson/komga/infrastructure/jooq/main/PageHashDao\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Grouping.kt\nkotlin/collections/GroupingKt__GroupingKt\n*L\n1#1,260:1\n1#2:261\n1550#3:262\n164#4:263\n53#4:264\n80#4,6:265\n*S KotlinDebug\n*F\n+ 1 PageHashDao.kt\norg/gotson/komga/infrastructure/jooq/main/PageHashDao\n*L\n206#1:262\n207#1:263\n207#1:264\n207#1:265,6\n*E\n"})
public class PageHashDao
extends SplitDslDaoBase
implements PageHashRepository {
    private final MediaPage p;
    private final Book b;
    private final PageHash ph;
    private final PageHashThumbnail pht;
    @NotNull
    private final Map<String, Field<? extends Object>> sortsKnown;
    @NotNull
    private final Map<String, Field<? extends Object>> sortsUnknown;

    public PageHashDao(@NotNull DSLContext dslRW, @Qualifier(value="dslContextRO") @NotNull DSLContext dslRO) {
        Intrinsics.checkNotNullParameter((Object)dslRW, (String)"dslRW");
        Intrinsics.checkNotNullParameter((Object)dslRO, (String)"dslRO");
        super(dslRW, dslRO);
        this.p = Tables.MEDIA_PAGE;
        this.b = Tables.BOOK;
        this.ph = Tables.PAGE_HASH;
        this.pht = Tables.PAGE_HASH_THUMBNAIL;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"hash", (Object)this.ph.HASH), TuplesKt.to((Object)"matchCount", (Object)DSL.field((String)"count")), TuplesKt.to((Object)"deleteCount", (Object)this.ph.DELETE_COUNT), TuplesKt.to((Object)"deleteSize", (Object)this.ph.SIZE.times((Field)this.ph.DELETE_COUNT)), TuplesKt.to((Object)"fileSize", (Object)this.ph.SIZE), TuplesKt.to((Object)"createdDate", (Object)this.ph.CREATED_DATE), TuplesKt.to((Object)"lastModifiedDate", (Object)this.ph.LAST_MODIFIED_DATE)};
        this.sortsKnown = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"hash", (Object)this.p.FILE_HASH), TuplesKt.to((Object)"fileSize", (Object)this.p.FILE_SIZE), TuplesKt.to((Object)"matchCount", (Object)DSL.field((String)"count")), TuplesKt.to((Object)"totalSize", (Object)DSL.field((String)"totalSize")), TuplesKt.to((Object)"url", (Object)this.b.URL), TuplesKt.to((Object)"bookId", (Object)this.b.ID), TuplesKt.to((Object)"pageNumber", (Object)this.p.NUMBER)};
        this.sortsUnknown = MapsKt.mapOf((Pair[])pairArray);
    }

    @Nullable
    public PageHashKnown findKnown(@NotNull String pageHash) {
        Intrinsics.checkNotNullParameter((Object)pageHash, (String)"pageHash");
        PageHashRecord pageHashRecord = (PageHashRecord)this.getDslRO().selectFrom((TableLike)this.ph).where(this.ph.HASH.eq((Object)pageHash)).fetchOneInto((Table)this.ph);
        return pageHashRecord != null ? PageHashDaoKt.toDomain$default((PageHashRecord)pageHashRecord, (int)0, (int)1, null) : null;
    }

    @NotNull
    public Page<PageHashKnown> findAllKnown(@Nullable List<? extends PageHashKnown.Action> actions, @NotNull Pageable pageable) {
        SelectSeekStepN selectSeekStepN;
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        DSLContext dSLContext = this.getDslRO();
        Field[] fieldArray = new SpreadBuilder(2);
        fieldArray.addSpread((Object)this.ph.fields());
        fieldArray.add((Object)DSL.count((Field)((Field)this.p.FILE_HASH)).as("count"));
        Field[] $this$findAllKnown_u24lambda_u241 = fieldArray = dSLContext.select((SelectFieldOrAsterisk[])fieldArray.toArray((Object[])new SelectFieldOrAsterisk[fieldArray.size()])).from((TableLike)this.ph).leftJoin((TableLike)this.p).on(this.ph.HASH.eq((Field)this.p.FILE_HASH));
        boolean bl = false;
        List<? extends PageHashKnown.Action> list = actions;
        if (list != null) {
            List<? extends PageHashKnown.Action> it = list;
            boolean bl2 = false;
            $this$findAllKnown_u24lambda_u241.where(this.ph.ACTION.in((Collection)actions));
        }
        Field[] fieldArray2 = fieldArray;
        fieldArray = this.ph.fields();
        SelectHavingStep selectHavingStep = fieldArray2.groupBy((GroupField[])Arrays.copyOf(fieldArray, fieldArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)selectHavingStep, (String)"groupBy(...)");
        SelectHavingStep query = selectHavingStep;
        int count = this.getDslRO().fetchCount((Select)query);
        Sort sort = pageable.getSort();
        Intrinsics.checkNotNullExpressionValue((Object)sort, (String)"getSort(...)");
        List orderBy = UtilsKt.toOrderBy((Sort)sort, (Map)this.sortsKnown);
        SelectSeekStepN $this$findAllKnown_u24lambda_u242 = selectSeekStepN = query.orderBy((Collection)orderBy);
        boolean bl3 = false;
        if (pageable.isPaged()) {
            $this$findAllKnown_u24lambda_u242.limit((Number)pageable.getPageSize()).offset((Number)pageable.getOffset());
        }
        List list2 = selectSeekStepN.fetch().map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"map(...)");
        List items2 = list2;
        selectSeekStepN = !((Collection)orderBy).isEmpty() ? pageable.getSort() : Sort.unsorted();
        Intrinsics.checkNotNull((Object)selectSeekStepN);
        SelectSeekStepN pageSort = selectSeekStepN;
        return (Page)new PageImpl(items2, (Pageable)(pageable.isPaged() ? PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)pageSort) : PageRequest.of((int)0, (int)Math.max(count, 20), (Sort)pageSort)), (long)count);
    }

    @NotNull
    public Page<PageHashUnknown> findAllUnknown(@NotNull Pageable pageable) {
        SelectSeekStepN selectSeekStepN;
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        AggregateFunction aggregateFunction = DSL.count((Field)((Field)this.p.BOOK_ID));
        Intrinsics.checkNotNullExpressionValue((Object)aggregateFunction, (String)"count(...)");
        AggregateFunction bookCount = aggregateFunction;
        GroupField[] groupFieldArray = new GroupField[]{this.p.FILE_HASH};
        SelectHavingConditionStep selectHavingConditionStep = this.getDslRO().select((SelectField)this.p.FILE_HASH, (SelectField)this.p.FILE_SIZE, (SelectField)bookCount.as("count"), (SelectField)bookCount.times((Field)this.p.FILE_SIZE).as("totalSize")).from((TableLike)this.p).where(this.p.FILE_HASH.ne((Object)"")).and(DSL.notExists((Select)((Select)this.getDslRO().selectOne().from((TableLike)this.ph).where(this.ph.HASH.eq((Field)this.p.FILE_HASH))))).groupBy(groupFieldArray).having(DSL.count((Field)((Field)this.p.BOOK_ID)).gt((Object)1));
        Intrinsics.checkNotNullExpressionValue((Object)selectHavingConditionStep, (String)"having(...)");
        SelectHavingConditionStep query = selectHavingConditionStep;
        int count = this.getDslRO().fetchCount((Select)query);
        Sort sort = pageable.getSort();
        Intrinsics.checkNotNullExpressionValue((Object)sort, (String)"getSort(...)");
        List orderBy = UtilsKt.toOrderBy((Sort)sort, (Map)this.sortsUnknown);
        SelectSeekStepN $this$findAllUnknown_u24lambda_u243 = selectSeekStepN = query.orderBy((Collection)orderBy);
        boolean bl = false;
        if (pageable.isPaged()) {
            $this$findAllUnknown_u24lambda_u243.limit((Number)pageable.getPageSize()).offset((Number)pageable.getOffset());
        }
        List list = selectSeekStepN.fetch((RecordMapper)findAllUnknown.items.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        List items2 = list;
        selectSeekStepN = !((Collection)orderBy).isEmpty() ? pageable.getSort() : Sort.unsorted();
        Intrinsics.checkNotNull((Object)selectSeekStepN);
        SelectSeekStepN pageSort = selectSeekStepN;
        return (Page)new PageImpl(items2, (Pageable)(pageable.isPaged() ? PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)pageSort) : PageRequest.of((int)0, (int)Math.max(count, 20), (Sort)pageSort)), (long)count);
    }

    @NotNull
    public Page<PageHashMatch> findMatchesByHash(@NotNull String pageHash, @NotNull Pageable pageable) {
        SelectSeekStepN selectSeekStepN;
        Intrinsics.checkNotNullParameter((Object)pageHash, (String)"pageHash");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        SelectConditionStep selectConditionStep = this.getDslRO().select((SelectField)this.p.BOOK_ID, (SelectField)this.b.URL, (SelectField)this.p.NUMBER, (SelectField)this.p.FILE_NAME, (SelectField)this.p.FILE_SIZE, (SelectField)this.p.MEDIA_TYPE).from((TableLike)this.p).leftJoin((TableLike)this.b).on(this.p.BOOK_ID.eq((Field)this.b.ID)).where(this.p.FILE_HASH.eq((Object)pageHash));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"where(...)");
        SelectConditionStep query = selectConditionStep;
        int count = this.getDslRO().fetchCount((Select)query);
        Sort sort = pageable.getSort();
        Intrinsics.checkNotNullExpressionValue((Object)sort, (String)"getSort(...)");
        List orderBy = UtilsKt.toOrderBy((Sort)sort, (Map)this.sortsUnknown);
        SelectSeekStepN $this$findMatchesByHash_u24lambda_u244 = selectSeekStepN = query.orderBy((Collection)orderBy);
        boolean bl = false;
        if (pageable.isPaged()) {
            $this$findMatchesByHash_u24lambda_u244.limit((Number)pageable.getPageSize()).offset((Number)pageable.getOffset());
        }
        List list = selectSeekStepN.fetch((RecordMapper)findMatchesByHash.items.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        List items2 = list;
        selectSeekStepN = !((Collection)orderBy).isEmpty() ? pageable.getSort() : Sort.unsorted();
        Intrinsics.checkNotNull((Object)selectSeekStepN);
        SelectSeekStepN pageSort = selectSeekStepN;
        return (Page)new PageImpl(items2, (Pageable)(pageable.isPaged() ? PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)pageSort) : PageRequest.of((int)0, (int)Math.max(count, 20), (Sort)pageSort)), (long)count);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<String, Collection<BookPageNumbered>> findMatchesByKnownHashAction(@Nullable List<? extends PageHashKnown.Action> actions, @Nullable String libraryId) {
        void destination$iv$iv$iv;
        void $this$aggregateTo$iv$iv$iv;
        void $this$fold$iv;
        String it;
        SelectOnConditionStep selectOnConditionStep;
        SelectOnConditionStep $this$findMatchesByKnownHashAction_u24lambda_u246 = selectOnConditionStep = this.getDslRO().select((SelectField)this.p.BOOK_ID, (SelectField)this.p.FILE_NAME, (SelectField)this.p.NUMBER, (SelectField)this.p.FILE_HASH, (SelectField)this.p.MEDIA_TYPE, (SelectField)this.p.FILE_SIZE).from((TableLike)this.p).innerJoin((TableLike)this.ph).on(this.p.FILE_HASH.eq((Field)this.ph.HASH));
        boolean bl = false;
        String string = libraryId;
        if (string != null) {
            it = string;
            boolean bl2 = false;
            $this$findMatchesByKnownHashAction_u24lambda_u246.innerJoin((TableLike)this.b).on(this.b.ID.eq((Field)this.p.BOOK_ID));
        }
        SelectOnConditionStep $this$findMatchesByKnownHashAction_u24lambda_u248 = selectOnConditionStep = selectOnConditionStep.where(this.ph.ACTION.in((Collection)actions));
        boolean bl3 = false;
        String string2 = libraryId;
        if (string2 != null) {
            it = string2;
            boolean bl4 = false;
            $this$findMatchesByKnownHashAction_u24lambda_u248.and(this.b.LIBRARY_ID.eq((Object)it));
        }
        List list = selectOnConditionStep.fetch((RecordMapper)findMatchesByKnownHashAction.3.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Iterable $this$groupingBy$iv = list;
        boolean $i$f$groupingBy = false;
        $this$groupingBy$iv = (Grouping)new /* Unavailable Anonymous Inner Class!! */;
        List initialValue$iv = CollectionsKt.emptyList();
        boolean $i$f$fold = false;
        void $this$aggregate$iv$iv = $this$fold$iv;
        boolean $i$f$aggregate = false;
        void bl4 = $this$aggregate$iv$iv;
        Map map = new LinkedHashMap();
        boolean $i$f$aggregateTo = false;
        Iterator iterator = $this$aggregateTo$iv$iv$iv.sourceIterator();
        while (iterator.hasNext()) {
            void acc$iv;
            void first$iv;
            void e$iv;
            Object e$iv$iv$iv = iterator.next();
            Object key$iv$iv$iv = $this$aggregateTo$iv$iv$iv.keyOf(e$iv$iv$iv);
            Object accumulator$iv$iv$iv = destination$iv$iv$iv.get(key$iv$iv$iv);
            boolean bl5 = accumulator$iv$iv$iv == null && !destination$iv$iv$iv.containsKey(key$iv$iv$iv);
            Object e = e$iv$iv$iv;
            Object v = accumulator$iv$iv$iv;
            Object object = key$iv$iv$iv;
            void var19_25 = destination$iv$iv$iv;
            boolean bl6 = false;
            Pair pair = (Pair)e$iv;
            List acc = first$iv != false ? initialValue$iv : acc$iv;
            boolean bl7 = false;
            BookPageNumbered bookPageNumbered = (BookPageNumbered)pair.component2();
            List list2 = CollectionsKt.plus((Collection)acc, (Object)bookPageNumbered);
            var19_25.put(object, list2);
        }
        return destination$iv$iv$iv;
    }

    @Nullable
    public byte[] getKnownThumbnail(@NotNull String pageHash) {
        Intrinsics.checkNotNullParameter((Object)pageHash, (String)"pageHash");
        Record1 record1 = (Record1)this.getDslRO().select((SelectField)this.pht.THUMBNAIL).from((TableLike)this.pht).where(this.pht.HASH.eq((Object)pageHash)).fetchOne();
        return record1 != null ? (byte[])record1.value1() : null;
    }

    @Transactional
    public void insert(@NotNull PageHashKnown pageHash, @Nullable byte[] thumbnail) {
        Intrinsics.checkNotNullParameter((Object)pageHash, (String)"pageHash");
        this.getDslRW().insertInto((Table)this.ph).set((Field)this.ph.HASH, (Object)pageHash.getHash()).set((Field)this.ph.SIZE, (Object)pageHash.getSize()).set((Field)this.ph.ACTION, (Object)pageHash.getAction().name()).execute();
        if (thumbnail != null) {
            this.getDslRW().insertInto((Table)this.pht).set((Field)this.pht.HASH, (Object)pageHash.getHash()).set((Field)this.pht.THUMBNAIL, (Object)thumbnail).execute();
        }
    }

    public void update(@NotNull PageHashKnown pageHash) {
        Intrinsics.checkNotNullParameter((Object)pageHash, (String)"pageHash");
        this.getDslRW().update((Table)this.ph).set((Field)this.ph.ACTION, (Object)pageHash.getAction().name()).set((Field)this.ph.SIZE, (Object)pageHash.getSize()).set((Field)this.ph.DELETE_COUNT, (Object)pageHash.getDeleteCount()).set((Field)this.ph.LAST_MODIFIED_DATE, (Object)LocalDateTime.now(ZoneId.of("Z"))).where(this.ph.HASH.eq((Object)pageHash.getHash())).execute();
    }

    public static final /* synthetic */ PageHash access$getPh$p(PageHashDao $this) {
        return $this.ph;
    }
}

