/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.jooq.main;

import java.io.Closeable;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.domain.model.SidecarStored;
import org.gotson.komga.domain.persistence.SidecarRepository;
import org.gotson.komga.infrastructure.jooq.SplitDslDaoBase;
import org.gotson.komga.infrastructure.jooq.TempTable;
import org.gotson.komga.jooq.main.Tables;
import org.gotson.komga.jooq.main.tables.Sidecar;
import org.gotson.komga.jooq.main.tables.records.SidecarRecord;
import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.RecordMapper;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000eH\u0017J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0014\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00070\u001bH\u0016J\f\u0010\u001c\u001a\u00020\u000f*\u00020\u001dH\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/gotson/komga/infrastructure/jooq/main/SidecarDao;", "Lorg/gotson/komga/infrastructure/jooq/SplitDslDaoBase;", "Lorg/gotson/komga/domain/persistence/SidecarRepository;", "dslRW", "Lorg/jooq/DSLContext;", "dslRO", "batchSize", "", "<init>", "(Lorg/jooq/DSLContext;Lorg/jooq/DSLContext;I)V", "sc", "Lorg/gotson/komga/jooq/main/tables/Sidecar;", "kotlin.jvm.PlatformType", "findAll", "", "Lorg/gotson/komga/domain/model/SidecarStored;", "save", "", "libraryId", "", "sidecar", "Lorg/gotson/komga/domain/model/Sidecar;", "deleteByLibraryIdAndUrls", "urls", "Ljava/net/URL;", "deleteByLibraryId", "countGroupedByLibraryId", "", "toDomain", "Lorg/gotson/komga/jooq/main/tables/records/SidecarRecord;", "komga"})
@SourceDebugExtension(value={"SMAP\nSidecarDao.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SidecarDao.kt\norg/gotson/komga/infrastructure/jooq/main/SidecarDao\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1563#2:84\n1634#2,3:85\n*S KotlinDebug\n*F\n+ 1 SidecarDao.kt\norg/gotson/komga/infrastructure/jooq/main/SidecarDao\n*L\n52#1:84\n52#1:85,3\n*E\n"})
public class SidecarDao
extends SplitDslDaoBase
implements SidecarRepository {
    private final int batchSize;
    private final Sidecar sc;

    public SidecarDao(@NotNull DSLContext dslRW, @Qualifier(value="dslContextRO") @NotNull DSLContext dslRO, @Value(value="#{@komgaProperties.database.batchChunkSize}") int batchSize) {
        Intrinsics.checkNotNullParameter((Object)dslRW, (String)"dslRW");
        Intrinsics.checkNotNullParameter((Object)dslRO, (String)"dslRO");
        super(dslRW, dslRO);
        this.batchSize = batchSize;
        this.sc = Tables.SIDECAR;
    }

    @NotNull
    public Collection<SidecarStored> findAll() {
        List list = this.getDslRO().selectFrom((TableLike)this.sc).fetch().map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    public void save(@NotNull String libraryId, @NotNull org.gotson.komga.domain.model.Sidecar sidecar) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        Intrinsics.checkNotNullParameter((Object)sidecar, (String)"sidecar");
        Object[] objectArray = new Object[]{sidecar.getUrl().toString(), sidecar.getParentUrl().toString(), sidecar.getLastModifiedTime(), libraryId};
        this.getDslRW().insertInto((Table)this.sc).values(objectArray).onDuplicateKeyUpdate().set((Field)this.sc.LAST_MODIFIED_TIME, (Object)sidecar.getLastModifiedTime()).set((Field)this.sc.PARENT_URL, (Object)sidecar.getParentUrl().toString()).set((Field)this.sc.LIBRARY_ID, (Object)libraryId).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Transactional
    public void deleteByLibraryIdAndUrls(@NotNull String libraryId, @NotNull Collection<URL> urls) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        Object object = urls;
        int n = this.batchSize;
        DSLContext dSLContext = this.getDslRW();
        TempTable.Companion companion = TempTable.Companion;
        boolean $i$f$map = false;
        void var5_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            URL uRL = (URL)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        object = (Closeable)companion.withTempTable(dSLContext, n, (Collection)collection);
        Throwable throwable = null;
        try {
            TempTable it = (TempTable)object;
            boolean bl = false;
            int n2 = this.getDslRW().deleteFrom((Table)this.sc).where(this.sc.LIBRARY_ID.eq((Object)libraryId)).and(this.sc.URL.in((Select)it.selectTempStrings())).execute();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    public void deleteByLibraryId(@NotNull String libraryId) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        this.getDslRW().deleteFrom((Table)this.sc).where(this.sc.LIBRARY_ID.eq((Object)libraryId)).execute();
    }

    @NotNull
    public Map<String, Integer> countGroupedByLibraryId() {
        GroupField[] groupFieldArray = new GroupField[]{this.sc.LIBRARY_ID};
        Map map = this.getDslRO().select((SelectField)this.sc.LIBRARY_ID, (SelectField)DSL.count((Field)((Field)this.sc.URL))).from((TableLike)this.sc).groupBy(groupFieldArray).fetchMap((Field)this.sc.LIBRARY_ID, (Field)DSL.count((Field)((Field)this.sc.URL)));
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"fetchMap(...)");
        return map;
    }

    private SidecarStored toDomain(SidecarRecord $this$toDomain) {
        URL uRL = new URL($this$toDomain.getUrl());
        URL uRL2 = new URL($this$toDomain.getParentUrl());
        LocalDateTime localDateTime = $this$toDomain.getLastModifiedTime();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"getLastModifiedTime(...)");
        String string = $this$toDomain.getLibraryId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLibraryId(...)");
        return new SidecarStored(uRL, uRL2, localDateTime, string);
    }

    public static final /* synthetic */ SidecarStored access$toDomain(SidecarDao $this, SidecarRecord $receiver) {
        return $this.toDomain($receiver);
    }
}

