/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.search;

import java.time.LocalDate;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.gotson.komga.domain.model.ReadList;
import org.gotson.komga.domain.model.SeriesCollection;
import org.gotson.komga.infrastructure.search.LuceneEntity;
import org.gotson.komga.interfaces.api.rest.dto.AlternateTitleDto;
import org.gotson.komga.interfaces.api.rest.dto.AuthorDto;
import org.gotson.komga.interfaces.api.rest.dto.BookDto;
import org.gotson.komga.interfaces.api.rest.dto.SeriesDto;
import org.gotson.komga.language.LanguageUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0003\u001a\u0012\u0010\u0004\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0001\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0006\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0007\u00a8\u0006\b"}, d2={"toDocument", "Lorg/apache/lucene/document/Document;", "Lorg/gotson/komga/interfaces/api/rest/dto/BookDto;", "Lorg/gotson/komga/interfaces/api/rest/dto/SeriesDto;", "oneshotDocument", "document", "Lorg/gotson/komga/domain/model/SeriesCollection;", "Lorg/gotson/komga/domain/model/ReadList;", "komga"})
@SourceDebugExtension(value={"SMAP\nLuceneEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuceneEntity.kt\norg/gotson/komga/infrastructure/search/LuceneEntityKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n1869#2,2:119\n1869#2,2:121\n1869#2,2:123\n1869#2,2:125\n1869#2,2:127\n1869#2,2:129\n1869#2,2:131\n1869#2,2:133\n1869#2,2:135\n1869#2,2:137\n*S KotlinDebug\n*F\n+ 1 LuceneEntity.kt\norg/gotson/komga/infrastructure/search/LuceneEntityKt\n*L\n34#1:119,2\n37#1:121,2\n54#1:123,2\n60#1:125,2\n64#1:127,2\n68#1:129,2\n71#1:131,2\n76#1:133,2\n96#1:135,2\n99#1:137,2\n*E\n"})
public final class LuceneEntityKt {
    @NotNull
    public static final Document toDocument(@NotNull BookDto $this$toDocument) {
        String it;
        Document document;
        Intrinsics.checkNotNullParameter((Object)$this$toDocument, (String)"<this>");
        Document $this$toDocument_u24lambda_u242 = document = new Document();
        boolean bl = false;
        $this$toDocument_u24lambda_u242.add((IndexableField)new TextField("title", $this$toDocument.getMetadata().getTitle(), Field.Store.NO));
        $this$toDocument_u24lambda_u242.add((IndexableField)new TextField("isbn", $this$toDocument.getMetadata().getIsbn(), Field.Store.NO));
        Iterable $this$forEach$iv = $this$toDocument.getMetadata().getTags();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl2 = false;
            $this$toDocument_u24lambda_u242.add((IndexableField)new TextField("tag", it, Field.Store.NO));
        }
        $this$forEach$iv = $this$toDocument.getMetadata().getAuthors();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (AuthorDto)element$iv;
            boolean bl3 = false;
            $this$toDocument_u24lambda_u242.add((IndexableField)new TextField("author", it.getName(), Field.Store.NO));
            $this$toDocument_u24lambda_u242.add((IndexableField)new TextField(it.getRole(), it.getName(), Field.Store.NO));
        }
        if ($this$toDocument.getMetadata().getReleaseDate() != null) {
            $this$toDocument_u24lambda_u242.add((IndexableField)new TextField("release_date", DateTools.dateToString((Date)LanguageUtilsKt.toDate((LocalDate)$this$toDocument.getMetadata().getReleaseDate()), (DateTools.Resolution)DateTools.Resolution.YEAR), Field.Store.NO));
        }
        $this$toDocument_u24lambda_u242.add((IndexableField)new TextField("status", $this$toDocument.getMedia().getStatus(), Field.Store.NO));
        $this$toDocument_u24lambda_u242.add((IndexableField)new TextField("deleted", String.valueOf($this$toDocument.getDeleted()), Field.Store.NO));
        $this$toDocument_u24lambda_u242.add((IndexableField)new TextField("oneshot", String.valueOf($this$toDocument.getOneshot()), Field.Store.NO));
        $this$toDocument_u24lambda_u242.add((IndexableField)new StringField("type", LuceneEntity.Book.getType(), Field.Store.NO));
        $this$toDocument_u24lambda_u242.add((IndexableField)new StringField(LuceneEntity.Book.getId(), $this$toDocument.getId(), Field.Store.YES));
        return document;
    }

    @NotNull
    public static final Document toDocument(@NotNull SeriesDto $this$toDocument) {
        Object it;
        Document document;
        Intrinsics.checkNotNullParameter((Object)$this$toDocument, (String)"<this>");
        Document $this$toDocument_u24lambda_u249 = document = new Document();
        boolean bl = false;
        $this$toDocument_u24lambda_u249.add((IndexableField)new TextField("title", $this$toDocument.getMetadata().getTitle(), Field.Store.NO));
        if (!Intrinsics.areEqual((Object)$this$toDocument.getMetadata().getTitleSort(), (Object)$this$toDocument.getMetadata().getTitle())) {
            $this$toDocument_u24lambda_u249.add((IndexableField)new TextField("title", $this$toDocument.getMetadata().getTitleSort(), Field.Store.NO));
        }
        Iterable $this$forEach$iv = $this$toDocument.getMetadata().getAlternateTitles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (AlternateTitleDto)element$iv;
            boolean bl2 = false;
            $this$toDocument_u24lambda_u249.add((IndexableField)new TextField("title", it.getTitle(), Field.Store.NO));
        }
        $this$toDocument_u24lambda_u249.add((IndexableField)new TextField("publisher", $this$toDocument.getMetadata().getPublisher(), Field.Store.NO));
        $this$toDocument_u24lambda_u249.add((IndexableField)new TextField("status", $this$toDocument.getMetadata().getStatus(), Field.Store.NO));
        $this$toDocument_u24lambda_u249.add((IndexableField)new TextField("reading_direction", $this$toDocument.getMetadata().getReadingDirection(), Field.Store.NO));
        if ($this$toDocument.getMetadata().getAgeRating() != null) {
            $this$toDocument_u24lambda_u249.add((IndexableField)new TextField("age_rating", $this$toDocument.getMetadata().getAgeRating().toString(), Field.Store.NO));
        }
        if (!StringsKt.isBlank((CharSequence)$this$toDocument.getMetadata().getLanguage())) {
            $this$toDocument_u24lambda_u249.add((IndexableField)new TextField("language", $this$toDocument.getMetadata().getLanguage(), Field.Store.NO));
        }
        $this$forEach$iv = $this$toDocument.getMetadata().getTags();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl3 = false;
            $this$toDocument_u24lambda_u249.add((IndexableField)new TextField("series_tag", (String)it, Field.Store.NO));
            $this$toDocument_u24lambda_u249.add((IndexableField)new TextField("tag", (String)it, Field.Store.NO));
        }
        $this$forEach$iv = $this$toDocument.getBooksMetadata().getTags();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl4 = false;
            $this$toDocument_u24lambda_u249.add((IndexableField)new TextField("book_tag", (String)it, Field.Store.NO));
            $this$toDocument_u24lambda_u249.add((IndexableField)new TextField("tag", (String)it, Field.Store.NO));
        }
        $this$forEach$iv = $this$toDocument.getMetadata().getGenres();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl5 = false;
            $this$toDocument_u24lambda_u249.add((IndexableField)new TextField("genre", (String)it, Field.Store.NO));
        }
        $this$forEach$iv = $this$toDocument.getMetadata().getSharingLabels();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl6 = false;
            $this$toDocument_u24lambda_u249.add((IndexableField)new TextField("sharing_label", (String)it, Field.Store.NO));
        }
        if ($this$toDocument.getMetadata().getTotalBookCount() != null) {
            $this$toDocument_u24lambda_u249.add((IndexableField)new TextField("total_book_count", $this$toDocument.getMetadata().getTotalBookCount().toString(), Field.Store.NO));
        }
        $this$toDocument_u24lambda_u249.add((IndexableField)new TextField("book_count", String.valueOf($this$toDocument.getBooksCount()), Field.Store.NO));
        $this$forEach$iv = $this$toDocument.getBooksMetadata().getAuthors();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (AuthorDto)element$iv;
            boolean bl7 = false;
            $this$toDocument_u24lambda_u249.add((IndexableField)new TextField("author", it.getName(), Field.Store.NO));
            $this$toDocument_u24lambda_u249.add((IndexableField)new TextField(it.getRole(), it.getName(), Field.Store.NO));
        }
        if ($this$toDocument.getBooksMetadata().getReleaseDate() != null) {
            $this$toDocument_u24lambda_u249.add((IndexableField)new TextField("release_date", DateTools.dateToString((Date)LanguageUtilsKt.toDate((LocalDate)$this$toDocument.getBooksMetadata().getReleaseDate()), (DateTools.Resolution)DateTools.Resolution.YEAR), Field.Store.NO));
        }
        $this$toDocument_u24lambda_u249.add((IndexableField)new TextField("deleted", String.valueOf($this$toDocument.getDeleted()), Field.Store.NO));
        $this$toDocument_u24lambda_u249.add((IndexableField)new TextField("oneshot", String.valueOf($this$toDocument.getOneshot()), Field.Store.NO));
        if ($this$toDocument.getMetadata().getTotalBookCount() != null) {
            Integer n = $this$toDocument.getMetadata().getTotalBookCount();
            int n2 = $this$toDocument.getBooksCount();
            $this$toDocument_u24lambda_u249.add((IndexableField)new TextField("complete", String.valueOf(n != null && n == n2), Field.Store.NO));
        }
        $this$toDocument_u24lambda_u249.add((IndexableField)new StringField("type", LuceneEntity.Series.getType(), Field.Store.NO));
        $this$toDocument_u24lambda_u249.add((IndexableField)new StringField(LuceneEntity.Series.getId(), $this$toDocument.getId(), Field.Store.YES));
        return document;
    }

    @NotNull
    public static final Document oneshotDocument(@NotNull SeriesDto $this$oneshotDocument, @NotNull Document document) {
        String it;
        Document document2;
        Intrinsics.checkNotNullParameter((Object)$this$oneshotDocument, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Document $this$oneshotDocument_u24lambda_u2412 = document2 = document;
        boolean bl = false;
        $this$oneshotDocument_u24lambda_u2412.add((IndexableField)new TextField("publisher", $this$oneshotDocument.getMetadata().getPublisher(), Field.Store.NO));
        $this$oneshotDocument_u24lambda_u2412.add((IndexableField)new TextField("status", $this$oneshotDocument.getMetadata().getStatus(), Field.Store.NO));
        $this$oneshotDocument_u24lambda_u2412.add((IndexableField)new TextField("reading_direction", $this$oneshotDocument.getMetadata().getReadingDirection(), Field.Store.NO));
        if ($this$oneshotDocument.getMetadata().getAgeRating() != null) {
            $this$oneshotDocument_u24lambda_u2412.add((IndexableField)new TextField("age_rating", $this$oneshotDocument.getMetadata().getAgeRating().toString(), Field.Store.NO));
        }
        if (!StringsKt.isBlank((CharSequence)$this$oneshotDocument.getMetadata().getLanguage())) {
            $this$oneshotDocument_u24lambda_u2412.add((IndexableField)new TextField("language", $this$oneshotDocument.getMetadata().getLanguage(), Field.Store.NO));
        }
        Iterable $this$forEach$iv = $this$oneshotDocument.getMetadata().getGenres();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl2 = false;
            $this$oneshotDocument_u24lambda_u2412.add((IndexableField)new TextField("genre", it, Field.Store.NO));
        }
        $this$forEach$iv = $this$oneshotDocument.getMetadata().getSharingLabels();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl3 = false;
            $this$oneshotDocument_u24lambda_u2412.add((IndexableField)new TextField("sharing_label", it, Field.Store.NO));
        }
        $this$oneshotDocument_u24lambda_u2412.add((IndexableField)new TextField("complete", "true", Field.Store.NO));
        return document2;
    }

    @NotNull
    public static final Document toDocument(@NotNull SeriesCollection $this$toDocument) {
        Document document;
        Intrinsics.checkNotNullParameter((Object)$this$toDocument, (String)"<this>");
        Document $this$toDocument_u24lambda_u2413 = document = new Document();
        boolean bl = false;
        $this$toDocument_u24lambda_u2413.add((IndexableField)new TextField("name", $this$toDocument.getName(), Field.Store.NO));
        $this$toDocument_u24lambda_u2413.add((IndexableField)new StringField("type", LuceneEntity.Collection.getType(), Field.Store.NO));
        $this$toDocument_u24lambda_u2413.add((IndexableField)new StringField(LuceneEntity.Collection.getId(), $this$toDocument.getId(), Field.Store.YES));
        return document;
    }

    @NotNull
    public static final Document toDocument(@NotNull ReadList $this$toDocument) {
        Document document;
        Intrinsics.checkNotNullParameter((Object)$this$toDocument, (String)"<this>");
        Document $this$toDocument_u24lambda_u2414 = document = new Document();
        boolean bl = false;
        $this$toDocument_u24lambda_u2414.add((IndexableField)new TextField("name", $this$toDocument.getName(), Field.Store.NO));
        $this$toDocument_u24lambda_u2414.add((IndexableField)new StringField("type", LuceneEntity.ReadList.getType(), Field.Store.NO));
        $this$toDocument_u24lambda_u2414.add((IndexableField)new StringField(LuceneEntity.ReadList.getId(), $this$toDocument.getId(), Field.Store.YES));
        return document;
    }
}

